(function compatibilityWrapper(){"use strict";if(typeof PDFJS==="undefined"){(typeof window!=="undefined"?window:this).PDFJS={}}(function checkTypedArrayCompatibility(){if(typeof Uint8Array!=="undefined"){if(typeof Uint8Array.prototype.subarray==="undefined"){Uint8Array.prototype.subarray=function subarray(start,end){return new Uint8Array(this.slice(start,end))};Float32Array.prototype.subarray=function subarray(start,end){return new Float32Array(this.slice(start,end))}}if(typeof Float64Array==="undefined"){window.Float64Array=Float32Array}return}function subarray(start,end){return new TypedArray(this.slice(start,end))}function setArrayOffset(array,offset){if(arguments.length<2){offset=0}for(var i=0,n=array.length;i<n;++i,++offset){this[offset]=array[i]&255}}function TypedArray(arg1){var result,i,n;if(typeof arg1==="number"){result=[];for(i=0;i<arg1;++i){result[i]=0}}else if("slice"in arg1){result=arg1.slice(0)}else{result=[];for(i=0,n=arg1.length;i<n;++i){result[i]=arg1[i]}}result.subarray=subarray;result.buffer=result;result.byteLength=result.length;result.set=setArrayOffset;if(typeof arg1==="object"&&arg1.buffer){result.buffer=arg1.buffer}return result}window.Uint8Array=TypedArray;window.Int8Array=TypedArray;window.Uint32Array=TypedArray;window.Int32Array=TypedArray;window.Uint16Array=TypedArray;window.Float32Array=TypedArray;window.Float64Array=TypedArray})();(function normalizeURLObject(){if(!window.URL){window.URL=window.webkitURL}})();(function checkObjectDefinePropertyCompatibility(){if(typeof Object.defineProperty!=="undefined"){var definePropertyPossible=true;try{Object.defineProperty(new Image,"id",{value:"test"});var Test=function Test(){};Test.prototype={get id(){}};Object.defineProperty(new Test,"id",{value:"",configurable:true,enumerable:true,writable:false})}catch(e){definePropertyPossible=false}if(definePropertyPossible){return}}Object.defineProperty=function objectDefineProperty(obj,name,def){delete obj[name];if("get"in def){obj.__defineGetter__(name,def["get"])}if("set"in def){obj.__defineSetter__(name,def["set"])}if("value"in def){obj.__defineSetter__(name,function objectDefinePropertySetter(value){this.__defineGetter__(name,function objectDefinePropertyGetter(){return value});return value});obj[name]=def.value}}})();(function checkXMLHttpRequestResponseCompatibility(){var xhrPrototype=XMLHttpRequest.prototype;var xhr=new XMLHttpRequest;if(!("overrideMimeType"in xhr)){Object.defineProperty(xhrPrototype,"overrideMimeType",{value:function xmlHttpRequestOverrideMimeType(mimeType){}})}if("responseType"in xhr){return}PDFJS.disableWorker=true;Object.defineProperty(xhrPrototype,"responseType",{get:function xmlHttpRequestGetResponseType(){return this._responseType||"text"},set:function xmlHttpRequestSetResponseType(value){if(value==="text"||value==="arraybuffer"){this._responseType=value;if(value==="arraybuffer"&&typeof this.overrideMimeType==="function"){this.overrideMimeType("text/plain; charset=x-user-defined")}}}});if(typeof VBArray!=="undefined"){Object.defineProperty(xhrPrototype,"response",{get:function xmlHttpRequestResponseGet(){if(this.responseType==="arraybuffer"){return new Uint8Array(new VBArray(this.responseBody).toArray())}else{return this.responseText}}});return}Object.defineProperty(xhrPrototype,"response",{get:function xmlHttpRequestResponseGet(){if(this.responseType!=="arraybuffer"){return this.responseText}var text=this.responseText;var i,n=text.length;var result=new Uint8Array(n);for(i=0;i<n;++i){result[i]=text.charCodeAt(i)&255}return result.buffer}})})();(function checkWindowBtoaCompatibility(){if("btoa"in window){return}var digits="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";window.btoa=function windowBtoa(chars){var buffer="";var i,n;for(i=0,n=chars.length;i<n;i+=3){var b1=chars.charCodeAt(i)&255;var b2=chars.charCodeAt(i+1)&255;var b3=chars.charCodeAt(i+2)&255;var d1=b1>>2,d2=(b1&3)<<4|b2>>4;var d3=i+1<n?(b2&15)<<2|b3>>6:64;var d4=i+2<n?b3&63:64;buffer+=digits.charAt(d1)+digits.charAt(d2)+digits.charAt(d3)+digits.charAt(d4)}return buffer}})();(function checkWindowAtobCompatibility(){if("atob"in window){return}var digits="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";window.atob=function(input){input=input.replace(/=+$/,"");if(input.length%4===1){throw new Error("bad atob input")}for(var bc=0,bs,buffer,idx=0,output="";buffer=input.charAt(idx++);~buffer&&(bs=bc%4?bs*64+buffer:buffer,bc++%4)?output+=String.fromCharCode(255&bs>>(-2*bc&6)):0){buffer=digits.indexOf(buffer)}return output}})();(function checkFunctionPrototypeBindCompatibility(){if(typeof Function.prototype.bind!=="undefined"){return}Function.prototype.bind=function functionPrototypeBind(obj){var fn=this,headArgs=Array.prototype.slice.call(arguments,1);var bound=function functionPrototypeBindBound(){var args=headArgs.concat(Array.prototype.slice.call(arguments));return fn.apply(obj,args)};return bound}})();(function checkDatasetProperty(){var div=document.createElement("div");if("dataset"in div){return}Object.defineProperty(HTMLElement.prototype,"dataset",{get:function(){if(this._dataset){return this._dataset}var dataset={};for(var j=0,jj=this.attributes.length;j<jj;j++){var attribute=this.attributes[j];if(attribute.name.substring(0,5)!=="data-"){continue}var key=attribute.name.substring(5).replace(/\-([a-z])/g,function(all,ch){return ch.toUpperCase()});dataset[key]=attribute.value}Object.defineProperty(this,"_dataset",{value:dataset,writable:false,enumerable:false});return dataset},enumerable:true})})();(function checkClassListProperty(){var div=document.createElement("div");if("classList"in div){return}function changeList(element,itemName,add,remove){var s=element.className||"";var list=s.split(/\s+/g);if(list[0]===""){list.shift()}var index=list.indexOf(itemName);if(index<0&&add){list.push(itemName)}if(index>=0&&remove){list.splice(index,1)}element.className=list.join(" ");return index>=0}var classListPrototype={add:function(name){changeList(this.element,name,true,false)},contains:function(name){return changeList(this.element,name,false,false)},remove:function(name){changeList(this.element,name,false,true)},toggle:function(name){changeList(this.element,name,true,true)}};Object.defineProperty(HTMLElement.prototype,"classList",{get:function(){if(this._classList){return this._classList}var classList=Object.create(classListPrototype,{element:{value:this,writable:false,enumerable:true}});Object.defineProperty(this,"_classList",{value:classList,writable:false,enumerable:false});return classList},enumerable:true})})();(function checkConsoleCompatibility(){if(!("console"in window)){window.console={log:function(){},error:function(){},warn:function(){}}}else if(!("bind"in console.log)){console.log=function(fn){return function(msg){return fn(msg)}}(console.log);console.error=function(fn){return function(msg){return fn(msg)}}(console.error);console.warn=function(fn){return function(msg){return fn(msg)}}(console.warn)}})();(function checkOnClickCompatibility(){function ignoreIfTargetDisabled(event){if(isDisabled(event.target)){event.stopPropagation()}}function isDisabled(node){return node.disabled||node.parentNode&&isDisabled(node.parentNode)}if(navigator.userAgent.indexOf("Opera")!==-1){document.addEventListener("click",ignoreIfTargetDisabled,true)}})();(function checkOnBlobSupport(){if(navigator.userAgent.indexOf("Trident")>=0){PDFJS.disableCreateObjectURL=true}})();(function checkNavigatorLanguage(){if("language"in navigator){return}PDFJS.locale=navigator.userLanguage||"en-US"})();(function checkRangeRequests(){var isSafari=Object.prototype.toString.call(window.HTMLElement).indexOf("Constructor")>0;var regex=/Android\s[0-2][^\d]/;var isOldAndroid=regex.test(navigator.userAgent);var isChromeWithRangeBug=/Chrome\/(39|40)\./.test(navigator.userAgent);if(isSafari||isOldAndroid||isChromeWithRangeBug){PDFJS.disableRange=true;PDFJS.disableStream=true}})();(function checkHistoryManipulation(){if(!history.pushState||navigator.userAgent.indexOf("Android 2.")>=0){PDFJS.disableHistory=true}})();(function checkSetPresenceInImageData(){if(window.CanvasPixelArray){if(typeof window.CanvasPixelArray.prototype.set!=="function"){window.CanvasPixelArray.prototype.set=function(arr){for(var i=0,ii=this.length;i<ii;i++){this[i]=arr[i]}}}}else{var polyfill=false,versionMatch;if(navigator.userAgent.indexOf("Chrom")>=0){versionMatch=navigator.userAgent.match(/Chrom(e|ium)\/([0-9]+)\./);polyfill=versionMatch&&parseInt(versionMatch[2])<21}else if(navigator.userAgent.indexOf("Android")>=0){polyfill=/Android\s[0-4][^\d]/g.test(navigator.userAgent)}else if(navigator.userAgent.indexOf("Safari")>=0){versionMatch=navigator.userAgent.match(/Version\/([0-9]+)\.([0-9]+)\.([0-9]+) Safari\//);polyfill=versionMatch&&parseInt(versionMatch[1])<6}if(polyfill){var contextPrototype=window.CanvasRenderingContext2D.prototype;var createImageData=contextPrototype.createImageData;contextPrototype.createImageData=function(w,h){var imageData=createImageData.call(this,w,h);imageData.data.set=function(arr){for(var i=0,ii=this.length;i<ii;i++){this[i]=arr[i]}};return imageData};contextPrototype=null}}})();(function checkRequestAnimationFrame(){function fakeRequestAnimationFrame(callback){window.setTimeout(callback,20)}var isIOS=/(iPad|iPhone|iPod)/g.test(navigator.userAgent);if(isIOS){window.requestAnimationFrame=fakeRequestAnimationFrame;return}if("requestAnimationFrame"in window){return}window.requestAnimationFrame=window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||fakeRequestAnimationFrame})();(function checkCanvasSizeLimitation(){var isIOS=/(iPad|iPhone|iPod)/g.test(navigator.userAgent);var isAndroid=/Android/g.test(navigator.userAgent);if(isIOS||isAndroid){PDFJS.maxCanvasPixels=5242880}})();(function checkFullscreenSupport(){var isEmbeddedIE=navigator.userAgent.indexOf("Trident")>=0&&window.parent!==window;if(isEmbeddedIE){PDFJS.disableFullscreen=true}})();(function checkCurrentScript(){if("currentScript"in document){return}Object.defineProperty(document,"currentScript",{get:function(){var scripts=document.getElementsByTagName("script");return scripts[scripts.length-1]},enumerable:true,configurable:true})})()}).call(typeof window==="undefined"?this:window);

!function(t,e){"use strict";"function"==typeof define&&define.amd?define("pdfjs-dist/build/pdf",["exports"],e):e("undefined"!=typeof exports?exports:t.pdfjsDistBuildPdf={})}(this,function(t){"use strict";var e="undefined"!=typeof document&&document.currentScript?document.currentScript.src:null,n={};(function(){!function(t,e){e(t.pdfjsSharedUtil={})}(this,function(t){function e(t){K=t}function n(){return K}function i(t){K>=J.infos&&console.log("Info: "+t)}function r(t){K>=J.warnings&&console.log("Warning: "+t)}function a(t){console.log("Deprecated API usage: "+t)}function s(t){throw K>=J.errors&&(console.log("Error: "+t),console.log(o())),new Error(t)}function o(){try{throw new Error}catch(t){return t.stack?t.stack.split("\n").slice(2).join("\n"):""}}function c(t,e){t||s(e)}function l(t,e){try{var n=new URL(t);if(!n.origin||"null"===n.origin)return!1}catch(t){return!1}var i=new URL(e,n);return n.origin===i.origin}function h(t,e){if(!t||"string"!=typeof t)return!1;var n=/^[a-z][a-z0-9+\-.]*(?=:)/i.exec(t);if(!n)return e;switch(n=n[0].toLowerCase()){case"http":case"https":case"ftp":case"mailto":case"tel":return!0;default:return!1}}function u(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!1}),n}function d(t){var e;return function(){return t&&(e=Object.create(null),t(e),t=null),e}}function p(t){return"string"!=typeof t?(r("The argument for removeNullCharacters must be a string."),t):t.replace(/\x00/g,"")}function f(t){c(null!==t&&"object"==typeof t&&void 0!==t.length,"Invalid argument for bytesToString");var e=t.length;if(e<8192)return String.fromCharCode.apply(null,t);for(var n=[],i=0;i<e;i+=8192){var r=Math.min(i+8192,e),a=t.subarray(i,r);n.push(String.fromCharCode.apply(null,a))}return n.join("")}function g(t){c("string"==typeof t,"Invalid argument for stringToBytes");for(var e=t.length,n=new Uint8Array(e),i=0;i<e;++i)n[i]=255&t.charCodeAt(i);return n}function m(t){return void 0!==t.length?t.length:(c(void 0!==t.byteLength),t.byteLength)}function A(t){if(1===t.length&&t[0]instanceof Uint8Array)return t[0];var e,n,i,r=0,a=t.length;for(e=0;e<a;e++)n=t[e],i=m(n),r+=i;var s=0,o=new Uint8Array(r);for(e=0;e<a;e++)n=t[e],n instanceof Uint8Array||(n="string"==typeof n?g(n):new Uint8Array(n)),i=n.byteLength,o.set(n,s),s+=i;return o}function v(t){return String.fromCharCode(t>>24&255,t>>16&255,t>>8&255,255&t)}function b(t){for(var e=1,n=0;t>e;)e<<=1,n++;return n}function y(t,e){return t[e]<<24>>24}function x(t,e){return t[e]<<8|t[e+1]}function S(t,e){return(t[e]<<24|t[e+1]<<16|t[e+2]<<8|t[e+3])>>>0}function k(){var t=new Uint8Array(2);return t[0]=1,1===new Uint16Array(t.buffer)[0]}function C(){try{return new Function(""),!0}catch(t){return!1}}function _(t){var e,n=t.length,i=[];if("þ"===t[0]&&"ÿ"===t[1])for(e=2;e<n;e+=2)i.push(String.fromCharCode(t.charCodeAt(e)<<8|t.charCodeAt(e+1)));else for(e=0;e<n;++e){var r=dt[t.charCodeAt(e)];i.push(r?String.fromCharCode(r):t.charAt(e))}return i.join("")}function w(t){return decodeURIComponent(escape(t))}function T(t){return unescape(encodeURIComponent(t))}function L(t){for(var e in t)return!1;return!0}function P(t){return"boolean"==typeof t}function E(t){return"number"==typeof t&&(0|t)===t}function R(t){return"number"==typeof t}function I(t){return"string"==typeof t}function D(t){return t instanceof Array}function j(t){return"object"==typeof t&&null!==t&&void 0!==t.byteLength}function O(t){return 32===t||9===t||13===t||10===t}function M(){var t={};return t.promise=new Promise(function(e,n){t.resolve=e,t.reject=n}),t}function F(t,e,n){this.sourceName=t,this.targetName=e,this.comObj=n,this.callbackIndex=1,this.postMessageTransfers=!0;var i=this.callbacksCapabilities=Object.create(null),r=this.actionHandler=Object.create(null);this._onComObjOnMessage=function(t){var e=t.data;if(e.targetName===this.sourceName)if(e.isReply){var a=e.callbackId;if(e.callbackId in i){var o=i[a];delete i[a],"error"in e?o.reject(e.error):o.resolve(e.data)}else s("Cannot resolve callback "+a)}else if(e.action in r){var c=r[e.action];if(e.callbackId){var l=this.sourceName,h=e.sourceName;Promise.resolve().then(function(){return c[0].call(c[1],e.data)}).then(function(t){n.postMessage({sourceName:l,targetName:h,isReply:!0,callbackId:e.callbackId,data:t})},function(t){t instanceof Error&&(t+=""),n.postMessage({sourceName:l,targetName:h,isReply:!0,callbackId:e.callbackId,error:t})})}else c[0].call(c[1],e.data)}else s("Unknown action from worker: "+e.action)}.bind(this),n.addEventListener("message",this._onComObjOnMessage)}function N(t,e,n){var i=new Image;i.onload=function(){n.resolve(t,i)},i.onerror=function(){n.resolve(t,null),r("Error during JPEG image loading")},i.src=e}var U="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,B=[.001,0,0,.001,0,0],W={FILL:0,STROKE:1,FILL_STROKE:2,INVISIBLE:3,FILL_ADD_TO_PATH:4,STROKE_ADD_TO_PATH:5,FILL_STROKE_ADD_TO_PATH:6,ADD_TO_PATH:7,FILL_STROKE_MASK:3,ADD_TO_PATH_FLAG:4},G={GRAYSCALE_1BPP:1,RGB_24BPP:2,RGBA_32BPP:3},X={TEXT:1,LINK:2,FREETEXT:3,LINE:4,SQUARE:5,CIRCLE:6,POLYGON:7,POLYLINE:8,HIGHLIGHT:9,UNDERLINE:10,SQUIGGLY:11,STRIKEOUT:12,STAMP:13,CARET:14,INK:15,POPUP:16,FILEATTACHMENT:17,SOUND:18,MOVIE:19,WIDGET:20,SCREEN:21,PRINTERMARK:22,TRAPNET:23,WATERMARK:24,THREED:25,REDACT:26},z={INVISIBLE:1,HIDDEN:2,PRINT:4,NOZOOM:8,NOROTATE:16,NOVIEW:32,READONLY:64,LOCKED:128,TOGGLENOVIEW:256,LOCKEDCONTENTS:512},H={READONLY:1,REQUIRED:2,NOEXPORT:4,MULTILINE:4096,PASSWORD:8192,NOTOGGLETOOFF:16384,RADIO:32768,PUSHBUTTON:65536,COMBO:131072,EDIT:262144,SORT:524288,FILESELECT:1048576,MULTISELECT:2097152,DONOTSPELLCHECK:4194304,DONOTSCROLL:8388608,COMB:16777216,RICHTEXT:33554432,RADIOSINUNISON:33554432,COMMITONSELCHANGE:67108864},Y={SOLID:1,DASHED:2,BEVELED:3,INSET:4,UNDERLINE:5},q={UNKNOWN:0,FLATE:1,LZW:2,DCT:3,JPX:4,JBIG:5,A85:6,AHX:7,CCF:8,RL:9},V={UNKNOWN:0,TYPE1:1,TYPE1C:2,CIDFONTTYPE0:3,CIDFONTTYPE0C:4,TRUETYPE:5,CIDFONTTYPE2:6,TYPE3:7,OPENTYPE:8,TYPE0:9,MMTYPE1:10},J={errors:0,warnings:1,infos:5},Q={dependency:1,setLineWidth:2,setLineCap:3,setLineJoin:4,setMiterLimit:5,setDash:6,setRenderingIntent:7,setFlatness:8,setGState:9,save:10,restore:11,transform:12,moveTo:13,lineTo:14,curveTo:15,curveTo2:16,curveTo3:17,closePath:18,rectangle:19,stroke:20,closeStroke:21,fill:22,eoFill:23,fillStroke:24,eoFillStroke:25,closeFillStroke:26,closeEOFillStroke:27,endPath:28,clip:29,eoClip:30,beginText:31,endText:32,setCharSpacing:33,setWordSpacing:34,setHScale:35,setLeading:36,setFont:37,setTextRenderingMode:38,setTextRise:39,moveText:40,setLeadingMoveText:41,setTextMatrix:42,nextLine:43,showText:44,showSpacedText:45,nextLineShowText:46,nextLineSetSpacingShowText:47,setCharWidth:48,setCharWidthAndBounds:49,setStrokeColorSpace:50,setFillColorSpace:51,setStrokeColor:52,setStrokeColorN:53,setFillColor:54,setFillColorN:55,setStrokeGray:56,setFillGray:57,setStrokeRGBColor:58,setFillRGBColor:59,setStrokeCMYKColor:60,setFillCMYKColor:61,shadingFill:62,beginInlineImage:63,beginImageData:64,endInlineImage:65,paintXObject:66,markPoint:67,markPointProps:68,beginMarkedContent:69,beginMarkedContentProps:70,endMarkedContent:71,beginCompat:72,endCompat:73,paintFormXObjectBegin:74,paintFormXObjectEnd:75,beginGroup:76,endGroup:77,beginAnnotations:78,endAnnotations:79,beginAnnotation:80,endAnnotation:81,paintJpegXObject:82,paintImageMaskXObject:83,paintImageMaskXObjectGroup:84,paintImageXObject:85,paintInlineImageXObject:86,paintInlineImageXObjectGroup:87,paintImageXObjectRepeat:88,paintImageMaskXObjectRepeat:89,paintSolidColorImageMask:90,constructPath:91},K=J.warnings,Z={unknown:"unknown",forms:"forms",javaScript:"javaScript",smask:"smask",shadingPattern:"shadingPattern",font:"font"},$={NEED_PASSWORD:1,INCORRECT_PASSWORD:2},tt=function(){function t(t,e){this.name="PasswordException",this.message=t,this.code=e}return t.prototype=new Error,t.constructor=t,t}(),et=function(){function t(t,e){this.name="UnknownErrorException",this.message=t,this.details=e}return t.prototype=new Error,t.constructor=t,t}(),nt=function(){function t(t){this.name="InvalidPDFException",this.message=t}return t.prototype=new Error,t.constructor=t,t}(),it=function(){function t(t){this.name="MissingPDFException",this.message=t}return t.prototype=new Error,t.constructor=t,t}(),rt=function(){function t(t,e){this.name="UnexpectedResponseException",this.message=t,this.status=e}return t.prototype=new Error,t.constructor=t,t}(),at=function(){function t(t){this.message=t}return t.prototype=new Error,t.prototype.name="NotImplementedException",t.constructor=t,t}(),st=function(){function t(t,e){this.begin=t,this.end=e,this.message="Missing data ["+t+", "+e+")"}return t.prototype=new Error,t.prototype.name="MissingDataException",t.constructor=t,t}(),ot=function(){function t(t){this.message=t}return t.prototype=new Error,t.prototype.name="XRefParseException",t.constructor=t,t}(),ct=function(){function t(t,e){this.buffer=t,this.byteLength=t.length,this.length=void 0===e?this.byteLength>>2:e,n(this.length)}function e(t){return{get:function(){var e=this.buffer,n=t<<2;return(e[n]|e[n+1]<<8|e[n+2]<<16|e[n+3]<<24)>>>0},set:function(e){var n=this.buffer,i=t<<2;n[i]=255&e,n[i+1]=e>>8&255,n[i+2]=e>>16&255,n[i+3]=e>>>24&255}}}function n(n){for(;i<n;)Object.defineProperty(t.prototype,i,e(i)),i++}t.prototype=Object.create(null);var i=0;return t}();t.Uint32ArrayView=ct;var lt=[1,0,0,1,0,0],ht=function(){function t(){}var e=["rgb(",0,",",0,",",0,")"];t.makeCssRgb=function(t,n,i){return e[1]=t,e[3]=n,e[5]=i,e.join("")},t.transform=function(t,e){return[t[0]*e[0]+t[2]*e[1],t[1]*e[0]+t[3]*e[1],t[0]*e[2]+t[2]*e[3],t[1]*e[2]+t[3]*e[3],t[0]*e[4]+t[2]*e[5]+t[4],t[1]*e[4]+t[3]*e[5]+t[5]]},t.applyTransform=function(t,e){return[t[0]*e[0]+t[1]*e[2]+e[4],t[0]*e[1]+t[1]*e[3]+e[5]]},t.applyInverseTransform=function(t,e){var n=e[0]*e[3]-e[1]*e[2];return[(t[0]*e[3]-t[1]*e[2]+e[2]*e[5]-e[4]*e[3])/n,(-t[0]*e[1]+t[1]*e[0]+e[4]*e[1]-e[5]*e[0])/n]},t.getAxialAlignedBoundingBox=function(e,n){var i=t.applyTransform(e,n),r=t.applyTransform(e.slice(2,4),n),a=t.applyTransform([e[0],e[3]],n),s=t.applyTransform([e[2],e[1]],n);return[Math.min(i[0],r[0],a[0],s[0]),Math.min(i[1],r[1],a[1],s[1]),Math.max(i[0],r[0],a[0],s[0]),Math.max(i[1],r[1],a[1],s[1])]},t.inverseTransform=function(t){var e=t[0]*t[3]-t[1]*t[2];return[t[3]/e,-t[1]/e,-t[2]/e,t[0]/e,(t[2]*t[5]-t[4]*t[3])/e,(t[4]*t[1]-t[5]*t[0])/e]},t.apply3dTransform=function(t,e){return[t[0]*e[0]+t[1]*e[1]+t[2]*e[2],t[3]*e[0]+t[4]*e[1]+t[5]*e[2],t[6]*e[0]+t[7]*e[1]+t[8]*e[2]]},t.singularValueDecompose2dScale=function(t){var e=[t[0],t[2],t[1],t[3]],n=t[0]*e[0]+t[1]*e[2],i=t[0]*e[1]+t[1]*e[3],r=t[2]*e[0]+t[3]*e[2],a=t[2]*e[1]+t[3]*e[3],s=(n+a)/2,o=Math.sqrt((n+a)*(n+a)-4*(n*a-r*i))/2,c=s+o||1,l=s-o||1;return[Math.sqrt(c),Math.sqrt(l)]},t.normalizeRect=function(t){var e=t.slice(0);return t[0]>t[2]&&(e[0]=t[2],e[2]=t[0]),t[1]>t[3]&&(e[1]=t[3],e[3]=t[1]),e},t.intersect=function(e,n){function i(t,e){return t-e}var r=[e[0],e[2],n[0],n[2]].sort(i),a=[e[1],e[3],n[1],n[3]].sort(i),s=[];return e=t.normalizeRect(e),n=t.normalizeRect(n),(r[0]===e[0]&&r[1]===n[0]||r[0]===n[0]&&r[1]===e[0])&&(s[0]=r[1],s[2]=r[2],(a[0]===e[1]&&a[1]===n[1]||a[0]===n[1]&&a[1]===e[1])&&(s[1]=a[1],s[3]=a[2],s))},t.sign=function(t){return t<0?-1:1};var n=["","C","CC","CCC","CD","D","DC","DCC","DCCC","CM","","X","XX","XXX","XL","L","LX","LXX","LXXX","XC","","I","II","III","IV","V","VI","VII","VIII","IX"];return t.toRoman=function(t,e){c(E(t)&&t>0,"The number should be a positive integer.");for(var i,r=[];t>=1e3;)t-=1e3,r.push("M");i=t/100|0,t%=100,r.push(n[i]),i=t/10|0,t%=10,r.push(n[10+i]),r.push(n[20+t]);var a=r.join("");return e?a.toLowerCase():a},t.appendToArray=function(t,e){Array.prototype.push.apply(t,e)},t.prependToArray=function(t,e){Array.prototype.unshift.apply(t,e)},t.extendObj=function(t,e){for(var n in e)t[n]=e[n]},t.getInheritableProperty=function(t,e){for(;t&&!t.has(e);)t=t.get("Parent");return t?t.get(e):null},t.inherit=function(t,e,n){t.prototype=Object.create(e.prototype),t.prototype.constructor=t;for(var i in n)t.prototype[i]=n[i]},t.loadScript=function(t,e){var n=document.createElement("script"),i=!1;n.setAttribute("src",t),e&&(n.onload=function(){i||e(),i=!0}),document.getElementsByTagName("head")[0].appendChild(n)},t}(),ut=function(){function t(t,e,n,i,r,a){this.viewBox=t,this.scale=e,this.rotation=n,this.offsetX=i,this.offsetY=r;var s,o,c,l,h=(t[2]+t[0])/2,u=(t[3]+t[1])/2;switch(n%=360,n=n<0?n+360:n){case 180:s=-1,o=0,c=0,l=1;break;case 90:s=0,o=1,c=1,l=0;break;case 270:s=0,o=-1,c=-1,l=0;break;default:s=1,o=0,c=0,l=-1}a&&(c=-c,l=-l);var d,p,f,g;0===s?(d=Math.abs(u-t[1])*e+i,p=Math.abs(h-t[0])*e+r,f=Math.abs(t[3]-t[1])*e,g=Math.abs(t[2]-t[0])*e):(d=Math.abs(h-t[0])*e+i,p=Math.abs(u-t[1])*e+r,f=Math.abs(t[2]-t[0])*e,g=Math.abs(t[3]-t[1])*e),this.transform=[s*e,o*e,c*e,l*e,d-s*e*h-c*e*u,p-o*e*h-l*e*u],this.width=f,this.height=g,this.fontScale=e}return t.prototype={clone:function(e){e=e||{};var n="scale"in e?e.scale:this.scale,i="rotation"in e?e.rotation:this.rotation;return new t(this.viewBox.slice(),n,i,this.offsetX,this.offsetY,e.dontFlip)},convertToViewportPoint:function(t,e){return ht.applyTransform([t,e],this.transform)},convertToViewportRectangle:function(t){var e=ht.applyTransform([t[0],t[1]],this.transform),n=ht.applyTransform([t[2],t[3]],this.transform);return[e[0],e[1],n[0],n[1]]},convertToPdfPoint:function(t,e){return ht.applyInverseTransform([t,e],this.transform)}},t}(),dt=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,728,711,710,729,733,731,730,732,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8226,8224,8225,8230,8212,8211,402,8260,8249,8250,8722,8240,8222,8220,8221,8216,8217,8218,8482,64257,64258,321,338,352,376,381,305,322,339,353,382,0,8364];!function(){function t(t){this._status=0,this._handlers=[];try{t.call(this,this._resolve.bind(this),this._reject.bind(this))}catch(t){this._reject(t)}}if(U.Promise)return"function"!=typeof U.Promise.all&&(U.Promise.all=function(t){var e,n,i=0,r=[],a=new U.Promise(function(t,i){e=t,n=i});return t.forEach(function(t,a){i++,t.then(function(t){r[a]=t,0===--i&&e(r)},n)}),0===i&&e(r),a}),"function"!=typeof U.Promise.resolve&&(U.Promise.resolve=function(t){return new U.Promise(function(e){e(t)})}),"function"!=typeof U.Promise.reject&&(U.Promise.reject=function(t){return new U.Promise(function(e,n){n(t)})}),void("function"!=typeof U.Promise.prototype.catch&&(U.Promise.prototype.catch=function(t){return U.Promise.prototype.then(void 0,t)}));var e={handlers:[],running:!1,unhandledRejections:[],pendingRejectionCheck:!1,scheduleHandlers:function(t){0!==t._status&&(this.handlers=this.handlers.concat(t._handlers),t._handlers=[],this.running||(this.running=!0,setTimeout(this.runHandlers.bind(this),0)))},runHandlers:function(){for(var t=Date.now()+1;this.handlers.length>0;){var e=this.handlers.shift(),n=e.thisPromise._status,i=e.thisPromise._value;try{1===n?"function"==typeof e.onResolve&&(i=e.onResolve(i)):"function"==typeof e.onReject&&(i=e.onReject(i),n=1,e.thisPromise._unhandledRejection&&this.removeUnhandeledRejection(e.thisPromise))}catch(t){n=2,i=t}if(e.nextPromise._updateStatus(n,i),Date.now()>=t)break}if(this.handlers.length>0)return void setTimeout(this.runHandlers.bind(this),0);this.running=!1},addUnhandledRejection:function(t){this.unhandledRejections.push({promise:t,time:Date.now()}),this.scheduleRejectionCheck()},removeUnhandeledRejection:function(t){t._unhandledRejection=!1;for(var e=0;e<this.unhandledRejections.length;e++)this.unhandledRejections[e].promise===t&&(this.unhandledRejections.splice(e),e--)},scheduleRejectionCheck:function(){this.pendingRejectionCheck||(this.pendingRejectionCheck=!0,setTimeout(function(){this.pendingRejectionCheck=!1;for(var t=Date.now(),e=0;e<this.unhandledRejections.length;e++)if(t-this.unhandledRejections[e].time>500){var n=this.unhandledRejections[e].promise._value,i="Unhandled rejection: "+n;n.stack&&(i+="\n"+n.stack),r(i),this.unhandledRejections.splice(e),e--}this.unhandledRejections.length&&this.scheduleRejectionCheck()}.bind(this),500))}};t.all=function(e){function n(t){2!==a._status&&(o=[],r(t))}var i,r,a=new t(function(t,e){i=t,r=e}),s=e.length,o=[];if(0===s)return i(o),a;for(var c=0,l=e.length;c<l;++c){var h=e[c],u=function(t){return function(e){2!==a._status&&(o[t]=e,0===--s&&i(o))}}(c);t.isPromise(h)?h.then(u,n):u(h)}return a},t.isPromise=function(t){return t&&"function"==typeof t.then},t.resolve=function(e){return new t(function(t){t(e)})},t.reject=function(e){return new t(function(t,n){n(e)})},t.prototype={_status:null,_value:null,_handlers:null,_unhandledRejection:null,_updateStatus:function(n,i){if(1!==this._status&&2!==this._status){if(1===n&&t.isPromise(i))return void i.then(this._updateStatus.bind(this,1),this._updateStatus.bind(this,2));this._status=n,this._value=i,2===n&&0===this._handlers.length&&(this._unhandledRejection=!0,e.addUnhandledRejection(this)),e.scheduleHandlers(this)}},_resolve:function(t){this._updateStatus(1,t)},_reject:function(t){this._updateStatus(2,t)},then:function(n,i){var r=new t(function(t,e){this.resolve=t,this.reject=e});return this._handlers.push({thisPromise:this,onResolve:n,onReject:i,nextPromise:r}),e.scheduleHandlers(this),r},catch:function(t){return this.then(void 0,t)}},U.Promise=t}(),function(){function t(){this.id="$weakmap"+e++}if(!U.WeakMap){var e=0;t.prototype={has:function(t){return!!Object.getOwnPropertyDescriptor(t,this.id)},get:function(t,e){return this.has(t)?t[this.id]:e},set:function(t,e){Object.defineProperty(t,this.id,{value:e,enumerable:!1,configurable:!0})},delete:function(t){delete t[this.id]}},U.WeakMap=t}}();var pt=function(){function t(t,e,n){for(;t.length<n;)t+=e;return t}function e(){this.started=Object.create(null),this.times=[],this.enabled=!0}return e.prototype={time:function(t){this.enabled&&(t in this.started&&r("Timer is already running for "+t),this.started[t]=Date.now())},timeEnd:function(t){this.enabled&&(t in this.started||r("Timer has not been started for "+t),this.times.push({name:t,start:this.started[t],end:Date.now()}),delete this.started[t])},toString:function(){var e,n,i=this.times,r="",a=0;for(e=0,n=i.length;e<n;++e){var s=i[e].name;s.length>a&&(a=s.length)}for(e=0,n=i.length;e<n;++e){var o=i[e],c=o.end-o.start;r+=t(o.name," ",a)+" "+c+"ms\n"}return r}},e}(),ft=function(t,e){if("undefined"!=typeof Blob)return new Blob([t],{type:e});r('The "Blob" constructor is not supported.')},gt=function(){var t="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";return function(e,n,i){if(!i&&"undefined"!=typeof URL&&URL.createObjectURL){var r=ft(e,n);return URL.createObjectURL(r)}for(var a="data:"+n+";base64,",s=0,o=e.length;s<o;s+=3){var c=255&e[s],l=255&e[s+1],h=255&e[s+2],u=c>>2,d=(3&c)<<4|l>>4,p=s+1<o?(15&l)<<2|h>>6:64,f=s+2<o?63&h:64;a+=t[u]+t[d]+t[p]+t[f]}return a}}();F.prototype={on:function(t,e,n){var i=this.actionHandler;i[t]&&s('There is already an actionName called "'+t+'"'),i[t]=[e,n]},send:function(t,e,n){var i={sourceName:this.sourceName,targetName:this.targetName,action:t,data:e};this.postMessage(i,n)},sendWithPromise:function(t,e,n){var i=this.callbackIndex++,r={sourceName:this.sourceName,targetName:this.targetName,action:t,data:e,callbackId:i},a=M();this.callbacksCapabilities[i]=a;try{this.postMessage(r,n)}catch(t){a.reject(t)}return a.promise},postMessage:function(t,e){e&&this.postMessageTransfers?this.comObj.postMessage(t,e):this.comObj.postMessage(t)},destroy:function(){this.comObj.removeEventListener("message",this._onComObjOnMessage)}},function(t){function e(t){return void 0!==u[t]}function n(){o.call(this),this._isInvalid=!0}function i(t){return""===t&&n.call(this),t.toLowerCase()}function r(t){var e=t.charCodeAt(0);return e>32&&e<127&&[34,35,60,62,63,96].indexOf(e)===-1?t:encodeURIComponent(t)}function a(t){var e=t.charCodeAt(0);return e>32&&e<127&&[34,35,60,62,96].indexOf(e)===-1?t:encodeURIComponent(t)}function s(t,s,o){function c(t){b.push(t)}var l=s||"scheme start",h=0,m="",A=!1,v=!1,b=[];t:for(;(t[h-1]!==p||0===h)&&!this._isInvalid;){var y=t[h];switch(l){case"scheme start":if(!y||!f.test(y)){if(s){c("Invalid scheme.");break t}m="",l="no scheme";continue}m+=y.toLowerCase(),l="scheme";break;case"scheme":if(y&&g.test(y))m+=y.toLowerCase();else{if(":"!==y){if(s){if(p===y)break t;c("Code point not allowed in scheme: "+y);break t}m="",h=0,l="no scheme";continue}if(this._scheme=m,m="",s)break t;e(this._scheme)&&(this._isRelative=!0),l="file"===this._scheme?"relative":this._isRelative&&o&&o._scheme===this._scheme?"relative or authority":this._isRelative?"authority first slash":"scheme data"}break;case"scheme data":"?"===y?(this._query="?",l="query"):"#"===y?(this._fragment="#",l="fragment"):p!==y&&"\t"!==y&&"\n"!==y&&"\r"!==y&&(this._schemeData+=r(y));break;case"no scheme":if(o&&e(o._scheme)){l="relative";continue}c("Missing scheme."),n.call(this);break;case"relative or authority":if("/"!==y||"/"!==t[h+1]){c("Expected /, got: "+y),l="relative";continue}l="authority ignore slashes";break;case"relative":if(this._isRelative=!0,"file"!==this._scheme&&(this._scheme=o._scheme),p===y){this._host=o._host,this._port=o._port,this._path=o._path.slice(),this._query=o._query,this._username=o._username,this._password=o._password;break t}if("/"===y||"\\"===y)"\\"===y&&c("\\ is an invalid code point."),l="relative slash";else if("?"===y)this._host=o._host,this._port=o._port,this._path=o._path.slice(),this._query="?",this._username=o._username,this._password=o._password,l="query";else{if("#"!==y){var x=t[h+1],S=t[h+2];("file"!==this._scheme||!f.test(y)||":"!==x&&"|"!==x||p!==S&&"/"!==S&&"\\"!==S&&"?"!==S&&"#"!==S)&&(this._host=o._host,this._port=o._port,this._username=o._username,this._password=o._password,this._path=o._path.slice(),this._path.pop()),l="relative path";continue}this._host=o._host,this._port=o._port,this._path=o._path.slice(),this._query=o._query,this._fragment="#",this._username=o._username,this._password=o._password,l="fragment"}break;case"relative slash":if("/"!==y&&"\\"!==y){"file"!==this._scheme&&(this._host=o._host,this._port=o._port,this._username=o._username,this._password=o._password),l="relative path";continue}"\\"===y&&c("\\ is an invalid code point."),l="file"===this._scheme?"file host":"authority ignore slashes";break;case"authority first slash":if("/"!==y){c("Expected '/', got: "+y),l="authority ignore slashes";continue}l="authority second slash";break;case"authority second slash":if(l="authority ignore slashes","/"!==y){c("Expected '/', got: "+y);continue}break;case"authority ignore slashes":if("/"!==y&&"\\"!==y){l="authority";continue}c("Expected authority, got: "+y);break;case"authority":if("@"===y){A&&(c("@ already seen."),m+="%40"),A=!0;for(var k=0;k<m.length;k++){var C=m[k];if("\t"!==C&&"\n"!==C&&"\r"!==C)if(":"!==C||null!==this._password){var _=r(C);null!==this._password?this._password+=_:this._username+=_}else this._password="";else c("Invalid whitespace in authority.")}m=""}else{if(p===y||"/"===y||"\\"===y||"?"===y||"#"===y){h-=m.length,m="",l="host";continue}m+=y}break;case"file host":if(p===y||"/"===y||"\\"===y||"?"===y||"#"===y){2!==m.length||!f.test(m[0])||":"!==m[1]&&"|"!==m[1]?0===m.length?l="relative path start":(this._host=i.call(this,m),m="",l="relative path start"):l="relative path";continue}"\t"===y||"\n"===y||"\r"===y?c("Invalid whitespace in file host."):m+=y;break;case"host":case"hostname":if(":"!==y||v){if(p===y||"/"===y||"\\"===y||"?"===y||"#"===y){if(this._host=i.call(this,m),m="",l="relative path start",s)break t;continue}"\t"!==y&&"\n"!==y&&"\r"!==y?("["===y?v=!0:"]"===y&&(v=!1),m+=y):c("Invalid code point in host/hostname: "+y)}else if(this._host=i.call(this,m),m="",l="port","hostname"===s)break t;break;case"port":if(/[0-9]/.test(y))m+=y;else{if(p===y||"/"===y||"\\"===y||"?"===y||"#"===y||s){if(""!==m){var w=parseInt(m,10);w!==u[this._scheme]&&(this._port=w+""),m=""}if(s)break t;l="relative path start";continue}"\t"===y||"\n"===y||"\r"===y?c("Invalid code point in port: "+y):n.call(this)}break;case"relative path start":if("\\"===y&&c("'\\' not allowed in path."),l="relative path","/"!==y&&"\\"!==y)continue;break;case"relative path":if(p!==y&&"/"!==y&&"\\"!==y&&(s||"?"!==y&&"#"!==y))"\t"!==y&&"\n"!==y&&"\r"!==y&&(m+=r(y));else{"\\"===y&&c("\\ not allowed in relative path.");var T;(T=d[m.toLowerCase()])&&(m=T),".."===m?(this._path.pop(),"/"!==y&&"\\"!==y&&this._path.push("")):"."===m&&"/"!==y&&"\\"!==y?this._path.push(""):"."!==m&&("file"===this._scheme&&0===this._path.length&&2===m.length&&f.test(m[0])&&"|"===m[1]&&(m=m[0]+":"),this._path.push(m)),m="","?"===y?(this._query="?",l="query"):"#"===y&&(this._fragment="#",l="fragment")}break;case"query":s||"#"!==y?p!==y&&"\t"!==y&&"\n"!==y&&"\r"!==y&&(this._query+=a(y)):(this._fragment="#",l="fragment");break;case"fragment":p!==y&&"\t"!==y&&"\n"!==y&&"\r"!==y&&(this._fragment+=y)}h++}}function o(){this._scheme="",this._schemeData="",this._username="",this._password=null,this._host="",this._port="",this._path=[],this._query="",this._fragment="",this._isInvalid=!1,this._isRelative=!1}function c(t,e){void 0===e||e instanceof c||(e=new c(String(e))),this._url=t,o.call(this);var n=t.replace(/^[ \t\r\n\f]+|[ \t\r\n\f]+$/g,"");s.call(this,n,null,e)}var l=!1;try{if("function"==typeof URL&&"object"==typeof URL.prototype&&"origin"in URL.prototype){var h=new URL("b","http://a");h.pathname="c%20d",l="http://a/c%20d"===h.href}}catch(t){}if(!l){var u=Object.create(null);u.ftp=21,u.file=0,u.gopher=70,u.http=80,u.https=443,u.ws=80,u.wss=443;var d=Object.create(null);d["%2e"]=".",d[".%2e"]="..",d["%2e."]="..",d["%2e%2e"]="..";var p,f=/[a-zA-Z]/,g=/[a-zA-Z0-9\+\-\.]/;c.prototype={toString:function(){return this.href},get href(){if(this._isInvalid)return this._url;var t="";return""===this._username&&null===this._password||(t=this._username+(null!==this._password?":"+this._password:"")+"@"),this.protocol+(this._isRelative?"//"+t+this.host:"")+this.pathname+this._query+this._fragment},set href(t){o.call(this),s.call(this,t)},get protocol(){return this._scheme+":"},set protocol(t){this._isInvalid||s.call(this,t+":","scheme start")},get host(){return this._isInvalid?"":this._port?this._host+":"+this._port:this._host},set host(t){!this._isInvalid&&this._isRelative&&s.call(this,t,"host")},get hostname(){return this._host},set hostname(t){!this._isInvalid&&this._isRelative&&s.call(this,t,"hostname")},get port(){return this._port},set port(t){!this._isInvalid&&this._isRelative&&s.call(this,t,"port")},get pathname(){return this._isInvalid?"":this._isRelative?"/"+this._path.join("/"):this._schemeData},set pathname(t){!this._isInvalid&&this._isRelative&&(this._path=[],s.call(this,t,"relative path start"))},get search(){return this._isInvalid||!this._query||"?"===this._query?"":this._query},set search(t){!this._isInvalid&&this._isRelative&&(this._query="?","?"===t[0]&&(t=t.slice(1)),s.call(this,t,"query"))},get hash(){return this._isInvalid||!this._fragment||"#"===this._fragment?"":this._fragment},set hash(t){this._isInvalid||(this._fragment="#","#"===t[0]&&(t=t.slice(1)),s.call(this,t,"fragment"))},get origin(){var t;if(this._isInvalid||!this._scheme)return"";switch(this._scheme){case"data":case"file":case"javascript":case"mailto":return"null"}return t=this.host,t?this._scheme+"://"+t:""}};var m=t.URL;m&&(c.createObjectURL=function(t){return m.createObjectURL.apply(m,arguments)},c.revokeObjectURL=function(t){m.revokeObjectURL(t)}),t.URL=c}}(U),t.FONT_IDENTITY_MATRIX=B,t.IDENTITY_MATRIX=lt,t.OPS=Q,t.VERBOSITY_LEVELS=J,t.UNSUPPORTED_FEATURES=Z,t.AnnotationBorderStyleType=Y,t.AnnotationFieldFlag=H,t.AnnotationFlag=z,t.AnnotationType=X,t.FontType=V,t.ImageKind=G,t.InvalidPDFException=nt,t.MessageHandler=F,t.MissingDataException=st,t.MissingPDFException=it,t.NotImplementedException=at,t.PageViewport=ut,t.PasswordException=tt,t.PasswordResponses=$,t.StatTimer=pt,t.StreamType=q,t.TextRenderingMode=W,t.UnexpectedResponseException=rt,t.UnknownErrorException=et,t.Util=ht,t.XRefParseException=ot,t.arrayByteLength=m,t.arraysToBytes=A,t.assert=c,t.bytesToString=f,t.createBlob=ft,t.createPromiseCapability=M,t.createObjectURL=gt,t.deprecated=a,t.error=s,t.getLookupTableFactory=d,t.getVerbosityLevel=n,t.globalScope=U,t.info=i,t.isArray=D,t.isArrayBuffer=j,t.isBool=P,t.isEmptyObj=L,t.isInt=E,t.isNum=R,t.isString=I,t.isSpace=O,t.isSameOrigin=l,t.isValidUrl=h,t.isLittleEndian=k,t.isEvalSupported=C,t.loadJpegStream=N,t.log2=b,t.readInt8=y,t.readUint16=x,t.readUint32=S,t.removeNullCharacters=p,t.setVerbosityLevel=e,t.shadow=u,t.string32=v,t.stringToBytes=g,t.stringToPDFString=_,t.stringToUTF8String=w,t.utf8StringToString=T,t.warn=r}),function(t,e){e(t.pdfjsDisplayDOMUtils={},t.pdfjsSharedUtil)}(this,function(t,e){function n(){var t=document.createElement("canvas");return t.width=t.height=1,void 0!==t.getContext("2d").createImageData(1,1).data.buffer}function i(t,e){var n=e&&e.url;if(t.href=t.title=n?o(n):"",n){var i=e.target;void 0===i&&(i=a("externalLinkTarget")),t.target=u[i];var r=e.rel;void 0===r&&(r=a("externalLinkRel")),t.rel=r}}function r(t){var e=t.indexOf("#"),n=t.indexOf("?"),i=Math.min(e>0?e:t.length,n>0?n:t.length);return t.substring(t.lastIndexOf("/",i)+1,i)}function a(t){var n=e.globalScope.PDFJS;switch(t){case"pdfBug":return!!n&&n.pdfBug;case"disableAutoFetch":return!!n&&n.disableAutoFetch;case"disableStream":return!!n&&n.disableStream;case"disableRange":return!!n&&n.disableRange;case"disableFontFace":return!!n&&n.disableFontFace;case"disableCreateObjectURL":return!!n&&n.disableCreateObjectURL;case"disableWebGL":return!n||n.disableWebGL;case"cMapUrl":return n?n.cMapUrl:null;case"cMapPacked":return!!n&&n.cMapPacked;case"postMessageTransfers":return!n||n.postMessageTransfers;case"workerSrc":return n?n.workerSrc:null;case"disableWorker":return!!n&&n.disableWorker;case"maxImageSize":return n?n.maxImageSize:-1;case"imageResourcesPath":return n?n.imageResourcesPath:"";case"isEvalSupported":return!n||n.isEvalSupported;case"externalLinkTarget":if(!n)return h.NONE;switch(n.externalLinkTarget){case h.NONE:case h.SELF:case h.BLANK:case h.PARENT:case h.TOP:return n.externalLinkTarget}return c("PDFJS.externalLinkTarget is invalid: "+n.externalLinkTarget),n.externalLinkTarget=h.NONE,h.NONE;case"externalLinkRel":return n?n.externalLinkRel:"noreferrer";case"enableStats":return!(!n||!n.enableStats);default:throw new Error("Unknown default setting: "+t)}}function s(){switch(a("externalLinkTarget")){case h.NONE:return!1;case h.SELF:case h.BLANK:case h.PARENT:case h.TOP:return!0}}var o=e.removeNullCharacters,c=e.warn,l=function(){function t(){}var e=["ms","Moz","Webkit","O"],n=Object.create(null);return t.getProp=function(t,i){if(1===arguments.length&&"string"==typeof n[t])return n[t];i=i||document.documentElement;var r,a,s=i.style;if("string"==typeof s[t])return n[t]=t;a=t.charAt(0).toUpperCase()+t.slice(1);for(var o=0,c=e.length;o<c;o++)if(r=e[o]+a,"string"==typeof s[r])return n[t]=r;return n[t]="undefined"},t.setProp=function(t,e,n){var i=this.getProp(t);"undefined"!==i&&(e.style[i]=n)},t}(),h={NONE:0,SELF:1,BLANK:2,PARENT:3,TOP:4},u=["","_self","_blank","_parent","_top"];t.CustomStyle=l,t.addLinkAttributes=i,t.isExternalLinkTargetSet=s,t.getFilenameFromUrl=r,t.LinkTarget=h,t.hasCanvasTypedArrays=n,t.getDefaultSetting=a}),function(t,e){e(t.pdfjsDisplayFontLoader={},t.pdfjsSharedUtil)}(this,function(t,e){function n(t){this.docId=t,this.styleElement=null,this.nativeFontFaces=[],this.loadTestFontId=0,this.loadingContext={requests:[],nextRequestId:0}}var i=e.assert,r=e.bytesToString,a=e.string32,s=e.shadow,o=e.warn;n.prototype={insertRule:function(t){var e=this.styleElement;e||(e=this.styleElement=document.createElement("style"),e.id="PDFJS_FONT_STYLE_TAG_"+this.docId,document.documentElement.getElementsByTagName("head")[0].appendChild(e));var n=e.sheet
;n.insertRule(t,n.cssRules.length)},clear:function(){var t=this.styleElement;t&&(t.parentNode.removeChild(t),t=this.styleElement=null),this.nativeFontFaces.forEach(function(t){document.fonts.delete(t)}),this.nativeFontFaces.length=0},get loadTestFont(){return s(this,"loadTestFont",atob("T1RUTwALAIAAAwAwQ0ZGIDHtZg4AAAOYAAAAgUZGVE1lkzZwAAAEHAAAABxHREVGABQAFQAABDgAAAAeT1MvMlYNYwkAAAEgAAAAYGNtYXABDQLUAAACNAAAAUJoZWFk/xVFDQAAALwAAAA2aGhlYQdkA+oAAAD0AAAAJGhtdHgD6AAAAAAEWAAAAAZtYXhwAAJQAAAAARgAAAAGbmFtZVjmdH4AAAGAAAAAsXBvc3T/hgAzAAADeAAAACAAAQAAAAEAALZRFsRfDzz1AAsD6AAAAADOBOTLAAAAAM4KHDwAAAAAA+gDIQAAAAgAAgAAAAAAAAABAAADIQAAAFoD6AAAAAAD6AABAAAAAAAAAAAAAAAAAAAAAQAAUAAAAgAAAAQD6AH0AAUAAAKKArwAAACMAooCvAAAAeAAMQECAAACAAYJAAAAAAAAAAAAAQAAAAAAAAAAAAAAAFBmRWQAwAAuAC4DIP84AFoDIQAAAAAAAQAAAAAAAAAAACAAIAABAAAADgCuAAEAAAAAAAAAAQAAAAEAAAAAAAEAAQAAAAEAAAAAAAIAAQAAAAEAAAAAAAMAAQAAAAEAAAAAAAQAAQAAAAEAAAAAAAUAAQAAAAEAAAAAAAYAAQAAAAMAAQQJAAAAAgABAAMAAQQJAAEAAgABAAMAAQQJAAIAAgABAAMAAQQJAAMAAgABAAMAAQQJAAQAAgABAAMAAQQJAAUAAgABAAMAAQQJAAYAAgABWABYAAAAAAAAAwAAAAMAAAAcAAEAAAAAADwAAwABAAAAHAAEACAAAAAEAAQAAQAAAC7//wAAAC7////TAAEAAAAAAAABBgAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAD/gwAyAAAAAQAAAAAAAAAAAAAAAAAAAAABAAQEAAEBAQJYAAEBASH4DwD4GwHEAvgcA/gXBIwMAYuL+nz5tQXkD5j3CBLnEQACAQEBIVhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYWFhYAAABAQAADwACAQEEE/t3Dov6fAH6fAT+fPp8+nwHDosMCvm1Cvm1DAz6fBQAAAAAAAABAAAAAMmJbzEAAAAAzgTjFQAAAADOBOQpAAEAAAAAAAAADAAUAAQAAAABAAAAAgABAAAAAAAAAAAD6AAAAAAAAA=="))},addNativeFontFace:function(t){this.nativeFontFaces.push(t),document.fonts.add(t)},bind:function(t,e){for(var i=[],r=[],a=[],s=function(t){return t.loaded.catch(function(e){o('Failed to load font "'+t.family+'": '+e)})},c=0,l=t.length;c<l;c++){var h=t[c];if(!h.attached&&h.loading!==!1)if(h.attached=!0,n.isFontLoadingAPISupported){var u=h.createNativeFontFace();u&&(this.addNativeFontFace(u),a.push(s(u)))}else{var d=h.createFontFaceRule();d&&(this.insertRule(d),i.push(d),r.push(h))}}var p=this.queueLoadingCallback(e);n.isFontLoadingAPISupported?Promise.all(a).then(function(){p.complete()}):i.length>0&&!n.isSyncFontLoadingSupported?this.prepareFontLoadEvent(i,r,p):p.complete()},queueLoadingCallback:function(t){function e(){for(i(!a.end,"completeRequest() cannot be called twice"),a.end=Date.now();n.requests.length>0&&n.requests[0].end;){var t=n.requests.shift();setTimeout(t.callback,0)}}var n=this.loadingContext,r="pdfjs-font-loading-"+n.nextRequestId++,a={id:r,complete:e,callback:t,started:Date.now()};return n.requests.push(a),a},prepareFontLoadEvent:function(t,e,n){function i(t,e){return t.charCodeAt(e)<<24|t.charCodeAt(e+1)<<16|t.charCodeAt(e+2)<<8|255&t.charCodeAt(e+3)}function r(t,e,n,i){return t.substr(0,e)+i+t.substr(e+n)}function s(t,e){return++d>30?(o("Load test font never loaded."),void e()):(u.font="30px "+t,u.fillText(".",0,20),u.getImageData(0,0,1,1).data[3]>0?void e():void setTimeout(s.bind(null,t,e)))}var c,l,h=document.createElement("canvas");h.width=1,h.height=1;var u=h.getContext("2d"),d=0,p="lt"+Date.now()+this.loadTestFontId++,f=this.loadTestFont;f=r(f,976,p.length,p);var g=i(f,16);for(c=0,l=p.length-3;c<l;c+=4)g=g-1482184792+i(p,c)|0;c<p.length&&(g=g-1482184792+i(p+"XXX",c)|0),f=r(f,16,4,a(g));var m="url(data:font/opentype;base64,"+btoa(f)+");",A='@font-face { font-family:"'+p+'";src:'+m+"}";this.insertRule(A);var v=[];for(c=0,l=e.length;c<l;c++)v.push(e[c].loadedName);v.push(p);var b=document.createElement("div");for(b.setAttribute("style","visibility: hidden;width: 10px; height: 10px;position: absolute; top: 0px; left: 0px;"),c=0,l=v.length;c<l;++c){var y=document.createElement("span");y.textContent="Hi",y.style.fontFamily=v[c],b.appendChild(y)}document.body.appendChild(b),s(p,function(){document.body.removeChild(b),n.complete()})}},n.isFontLoadingAPISupported="undefined"!=typeof document&&!!document.fonts,Object.defineProperty(n,"isSyncFontLoadingSupported",{get:function(){if("undefined"==typeof navigator)return s(n,"isSyncFontLoadingSupported",!0);var t=!1,e=/Mozilla\/5.0.*?rv:(\d+).*? Gecko/.exec(navigator.userAgent);return e&&e[1]>=14&&(t=!0),s(n,"isSyncFontLoadingSupported",t)},enumerable:!0,configurable:!0});var c={get value(){return s(this,"value",e.isEvalSupported())}},l=function(){function t(t,e){this.compiledGlyphs=Object.create(null);for(var n in t)this[n]=t[n];this.options=e}return t.prototype={createNativeFontFace:function(){if(!this.data)return null;if(this.options.disableFontFace)return this.disableFontFace=!0,null;var t=new FontFace(this.loadedName,this.data,{});return this.options.fontRegistry&&this.options.fontRegistry.registerFont(this),t},createFontFaceRule:function(){if(!this.data)return null;if(this.options.disableFontFace)return this.disableFontFace=!0,null;var t=r(new Uint8Array(this.data)),e=this.loadedName,n="url(data:"+this.mimetype+";base64,"+btoa(t)+");",i='@font-face { font-family:"'+e+'";src:'+n+"}";return this.options.fontRegistry&&this.options.fontRegistry.registerFont(this,n),i},getPathGenerator:function(t,e){if(!(e in this.compiledGlyphs)){var n,i,r,a=t.get(this.loadedName+"_path_"+e);if(this.options.isEvalSupported&&c.value){var s,o="";for(i=0,r=a.length;i<r;i++)n=a[i],s=void 0!==n.args?n.args.join(","):"",o+="c."+n.cmd+"("+s+");\n";this.compiledGlyphs[e]=new Function("c","size",o)}else this.compiledGlyphs[e]=function(t,e){for(i=0,r=a.length;i<r;i++)n=a[i],"scale"===n.cmd&&(n.args=[e,-e]),t[n.cmd].apply(t,n.args)}}return this.compiledGlyphs[e]}},t}();t.FontFaceObject=l,t.FontLoader=n}),function(t,e){e(t.pdfjsDisplayMetadata={},t.pdfjsSharedUtil)}(this,function(t,e){function n(t){return t.replace(/>\\376\\377([^<]+)/g,function(t,e){for(var n=e.replace(/\\([0-3])([0-7])([0-7])/g,function(t,e,n,i){return String.fromCharCode(64*e+8*n+1*i)}),i="",r=0;r<n.length;r+=2){var a=256*n.charCodeAt(r)+n.charCodeAt(r+1);i+="&#x"+(65536+a).toString(16).substring(1)+";"}return">"+i})}function i(t){if("string"==typeof t){t=n(t);t=(new DOMParser).parseFromString(t,"application/xml")}else t instanceof Document||r("Metadata: Invalid metadata object");this.metaDocument=t,this.metadata=Object.create(null),this.parse()}var r=e.error;i.prototype={parse:function(){var t=this.metaDocument,e=t.documentElement;if("rdf:rdf"!==e.nodeName.toLowerCase())for(e=e.firstChild;e&&"rdf:rdf"!==e.nodeName.toLowerCase();)e=e.nextSibling;var n=e?e.nodeName.toLowerCase():null;if(e&&"rdf:rdf"===n&&e.hasChildNodes()){var i,r,a,s,o,c,l,h=e.childNodes;for(s=0,c=h.length;s<c;s++)if(i=h[s],"rdf:description"===i.nodeName.toLowerCase())for(o=0,l=i.childNodes.length;o<l;o++)"#text"!==i.childNodes[o].nodeName.toLowerCase()&&(r=i.childNodes[o],a=r.nodeName.toLowerCase(),this.metadata[a]=r.textContent.trim())}},get:function(t){return this.metadata[t]||null},has:function(t){return void 0!==this.metadata[t]}},t.Metadata=i}),function(t,e){e(t.pdfjsDisplaySVG={},t.pdfjsSharedUtil)}(this,function(t,e){var n=e.FONT_IDENTITY_MATRIX,i=e.IDENTITY_MATRIX,r=e.ImageKind,a=e.OPS,s=e.Util,o=e.isNum,c=e.isArray,l=e.warn,h=e.createObjectURL,u={fontStyle:"normal",fontWeight:"normal",fillColor:"#000000"},d=function(){function t(t,e,n){for(var i=-1,r=e;r<n;r++){i=i>>>8^s[255&(i^t[r])]}return i^-1}function e(e,n,i,r){var a=r,s=n.length;i[a]=s>>24&255,i[a+1]=s>>16&255,i[a+2]=s>>8&255,i[a+3]=255&s,a+=4,i[a]=255&e.charCodeAt(0),i[a+1]=255&e.charCodeAt(1),i[a+2]=255&e.charCodeAt(2),i[a+3]=255&e.charCodeAt(3),a+=4,i.set(n,a),a+=n.length;var o=t(i,r+4,a);i[a]=o>>24&255,i[a+1]=o>>16&255,i[a+2]=o>>8&255,i[a+3]=255&o}function n(t,e,n){for(var i=1,r=0,a=e;a<n;++a)i=(i+(255&t[a]))%65521,r=(r+i)%65521;return r<<16|i}function i(t,i,s){var o,c,l,u=t.width,d=t.height,p=t.data;switch(i){case r.GRAYSCALE_1BPP:c=0,o=1,l=u+7>>3;break;case r.RGB_24BPP:c=2,o=8,l=3*u;break;case r.RGBA_32BPP:c=6,o=8,l=4*u;break;default:throw new Error("invalid format")}var f,g,m=new Uint8Array((1+l)*d),A=0,v=0;for(f=0;f<d;++f)m[A++]=0,m.set(p.subarray(v,v+l),A),v+=l,A+=l;if(i===r.GRAYSCALE_1BPP)for(A=0,f=0;f<d;f++)for(A++,g=0;g<l;g++)m[A++]^=255;var b=new Uint8Array([u>>24&255,u>>16&255,u>>8&255,255&u,d>>24&255,d>>16&255,d>>8&255,255&d,o,c,0,0,0]),y=m.length,x=Math.ceil(y/65535),S=new Uint8Array(2+y+5*x+4),k=0;S[k++]=120,S[k++]=156;for(var C=0;y>65535;)S[k++]=0,S[k++]=255,S[k++]=255,S[k++]=0,S[k++]=0,S.set(m.subarray(C,C+65535),k),k+=65535,C+=65535,y-=65535;S[k++]=1,S[k++]=255&y,S[k++]=y>>8&255,S[k++]=255&~y,S[k++]=(65535&~y)>>8&255,S.set(m.subarray(C),k),k+=m.length-C;var _=n(m,0,m.length);S[k++]=_>>24&255,S[k++]=_>>16&255,S[k++]=_>>8&255,S[k++]=255&_;var w=a.length+36+b.length+S.length,T=new Uint8Array(w),L=0;return T.set(a,L),L+=a.length,e("IHDR",b,T,L),L+=12+b.length,e("IDATA",S,T,L),L+=12+S.length,e("IEND",new Uint8Array(0),T,L),h(T,"image/png",s)}for(var a=new Uint8Array([137,80,78,71,13,10,26,10]),s=new Int32Array(256),o=0;o<256;o++){for(var c=o,l=0;l<8;l++)c=1&c?3988292384^c>>1&2147483647:c>>1&2147483647;s[o]=c}return function(t,e){return i(t,void 0===t.kind?r.GRAYSCALE_1BPP:t.kind,e)}}(),p=function(){function t(){this.fontSizeScale=1,this.fontWeight=u.fontWeight,this.fontSize=0,this.textMatrix=i,this.fontMatrix=n,this.leading=0,this.x=0,this.y=0,this.lineX=0,this.lineY=0,this.charSpacing=0,this.wordSpacing=0,this.textHScale=1,this.textRise=0,this.fillColor=u.fillColor,this.strokeColor="#000000",this.fillAlpha=1,this.strokeAlpha=1,this.lineWidth=1,this.lineJoin="",this.lineCap="",this.miterLimit=0,this.dashArray=[],this.dashPhase=0,this.dependencies=[],this.clipId="",this.pendingClip=!1,this.maskId=""}return t.prototype={clone:function(){return Object.create(this)},setCurrentPoint:function(t,e){this.x=t,this.y=e}},t}(),f=function(){function t(t,e){var n=document.createElementNS("http://www.w3.org/2000/svg","svg:svg");return n.setAttributeNS(null,"version","1.1"),n.setAttributeNS(null,"width",t+"px"),n.setAttributeNS(null,"height",e+"px"),n.setAttributeNS(null,"viewBox","0 0 "+t+" "+e),n}function e(t){for(var e=[],n=[],i=t.length,r=0;r<i;r++)"save"!==t[r].fn?"restore"===t[r].fn?e=n.pop():e.push(t[r]):(e.push({fnId:92,fn:"group",items:[]}),n.push(e),e=e[e.length-1].items);return e}function r(t){if(t===(0|t))return t.toString();var e=t.toFixed(10),n=e.length-1;if("0"!==e[n])return e;do n--;while("0"===e[n]);return e.substr(0,"."===e[n]?n:n+1)}function f(t){if(0===t[4]&&0===t[5]){if(0===t[1]&&0===t[2])return 1===t[0]&&1===t[3]?"":"scale("+r(t[0])+" "+r(t[3])+")";if(t[0]===t[3]&&t[1]===-t[2]){return"rotate("+r(180*Math.acos(t[0])/Math.PI)+")"}}else if(1===t[0]&&0===t[1]&&0===t[2]&&1===t[3])return"translate("+r(t[4])+" "+r(t[5])+")";return"matrix("+r(t[0])+" "+r(t[1])+" "+r(t[2])+" "+r(t[3])+" "+r(t[4])+" "+r(t[5])+")"}function g(t,e,n){this.current=new p,this.transformMatrix=i,this.transformStack=[],this.extraStack=[],this.commonObjs=t,this.objs=e,this.pendingEOFill=!1,this.embedFonts=!1,this.embeddedFonts=Object.create(null),this.cssStyle=null,this.forceDataSchema=!!n}var m="http://www.w3.org/2000/svg",A="http://www.w3.org/1999/xlink",v=["butt","round","square"],b=["miter","round","bevel"],y=0,x=0;return g.prototype={save:function(){this.transformStack.push(this.transformMatrix);var t=this.current;this.extraStack.push(t),this.current=t.clone()},restore:function(){this.transformMatrix=this.transformStack.pop(),this.current=this.extraStack.pop(),this.tgrp=document.createElementNS(m,"svg:g"),this.tgrp.setAttributeNS(null,"transform",f(this.transformMatrix)),this.pgrp.appendChild(this.tgrp)},group:function(t){this.save(),this.executeOpTree(t),this.restore()},loadDependencies:function(t){for(var e=t.fnArray,n=e.length,i=t.argsArray,r=this,s=0;s<n;s++)if(a.dependency===e[s])for(var o=i[s],c=0,l=o.length;c<l;c++){var h,u=o[c],d="g_"===u.substring(0,2);h=d?new Promise(function(t){r.commonObjs.get(u,t)}):new Promise(function(t){r.objs.get(u,t)}),this.current.dependencies.push(h)}return Promise.all(this.current.dependencies)},transform:function(t,e,n,i,r,a){var o=[t,e,n,i,r,a];this.transformMatrix=s.transform(this.transformMatrix,o),this.tgrp=document.createElementNS(m,"svg:g"),this.tgrp.setAttributeNS(null,"transform",f(this.transformMatrix))},getSVG:function(e,n){return this.svg=t(n.width,n.height),this.viewport=n,this.loadDependencies(e).then(function(){this.transformMatrix=i,this.pgrp=document.createElementNS(m,"svg:g"),this.pgrp.setAttributeNS(null,"transform",f(n.transform)),this.tgrp=document.createElementNS(m,"svg:g"),this.tgrp.setAttributeNS(null,"transform",f(this.transformMatrix)),this.defs=document.createElementNS(m,"svg:defs"),this.pgrp.appendChild(this.defs),this.pgrp.appendChild(this.tgrp),this.svg.appendChild(this.pgrp);var t=this.convertOpList(e);return this.executeOpTree(t),this.svg}.bind(this))},convertOpList:function(t){var n=t.argsArray,i=t.fnArray,r=i.length,s=[],o=[];for(var c in a)s[a[c]]=c;for(var l=0;l<r;l++){var h=i[l];o.push({fnId:h,fn:s[h],args:n[l]})}return e(o)},executeOpTree:function(t){for(var e=t.length,n=0;n<e;n++){var i=t[n].fn,r=t[n].fnId,s=t[n].args;switch(0|r){case a.beginText:this.beginText();break;case a.setLeading:this.setLeading(s);break;case a.setLeadingMoveText:this.setLeadingMoveText(s[0],s[1]);break;case a.setFont:this.setFont(s);break;case a.showText:this.showText(s[0]);break;case a.showSpacedText:this.showText(s[0]);break;case a.endText:this.endText();break;case a.moveText:this.moveText(s[0],s[1]);break;case a.setCharSpacing:this.setCharSpacing(s[0]);break;case a.setWordSpacing:this.setWordSpacing(s[0]);break;case a.setHScale:this.setHScale(s[0]);break;case a.setTextMatrix:this.setTextMatrix(s[0],s[1],s[2],s[3],s[4],s[5]);break;case a.setLineWidth:this.setLineWidth(s[0]);break;case a.setLineJoin:this.setLineJoin(s[0]);break;case a.setLineCap:this.setLineCap(s[0]);break;case a.setMiterLimit:this.setMiterLimit(s[0]);break;case a.setFillRGBColor:this.setFillRGBColor(s[0],s[1],s[2]);break;case a.setStrokeRGBColor:this.setStrokeRGBColor(s[0],s[1],s[2]);break;case a.setDash:this.setDash(s[0],s[1]);break;case a.setGState:this.setGState(s[0]);break;case a.fill:this.fill();break;case a.eoFill:this.eoFill();break;case a.stroke:this.stroke();break;case a.fillStroke:this.fillStroke();break;case a.eoFillStroke:this.eoFillStroke();break;case a.clip:this.clip("nonzero");break;case a.eoClip:this.clip("evenodd");break;case a.paintSolidColorImageMask:this.paintSolidColorImageMask();break;case a.paintJpegXObject:this.paintJpegXObject(s[0],s[1],s[2]);break;case a.paintImageXObject:this.paintImageXObject(s[0]);break;case a.paintInlineImageXObject:this.paintInlineImageXObject(s[0]);break;case a.paintImageMaskXObject:this.paintImageMaskXObject(s[0]);break;case a.paintFormXObjectBegin:this.paintFormXObjectBegin(s[0],s[1]);break;case a.paintFormXObjectEnd:this.paintFormXObjectEnd();break;case a.closePath:this.closePath();break;case a.closeStroke:this.closeStroke();break;case a.closeFillStroke:this.closeFillStroke();break;case a.nextLine:this.nextLine();break;case a.transform:this.transform(s[0],s[1],s[2],s[3],s[4],s[5]);break;case a.constructPath:this.constructPath(s[0],s[1]);break;case a.endPath:this.endPath();break;case 92:this.group(t[n].items);break;default:l("Unimplemented method "+i)}}},setWordSpacing:function(t){this.current.wordSpacing=t},setCharSpacing:function(t){this.current.charSpacing=t},nextLine:function(){this.moveText(0,this.current.leading)},setTextMatrix:function(t,e,n,i,a,s){var o=this.current;this.current.textMatrix=this.current.lineMatrix=[t,e,n,i,a,s],this.current.x=this.current.lineX=0,this.current.y=this.current.lineY=0,o.xcoords=[],o.tspan=document.createElementNS(m,"svg:tspan"),o.tspan.setAttributeNS(null,"font-family",o.fontFamily),o.tspan.setAttributeNS(null,"font-size",r(o.fontSize)+"px"),o.tspan.setAttributeNS(null,"y",r(-o.y)),o.txtElement=document.createElementNS(m,"svg:text"),o.txtElement.appendChild(o.tspan)},beginText:function(){this.current.x=this.current.lineX=0,this.current.y=this.current.lineY=0,this.current.textMatrix=i,this.current.lineMatrix=i,this.current.tspan=document.createElementNS(m,"svg:tspan"),this.current.txtElement=document.createElementNS(m,"svg:text"),this.current.txtgrp=document.createElementNS(m,"svg:g"),this.current.xcoords=[]},moveText:function(t,e){var n=this.current;this.current.x=this.current.lineX+=t,this.current.y=this.current.lineY+=e,n.xcoords=[],n.tspan=document.createElementNS(m,"svg:tspan"),n.tspan.setAttributeNS(null,"font-family",n.fontFamily),n.tspan.setAttributeNS(null,"font-size",r(n.fontSize)+"px"),n.tspan.setAttributeNS(null,"y",r(-n.y))},showText:function(t){var e=this.current,n=e.font,i=e.fontSize;if(0!==i){var a,s=e.charSpacing,c=e.wordSpacing,l=e.fontDirection,h=e.textHScale*l,d=t.length,p=n.vertical,g=i*e.fontMatrix[0],m=0;for(a=0;a<d;++a){var A=t[a];if(null!==A)if(o(A))m+=-A*i*.001;else{e.xcoords.push(e.x+m*h);var v=A.width,b=A.fontChar,y=v*g+s*l;m+=y,e.tspan.textContent+=b}else m+=l*c}p?e.y-=m*h:e.x+=m*h,e.tspan.setAttributeNS(null,"x",e.xcoords.map(r).join(" ")),e.tspan.setAttributeNS(null,"y",r(-e.y)),e.tspan.setAttributeNS(null,"font-family",e.fontFamily),e.tspan.setAttributeNS(null,"font-size",r(e.fontSize)+"px"),e.fontStyle!==u.fontStyle&&e.tspan.setAttributeNS(null,"font-style",e.fontStyle),e.fontWeight!==u.fontWeight&&e.tspan.setAttributeNS(null,"font-weight",e.fontWeight),e.fillColor!==u.fillColor&&e.tspan.setAttributeNS(null,"fill",e.fillColor),e.txtElement.setAttributeNS(null,"transform",f(e.textMatrix)+" scale(1, -1)"),e.txtElement.setAttributeNS("http://www.w3.org/XML/1998/namespace","xml:space","preserve"),e.txtElement.appendChild(e.tspan),e.txtgrp.appendChild(e.txtElement),this.tgrp.appendChild(e.txtElement)}},setLeadingMoveText:function(t,e){this.setLeading(-e),this.moveText(t,e)},addFontStyle:function(t){this.cssStyle||(this.cssStyle=document.createElementNS(m,"svg:style"),this.cssStyle.setAttributeNS(null,"type","text/css"),this.defs.appendChild(this.cssStyle));var e=h(t.data,t.mimetype,this.forceDataSchema);this.cssStyle.textContent+='@font-face { font-family: "'+t.loadedName+'"; src: url('+e+"); }\n"},setFont:function(t){var e=this.current,i=this.commonObjs.get(t[0]),a=t[1];this.current.font=i,this.embedFonts&&i.data&&!this.embeddedFonts[i.loadedName]&&(this.addFontStyle(i),this.embeddedFonts[i.loadedName]=i),e.fontMatrix=i.fontMatrix?i.fontMatrix:n;var s=i.black?i.bold?"bolder":"bold":i.bold?"bold":"normal",o=i.italic?"italic":"normal";a<0?(a=-a,e.fontDirection=-1):e.fontDirection=1,e.fontSize=a,e.fontFamily=i.loadedName,e.fontWeight=s,e.fontStyle=o,e.tspan=document.createElementNS(m,"svg:tspan"),e.tspan.setAttributeNS(null,"y",r(-e.y)),e.xcoords=[]},endText:function(){this.current.pendingClip?(this.cgrp.appendChild(this.tgrp),this.pgrp.appendChild(this.cgrp)):this.pgrp.appendChild(this.tgrp),this.tgrp=document.createElementNS(m,"svg:g"),this.tgrp.setAttributeNS(null,"transform",f(this.transformMatrix))},setLineWidth:function(t){this.current.lineWidth=t},setLineCap:function(t){this.current.lineCap=v[t]},setLineJoin:function(t){this.current.lineJoin=b[t]},setMiterLimit:function(t){this.current.miterLimit=t},setStrokeRGBColor:function(t,e,n){var i=s.makeCssRgb(t,e,n);this.current.strokeColor=i},setFillRGBColor:function(t,e,n){var i=s.makeCssRgb(t,e,n);this.current.fillColor=i,this.current.tspan=document.createElementNS(m,"svg:tspan"),this.current.xcoords=[]},setDash:function(t,e){this.current.dashArray=t,this.current.dashPhase=e},constructPath:function(t,e){var n=this.current,i=n.x,s=n.y;n.path=document.createElementNS(m,"svg:path");for(var o=[],c=t.length,l=0,h=0;l<c;l++)switch(0|t[l]){case a.rectangle:i=e[h++],s=e[h++];var u=e[h++],d=e[h++],p=i+u,f=s+d;o.push("M",r(i),r(s),"L",r(p),r(s),"L",r(p),r(f),"L",r(i),r(f),"Z");break;case a.moveTo:i=e[h++],s=e[h++],o.push("M",r(i),r(s));break;case a.lineTo:i=e[h++],s=e[h++],o.push("L",r(i),r(s));break;case a.curveTo:i=e[h+4],s=e[h+5],o.push("C",r(e[h]),r(e[h+1]),r(e[h+2]),r(e[h+3]),r(i),r(s)),h+=6;break;case a.curveTo2:i=e[h+2],s=e[h+3],o.push("C",r(i),r(s),r(e[h]),r(e[h+1]),r(e[h+2]),r(e[h+3])),h+=4;break;case a.curveTo3:i=e[h+2],s=e[h+3],o.push("C",r(e[h]),r(e[h+1]),r(i),r(s),r(i),r(s)),h+=4;break;case a.closePath:o.push("Z")}n.path.setAttributeNS(null,"d",o.join(" ")),n.path.setAttributeNS(null,"stroke-miterlimit",r(n.miterLimit)),n.path.setAttributeNS(null,"stroke-linecap",n.lineCap),n.path.setAttributeNS(null,"stroke-linejoin",n.lineJoin),n.path.setAttributeNS(null,"stroke-width",r(n.lineWidth)+"px"),n.path.setAttributeNS(null,"stroke-dasharray",n.dashArray.map(r).join(" ")),n.path.setAttributeNS(null,"stroke-dashoffset",r(n.dashPhase)+"px"),n.path.setAttributeNS(null,"fill","none"),this.tgrp.appendChild(n.path),n.pendingClip?(this.cgrp.appendChild(this.tgrp),this.pgrp.appendChild(this.cgrp)):this.pgrp.appendChild(this.tgrp),n.element=n.path,n.setCurrentPoint(i,s)},endPath:function(){this.current.pendingClip?(this.cgrp.appendChild(this.tgrp),this.pgrp.appendChild(this.cgrp)):this.pgrp.appendChild(this.tgrp),this.tgrp=document.createElementNS(m,"svg:g"),this.tgrp.setAttributeNS(null,"transform",f(this.transformMatrix))},clip:function(t){var e=this.current;e.clipId="clippath"+y,y++,this.clippath=document.createElementNS(m,"svg:clipPath"),this.clippath.setAttributeNS(null,"id",e.clipId);var n=e.element.cloneNode();"evenodd"===t?n.setAttributeNS(null,"clip-rule","evenodd"):n.setAttributeNS(null,"clip-rule","nonzero"),this.clippath.setAttributeNS(null,"transform",f(this.transformMatrix)),this.clippath.appendChild(n),this.defs.appendChild(this.clippath),e.pendingClip=!0,this.cgrp=document.createElementNS(m,"svg:g"),this.cgrp.setAttributeNS(null,"clip-path","url(#"+e.clipId+")"),this.pgrp.appendChild(this.cgrp)},closePath:function(){var t=this.current,e=t.path.getAttributeNS(null,"d");e+="Z",t.path.setAttributeNS(null,"d",e)},setLeading:function(t){this.current.leading=-t},setTextRise:function(t){this.current.textRise=t},setHScale:function(t){this.current.textHScale=t/100},setGState:function(t){for(var e=0,n=t.length;e<n;e++){var i=t[e],r=i[0],a=i[1];switch(r){case"LW":this.setLineWidth(a);break;case"LC":this.setLineCap(a);break;case"LJ":this.setLineJoin(a);break;case"ML":this.setMiterLimit(a);break;case"D":this.setDash(a[0],a[1]);break;case"RI":break;case"FL":break;case"Font":this.setFont(a);break;case"CA":break;case"ca":break;case"BM":break;case"SMask":}}},fill:function(){var t=this.current;t.element.setAttributeNS(null,"fill",t.fillColor)},stroke:function(){var t=this.current;t.element.setAttributeNS(null,"stroke",t.strokeColor),t.element.setAttributeNS(null,"fill","none")},eoFill:function(){var t=this.current;t.element.setAttributeNS(null,"fill",t.fillColor),t.element.setAttributeNS(null,"fill-rule","evenodd")},fillStroke:function(){this.stroke(),this.fill()},eoFillStroke:function(){this.current.element.setAttributeNS(null,"fill-rule","evenodd"),this.fillStroke()},closeStroke:function(){this.closePath(),this.stroke()},closeFillStroke:function(){this.closePath(),this.fillStroke()},paintSolidColorImageMask:function(){var t=this.current,e=document.createElementNS(m,"svg:rect");e.setAttributeNS(null,"x","0"),e.setAttributeNS(null,"y","0"),e.setAttributeNS(null,"width","1px"),e.setAttributeNS(null,"height","1px"),e.setAttributeNS(null,"fill",t.fillColor),this.tgrp.appendChild(e)},paintJpegXObject:function(t,e,n){var i=this.current,a=this.objs.get(t),s=document.createElementNS(m,"svg:image");s.setAttributeNS(A,"xlink:href",a.src),s.setAttributeNS(null,"width",a.width+"px"),s.setAttributeNS(null,"height",a.height+"px"),s.setAttributeNS(null,"x","0"),s.setAttributeNS(null,"y",r(-n)),s.setAttributeNS(null,"transform","scale("+r(1/e)+" "+r(-1/n)+")"),this.tgrp.appendChild(s),i.pendingClip?(this.cgrp.appendChild(this.tgrp),this.pgrp.appendChild(this.cgrp)):this.pgrp.appendChild(this.tgrp)},paintImageXObject:function(t){var e=this.objs.get(t);if(!e)return void l("Dependent image isn't ready yet");this.paintInlineImageXObject(e)},paintInlineImageXObject:function(t,e){var n=this.current,i=t.width,a=t.height,s=d(t,this.forceDataSchema),o=document.createElementNS(m,"svg:rect");o.setAttributeNS(null,"x","0"),o.setAttributeNS(null,"y","0"),o.setAttributeNS(null,"width",r(i)),o.setAttributeNS(null,"height",r(a)),n.element=o,this.clip("nonzero");var c=document.createElementNS(m,"svg:image");c.setAttributeNS(A,"xlink:href",s),c.setAttributeNS(null,"x","0"),c.setAttributeNS(null,"y",r(-a)),c.setAttributeNS(null,"width",r(i)+"px"),c.setAttributeNS(null,"height",r(a)+"px"),c.setAttributeNS(null,"transform","scale("+r(1/i)+" "+r(-1/a)+")"),e?e.appendChild(c):this.tgrp.appendChild(c),n.pendingClip?(this.cgrp.appendChild(this.tgrp),this.pgrp.appendChild(this.cgrp)):this.pgrp.appendChild(this.tgrp)},paintImageMaskXObject:function(t){var e=this.current,n=t.width,i=t.height,a=e.fillColor;e.maskId="mask"+x++;var s=document.createElementNS(m,"svg:mask");s.setAttributeNS(null,"id",e.maskId);var o=document.createElementNS(m,"svg:rect");o.setAttributeNS(null,"x","0"),o.setAttributeNS(null,"y","0"),o.setAttributeNS(null,"width",r(n)),o.setAttributeNS(null,"height",r(i)),o.setAttributeNS(null,"fill",a),o.setAttributeNS(null,"mask","url(#"+e.maskId+")"),this.defs.appendChild(s),this.tgrp.appendChild(o),this.paintInlineImageXObject(t,s)},paintFormXObjectBegin:function(t,e){if(this.save(),c(t)&&6===t.length&&this.transform(t[0],t[1],t[2],t[3],t[4],t[5]),c(e)&&4===e.length){var n=e[2]-e[0],i=e[3]-e[1],a=document.createElementNS(m,"svg:rect");a.setAttributeNS(null,"x",e[0]),a.setAttributeNS(null,"y",e[1]),a.setAttributeNS(null,"width",r(n)),a.setAttributeNS(null,"height",r(i)),this.current.element=a,this.clip("nonzero"),this.endPath()}},paintFormXObjectEnd:function(){this.restore()}},g}();t.SVGGraphics=f}),function(t,e){e(t.pdfjsDisplayAnnotationLayer={},t.pdfjsSharedUtil,t.pdfjsDisplayDOMUtils)}(this,function(t,e,n){function i(){}var r=e.AnnotationBorderStyleType,a=e.AnnotationType,s=e.Util,o=n.addLinkAttributes,c=n.LinkTarget,l=n.getFilenameFromUrl,h=e.warn,u=n.CustomStyle,d=n.getDefaultSetting;i.prototype={create:function(t){switch(t.data.annotationType){case a.LINK:return new f(t);case a.TEXT:return new g(t);case a.WIDGET:switch(t.data.fieldType){case"Tx":return new A(t)}return new m(t);case a.POPUP:return new v(t);case a.HIGHLIGHT:return new y(t);case a.UNDERLINE:return new x(t);case a.SQUIGGLY:return new S(t);case a.STRIKEOUT:return new k(t);case a.FILEATTACHMENT:return new C(t);default:return new p(t)}}};var p=function(){function t(t,e){this.isRenderable=e||!1,this.data=t.data,this.layer=t.layer,this.page=t.page,this.viewport=t.viewport,this.linkService=t.linkService,this.downloadManager=t.downloadManager,this.imageResourcesPath=t.imageResourcesPath,this.renderInteractiveForms=t.renderInteractiveForms,e&&(this.container=this._createContainer())}return t.prototype={_createContainer:function(){var t=this.data,e=this.page,n=this.viewport,i=document.createElement("section"),a=t.rect[2]-t.rect[0],o=t.rect[3]-t.rect[1];i.setAttribute("data-annotation-id",t.id);var c=s.normalizeRect([t.rect[0],e.view[3]-t.rect[1]+e.view[1],t.rect[2],e.view[3]-t.rect[3]+e.view[1]]);if(u.setProp("transform",i,"matrix("+n.transform.join(",")+")"),u.setProp("transformOrigin",i,-c[0]+"px "+-c[1]+"px"),t.borderStyle.width>0){i.style.borderWidth=t.borderStyle.width+"px",t.borderStyle.style!==r.UNDERLINE&&(a-=2*t.borderStyle.width,o-=2*t.borderStyle.width);var l=t.borderStyle.horizontalCornerRadius,d=t.borderStyle.verticalCornerRadius;if(l>0||d>0){var p=l+"px / "+d+"px";u.setProp("borderRadius",i,p)}switch(t.borderStyle.style){case r.SOLID:i.style.borderStyle="solid";break;case r.DASHED:i.style.borderStyle="dashed";break;case r.BEVELED:h("Unimplemented border style: beveled");break;case r.INSET:h("Unimplemented border style: inset");break;case r.UNDERLINE:i.style.borderBottomStyle="solid"}t.color?i.style.borderColor=s.makeCssRgb(0|t.color[0],0|t.color[1],0|t.color[2]):i.style.borderWidth=0}return i.style.left=c[0]+"px",i.style.top=c[1]+"px",i.style.width=a+"px",i.style.height=o+"px",i},_createPopup:function(t,e,n){e||(e=document.createElement("div"),e.style.height=t.style.height,e.style.width=t.style.width,t.appendChild(e));var i=new b({container:t,trigger:e,color:n.color,title:n.title,contents:n.contents,hideWrapper:!0}),r=i.render();r.style.left=t.style.width,t.appendChild(r)},render:function(){throw new Error("Abstract method AnnotationElement.render called")}},t}(),f=function(){function t(t){p.call(this,t,!0)}return s.inherit(t,p,{render:function(){this.container.className="linkAnnotation";var t=document.createElement("a");return o(t,{url:this.data.url,target:this.data.newWindow?c.BLANK:void 0}),this.data.url||(this.data.action?this._bindNamedAction(t,this.data.action):this._bindLink(t,this.data.dest||null)),this.container.appendChild(t),this.container},_bindLink:function(t,e){var n=this;t.href=this.linkService.getDestinationHash(e),t.onclick=function(){return e&&n.linkService.navigateTo(e),!1},e&&(t.className="internalLink")},_bindNamedAction:function(t,e){var n=this;t.href=this.linkService.getAnchorUrl(""),t.onclick=function(){return n.linkService.executeNamedAction(e),!1},t.className="internalLink"}}),t}(),g=function(){function t(t){var e=!!(t.data.hasPopup||t.data.title||t.data.contents);p.call(this,t,e)}return s.inherit(t,p,{render:function(){this.container.className="textAnnotation";var t=document.createElement("img");return t.style.height=this.container.style.height,t.style.width=this.container.style.width,t.src=this.imageResourcesPath+"annotation-"+this.data.name.toLowerCase()+".svg",t.alt="[{{type}} Annotation]",t.dataset.l10nId="text_annotation_type",t.dataset.l10nArgs=JSON.stringify({type:this.data.name}),this.data.hasPopup||this._createPopup(this.container,t,this.data),this.container.appendChild(t),this.container}}),t}(),m=function(){function t(t){var e=t.renderInteractiveForms||!t.data.hasAppearance&&!!t.data.fieldValue;p.call(this,t,e)}return s.inherit(t,p,{render:function(){return this.container}}),t}(),A=function(){function t(t){m.call(this,t)}var e=["left","center","right"];return s.inherit(t,m,{render:function(){this.container.className="textWidgetAnnotation";var t=null;if(this.renderInteractiveForms){if(this.data.multiLine?(t=document.createElement("textarea"),t.textContent=this.data.fieldValue):(t=document.createElement("input"),t.type="text",t.setAttribute("value",this.data.fieldValue)),t.disabled=this.data.readOnly,null!==this.data.maxLen&&(t.maxLength=this.data.maxLen),this.data.comb){var n=this.data.rect[2]-this.data.rect[0],i=n/this.data.maxLen;t.classList.add("comb"),t.style.letterSpacing="calc("+i+"px - 1ch)"}}else{t=document.createElement("div"),t.textContent=this.data.fieldValue,t.style.verticalAlign="middle",t.style.display="table-cell";var r=null;this.data.fontRefName&&(r=this.page.commonObjs.getData(this.data.fontRefName)),this._setTextStyle(t,r)}return null!==this.data.textAlignment&&(t.style.textAlign=e[this.data.textAlignment]),this.container.appendChild(t),this.container},_setTextStyle:function(t,e){var n=t.style;if(n.fontSize=this.data.fontSize+"px",n.direction=this.data.fontDirection<0?"rtl":"ltr",e){n.fontWeight=e.black?e.bold?"900":"bold":e.bold?"bold":"normal",n.fontStyle=e.italic?"italic":"normal";var i=e.loadedName?'"'+e.loadedName+'", ':"",r=e.fallbackName||"Helvetica, sans-serif";n.fontFamily=i+r}}}),t}(),v=function(){function t(t){var e=!(!t.data.title&&!t.data.contents);p.call(this,t,e)}return s.inherit(t,p,{render:function(){this.container.className="popupAnnotation";var t='[data-annotation-id="'+this.data.parentId+'"]',e=this.layer.querySelector(t);if(!e)return this.container;var n=new b({container:this.container,trigger:e,color:this.data.color,title:this.data.title,contents:this.data.contents
}),i=parseFloat(e.style.left),r=parseFloat(e.style.width);return u.setProp("transformOrigin",this.container,-(i+r)+"px -"+e.style.top),this.container.style.left=i+r+"px",this.container.appendChild(n.render()),this.container}}),t}(),b=function(){function t(t){this.container=t.container,this.trigger=t.trigger,this.color=t.color,this.title=t.title,this.contents=t.contents,this.hideWrapper=t.hideWrapper||!1,this.pinned=!1}return t.prototype={render:function(){var t=document.createElement("div");t.className="popupWrapper",this.hideElement=this.hideWrapper?t:this.container,this.hideElement.setAttribute("hidden",!0);var e=document.createElement("div");e.className="popup";var n=this.color;if(n){var i=.7*(255-n[0])+n[0],r=.7*(255-n[1])+n[1],a=.7*(255-n[2])+n[2];e.style.backgroundColor=s.makeCssRgb(0|i,0|r,0|a)}var o=this._formatContents(this.contents),c=document.createElement("h1");return c.textContent=this.title,this.trigger.addEventListener("click",this._toggle.bind(this)),this.trigger.addEventListener("mouseover",this._show.bind(this,!1)),this.trigger.addEventListener("mouseout",this._hide.bind(this,!1)),e.addEventListener("click",this._hide.bind(this,!0)),e.appendChild(c),e.appendChild(o),t.appendChild(e),t},_formatContents:function(t){for(var e=document.createElement("p"),n=t.split(/(?:\r\n?|\n)/),i=0,r=n.length;i<r;++i){var a=n[i];e.appendChild(document.createTextNode(a)),i<r-1&&e.appendChild(document.createElement("br"))}return e},_toggle:function(){this.pinned?this._hide(!0):this._show(!0)},_show:function(t){t&&(this.pinned=!0),this.hideElement.hasAttribute("hidden")&&(this.hideElement.removeAttribute("hidden"),this.container.style.zIndex+=1)},_hide:function(t){t&&(this.pinned=!1),this.hideElement.hasAttribute("hidden")||this.pinned||(this.hideElement.setAttribute("hidden",!0),this.container.style.zIndex-=1)}},t}(),y=function(){function t(t){var e=!!(t.data.hasPopup||t.data.title||t.data.contents);p.call(this,t,e)}return s.inherit(t,p,{render:function(){return this.container.className="highlightAnnotation",this.data.hasPopup||this._createPopup(this.container,null,this.data),this.container}}),t}(),x=function(){function t(t){var e=!!(t.data.hasPopup||t.data.title||t.data.contents);p.call(this,t,e)}return s.inherit(t,p,{render:function(){return this.container.className="underlineAnnotation",this.data.hasPopup||this._createPopup(this.container,null,this.data),this.container}}),t}(),S=function(){function t(t){var e=!!(t.data.hasPopup||t.data.title||t.data.contents);p.call(this,t,e)}return s.inherit(t,p,{render:function(){return this.container.className="squigglyAnnotation",this.data.hasPopup||this._createPopup(this.container,null,this.data),this.container}}),t}(),k=function(){function t(t){var e=!!(t.data.hasPopup||t.data.title||t.data.contents);p.call(this,t,e)}return s.inherit(t,p,{render:function(){return this.container.className="strikeoutAnnotation",this.data.hasPopup||this._createPopup(this.container,null,this.data),this.container}}),t}(),C=function(){function t(t){p.call(this,t,!0),this.filename=l(t.data.file.filename),this.content=t.data.file.content}return s.inherit(t,p,{render:function(){this.container.className="fileAttachmentAnnotation";var t=document.createElement("div");return t.style.height=this.container.style.height,t.style.width=this.container.style.width,t.addEventListener("dblclick",this._download.bind(this)),this.data.hasPopup||!this.data.title&&!this.data.contents||this._createPopup(this.container,t,this.data),this.container.appendChild(t),this.container},_download:function(){if(!this.downloadManager)return void h("Download cannot be started due to unavailable download manager");this.downloadManager.downloadData(this.content,this.filename,"")}}),t}(),_=function(){return{render:function(t){for(var e=new i,n=0,r=t.annotations.length;n<r;n++){var a=t.annotations[n];if(a){var s={data:a,layer:t.div,page:t.page,viewport:t.viewport,linkService:t.linkService,downloadManager:t.downloadManager,imageResourcesPath:t.imageResourcesPath||d("imageResourcesPath"),renderInteractiveForms:t.renderInteractiveForms||!1},o=e.create(s);o.isRenderable&&t.div.appendChild(o.render())}}},update:function(t){for(var e=0,n=t.annotations.length;e<n;e++){var i=t.annotations[e],r=t.div.querySelector('[data-annotation-id="'+i.id+'"]');r&&u.setProp("transform",r,"matrix("+t.viewport.transform.join(",")+")")}t.div.removeAttribute("hidden")}}}();t.AnnotationLayer=_}),function(t,e){e(t.pdfjsDisplayTextLayer={},t.pdfjsSharedUtil,t.pdfjsDisplayDOMUtils)}(this,function(t,e,n){var i=e.Util,r=e.createPromiseCapability,a=n.CustomStyle,s=n.getDefaultSetting,o=function(){function t(t){return!d.test(t)}function e(e,n,r){var a=document.createElement("div"),o={style:null,angle:0,canvasWidth:0,isWhitespace:!1,originalTransform:null,paddingBottom:0,paddingLeft:0,paddingRight:0,paddingTop:0,scale:1};if(e._textDivs.push(a),t(n.str))return o.isWhitespace=!0,void e._textDivProperties.set(a,o);var c=i.transform(e._viewport.transform,n.transform),l=Math.atan2(c[1],c[0]),h=r[n.fontName];h.vertical&&(l+=Math.PI/2);var u=Math.sqrt(c[2]*c[2]+c[3]*c[3]),d=u;h.ascent?d=h.ascent*d:h.descent&&(d=(1+h.descent)*d);var f,g;if(0===l?(f=c[4],g=c[5]-d):(f=c[4]+d*Math.sin(l),g=c[5]-d*Math.cos(l)),p[1]=f,p[3]=g,p[5]=u,p[7]=h.fontFamily,o.style=p.join(""),a.setAttribute("style",o.style),a.textContent=n.str,s("pdfBug")&&(a.dataset.fontName=n.fontName),0!==l&&(o.angle=l*(180/Math.PI)),n.str.length>1&&(h.vertical?o.canvasWidth=n.height*e._viewport.scale:o.canvasWidth=n.width*e._viewport.scale),e._textDivProperties.set(a,o),e._enhanceTextSelection){var m=1,A=0;0!==l&&(m=Math.cos(l),A=Math.sin(l));var v,b,y=(h.vertical?n.height:n.width)*e._viewport.scale,x=u;0!==l?(v=[m,A,-A,m,f,g],b=i.getAxialAlignedBoundingBox([0,0,y,x],v)):b=[f,g,f+y,g+x],e._bounds.push({left:b[0],top:b[1],right:b[2],bottom:b[3],div:a,size:[y,x],m:v})}}function n(t){if(!t._canceled){var e=t._container,n=t._textDivs,i=t._capability,r=n.length;if(r>1e5)return t._renderingDone=!0,void i.resolve();var s=document.createElement("canvas");s.mozOpaque=!0;for(var o,c,l=s.getContext("2d",{alpha:!1}),h=0;h<r;h++){var u=n[h],d=t._textDivProperties.get(u);if(!d.isWhitespace){var p=u.style.fontSize,f=u.style.fontFamily;p===o&&f===c||(l.font=p+" "+f,o=p,c=f);var g=l.measureText(u.textContent).width;e.appendChild(u);var m="";0!==d.canvasWidth&&g>0&&(d.scale=d.canvasWidth/g,m="scaleX("+d.scale+")"),0!==d.angle&&(m="rotate("+d.angle+"deg) "+m),""!==m&&(d.originalTransform=m,a.setProp("transform",u,m)),t._textDivProperties.set(u,d)}}t._renderingDone=!0,i.resolve()}}function o(t){for(var e=t._bounds,n=t._viewport,r=c(n.width,n.height,e),a=0;a<r.length;a++){var s=e[a].div,o=t._textDivProperties.get(s);if(0!==o.angle){var l=r[a],h=e[a],u=h.m,d=u[0],p=u[1],f=[[0,0],[0,h.size[1]],[h.size[0],0],h.size],g=new Float64Array(64);f.forEach(function(t,e){var n=i.applyTransform(t,u);g[e+0]=d&&(l.left-n[0])/d,g[e+4]=p&&(l.top-n[1])/p,g[e+8]=d&&(l.right-n[0])/d,g[e+12]=p&&(l.bottom-n[1])/p,g[e+16]=p&&(l.left-n[0])/-p,g[e+20]=d&&(l.top-n[1])/d,g[e+24]=p&&(l.right-n[0])/-p,g[e+28]=d&&(l.bottom-n[1])/d,g[e+32]=d&&(l.left-n[0])/-d,g[e+36]=p&&(l.top-n[1])/-p,g[e+40]=d&&(l.right-n[0])/-d,g[e+44]=p&&(l.bottom-n[1])/-p,g[e+48]=p&&(l.left-n[0])/p,g[e+52]=d&&(l.top-n[1])/-d,g[e+56]=p&&(l.right-n[0])/p,g[e+60]=d&&(l.bottom-n[1])/-d});var m=function(t,e,n){for(var i=0,r=0;r<n;r++){var a=t[e++];a>0&&(i=i?Math.min(a,i):a)}return i},A=1+Math.min(Math.abs(d),Math.abs(p));o.paddingLeft=m(g,32,16)/A,o.paddingTop=m(g,48,16)/A,o.paddingRight=m(g,0,16)/A,o.paddingBottom=m(g,16,16)/A,t._textDivProperties.set(s,o)}else o.paddingLeft=e[a].left-r[a].left,o.paddingTop=e[a].top-r[a].top,o.paddingRight=r[a].right-e[a].right,o.paddingBottom=r[a].bottom-e[a].bottom,t._textDivProperties.set(s,o)}}function c(t,e,n){var i=n.map(function(t,e){return{x1:t.left,y1:t.top,x2:t.right,y2:t.bottom,index:e,x1New:void 0,x2New:void 0}});l(t,i);var r=new Array(n.length);return i.forEach(function(t){r[t.index]={left:t.x1New,top:0,right:t.x2New,bottom:0}}),n.map(function(e,n){var a=r[n],s=i[n];s.x1=e.top,s.y1=t-a.right,s.x2=e.bottom,s.y2=t-a.left,s.index=n,s.x1New=void 0,s.x2New=void 0}),l(e,i),i.forEach(function(t){var e=t.index;r[e].top=t.x1New,r[e].bottom=t.x2New}),r}function l(t,e){e.sort(function(t,e){return t.x1-e.x1||t.index-e.index});var n={x1:-(1/0),y1:-(1/0),x2:0,y2:1/0,index:-1,x1New:0,x2New:0},i=[{start:-(1/0),end:1/0,boundary:n}];e.forEach(function(t){for(var e=0;e<i.length&&i[e].end<=t.y1;)e++;for(var n=i.length-1;n>=0&&i[n].start>=t.y2;)n--;var r,a,s,o,c=-(1/0);for(s=e;s<=n;s++){r=i[s],a=r.boundary;var l;l=a.x2>t.x1?a.index>t.index?a.x1New:t.x1:void 0===a.x2New?(a.x2+t.x1)/2:a.x2New,l>c&&(c=l)}for(t.x1New=c,s=e;s<=n;s++)r=i[s],a=r.boundary,void 0===a.x2New?a.x2>t.x1?a.index>t.index&&(a.x2New=a.x2):a.x2New=c:a.x2New>c&&(a.x2New=Math.max(c,a.x2));var h=[],u=null;for(s=e;s<=n;s++){r=i[s],a=r.boundary;var d=a.x2>t.x2?a:t;u===d?h[h.length-1].end=r.end:(h.push({start:r.start,end:r.end,boundary:d}),u=d)}for(i[e].start<t.y1&&(h[0].start=t.y1,h.unshift({start:i[e].start,end:t.y1,boundary:i[e].boundary})),t.y2<i[n].end&&(h[h.length-1].end=t.y2,h.push({start:t.y2,end:i[n].end,boundary:i[n].boundary})),s=e;s<=n;s++)if(r=i[s],a=r.boundary,void 0===a.x2New){var p=!1;for(o=e-1;!p&&o>=0&&i[o].start>=a.y1;o--)p=i[o].boundary===a;for(o=n+1;!p&&o<i.length&&i[o].end<=a.y2;o++)p=i[o].boundary===a;for(o=0;!p&&o<h.length;o++)p=h[o].boundary===a;p||(a.x2New=c)}Array.prototype.splice.apply(i,[e,n-e+1].concat(h))}),i.forEach(function(e){var n=e.boundary;void 0===n.x2New&&(n.x2New=Math.max(t,n.x2))})}function h(t,e,n,i,a){this._textContent=t,this._container=e,this._viewport=n,this._textDivs=i||[],this._textDivProperties=new WeakMap,this._renderingDone=!1,this._canceled=!1,this._capability=r(),this._renderTimer=null,this._bounds=[],this._enhanceTextSelection=!!a}function u(t){var e=new h(t.textContent,t.container,t.viewport,t.textDivs,t.enhanceTextSelection);return e._render(t.timeout),e}var d=/\S/,p=["left: ",0,"px; top: ",0,"px; font-size: ",0,"px; font-family: ","",";"];return h.prototype={get promise(){return this._capability.promise},cancel:function(){this._canceled=!0,null!==this._renderTimer&&(clearTimeout(this._renderTimer),this._renderTimer=null),this._capability.reject("canceled")},_render:function(t){for(var i=this._textContent.items,r=this._textContent.styles,a=0,s=i.length;a<s;a++)e(this,i[a],r);if(t){var o=this;this._renderTimer=setTimeout(function(){n(o),o._renderTimer=null},t)}else n(this)},expandTextDivs:function(t){if(this._enhanceTextSelection&&this._renderingDone){null!==this._bounds&&(o(this),this._bounds=null);for(var e=0,n=this._textDivs.length;e<n;e++){var i=this._textDivs[e],r=this._textDivProperties.get(i);if(!r.isWhitespace)if(t){var s="",c="";1!==r.scale&&(s="scaleX("+r.scale+")"),0!==r.angle&&(s="rotate("+r.angle+"deg) "+s),0!==r.paddingLeft&&(c+=" padding-left: "+r.paddingLeft/r.scale+"px;",s+=" translateX("+-r.paddingLeft/r.scale+"px)"),0!==r.paddingTop&&(c+=" padding-top: "+r.paddingTop+"px;",s+=" translateY("+-r.paddingTop+"px)"),0!==r.paddingRight&&(c+=" padding-right: "+r.paddingRight/r.scale+"px;"),0!==r.paddingBottom&&(c+=" padding-bottom: "+r.paddingBottom+"px;"),""!==c&&i.setAttribute("style",r.style+c),""!==s&&a.setProp("transform",i,s)}else i.style.padding=0,a.setProp("transform",i,r.originalTransform||"")}}}},u}();t.renderTextLayer=o}),function(t,e){e(t.pdfjsDisplayWebGL={},t.pdfjsSharedUtil,t.pdfjsDisplayDOMUtils)}(this,function(t,e,n){var i=e.shadow,r=n.getDefaultSetting,a=function(){function t(t,e,n){var i=t.createShader(n);if(t.shaderSource(i,e),t.compileShader(i),!t.getShaderParameter(i,t.COMPILE_STATUS)){var r=t.getShaderInfoLog(i);throw new Error("Error during shader compilation: "+r)}return i}function e(e,n){return t(e,n,e.VERTEX_SHADER)}function n(e,n){return t(e,n,e.FRAGMENT_SHADER)}function a(t,e){for(var n=t.createProgram(),i=0,r=e.length;i<r;++i)t.attachShader(n,e[i]);if(t.linkProgram(n),!t.getProgramParameter(n,t.LINK_STATUS)){var a=t.getProgramInfoLog(n);throw new Error("Error during program linking: "+a)}return n}function s(t,e,n){t.activeTexture(n);var i=t.createTexture();return t.bindTexture(t.TEXTURE_2D,i),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.NEAREST),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.NEAREST),t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,e),i}function o(){p||(f=document.createElement("canvas"),p=f.getContext("webgl",{premultipliedalpha:!1}))}function c(){var t,i;o(),t=f,f=null,i=p,p=null;var r=e(i,"  attribute vec2 a_position;                                      attribute vec2 a_texCoord;                                                                                                      uniform vec2 u_resolution;                                                                                                      varying vec2 v_texCoord;                                                                                                        void main() {                                                     vec2 clipSpace = (a_position / u_resolution) * 2.0 - 1.0;       gl_Position = vec4(clipSpace * vec2(1, -1), 0, 1);                                                                              v_texCoord = a_texCoord;                                      }                                                             "),s=n(i,"  precision mediump float;                                                                                                        uniform vec4 u_backdrop;                                        uniform int u_subtype;                                          uniform sampler2D u_image;                                      uniform sampler2D u_mask;                                                                                                       varying vec2 v_texCoord;                                                                                                        void main() {                                                     vec4 imageColor = texture2D(u_image, v_texCoord);               vec4 maskColor = texture2D(u_mask, v_texCoord);                 if (u_backdrop.a > 0.0) {                                         maskColor.rgb = maskColor.rgb * maskColor.a +                                   u_backdrop.rgb * (1.0 - maskColor.a);         }                                                               float lum;                                                      if (u_subtype == 0) {                                             lum = maskColor.a;                                            } else {                                                          lum = maskColor.r * 0.3 + maskColor.g * 0.59 +                        maskColor.b * 0.11;                                     }                                                               imageColor.a *= lum;                                            imageColor.rgb *= imageColor.a;                                 gl_FragColor = imageColor;                                    }                                                             "),c=a(i,[r,s]);i.useProgram(c);var l={};l.gl=i,l.canvas=t,l.resolutionLocation=i.getUniformLocation(c,"u_resolution"),l.positionLocation=i.getAttribLocation(c,"a_position"),l.backdropLocation=i.getUniformLocation(c,"u_backdrop"),l.subtypeLocation=i.getUniformLocation(c,"u_subtype");var h=i.getAttribLocation(c,"a_texCoord"),u=i.getUniformLocation(c,"u_image"),d=i.getUniformLocation(c,"u_mask"),m=i.createBuffer();i.bindBuffer(i.ARRAY_BUFFER,m),i.bufferData(i.ARRAY_BUFFER,new Float32Array([0,0,1,0,0,1,0,1,1,0,1,1]),i.STATIC_DRAW),i.enableVertexAttribArray(h),i.vertexAttribPointer(h,2,i.FLOAT,!1,0,0),i.uniform1i(u,0),i.uniform1i(d,1),g=l}function l(t,e,n){var i=t.width,r=t.height;g||c();var a=g,o=a.canvas,l=a.gl;o.width=i,o.height=r,l.viewport(0,0,l.drawingBufferWidth,l.drawingBufferHeight),l.uniform2f(a.resolutionLocation,i,r),n.backdrop?l.uniform4f(a.resolutionLocation,n.backdrop[0],n.backdrop[1],n.backdrop[2],1):l.uniform4f(a.resolutionLocation,0,0,0,0),l.uniform1i(a.subtypeLocation,"Luminosity"===n.subtype?1:0);var h=s(l,t,l.TEXTURE0),u=s(l,e,l.TEXTURE1),d=l.createBuffer();return l.bindBuffer(l.ARRAY_BUFFER,d),l.bufferData(l.ARRAY_BUFFER,new Float32Array([0,0,i,0,0,r,0,r,i,0,i,r]),l.STATIC_DRAW),l.enableVertexAttribArray(a.positionLocation),l.vertexAttribPointer(a.positionLocation,2,l.FLOAT,!1,0,0),l.clearColor(0,0,0,0),l.enable(l.BLEND),l.blendFunc(l.ONE,l.ONE_MINUS_SRC_ALPHA),l.clear(l.COLOR_BUFFER_BIT),l.drawArrays(l.TRIANGLES,0,6),l.flush(),l.deleteTexture(h),l.deleteTexture(u),l.deleteBuffer(d),o}function h(){var t,i;o(),t=f,f=null,i=p,p=null;var r=e(i,"  attribute vec2 a_position;                                      attribute vec3 a_color;                                                                                                         uniform vec2 u_resolution;                                      uniform vec2 u_scale;                                           uniform vec2 u_offset;                                                                                                          varying vec4 v_color;                                                                                                           void main() {                                                     vec2 position = (a_position + u_offset) * u_scale;              vec2 clipSpace = (position / u_resolution) * 2.0 - 1.0;         gl_Position = vec4(clipSpace * vec2(1, -1), 0, 1);                                                                              v_color = vec4(a_color / 255.0, 1.0);                         }                                                             "),s=n(i,"  precision mediump float;                                                                                                        varying vec4 v_color;                                                                                                           void main() {                                                     gl_FragColor = v_color;                                       }                                                             "),c=a(i,[r,s]);i.useProgram(c);var l={};l.gl=i,l.canvas=t,l.resolutionLocation=i.getUniformLocation(c,"u_resolution"),l.scaleLocation=i.getUniformLocation(c,"u_scale"),l.offsetLocation=i.getUniformLocation(c,"u_offset"),l.positionLocation=i.getAttribLocation(c,"a_position"),l.colorLocation=i.getAttribLocation(c,"a_color"),m=l}function u(t,e,n,i,r){m||h();var a=m,s=a.canvas,o=a.gl;s.width=t,s.height=e,o.viewport(0,0,o.drawingBufferWidth,o.drawingBufferHeight),o.uniform2f(a.resolutionLocation,t,e);var c,l,u,d=0;for(c=0,l=i.length;c<l;c++)switch(i[c].type){case"lattice":u=i[c].coords.length/i[c].verticesPerRow|0,d+=(u-1)*(i[c].verticesPerRow-1)*6;break;case"triangles":d+=i[c].coords.length}var p=new Float32Array(2*d),f=new Uint8Array(3*d),g=r.coords,A=r.colors,v=0,b=0;for(c=0,l=i.length;c<l;c++){var y=i[c],x=y.coords,S=y.colors;switch(y.type){case"lattice":var k=y.verticesPerRow;u=x.length/k|0;for(var C=1;C<u;C++)for(var _=C*k+1,w=1;w<k;w++,_++)p[v]=g[x[_-k-1]],p[v+1]=g[x[_-k-1]+1],p[v+2]=g[x[_-k]],p[v+3]=g[x[_-k]+1],p[v+4]=g[x[_-1]],p[v+5]=g[x[_-1]+1],f[b]=A[S[_-k-1]],f[b+1]=A[S[_-k-1]+1],f[b+2]=A[S[_-k-1]+2],f[b+3]=A[S[_-k]],f[b+4]=A[S[_-k]+1],f[b+5]=A[S[_-k]+2],f[b+6]=A[S[_-1]],f[b+7]=A[S[_-1]+1],f[b+8]=A[S[_-1]+2],p[v+6]=p[v+2],p[v+7]=p[v+3],p[v+8]=p[v+4],p[v+9]=p[v+5],p[v+10]=g[x[_]],p[v+11]=g[x[_]+1],f[b+9]=f[b+3],f[b+10]=f[b+4],f[b+11]=f[b+5],f[b+12]=f[b+6],f[b+13]=f[b+7],f[b+14]=f[b+8],f[b+15]=A[S[_]],f[b+16]=A[S[_]+1],f[b+17]=A[S[_]+2],v+=12,b+=18;break;case"triangles":for(var T=0,L=x.length;T<L;T++)p[v]=g[x[T]],p[v+1]=g[x[T]+1],f[b]=A[S[T]],f[b+1]=A[S[T]+1],f[b+2]=A[S[T]+2],v+=2,b+=3}}n?o.clearColor(n[0]/255,n[1]/255,n[2]/255,1):o.clearColor(0,0,0,0),o.clear(o.COLOR_BUFFER_BIT);var P=o.createBuffer();o.bindBuffer(o.ARRAY_BUFFER,P),o.bufferData(o.ARRAY_BUFFER,p,o.STATIC_DRAW),o.enableVertexAttribArray(a.positionLocation),o.vertexAttribPointer(a.positionLocation,2,o.FLOAT,!1,0,0);var E=o.createBuffer();return o.bindBuffer(o.ARRAY_BUFFER,E),o.bufferData(o.ARRAY_BUFFER,f,o.STATIC_DRAW),o.enableVertexAttribArray(a.colorLocation),o.vertexAttribPointer(a.colorLocation,3,o.UNSIGNED_BYTE,!1,0,0),o.uniform2f(a.scaleLocation,r.scaleX,r.scaleY),o.uniform2f(a.offsetLocation,r.offsetX,r.offsetY),o.drawArrays(o.TRIANGLES,0,d),o.flush(),o.deleteBuffer(P),o.deleteBuffer(E),s}function d(){g&&g.canvas&&(g.canvas.width=0,g.canvas.height=0),m&&m.canvas&&(m.canvas.width=0,m.canvas.height=0),g=null,m=null}var p,f,g=null,m=null;return{get isEnabled(){if(r("disableWebGL"))return!1;var t=!1;try{o(),t=!!p}catch(t){}return i(this,"isEnabled",t)},composeSMask:l,drawFigures:u,clear:d}}();t.WebGLUtils=a}),function(t,e){e(t.pdfjsDisplayPatternHelper={},t.pdfjsSharedUtil,t.pdfjsDisplayWebGL)}(this,function(t,e,n){function i(t){var e=l[t[0]];return e||o("Unknown IR type: "+t[0]),e.fromIR(t)}var r=e.Util,a=e.info,s=e.isArray,o=e.error,c=n.WebGLUtils,l={};l.RadialAxial={fromIR:function(t){var e=t[1],n=t[2],i=t[3],r=t[4],a=t[5],s=t[6];return{type:"Pattern",getPattern:function(t){var o;"axial"===e?o=t.createLinearGradient(i[0],i[1],r[0],r[1]):"radial"===e&&(o=t.createRadialGradient(i[0],i[1],a,r[0],r[1],s));for(var c=0,l=n.length;c<l;++c){var h=n[c];o.addColorStop(h[0],h[1])}return o}}}};var h=function(){function t(t,e,n,i,r,a,s,o){var c,l=e.coords,h=e.colors,u=t.data,d=4*t.width;l[n+1]>l[i+1]&&(c=n,n=i,i=c,c=a,a=s,s=c),l[i+1]>l[r+1]&&(c=i,i=r,r=c,c=s,s=o,o=c),l[n+1]>l[i+1]&&(c=n,n=i,i=c,c=a,a=s,s=c);var p=(l[n]+e.offsetX)*e.scaleX,f=(l[n+1]+e.offsetY)*e.scaleY,g=(l[i]+e.offsetX)*e.scaleX,m=(l[i+1]+e.offsetY)*e.scaleY,A=(l[r]+e.offsetX)*e.scaleX,v=(l[r+1]+e.offsetY)*e.scaleY;if(!(f>=v))for(var b,y,x,S,k,C,_,w,T,L=h[a],P=h[a+1],E=h[a+2],R=h[s],I=h[s+1],D=h[s+2],j=h[o],O=h[o+1],M=h[o+2],F=Math.round(f),N=Math.round(v),U=F;U<=N;U++){U<m?(T=U<f?0:f===m?1:(f-U)/(f-m),b=p-(p-g)*T,y=L-(L-R)*T,x=P-(P-I)*T,S=E-(E-D)*T):(T=U>v?1:m===v?0:(m-U)/(m-v),b=g-(g-A)*T,y=R-(R-j)*T,x=I-(I-O)*T,S=D-(D-M)*T),T=U<f?0:U>v?1:(f-U)/(f-v),k=p-(p-A)*T,C=L-(L-j)*T,_=P-(P-O)*T,w=E-(E-M)*T;for(var B=Math.round(Math.min(b,k)),W=Math.round(Math.max(b,k)),G=d*U+4*B,X=B;X<=W;X++)T=(b-X)/(b-k),T=T<0?0:T>1?1:T,u[G++]=y-(y-C)*T|0,u[G++]=x-(x-_)*T|0,u[G++]=S-(S-w)*T|0,u[G++]=255}}function e(e,n,i){var r,a,s=n.coords,c=n.colors;switch(n.type){case"lattice":var l=n.verticesPerRow,h=Math.floor(s.length/l)-1,u=l-1;for(r=0;r<h;r++)for(var d=r*l,p=0;p<u;p++,d++)t(e,i,s[d],s[d+1],s[d+l],c[d],c[d+1],c[d+l]),t(e,i,s[d+l+1],s[d+1],s[d+l],c[d+l+1],c[d+1],c[d+l]);break;case"triangles":for(r=0,a=s.length;r<a;r+=3)t(e,i,s[r],s[r+1],s[r+2],c[r],c[r+1],c[r+2]);break;default:o("illigal figure")}}function n(t,n,i,r,a,s,o){var l,h,u,d,p=Math.floor(t[0]),f=Math.floor(t[1]),g=Math.ceil(t[2])-p,m=Math.ceil(t[3])-f,A=Math.min(Math.ceil(Math.abs(g*n[0]*1.1)),3e3),v=Math.min(Math.ceil(Math.abs(m*n[1]*1.1)),3e3),b=g/A,y=m/v,x={coords:i,colors:r,offsetX:-p,offsetY:-f,scaleX:1/b,scaleY:1/y},S=A+4,k=v+4;if(c.isEnabled)l=c.drawFigures(A,v,s,a,x),h=o.getCanvas("mesh",S,k,!1),h.context.drawImage(l,2,2),l=h.canvas;else{h=o.getCanvas("mesh",S,k,!1);var C=h.context,_=C.createImageData(A,v);if(s){var w=_.data;for(u=0,d=w.length;u<d;u+=4)w[u]=s[0],w[u+1]=s[1],w[u+2]=s[2],w[u+3]=255}for(u=0;u<a.length;u++)e(_,a[u],x);C.putImageData(_,2,2),l=h.canvas}return{canvas:l,offsetX:p-2*b,offsetY:f-2*y,scaleX:b,scaleY:y}}return n}();l.Mesh={fromIR:function(t){var e=t[2],n=t[3],i=t[4],a=t[5],s=t[6],o=t[8];return{type:"Pattern",getPattern:function(t,c,l){var u;if(l)u=r.singularValueDecompose2dScale(t.mozCurrentTransform);else if(u=r.singularValueDecompose2dScale(c.baseTransform),s){var d=r.singularValueDecompose2dScale(s);u=[u[0]*d[0],u[1]*d[1]]}var p=h(a,u,e,n,i,l?null:o,c.cachedCanvases);return l||(t.setTransform.apply(t,c.baseTransform),s&&t.transform.apply(t,s)),t.translate(p.offsetX,p.offsetY),t.scale(p.scaleX,p.scaleY),t.createPattern(p.canvas,"no-repeat")}}}},l.Dummy={fromIR:function(){return{type:"Pattern",getPattern:function(){return"hotpink"}}}};var u=function(){function t(t,e,n,i,r){this.operatorList=t[2],this.matrix=t[3]||[1,0,0,1,0,0],this.bbox=t[4],this.xstep=t[5],this.ystep=t[6],this.paintType=t[7],this.tilingType=t[8],this.color=e,this.canvasGraphicsFactory=i,this.baseTransform=r,this.type="Pattern",this.ctx=n}var e={COLORED:1,UNCOLORED:2};return t.prototype={createPatternCanvas:function(t){var e=this.operatorList,n=this.bbox,i=this.xstep,s=this.ystep,o=this.paintType,c=this.tilingType,l=this.color,h=this.canvasGraphicsFactory;a("TilingType: "+c);var u=n[0],d=n[1],p=n[2],f=n[3],g=[u,d],m=[u+i,d+s],A=m[0]-g[0],v=m[1]-g[1],b=r.singularValueDecompose2dScale(this.matrix),y=r.singularValueDecompose2dScale(this.baseTransform),x=[b[0]*y[0],b[1]*y[1]];A=Math.min(Math.ceil(Math.abs(A*x[0])),3e3),v=Math.min(Math.ceil(Math.abs(v*x[1])),3e3);var S=t.cachedCanvases.getCanvas("pattern",A,v,!0),k=S.context,C=h.createCanvasGraphics(k);C.groupLevel=t.groupLevel,this.setFillAndStrokeStyleToContext(k,o,l),this.setScale(A,v,i,s),this.transformToScale(C);var _=[1,0,0,1,-g[0],-g[1]];return C.transform.apply(C,_),this.clipBbox(C,n,u,d,p,f),C.executeOperatorList(e),S.canvas},setScale:function(t,e,n,i){this.scale=[t/n,e/i]},transformToScale:function(t){var e=this.scale,n=[e[0],0,0,e[1],0,0];t.transform.apply(t,n)},scaleToContext:function(){var t=this.scale;this.ctx.scale(1/t[0],1/t[1])},clipBbox:function(t,e,n,i,r,a){if(e&&s(e)&&4===e.length){var o=r-n,c=a-i;t.ctx.rect(n,i,o,c),t.clip(),t.endPath()}},setFillAndStrokeStyleToContext:function(t,n,i){switch(n){case e.COLORED:var a=this.ctx;t.fillStyle=a.fillStyle,t.strokeStyle=a.strokeStyle;break;case e.UNCOLORED:var s=r.makeCssRgb(i[0],i[1],i[2]);t.fillStyle=s,t.strokeStyle=s;break;default:o("Unsupported paint type: "+n)}},getPattern:function(t,e){var n=this.createPatternCanvas(e);return t=this.ctx,t.setTransform.apply(t,this.baseTransform),t.transform.apply(t,this.matrix),this.scaleToContext(),t.createPattern(n,"repeat")}},t}();t.getShadingPatternFromIR=i,t.TilingPattern=u}),function(t,e){e(t.pdfjsDisplayCanvas={},t.pdfjsSharedUtil,t.pdfjsDisplayDOMUtils,t.pdfjsDisplayPatternHelper,t.pdfjsDisplayWebGL)}(this,function(t,e,n,i,r){function a(t,e){var n=document.createElement("canvas");return n.width=t,n.height=e,n}function s(t){t.mozCurrentTransform||(t._originalSave=t.save,t._originalRestore=t.restore,t._originalRotate=t.rotate,t._originalScale=t.scale,t._originalTranslate=t.translate,t._originalTransform=t.transform,t._originalSetTransform=t.setTransform,t._transformMatrix=t._transformMatrix||[1,0,0,1,0,0],t._transformStack=[],Object.defineProperty(t,"mozCurrentTransform",{get:function(){return this._transformMatrix}}),Object.defineProperty(t,"mozCurrentTransformInverse",{get:function(){var t=this._transformMatrix,e=t[0],n=t[1],i=t[2],r=t[3],a=t[4],s=t[5],o=e*r-n*i,c=n*i-e*r;return[r/o,n/c,i/c,e/o,(r*a-i*s)/c,(n*a-e*s)/o]}}),t.save=function(){var t=this._transformMatrix;this._transformStack.push(t),this._transformMatrix=t.slice(0,6),this._originalSave()},t.restore=function(){var t=this._transformStack.pop();t&&(this._transformMatrix=t,this._originalRestore())},t.translate=function(t,e){var n=this._transformMatrix;n[4]=n[0]*t+n[2]*e+n[4],n[5]=n[1]*t+n[3]*e+n[5],this._originalTranslate(t,e)},t.scale=function(t,e){var n=this._transformMatrix;n[0]=n[0]*t,n[1]=n[1]*t,n[2]=n[2]*e,n[3]=n[3]*e,this._originalScale(t,e)},t.transform=function(e,n,i,r,a,s){var o=this._transformMatrix;this._transformMatrix=[o[0]*e+o[2]*n,o[1]*e+o[3]*n,o[0]*i+o[2]*r,o[1]*i+o[3]*r,o[0]*a+o[2]*s+o[4],o[1]*a+o[3]*s+o[5]],t._originalTransform(e,n,i,r,a,s)},t.setTransform=function(e,n,i,r,a,s){this._transformMatrix=[e,n,i,r,a,s],t._originalSetTransform(e,n,i,r,a,s)},t.rotate=function(t){var e=Math.cos(t),n=Math.sin(t),i=this._transformMatrix;this._transformMatrix=[i[0]*e+i[2]*n,i[1]*e+i[3]*n,i[0]*-n+i[2]*e,i[1]*-n+i[3]*e,i[4],i[5]],this._originalRotate(t)})}function o(t){var e,n,i,r,a=t.width,s=t.height,o=a+1,c=new Uint8Array(o*(s+1)),l=new Uint8Array([0,2,4,0,1,0,5,4,8,10,0,8,0,2,1,0]),h=a+7&-8,u=t.data,d=new Uint8Array(h*s),p=0;for(e=0,r=u.length;e<r;e++)for(var f=128,g=u[e];f>0;)d[p++]=g&f?0:255,f>>=1;var m=0;for(p=0,0!==d[p]&&(c[0]=1,++m),n=1;n<a;n++)d[p]!==d[p+1]&&(c[n]=d[p]?2:1,++m),p++;for(0!==d[p]&&(c[n]=2,++m),e=1;e<s;e++){p=e*h,i=e*o,d[p-h]!==d[p]&&(c[i]=d[p]?1:8,++m);var A=(d[p]?4:0)+(d[p-h]?8:0);for(n=1;n<a;n++)A=(A>>2)+(d[p+1]?4:0)+(d[p-h+1]?8:0),l[A]&&(c[i+n]=l[A],++m),p++;if(d[p-h]!==d[p]&&(c[i+n]=d[p]?2:4,++m),m>1e3)return null}for(p=h*(s-1),i=e*o,0!==d[p]&&(c[i]=8,++m),n=1;n<a;n++)d[p]!==d[p+1]&&(c[i+n]=d[p]?4:8,++m),p++;if(0!==d[p]&&(c[i+n]=4,++m),m>1e3)return null;var v=new Int32Array([0,o,-1,0,-o,0,0,0,1]),b=[];for(e=0;m&&e<=s;e++){for(var y=e*o,x=y+a;y<x&&!c[y];)y++;if(y!==x){var S,k=[y%o,e],C=c[y],_=y;do{var w=v[C];do y+=w;while(!c[y]);S=c[y],5!==S&&10!==S?(C=S,c[y]=0):(C=S&51*C>>4,c[y]&=C>>2|C<<2),k.push(y%o),k.push(y/o|0),--m}while(_!==y);b.push(k),--e}}return function(t){t.save(),t.scale(1/a,-1/s),t.translate(0,-s),t.beginPath();for(var e=0,n=b.length;e<n;e++){var i=b[e];t.moveTo(i[0],i[1]);for(var r=2,o=i.length;r<o;r+=2)t.lineTo(i[r],i[r+1])}t.fill(),t.beginPath(),t.restore()}}var c=e.FONT_IDENTITY_MATRIX,l=e.IDENTITY_MATRIX,h=e.ImageKind,u=e.OPS,d=e.TextRenderingMode,p=e.Uint32ArrayView,f=e.Util,g=e.assert,m=e.info,A=e.isNum,v=e.isArray,b=e.isLittleEndian,y=e.error,x=e.shadow,S=e.warn,k=i.TilingPattern,C=i.getShadingPatternFromIR,_=r.WebGLUtils,w=n.hasCanvasTypedArrays,T={get value(){return x(T,"value",w())}},L={get value(){return x(L,"value",b())}},P=function(){function t(){this.cache=Object.create(null)}return t.prototype={getCanvas:function(t,e,n,i){var r;if(void 0!==this.cache[t])r=this.cache[t],r.canvas.width=e,r.canvas.height=n,r.context.setTransform(1,0,0,1,0,0);else{var o=a(e,n),c=o.getContext("2d");i&&s(c),this.cache[t]=r={canvas:o,context:c}}return r},clear:function(){for(var t in this.cache){var e=this.cache[t];e.canvas.width=0,e.canvas.height=0,delete this.cache[t]}}},t}(),E=function(){function t(t){this.alphaIsShape=!1,this.fontSize=0,this.fontSizeScale=1,this.textMatrix=l,this.textMatrixScale=1,this.fontMatrix=c,this.leading=0,this.x=0,this.y=0,this.lineX=0,this.lineY=0,this.charSpacing=0,this.wordSpacing=0,this.textHScale=1,this.textRenderingMode=d.FILL,this.textRise=0,this.fillColor="#000000",this.strokeColor="#000000",this.patternFill=!1,this.fillAlpha=1,this.strokeAlpha=1,this.lineWidth=1,this.activeSMask=null,this.resumeSMaskCtx=null,this.old=t}return t.prototype={clone:function(){return Object.create(this)},setCurrentPoint:function(t,e){this.x=t,this.y=e}},t}(),R=function(){function t(t,e,n,i){this.ctx=t,this.current=new E,this.stateStack=[],this.pendingClip=null,this.pendingEOFill=!1,this.res=null,this.xobjs=null,this.commonObjs=e,this.objs=n,this.imageLayer=i,this.groupStack=[],this.processingType3=null,this.baseTransform=null,this.baseTransformStack=[],this.groupLevel=0,this.smaskStack=[],this.smaskCounter=0,this.tempSMask=null,this.cachedCanvases=new P,t&&s(t),this.cachedGetSinglePixelWidth=null}function e(t,e){if("undefined"!=typeof ImageData&&e instanceof ImageData)return void t.putImageData(e,0,0);var n,i,r,a,s,o=e.height,c=e.width,l=o%16,u=(o-l)/16,d=0===l?u:u+1,f=t.createImageData(c,16),g=0,m=e.data,A=f.data;if(e.kind===h.GRAYSCALE_1BPP){var v=m.byteLength,b=T.value?new Uint32Array(A.buffer):new p(A),x=b.length,S=c+7>>3,k=4294967295,C=L.value||!T.value?4278190080:255;for(i=0;i<d;i++){for(a=i<u?16:l,n=0,r=0;r<a;r++){for(var _=v-g,w=0,P=_>S?c:8*_-7,E=P&-8,R=0,I=0;w<E;w+=8)I=m[g++],b[n++]=128&I?k:C,b[n++]=64&I?k:C,b[n++]=32&I?k:C,b[n++]=16&I?k:C,b[n++]=8&I?k:C,b[n++]=4&I?k:C,b[n++]=2&I?k:C,b[n++]=1&I?k:C;for(;w<P;w++)0===R&&(I=m[g++],R=128),b[n++]=I&R?k:C,R>>=1}
for(;n<x;)b[n++]=0;t.putImageData(f,0,16*i)}}else if(e.kind===h.RGBA_32BPP){for(r=0,s=16*c*4,i=0;i<u;i++)A.set(m.subarray(g,g+s)),g+=s,t.putImageData(f,0,r),r+=16;i<d&&(s=c*l*4,A.set(m.subarray(g,g+s)),t.putImageData(f,0,r))}else if(e.kind===h.RGB_24BPP)for(a=16,s=c*a,i=0;i<d;i++){for(i>=u&&(a=l,s=c*a),n=0,r=s;r--;)A[n++]=m[g++],A[n++]=m[g++],A[n++]=m[g++],A[n++]=255;t.putImageData(f,0,16*i)}else y("bad image kind: "+e.kind)}function n(t,e){for(var n=e.height,i=e.width,r=n%16,a=(n-r)/16,s=0===r?a:a+1,o=t.createImageData(i,16),c=0,l=e.data,h=o.data,u=0;u<s;u++){for(var d=u<a?16:r,p=3,f=0;f<d;f++)for(var g=0,m=0;m<i;m++){if(!g){var A=l[c++];g=128}h[p]=A&g?0:255,p+=4,g>>=1}t.putImageData(o,0,16*u)}}function i(t,e){for(var n=["strokeStyle","fillStyle","fillRule","globalAlpha","lineWidth","lineCap","lineJoin","miterLimit","globalCompositeOperation","font"],i=0,r=n.length;i<r;i++){var a=n[i];void 0!==t[a]&&(e[a]=t[a])}void 0!==t.setLineDash&&(e.setLineDash(t.getLineDash()),e.lineDashOffset=t.lineDashOffset)}function r(t,e,n,i){for(var r=t.length,a=3;a<r;a+=4){var s=t[a];if(0===s)t[a-3]=e,t[a-2]=n,t[a-1]=i;else if(s<255){var o=255-s;t[a-3]=t[a-3]*s+e*o>>8,t[a-2]=t[a-2]*s+n*o>>8,t[a-1]=t[a-1]*s+i*o>>8}}}function a(t,e,n){for(var i=t.length,r=3;r<i;r+=4){var a=n?n[t[r]]:t[r];e[r]=e[r]*a*(1/255)|0}}function b(t,e,n){for(var i=t.length,r=3;r<i;r+=4){var a=77*t[r-3]+152*t[r-2]+28*t[r-1];e[r]=n?e[r]*n[a>>8]>>8:e[r]*a>>16}}function w(t,e,n,i,s,o,c){var l,h=!!o,u=h?o[0]:0,d=h?o[1]:0,p=h?o[2]:0;l="Luminosity"===s?b:a;for(var f=Math.min(i,Math.ceil(1048576/n)),g=0;g<i;g+=f){var m=Math.min(f,i-g),A=t.getImageData(0,g,n,m),v=e.getImageData(0,g,n,m);h&&r(A.data,u,d,p),l(A.data,v.data,c),t.putImageData(v,0,g)}}function R(t,e,n){var i=e.canvas,r=e.context;t.setTransform(e.scaleX,0,0,e.scaleY,e.offsetX,e.offsetY);var a=e.backdrop||null;if(!e.transferMap&&_.isEnabled){var s=_.composeSMask(n.canvas,i,{subtype:e.subtype,backdrop:a});return t.setTransform(1,0,0,1,0,0),void t.drawImage(s,e.offsetX,e.offsetY)}w(r,n,i.width,i.height,e.subtype,a,e.transferMap),t.drawImage(i,0,0)}var I=["butt","round","square"],D=["miter","round","bevel"],j={},O={};t.prototype={beginDrawing:function(t,e,n){var i=this.ctx.canvas.width,r=this.ctx.canvas.height;if(this.ctx.save(),this.ctx.fillStyle="rgb(255, 255, 255)",this.ctx.fillRect(0,0,i,r),this.ctx.restore(),n){var a=this.cachedCanvases.getCanvas("transparent",i,r,!0);this.compositeCtx=this.ctx,this.transparentCanvas=a.canvas,this.ctx=a.context,this.ctx.save(),this.ctx.transform.apply(this.ctx,this.compositeCtx.mozCurrentTransform)}this.ctx.save(),t&&this.ctx.transform.apply(this.ctx,t),this.ctx.transform.apply(this.ctx,e.transform),this.baseTransform=this.ctx.mozCurrentTransform.slice(),this.imageLayer&&this.imageLayer.beginLayout()},executeOperatorList:function(t,e,n,i){var r=t.argsArray,a=t.fnArray,s=e||0,o=r.length;if(o===s)return s;for(var c,l=o-s>10&&"function"==typeof n,h=l?Date.now()+15:0,d=0,p=this.commonObjs,f=this.objs;;){if(void 0!==i&&s===i.nextBreakPoint)return i.breakIt(s,n),s;if((c=a[s])!==u.dependency)this[c].apply(this,r[s]);else for(var g=r[s],m=0,A=g.length;m<A;m++){var v=g[m],b="g"===v[0]&&"_"===v[1],y=b?p:f;if(!y.isResolved(v))return y.get(v,n),s}if(++s===o)return s;if(l&&++d>10){if(Date.now()>h)return n(),s;d=0}}},endDrawing:function(){null!==this.current.activeSMask&&this.endSMaskGroup(),this.ctx.restore(),this.transparentCanvas&&(this.ctx=this.compositeCtx,this.ctx.save(),this.ctx.setTransform(1,0,0,1,0,0),this.ctx.drawImage(this.transparentCanvas,0,0),this.ctx.restore(),this.transparentCanvas=null),this.cachedCanvases.clear(),_.clear(),this.imageLayer&&this.imageLayer.endLayout()},setLineWidth:function(t){this.current.lineWidth=t,this.ctx.lineWidth=t},setLineCap:function(t){this.ctx.lineCap=I[t]},setLineJoin:function(t){this.ctx.lineJoin=D[t]},setMiterLimit:function(t){this.ctx.miterLimit=t},setDash:function(t,e){var n=this.ctx;void 0!==n.setLineDash&&(n.setLineDash(t),n.lineDashOffset=e)},setRenderingIntent:function(t){},setFlatness:function(t){},setGState:function(t){for(var e=0,n=t.length;e<n;e++){var i=t[e],r=i[0],a=i[1];switch(r){case"LW":this.setLineWidth(a);break;case"LC":this.setLineCap(a);break;case"LJ":this.setLineJoin(a);break;case"ML":this.setMiterLimit(a);break;case"D":this.setDash(a[0],a[1]);break;case"RI":this.setRenderingIntent(a);break;case"FL":this.setFlatness(a);break;case"Font":this.setFont(a[0],a[1]);break;case"CA":this.current.strokeAlpha=i[1];break;case"ca":this.current.fillAlpha=i[1],this.ctx.globalAlpha=i[1];break;case"BM":if(a&&a.name&&"Normal"!==a.name){var s=a.name.replace(/([A-Z])/g,function(t){return"-"+t.toLowerCase()}).substring(1);this.ctx.globalCompositeOperation=s,this.ctx.globalCompositeOperation!==s&&S('globalCompositeOperation "'+s+'" is not supported')}else this.ctx.globalCompositeOperation="source-over";break;case"SMask":this.current.activeSMask&&(this.stateStack.length>0&&this.stateStack[this.stateStack.length-1].activeSMask===this.current.activeSMask?this.suspendSMaskGroup():this.endSMaskGroup()),this.current.activeSMask=a?this.tempSMask:null,this.current.activeSMask&&this.beginSMaskGroup(),this.tempSMask=null}}},beginSMaskGroup:function(){var t=this.current.activeSMask,e=t.canvas.width,n=t.canvas.height,r="smaskGroupAt"+this.groupLevel,a=this.cachedCanvases.getCanvas(r,e,n,!0),s=this.ctx,o=s.mozCurrentTransform;this.ctx.save();var c=a.context;c.scale(1/t.scaleX,1/t.scaleY),c.translate(-t.offsetX,-t.offsetY),c.transform.apply(c,o),t.startTransformInverse=c.mozCurrentTransformInverse,i(s,c),this.ctx=c,this.setGState([["BM","Normal"],["ca",1],["CA",1]]),this.groupStack.push(s),this.groupLevel++},suspendSMaskGroup:function(){var t=this.ctx;this.groupLevel--,this.ctx=this.groupStack.pop(),R(this.ctx,this.current.activeSMask,t),this.ctx.restore(),this.ctx.save(),i(t,this.ctx),this.current.resumeSMaskCtx=t;var e=f.transform(this.current.activeSMask.startTransformInverse,t.mozCurrentTransform);this.ctx.transform.apply(this.ctx,e),t.save(),t.setTransform(1,0,0,1,0,0),t.clearRect(0,0,t.canvas.width,t.canvas.height),t.restore()},resumeSMaskGroup:function(){var t=this.current.resumeSMaskCtx,e=this.ctx;this.ctx=t,this.groupStack.push(e),this.groupLevel++},endSMaskGroup:function(){var t=this.ctx;this.groupLevel--,this.ctx=this.groupStack.pop(),R(this.ctx,this.current.activeSMask,t),this.ctx.restore(),i(t,this.ctx);var e=f.transform(this.current.activeSMask.startTransformInverse,t.mozCurrentTransform);this.ctx.transform.apply(this.ctx,e)},save:function(){this.ctx.save();var t=this.current;this.stateStack.push(t),this.current=t.clone(),this.current.resumeSMaskCtx=null},restore:function(){this.current.resumeSMaskCtx&&this.resumeSMaskGroup(),null===this.current.activeSMask||0!==this.stateStack.length&&this.stateStack[this.stateStack.length-1].activeSMask===this.current.activeSMask||this.endSMaskGroup(),0!==this.stateStack.length&&(this.current=this.stateStack.pop(),this.ctx.restore(),this.pendingClip=null,this.cachedGetSinglePixelWidth=null)},transform:function(t,e,n,i,r,a){this.ctx.transform(t,e,n,i,r,a),this.cachedGetSinglePixelWidth=null},constructPath:function(t,e){for(var n=this.ctx,i=this.current,r=i.x,a=i.y,s=0,o=0,c=t.length;s<c;s++)switch(0|t[s]){case u.rectangle:r=e[o++],a=e[o++];var l=e[o++],h=e[o++];0===l&&(l=this.getSinglePixelWidth()),0===h&&(h=this.getSinglePixelWidth());var d=r+l,p=a+h;this.ctx.moveTo(r,a),this.ctx.lineTo(d,a),this.ctx.lineTo(d,p),this.ctx.lineTo(r,p),this.ctx.lineTo(r,a),this.ctx.closePath();break;case u.moveTo:r=e[o++],a=e[o++],n.moveTo(r,a);break;case u.lineTo:r=e[o++],a=e[o++],n.lineTo(r,a);break;case u.curveTo:r=e[o+4],a=e[o+5],n.bezierCurveTo(e[o],e[o+1],e[o+2],e[o+3],r,a),o+=6;break;case u.curveTo2:n.bezierCurveTo(r,a,e[o],e[o+1],e[o+2],e[o+3]),r=e[o+2],a=e[o+3],o+=4;break;case u.curveTo3:r=e[o+2],a=e[o+3],n.bezierCurveTo(e[o],e[o+1],r,a,r,a),o+=4;break;case u.closePath:n.closePath()}i.setCurrentPoint(r,a)},closePath:function(){this.ctx.closePath()},stroke:function(t){t=void 0===t||t;var e=this.ctx,n=this.current.strokeColor;e.lineWidth=Math.max(.65*this.getSinglePixelWidth(),this.current.lineWidth),e.globalAlpha=this.current.strokeAlpha,n&&n.hasOwnProperty("type")&&"Pattern"===n.type?(e.save(),e.strokeStyle=n.getPattern(e,this),e.stroke(),e.restore()):e.stroke(),t&&this.consumePath(),e.globalAlpha=this.current.fillAlpha},closeStroke:function(){this.closePath(),this.stroke()},fill:function(t){t=void 0===t||t;var e=this.ctx,n=this.current.fillColor,i=this.current.patternFill,r=!1;i&&(e.save(),this.baseTransform&&e.setTransform.apply(e,this.baseTransform),e.fillStyle=n.getPattern(e,this),r=!0),this.pendingEOFill?(void 0!==e.mozFillRule?(e.mozFillRule="evenodd",e.fill(),e.mozFillRule="nonzero"):e.fill("evenodd"),this.pendingEOFill=!1):e.fill(),r&&e.restore(),t&&this.consumePath()},eoFill:function(){this.pendingEOFill=!0,this.fill()},fillStroke:function(){this.fill(!1),this.stroke(!1),this.consumePath()},eoFillStroke:function(){this.pendingEOFill=!0,this.fillStroke()},closeFillStroke:function(){this.closePath(),this.fillStroke()},closeEOFillStroke:function(){this.pendingEOFill=!0,this.closePath(),this.fillStroke()},endPath:function(){this.consumePath()},clip:function(){this.pendingClip=j},eoClip:function(){this.pendingClip=O},beginText:function(){this.current.textMatrix=l,this.current.textMatrixScale=1,this.current.x=this.current.lineX=0,this.current.y=this.current.lineY=0},endText:function(){var t=this.pendingTextPaths,e=this.ctx;if(void 0===t)return void e.beginPath();e.save(),e.beginPath();for(var n=0;n<t.length;n++){var i=t[n];e.setTransform.apply(e,i.transform),e.translate(i.x,i.y),i.addToPath(e,i.fontSize)}e.restore(),e.clip(),e.beginPath(),delete this.pendingTextPaths},setCharSpacing:function(t){this.current.charSpacing=t},setWordSpacing:function(t){this.current.wordSpacing=t},setHScale:function(t){this.current.textHScale=t/100},setLeading:function(t){this.current.leading=-t},setFont:function(t,e){var n=this.commonObjs.get(t),i=this.current;if(n||y("Can't find font for "+t),i.fontMatrix=n.fontMatrix?n.fontMatrix:c,0!==i.fontMatrix[0]&&0!==i.fontMatrix[3]||S("Invalid font matrix for font "+t),e<0?(e=-e,i.fontDirection=-1):i.fontDirection=1,this.current.font=n,this.current.fontSize=e,!n.isType3Font){var r=n.loadedName||"sans-serif",a=n.black?n.bold?"900":"bold":n.bold?"bold":"normal",s=n.italic?"italic":"normal",o='"'+r+'", '+n.fallbackName,l=e<16?16:e>100?100:e;this.current.fontSizeScale=e/l;var h=s+" "+a+" "+l+"px "+o;this.ctx.font=h}},setTextRenderingMode:function(t){this.current.textRenderingMode=t},setTextRise:function(t){this.current.textRise=t},moveText:function(t,e){this.current.x=this.current.lineX+=t,this.current.y=this.current.lineY+=e},setLeadingMoveText:function(t,e){this.setLeading(-e),this.moveText(t,e)},setTextMatrix:function(t,e,n,i,r,a){this.current.textMatrix=[t,e,n,i,r,a],this.current.textMatrixScale=Math.sqrt(t*t+e*e),this.current.x=this.current.lineX=0,this.current.y=this.current.lineY=0},nextLine:function(){this.moveText(0,this.current.leading)},paintChar:function(t,e,n){var i,r=this.ctx,a=this.current,s=a.font,o=a.textRenderingMode,c=a.fontSize/a.fontSizeScale,l=o&d.FILL_STROKE_MASK,h=!!(o&d.ADD_TO_PATH_FLAG);if((s.disableFontFace||h)&&(i=s.getPathGenerator(this.commonObjs,t)),s.disableFontFace?(r.save(),r.translate(e,n),r.beginPath(),i(r,c),l!==d.FILL&&l!==d.FILL_STROKE||r.fill(),l!==d.STROKE&&l!==d.FILL_STROKE||r.stroke(),r.restore()):(l!==d.FILL&&l!==d.FILL_STROKE||r.fillText(t,e,n),l!==d.STROKE&&l!==d.FILL_STROKE||r.strokeText(t,e,n)),h){(this.pendingTextPaths||(this.pendingTextPaths=[])).push({transform:r.mozCurrentTransform,x:e,y:n,fontSize:c,addToPath:i})}},get isFontSubpixelAAEnabled(){var t=document.createElement("canvas").getContext("2d");t.scale(1.5,1),t.fillText("I",0,10);for(var e=t.getImageData(0,0,10,10).data,n=!1,i=3;i<e.length;i+=4)if(e[i]>0&&e[i]<255){n=!0;break}return x(this,"isFontSubpixelAAEnabled",n)},showText:function(t){var e=this.current,n=e.font;if(n.isType3Font)return this.showType3Text(t);var i=e.fontSize;if(0!==i){var r=this.ctx,a=e.fontSizeScale,s=e.charSpacing,o=e.wordSpacing,c=e.fontDirection,l=e.textHScale*c,h=t.length,u=n.vertical,p=u?1:-1,f=n.defaultVMetrics,g=i*e.fontMatrix[0],m=e.textRenderingMode===d.FILL&&!n.disableFontFace;r.save(),r.transform.apply(r,e.textMatrix),r.translate(e.x,e.y+e.textRise),e.patternFill&&(r.fillStyle=e.fillColor.getPattern(r,this)),c>0?r.scale(l,-1):r.scale(l,1);var v=e.lineWidth,b=e.textMatrixScale;if(0===b||0===v){var y=e.textRenderingMode&d.FILL_STROKE_MASK;y!==d.STROKE&&y!==d.FILL_STROKE||(this.cachedGetSinglePixelWidth=null,v=.65*this.getSinglePixelWidth())}else v/=b;1!==a&&(r.scale(a,a),v/=a),r.lineWidth=v;var x,S=0;for(x=0;x<h;++x){var k=t[x];if(A(k))S+=p*k*i/1e3;else{var C,_,w,T,L=!1,P=(k.isSpace?o:0)+s,E=k.fontChar,R=k.accent,I=k.width;if(u){var D,j,O;D=k.vmetric||f,j=k.vmetric?D[1]:.5*I,j=-j*g,O=D[2]*g,I=D?-D[0]:I,C=j/a,_=(S+O)/a}else C=S/a,_=0;if(n.remeasure&&I>0){var M=1e3*r.measureText(E).width/i*a;if(I<M&&this.isFontSubpixelAAEnabled){var F=I/M;L=!0,r.save(),r.scale(F,1),C/=F}else I!==M&&(C+=(I-M)/2e3*i/a)}(k.isInFont||n.missingFile)&&(m&&!R?r.fillText(E,C,_):(this.paintChar(E,C,_),R&&(w=C+R.offset.x/a,T=_-R.offset.y/a,this.paintChar(R.fontChar,w,T))));S+=I*g+P*c,L&&r.restore()}}u?e.y-=S*l:e.x+=S*l,r.restore()}},showType3Text:function(t){var e,n,i,r,a=this.ctx,s=this.current,o=s.font,l=s.fontSize,h=s.fontDirection,u=o.vertical?1:-1,p=s.charSpacing,g=s.wordSpacing,m=s.textHScale*h,v=s.fontMatrix||c,b=t.length,y=s.textRenderingMode===d.INVISIBLE;if(!y&&0!==l){for(this.cachedGetSinglePixelWidth=null,a.save(),a.transform.apply(a,s.textMatrix),a.translate(s.x,s.y),a.scale(m,h),e=0;e<b;++e)if(n=t[e],A(n))r=u*n*l/1e3,this.ctx.translate(r,0),s.x+=r*m;else{var x=(n.isSpace?g:0)+p,k=o.charProcOperatorList[n.operatorListId];if(k){this.processingType3=n,this.save(),a.scale(l,l),a.transform.apply(a,v),this.executeOperatorList(k),this.restore();var C=f.applyTransform([n.width,0],v);i=C[0]*l+x,a.translate(i,0),s.x+=i*m}else S('Type3 character "'+n.operatorListId+'" is not available')}a.restore(),this.processingType3=null}},setCharWidth:function(t,e){},setCharWidthAndBounds:function(t,e,n,i,r,a){this.ctx.rect(n,i,r-n,a-i),this.clip(),this.endPath()},getColorN_Pattern:function(e){var n;if("TilingPattern"===e[0]){var i=e[1],r=this.baseTransform||this.ctx.mozCurrentTransform.slice(),a=this,s={createCanvasGraphics:function(e){return new t(e,a.commonObjs,a.objs)}};n=new k(e,i,this.ctx,s,r)}else n=C(e);return n},setStrokeColorN:function(){this.current.strokeColor=this.getColorN_Pattern(arguments)},setFillColorN:function(){this.current.fillColor=this.getColorN_Pattern(arguments),this.current.patternFill=!0},setStrokeRGBColor:function(t,e,n){var i=f.makeCssRgb(t,e,n);this.ctx.strokeStyle=i,this.current.strokeColor=i},setFillRGBColor:function(t,e,n){var i=f.makeCssRgb(t,e,n);this.ctx.fillStyle=i,this.current.fillColor=i,this.current.patternFill=!1},shadingFill:function(t){var e=this.ctx;this.save();var n=C(t);e.fillStyle=n.getPattern(e,this,!0);var i=e.mozCurrentTransformInverse;if(i){var r=e.canvas,a=r.width,s=r.height,o=f.applyTransform([0,0],i),c=f.applyTransform([0,s],i),l=f.applyTransform([a,0],i),h=f.applyTransform([a,s],i),u=Math.min(o[0],c[0],l[0],h[0]),d=Math.min(o[1],c[1],l[1],h[1]),p=Math.max(o[0],c[0],l[0],h[0]),g=Math.max(o[1],c[1],l[1],h[1]);this.ctx.fillRect(u,d,p-u,g-d)}else this.ctx.fillRect(-1e10,-1e10,2e10,2e10);this.restore()},beginInlineImage:function(){y("Should not call beginInlineImage")},beginImageData:function(){y("Should not call beginImageData")},paintFormXObjectBegin:function(t,e){if(this.save(),this.baseTransformStack.push(this.baseTransform),v(t)&&6===t.length&&this.transform.apply(this,t),this.baseTransform=this.ctx.mozCurrentTransform,v(e)&&4===e.length){var n=e[2]-e[0],i=e[3]-e[1];this.ctx.rect(e[0],e[1],n,i),this.clip(),this.endPath()}},paintFormXObjectEnd:function(){this.restore(),this.baseTransform=this.baseTransformStack.pop()},beginGroup:function(t){this.save();var e=this.ctx;t.isolated||m("TODO: Support non-isolated groups."),t.knockout&&S("Knockout groups not supported.");var n=e.mozCurrentTransform;t.matrix&&e.transform.apply(e,t.matrix),g(t.bbox,"Bounding box is required.");var r=f.getAxialAlignedBoundingBox(t.bbox,e.mozCurrentTransform),a=[0,0,e.canvas.width,e.canvas.height];r=f.intersect(r,a)||[0,0,0,0];var s=Math.floor(r[0]),o=Math.floor(r[1]),c=Math.max(Math.ceil(r[2])-s,1),l=Math.max(Math.ceil(r[3])-o,1),h=1,u=1;c>4096&&(h=c/4096,c=4096),l>4096&&(u=l/4096,l=4096);var d="groupAt"+this.groupLevel;t.smask&&(d+="_smask_"+this.smaskCounter++%2);var p=this.cachedCanvases.getCanvas(d,c,l,!0),A=p.context;A.scale(1/h,1/u),A.translate(-s,-o),A.transform.apply(A,n),t.smask?this.smaskStack.push({canvas:p.canvas,context:A,offsetX:s,offsetY:o,scaleX:h,scaleY:u,subtype:t.smask.subtype,backdrop:t.smask.backdrop,transferMap:t.smask.transferMap||null,startTransformInverse:null}):(e.setTransform(1,0,0,1,0,0),e.translate(s,o),e.scale(h,u)),i(e,A),this.ctx=A,this.setGState([["BM","Normal"],["ca",1],["CA",1]]),this.groupStack.push(e),this.groupLevel++,this.current.activeSMask=null},endGroup:function(t){this.groupLevel--;var e=this.ctx;this.ctx=this.groupStack.pop(),void 0!==this.ctx.imageSmoothingEnabled?this.ctx.imageSmoothingEnabled=!1:this.ctx.mozImageSmoothingEnabled=!1,t.smask?this.tempSMask=this.smaskStack.pop():this.ctx.drawImage(e.canvas,0,0),this.restore()},beginAnnotations:function(){this.save(),this.current=new E,this.baseTransform&&this.ctx.setTransform.apply(this.ctx,this.baseTransform)},endAnnotations:function(){this.restore()},beginAnnotation:function(t,e,n){if(this.save(),v(t)&&4===t.length){var i=t[2]-t[0],r=t[3]-t[1];this.ctx.rect(t[0],t[1],i,r),this.clip(),this.endPath()}this.transform.apply(this,e),this.transform.apply(this,n)},endAnnotation:function(){this.restore()},paintJpegXObject:function(t,e,n){var i=this.objs.get(t);if(!i)return void S("Dependent image isn't ready yet");this.save();var r=this.ctx;if(r.scale(1/e,-1/n),r.drawImage(i,0,0,i.width,i.height,0,-n,e,n),this.imageLayer){var a=r.mozCurrentTransformInverse,s=this.getCanvasPosition(0,0);this.imageLayer.appendImage({objId:t,left:s[0],top:s[1],width:e/a[0],height:n/a[3]})}this.restore()},paintImageMaskXObject:function(t){var e=this.ctx,i=t.width,r=t.height,a=this.current.fillColor,s=this.current.patternFill,c=this.processingType3;if(c&&void 0===c.compiled&&(c.compiled=i<=1e3&&r<=1e3?o({data:t.data,width:i,height:r}):null),c&&c.compiled)return void c.compiled(e);var l=this.cachedCanvases.getCanvas("maskCanvas",i,r),h=l.context;h.save(),n(h,t),h.globalCompositeOperation="source-in",h.fillStyle=s?a.getPattern(h,this):a,h.fillRect(0,0,i,r),h.restore(),this.paintInlineImageXObject(l.canvas)},paintImageMaskXObjectRepeat:function(t,e,i,r){var a=t.width,s=t.height,o=this.current.fillColor,c=this.current.patternFill,l=this.cachedCanvases.getCanvas("maskCanvas",a,s),h=l.context;h.save(),n(h,t),h.globalCompositeOperation="source-in",h.fillStyle=c?o.getPattern(h,this):o,h.fillRect(0,0,a,s),h.restore();for(var u=this.ctx,d=0,p=r.length;d<p;d+=2)u.save(),u.transform(e,0,0,i,r[d],r[d+1]),u.scale(1,-1),u.drawImage(l.canvas,0,0,a,s,0,-1,1,1),u.restore()},paintImageMaskXObjectGroup:function(t){for(var e=this.ctx,i=this.current.fillColor,r=this.current.patternFill,a=0,s=t.length;a<s;a++){var o=t[a],c=o.width,l=o.height,h=this.cachedCanvases.getCanvas("maskCanvas",c,l),u=h.context;u.save(),n(u,o),u.globalCompositeOperation="source-in",u.fillStyle=r?i.getPattern(u,this):i,u.fillRect(0,0,c,l),u.restore(),e.save(),e.transform.apply(e,o.transform),e.scale(1,-1),e.drawImage(h.canvas,0,0,c,l,0,-1,1,1),e.restore()}},paintImageXObject:function(t){var e=this.objs.get(t);if(!e)return void S("Dependent image isn't ready yet");this.paintInlineImageXObject(e)},paintImageXObjectRepeat:function(t,e,n,i){var r=this.objs.get(t);if(!r)return void S("Dependent image isn't ready yet");for(var a=r.width,s=r.height,o=[],c=0,l=i.length;c<l;c+=2)o.push({transform:[e,0,0,n,i[c],i[c+1]],x:0,y:0,w:a,h:s});this.paintInlineImageXObjectGroup(r,o)},paintInlineImageXObject:function(t){var n=t.width,i=t.height,r=this.ctx;this.save(),r.scale(1/n,-1/i);var a,s,o=r.mozCurrentTransformInverse,c=o[0],l=o[1],h=Math.max(Math.sqrt(c*c+l*l),1),u=o[2],d=o[3],p=Math.max(Math.sqrt(u*u+d*d),1);if(t instanceof HTMLElement||!t.data)a=t;else{s=this.cachedCanvases.getCanvas("inlineImage",n,i);var f=s.context;e(f,t),a=s.canvas}for(var g=n,m=i,A="prescale1";h>2&&g>1||p>2&&m>1;){var v=g,b=m;h>2&&g>1&&(v=Math.ceil(g/2),h/=g/v),p>2&&m>1&&(b=Math.ceil(m/2),p/=m/b),s=this.cachedCanvases.getCanvas(A,v,b),f=s.context,f.clearRect(0,0,v,b),f.drawImage(a,0,0,g,m,0,0,v,b),a=s.canvas,g=v,m=b,A="prescale1"===A?"prescale2":"prescale1"}if(r.drawImage(a,0,0,g,m,0,-i,n,i),this.imageLayer){var y=this.getCanvasPosition(0,-i);this.imageLayer.appendImage({imgData:t,left:y[0],top:y[1],width:n/o[0],height:i/o[3]})}this.restore()},paintInlineImageXObjectGroup:function(t,n){var i=this.ctx,r=t.width,a=t.height,s=this.cachedCanvases.getCanvas("inlineImage",r,a);e(s.context,t);for(var o=0,c=n.length;o<c;o++){var l=n[o];if(i.save(),i.transform.apply(i,l.transform),i.scale(1,-1),i.drawImage(s.canvas,l.x,l.y,l.w,l.h,0,-1,1,1),this.imageLayer){var h=this.getCanvasPosition(l.x,l.y);this.imageLayer.appendImage({imgData:t,left:h[0],top:h[1],width:r,height:a})}i.restore()}},paintSolidColorImageMask:function(){this.ctx.fillRect(0,0,1,1)},paintXObject:function(){S("Unsupported 'paintXObject' command.")},markPoint:function(t){},markPointProps:function(t,e){},beginMarkedContent:function(t){},beginMarkedContentProps:function(t,e){},endMarkedContent:function(){},beginCompat:function(){},endCompat:function(){},consumePath:function(){var t=this.ctx;this.pendingClip&&(this.pendingClip===O?void 0!==t.mozFillRule?(t.mozFillRule="evenodd",t.clip(),t.mozFillRule="nonzero"):t.clip("evenodd"):t.clip(),this.pendingClip=null),t.beginPath()},getSinglePixelWidth:function(t){if(null===this.cachedGetSinglePixelWidth){this.ctx.save();var e=this.ctx.mozCurrentTransformInverse;this.ctx.restore(),this.cachedGetSinglePixelWidth=Math.sqrt(Math.max(e[0]*e[0]+e[1]*e[1],e[2]*e[2]+e[3]*e[3]))}return this.cachedGetSinglePixelWidth},getCanvasPosition:function(t,e){var n=this.ctx.mozCurrentTransform;return[n[0]*t+n[2]*e+n[4],n[1]*t+n[3]*e+n[5]]}};for(var M in u)t.prototype[u[M]]=t.prototype[M];return t}();t.CanvasGraphics=R,t.createScratchCanvas=a}),function(t,e){e(t.pdfjsDisplayAPI={},t.pdfjsSharedUtil,t.pdfjsDisplayFontLoader,t.pdfjsDisplayCanvas,t.pdfjsDisplayMetadata,t.pdfjsDisplayDOMUtils)}(this,function(t,n,i,r,a,s,o){function c(t,e,n,i){var r=new H;arguments.length>1&&k("getDocument is called with pdfDataRangeTransport, passwordCallback or progressCallback argument"),e&&(e instanceof Y||(e=Object.create(e),e.length=t.length,e.initialData=t.initialData,e.abort||(e.abort=function(){})),t=Object.create(t),t.range=e),r.onPassword=n||null,r.onProgress=i||null;var a;"string"==typeof t?a={url:t}:L(t)?a={data:t}:t instanceof Y?a={range:t}:("object"!=typeof t&&S("Invalid parameter in getDocument, need either Uint8Array, string or a parameter object"),t.url||t.data||t.range||S("Invalid parameter object: need either .data, .range or .url"),a=t);var s={},o=null,c=null;for(var h in a)if("url"!==h||"undefined"==typeof window)if("range"!==h)if("worker"!==h)if("data"!==h||a[h]instanceof Uint8Array)s[h]=a[h];else{var u=a[h];"string"==typeof u?s[h]=R(u):"object"!=typeof u||null===u||isNaN(u.length)?L(u)?s[h]=new Uint8Array(u):S("Invalid PDF binary data: either typed array, string or array-like object is expected in the data property."):s[h]=new Uint8Array(u)}else c=a[h];else o=a[h];else s[h]=new URL(a[h],window.location).href;s.rangeChunkSize=s.rangeChunkSize||65536,c||(c=new J,r._worker=c);var p=r.docId;return c.promise.then(function(){if(r.destroyed)throw new Error("Loading aborted");return l(c,s,o,p).then(function(t){if(r.destroyed)throw new Error("Loading aborted");var e=new d(p,t,c.port),n=new Q(e,r,o);r._transport=n,e.send("Ready",null)})}).catch(r._capability.reject),r}function l(t,e,n,i){return t.destroyed?Promise.reject(new Error("Worker was destroyed")):(e.disableAutoFetch=U("disableAutoFetch"),e.disableStream=U("disableStream"),e.chunkedViewerLoading=!!n,n&&(e.length=n.length,e.initialData=n.initialData),t.messageHandler.sendWithPromise("GetDocRequest",{docId:i,source:e,disableRange:U("disableRange"),maxImageSize:U("maxImageSize"),cMapUrl:U("cMapUrl"),cMapPacked:U("cMapPacked"),disableFontFace:U("disableFontFace"),disableCreateObjectURL:U("disableCreateObjectURL"),postMessageTransfers:U("postMessageTransfers")&&!W}).then(function(e){if(t.destroyed)throw new Error("Worker was destroyed");return e}))}var h,u=n.InvalidPDFException,d=n.MessageHandler,p=n.MissingPDFException,f=n.PageViewport,g=n.PasswordResponses,m=n.PasswordException,A=n.StatTimer,v=n.UnexpectedResponseException,b=n.UnknownErrorException,y=n.Util,x=n.createPromiseCapability,S=n.error,k=n.deprecated,C=n.getVerbosityLevel,_=n.info,w=n.isInt,T=n.isArray,L=n.isArrayBuffer,P=n.isSameOrigin,E=n.loadJpegStream,R=n.stringToBytes,I=n.globalScope,D=n.warn,j=i.FontFaceObject,O=i.FontLoader,M=r.CanvasGraphics,F=r.createScratchCanvas,N=a.Metadata,U=s.getDefaultSetting,B=!1,W=!1,G=!1;"undefined"==typeof window&&(B=!0,void 0===require.ensure&&(require.ensure=require("node-ensure")),G=!0),"undefined"!=typeof __webpack_require__&&(G=!0),"undefined"!=typeof requirejs&&requirejs.toUrl&&(h=requirejs.toUrl("pdfjs-dist/build/pdf.worker.js"));var X="undefined"!=typeof requirejs&&requirejs.load,z=G?function(t){require.ensure([],function(){t(require("./pdf.worker.js").WorkerMessageHandler)})}:X?function(t){requirejs(["pdfjs-dist/build/pdf.worker"],function(e){t(e.WorkerMessageHandler)})}:null,H=function(){function t(){this._capability=x(),this._transport=null,this._worker=null,this.docId="d"+e++,this.destroyed=!1,this.onPassword=null,this.onProgress=null,this.onUnsupportedFeature=null}var e=Math.floor(1e6*Math.random());return t.prototype={get promise(){return this._capability.promise},destroy:function(){return this.destroyed=!0,(this._transport?this._transport.destroy():Promise.resolve()).then(function(){this._transport=null,this._worker&&(this._worker.destroy(),this._worker=null)}.bind(this))},then:function(t,e){return this.promise.then.apply(this.promise,arguments)}},t}(),Y=function(){function t(t,e){this.length=t,this.initialData=e,this._rangeListeners=[],this._progressListeners=[],this._progressiveReadListeners=[],this._readyCapability=x()}return t.prototype={addRangeListener:function(t){this._rangeListeners.push(t)},addProgressListener:function(t){this._progressListeners.push(t)},addProgressiveReadListener:function(t){this._progressiveReadListeners.push(t)},onDataRange:function(t,e){for(var n=this._rangeListeners,i=0,r=n.length;i<r;++i)n[i](t,e)},onDataProgress:function(t){this._readyCapability.promise.then(function(){for(var e=this._progressListeners,n=0,i=e.length;n<i;++n)e[n](t)}.bind(this))},onDataProgressiveRead:function(t){this._readyCapability.promise.then(function(){for(var e=this._progressiveReadListeners,n=0,i=e.length;n<i;++n)e[n](t)}.bind(this))},transportReady:function(){this._readyCapability.resolve()},requestDataRange:function(t,e){throw new Error("Abstract method PDFDataRangeTransport.requestDataRange")},abort:function(){}},t}(),q=function(){function t(t,e,n){this.pdfInfo=t,this.transport=e,this.loadingTask=n}return t.prototype={get numPages(){return this.pdfInfo.numPages},get fingerprint(){return this.pdfInfo.fingerprint},getPage:function(t){return this.transport.getPage(t)},getPageIndex:function(t){return this.transport.getPageIndex(t)},getDestinations:function(){return this.transport.getDestinations()},getDestination:function(t){return this.transport.getDestination(t)},getPageLabels:function(){return this.transport.getPageLabels()},getAttachments:function(){return this.transport.getAttachments()},getJavaScript:function(){return this.transport.getJavaScript()},getOutline:function(){return this.transport.getOutline()},getMetadata:function(){return this.transport.getMetadata()},getData:function(){return this.transport.getData()},getDownloadInfo:function(){return this.transport.downloadInfoCapability.promise},getStats:function(){return this.transport.getStats()},cleanup:function(){this.transport.startCleanup()},destroy:function(){return this.loadingTask.destroy()}},t}(),V=function(){function t(t,e,n){this.pageIndex=t,this.pageInfo=e,this.transport=n,this.stats=new A,this.stats.enabled=U("enableStats"),this.commonObjs=n.commonObjs,this.objs=new K,this.cleanupAfterRender=!1,this.pendingCleanup=!1,this.intentStates=Object.create(null),this.destroyed=!1}return t.prototype={get pageNumber(){return this.pageIndex+1},get rotate(){return this.pageInfo.rotate},get ref(){return this.pageInfo.ref},get view(){return this.pageInfo.view},getViewport:function(t,e){return arguments.length<2&&(e=this.rotate),new f(this.view,t,e,0,0)},getAnnotations:function(t){var e=t&&t.intent||null;return this.annotationsPromise&&this.annotationsIntent===e||(this.annotationsPromise=this.transport.getAnnotations(this.pageIndex,e),this.annotationsIntent=e),this.annotationsPromise},render:function(t){function e(t){var e=a.renderTasks.indexOf(s);e>=0&&a.renderTasks.splice(e,1),c.cleanupAfterRender&&(c.pendingCleanup=!0),c._tryCleanup(),t?s.capability.reject(t):s.capability.resolve(),n.timeEnd("Rendering"),n.timeEnd("Overall")}var n=this.stats;n.time("Overall"),this.pendingCleanup=!1;var i="print"===t.intent?"print":"display",r=t.renderInteractiveForms===!0;this.intentStates[i]||(this.intentStates[i]=Object.create(null));var a=this.intentStates[i];a.displayReadyCapability||(a.receivingOperatorList=!0,a.displayReadyCapability=x(),a.operatorList={fnArray:[],argsArray:[],lastChunk:!1},this.stats.time("Page Request"),this.transport.messageHandler.send("RenderPageRequest",{pageIndex:this.pageNumber-1,intent:i,renderInteractiveForms:r}));var s=new $(e,t,this.objs,this.commonObjs,a.operatorList,this.pageNumber);s.useRequestAnimationFrame="print"!==i,a.renderTasks||(a.renderTasks=[]),a.renderTasks.push(s);var o=s.task;t.continueCallback&&(k("render is used with continueCallback parameter"),o.onContinue=t.continueCallback);var c=this;return a.displayReadyCapability.promise.then(function(t){if(c.pendingCleanup)return void e();n.time("Rendering"),s.initializeGraphics(t),s.operatorListChanged()},function(t){e(t)}),o},getOperatorList:function(){function t(){if(n.operatorList.lastChunk){n.opListReadCapability.resolve(n.operatorList);var t=n.renderTasks.indexOf(e);t>=0&&n.renderTasks.splice(t,1)}}this.intentStates.oplist||(this.intentStates.oplist=Object.create(null));var e,n=this.intentStates.oplist;return n.opListReadCapability||(e={},e.operatorListChanged=t,n.receivingOperatorList=!0,n.opListReadCapability=x(),n.renderTasks=[],n.renderTasks.push(e),n.operatorList={fnArray:[],argsArray:[],lastChunk:!1},this.transport.messageHandler.send("RenderPageRequest",{pageIndex:this.pageIndex,intent:"oplist"})),n.opListReadCapability.promise},getTextContent:function(t){return this.transport.messageHandler.sendWithPromise("GetTextContent",{pageIndex:this.pageNumber-1,normalizeWhitespace:!(!t||t.normalizeWhitespace!==!0),combineTextItems:!t||t.disableCombineTextItems!==!0})},_destroy:function(){this.destroyed=!0,this.transport.pageCache[this.pageIndex]=null;var t=[];return Object.keys(this.intentStates).forEach(function(e){if("oplist"!==e){this.intentStates[e].renderTasks.forEach(function(e){var n=e.capability.promise.catch(function(){});t.push(n),e.cancel()})}},this),this.objs.clear(),this.annotationsPromise=null,this.pendingCleanup=!1,Promise.all(t)},destroy:function(){k("page destroy method, use cleanup() instead"),this.cleanup()},cleanup:function(){this.pendingCleanup=!0,this._tryCleanup()},_tryCleanup:function(){
this.pendingCleanup&&!Object.keys(this.intentStates).some(function(t){var e=this.intentStates[t];return 0!==e.renderTasks.length||e.receivingOperatorList},this)&&(Object.keys(this.intentStates).forEach(function(t){delete this.intentStates[t]},this),this.objs.clear(),this.annotationsPromise=null,this.pendingCleanup=!1)},_startRenderPage:function(t,e){var n=this.intentStates[e];n.displayReadyCapability&&n.displayReadyCapability.resolve(t)},_renderPageChunk:function(t,e){var n,i,r=this.intentStates[e];for(n=0,i=t.length;n<i;n++)r.operatorList.fnArray.push(t.fnArray[n]),r.operatorList.argsArray.push(t.argsArray[n]);for(r.operatorList.lastChunk=t.lastChunk,n=0;n<r.renderTasks.length;n++)r.renderTasks[n].operatorListChanged();t.lastChunk&&(r.receivingOperatorList=!1,this._tryCleanup())}},t}(),J=function(){function t(){return void 0!==h?h:U("workerSrc")?U("workerSrc"):e?e.replace(/\.js$/i,".worker.js"):void S("No PDFJS.workerSrc specified")}function n(){if(!s){s=x();(z||function(e){y.loadScript(t(),function(){e(window.pdfjsDistBuildPdfWorker.WorkerMessageHandler)})})(s.resolve)}return s.promise}function i(t){this._listeners=[],this._defer=t,this._deferred=Promise.resolve(void 0)}function r(t){var e="importScripts('"+t+"');";return URL.createObjectURL(new Blob([e]))}function a(t){this.name=t,this.destroyed=!1,this._readyCapability=x(),this._port=null,this._webWorker=null,this._messageHandler=null,this._initialize()}var s,o=0;return i.prototype={postMessage:function(t,e){function n(t){if("object"!=typeof t||null===t)return t;if(i.has(t))return i.get(t);var r,a;if((a=t.buffer)&&L(a)){var s=e&&e.indexOf(a)>=0;return r=t===a?t:s?new t.constructor(a,t.byteOffset,t.byteLength):new t.constructor(t),i.set(t,r),r}r=T(t)?[]:{},i.set(t,r);for(var o in t){for(var c,l=t;!(c=Object.getOwnPropertyDescriptor(l,o));)l=Object.getPrototypeOf(l);void 0!==c.value&&"function"!=typeof c.value&&(r[o]=n(c.value))}return r}if(!this._defer)return void this._listeners.forEach(function(e){e.call(this,{data:t})},this);var i=new WeakMap,r={data:n(t)};this._deferred.then(function(){this._listeners.forEach(function(t){t.call(this,r)},this)}.bind(this))},addEventListener:function(t,e){this._listeners.push(e)},removeEventListener:function(t,e){var n=this._listeners.indexOf(e);this._listeners.splice(n,1)},terminate:function(){this._listeners=[]}},a.prototype={get promise(){return this._readyCapability.promise},get port(){return this._port},get messageHandler(){return this._messageHandler},_initialize:function(){if(!B&&!U("disableWorker")&&"undefined"!=typeof Worker){var e=t();try{P(window.location.href,e)||(e=r(new URL(e,window.location).href));var n=new Worker(e),i=new d("main","worker",n),a=function(){n.removeEventListener("error",s),i.destroy(),n.terminate(),this.destroyed?this._readyCapability.reject(new Error("Worker was destroyed")):this._setupFakeWorker()}.bind(this),s=function(t){this._webWorker||a()}.bind(this);n.addEventListener("error",s),i.on("test",function(t){if(n.removeEventListener("error",s),this.destroyed)return void a();t&&t.supportTypedArray?(this._messageHandler=i,this._port=n,this._webWorker=n,t.supportTransfers||(W=!0),this._readyCapability.resolve(),i.send("configure",{verbosity:C()})):(this._setupFakeWorker(),i.destroy(),n.terminate())}.bind(this)),i.on("console_log",function(t){console.log.apply(console,t)}),i.on("console_error",function(t){console.error.apply(console,t)}),i.on("ready",function(t){if(n.removeEventListener("error",s),this.destroyed)return void a();try{o()}catch(t){this._setupFakeWorker()}}.bind(this));var o=function(){var t=U("postMessageTransfers")&&!W,e=new Uint8Array([t?255:0]);try{i.send("test",e,[e.buffer])}catch(t){_("Cannot use postMessage transfers"),e[0]=0,i.send("test",e)}};return void o()}catch(t){_("The worker has been disabled.")}}this._setupFakeWorker()},_setupFakeWorker:function(){B||U("disableWorker")||(D("Setting up fake worker."),B=!0),n().then(function(t){if(this.destroyed)return void this._readyCapability.reject(new Error("Worker was destroyed"));var e=Uint8Array!==Float32Array,n=new i(e);this._port=n;var r="fake"+o++,a=new d(r+"_worker",r,n);t.setup(a,n);var s=new d(r,r+"_worker",n);this._messageHandler=s,this._readyCapability.resolve()}.bind(this))},destroy:function(){this.destroyed=!0,this._webWorker&&(this._webWorker.terminate(),this._webWorker=null),this._port=null,this._messageHandler&&(this._messageHandler.destroy(),this._messageHandler=null)}},a}(),Q=function(){function t(t,e,n){this.messageHandler=t,this.loadingTask=e,this.pdfDataRangeTransport=n,this.commonObjs=new K,this.fontLoader=new O(e.docId),this.destroyed=!1,this.destroyCapability=null,this.pageCache=[],this.pagePromises=[],this.downloadInfoCapability=x(),this.setupMessageHandler()}return t.prototype={destroy:function(){if(this.destroyCapability)return this.destroyCapability.promise;this.destroyed=!0,this.destroyCapability=x();var t=[];this.pageCache.forEach(function(e){e&&t.push(e._destroy())}),this.pageCache=[],this.pagePromises=[];var e=this,n=this.messageHandler.sendWithPromise("Terminate",null);return t.push(n),Promise.all(t).then(function(){e.fontLoader.clear(),e.pdfDataRangeTransport&&(e.pdfDataRangeTransport.abort(),e.pdfDataRangeTransport=null),e.messageHandler&&(e.messageHandler.destroy(),e.messageHandler=null),e.destroyCapability.resolve()},this.destroyCapability.reject),this.destroyCapability.promise},setupMessageHandler:function(){function t(t){e.send("UpdatePassword",t)}var e=this.messageHandler,n=this.pdfDataRangeTransport;n&&(n.addRangeListener(function(t,n){e.send("OnDataRange",{begin:t,chunk:n})}),n.addProgressListener(function(t){e.send("OnDataProgress",{loaded:t})}),n.addProgressiveReadListener(function(t){e.send("OnDataRange",{chunk:t})}),e.on("RequestDataRange",function(t){n.requestDataRange(t.begin,t.end)},this)),e.on("GetDoc",function(t){var e=t.pdfInfo;this.numPages=t.pdfInfo.numPages;var n=this.loadingTask,i=new q(e,this,n);this.pdfDocument=i,n._capability.resolve(i)},this),e.on("NeedPassword",function(e){var n=this.loadingTask;if(n.onPassword)return n.onPassword(t,g.NEED_PASSWORD);n._capability.reject(new m(e.message,e.code))},this),e.on("IncorrectPassword",function(e){var n=this.loadingTask;if(n.onPassword)return n.onPassword(t,g.INCORRECT_PASSWORD);n._capability.reject(new m(e.message,e.code))},this),e.on("InvalidPDF",function(t){this.loadingTask._capability.reject(new u(t.message))},this),e.on("MissingPDF",function(t){this.loadingTask._capability.reject(new p(t.message))},this),e.on("UnexpectedResponse",function(t){this.loadingTask._capability.reject(new v(t.message,t.status))},this),e.on("UnknownError",function(t){this.loadingTask._capability.reject(new b(t.message,t.details))},this),e.on("DataLoaded",function(t){this.downloadInfoCapability.resolve(t)},this),e.on("PDFManagerReady",function(t){this.pdfDataRangeTransport&&this.pdfDataRangeTransport.transportReady()},this),e.on("StartRenderPage",function(t){if(!this.destroyed){var e=this.pageCache[t.pageIndex];e.stats.timeEnd("Page Request"),e._startRenderPage(t.transparency,t.intent)}},this),e.on("RenderPageChunk",function(t){if(!this.destroyed){this.pageCache[t.pageIndex]._renderPageChunk(t.operatorList,t.intent)}},this),e.on("commonobj",function(t){if(!this.destroyed){var e=t[0],n=t[1];if(!this.commonObjs.hasData(e))switch(n){case"Font":var i=t[2];if("error"in i){var r=i.error;D("Error during font loading: "+r),this.commonObjs.resolve(e,r);break}var a=null;U("pdfBug")&&I.FontInspector&&I.FontInspector.enabled&&(a={registerFont:function(t,e){I.FontInspector.fontAdded(t,e)}});var s=new j(i,{isEvalSuported:U("isEvalSupported"),disableFontFace:U("disableFontFace"),fontRegistry:a});this.fontLoader.bind([s],function(t){this.commonObjs.resolve(e,s)}.bind(this));break;case"FontPath":this.commonObjs.resolve(e,t[2]);break;default:S("Got unknown common object type "+n)}}},this),e.on("obj",function(t){if(!this.destroyed){var e,n=t[0],i=t[1],r=t[2],a=this.pageCache[i];if(!a.objs.hasData(n))switch(r){case"JpegStream":e=t[3],E(n,e,a.objs);break;case"Image":e=t[3],a.objs.resolve(n,e);e&&"data"in e&&e.data.length>8e6&&(a.cleanupAfterRender=!0);break;default:S("Got unknown object type "+r)}}},this),e.on("DocProgress",function(t){if(!this.destroyed){var e=this.loadingTask;e.onProgress&&e.onProgress({loaded:t.loaded,total:t.total})}},this),e.on("PageError",function(t){if(!this.destroyed){var e=this.pageCache[t.pageNum-1],n=e.intentStates[t.intent];if(n.displayReadyCapability?n.displayReadyCapability.reject(t.error):S(t.error),n.operatorList){n.operatorList.lastChunk=!0;for(var i=0;i<n.renderTasks.length;i++)n.renderTasks[i].operatorListChanged()}}},this),e.on("UnsupportedFeature",function(t){if(!this.destroyed){var e=t.featureId,n=this.loadingTask;n.onUnsupportedFeature&&n.onUnsupportedFeature(e),tt.notify(e)}},this),e.on("JpegDecode",function(t){if(this.destroyed)return Promise.reject(new Error("Worker was destroyed"));var e=t[0],n=t[1];return 3!==n&&1!==n?Promise.reject(new Error("Only 3 components or 1 component can be returned")):new Promise(function(t,i){var r=new Image;r.onload=function(){var e=r.width,i=r.height,a=e*i,s=4*a,o=new Uint8Array(a*n),c=F(e,i),l=c.getContext("2d");l.drawImage(r,0,0);var h,u,d=l.getImageData(0,0,e,i).data;if(3===n)for(h=0,u=0;h<s;h+=4,u+=3)o[u]=d[h],o[u+1]=d[h+1],o[u+2]=d[h+2];else if(1===n)for(h=0,u=0;h<s;h+=4,u++)o[u]=d[h];t({data:o,width:e,height:i})},r.onerror=function(){i(new Error("JpegDecode failed to load image"))},r.src=e})},this)},getData:function(){return this.messageHandler.sendWithPromise("GetData",null)},getPage:function(t,e){if(!w(t)||t<=0||t>this.numPages)return Promise.reject(new Error("Invalid page request"));var n=t-1;if(n in this.pagePromises)return this.pagePromises[n];var i=this.messageHandler.sendWithPromise("GetPage",{pageIndex:n}).then(function(t){if(this.destroyed)throw new Error("Transport destroyed");var e=new V(n,t,this);return this.pageCache[n]=e,e}.bind(this));return this.pagePromises[n]=i,i},getPageIndex:function(t){return this.messageHandler.sendWithPromise("GetPageIndex",{ref:t}).catch(function(t){return Promise.reject(new Error(t))})},getAnnotations:function(t,e){return this.messageHandler.sendWithPromise("GetAnnotations",{pageIndex:t,intent:e})},getDestinations:function(){return this.messageHandler.sendWithPromise("GetDestinations",null)},getDestination:function(t){return this.messageHandler.sendWithPromise("GetDestination",{id:t})},getPageLabels:function(){return this.messageHandler.sendWithPromise("GetPageLabels",null)},getAttachments:function(){return this.messageHandler.sendWithPromise("GetAttachments",null)},getJavaScript:function(){return this.messageHandler.sendWithPromise("GetJavaScript",null)},getOutline:function(){return this.messageHandler.sendWithPromise("GetOutline",null)},getMetadata:function(){return this.messageHandler.sendWithPromise("GetMetadata",null).then(function(t){return{info:t[0],metadata:t[1]?new N(t[1]):null}})},getStats:function(){return this.messageHandler.sendWithPromise("GetStats",null)},startCleanup:function(){this.messageHandler.sendWithPromise("Cleanup",null).then(function(){for(var t=0,e=this.pageCache.length;t<e;t++){var n=this.pageCache[t];n&&n.cleanup()}this.commonObjs.clear(),this.fontLoader.clear()}.bind(this))}},t}(),K=function(){function t(){this.objs=Object.create(null)}return t.prototype={ensureObj:function(t){if(this.objs[t])return this.objs[t];var e={capability:x(),data:null,resolved:!1};return this.objs[t]=e,e},get:function(t,e){if(e)return this.ensureObj(t).capability.promise.then(e),null;var n=this.objs[t];return n&&n.resolved||S("Requesting object that isn't resolved yet "+t),n.data},resolve:function(t,e){var n=this.ensureObj(t);n.resolved=!0,n.data=e,n.capability.resolve(e)},isResolved:function(t){var e=this.objs;return!!e[t]&&e[t].resolved},hasData:function(t){return this.isResolved(t)},getData:function(t){var e=this.objs;return e[t]&&e[t].resolved?e[t].data:null},clear:function(){this.objs=Object.create(null)}},t}(),Z=function(){function t(t){this._internalRenderTask=t,this.onContinue=null}return t.prototype={get promise(){return this._internalRenderTask.capability.promise},cancel:function(){this._internalRenderTask.cancel()},then:function(t,e){return this.promise.then.apply(this.promise,arguments)}},t}(),$=function(){function t(t,e,n,i,r,a){this.callback=t,this.params=e,this.objs=n,this.commonObjs=i,this.operatorListIdx=null,this.operatorList=r,this.pageNumber=a,this.running=!1,this.graphicsReadyCallback=null,this.graphicsReady=!1,this.useRequestAnimationFrame=!1,this.cancelled=!1,this.capability=x(),this.task=new Z(this),this._continueBound=this._continue.bind(this),this._scheduleNextBound=this._scheduleNext.bind(this),this._nextBound=this._next.bind(this)}return t.prototype={initializeGraphics:function(t){if(!this.cancelled){U("pdfBug")&&I.StepperManager&&I.StepperManager.enabled&&(this.stepper=I.StepperManager.create(this.pageNumber-1),this.stepper.init(this.operatorList),this.stepper.nextBreakPoint=this.stepper.getNextBreakPoint());var e=this.params;this.gfx=new M(e.canvasContext,this.commonObjs,this.objs,e.imageLayer),this.gfx.beginDrawing(e.transform,e.viewport,t),this.operatorListIdx=0,this.graphicsReady=!0,this.graphicsReadyCallback&&this.graphicsReadyCallback()}},cancel:function(){this.running=!1,this.cancelled=!0,this.callback("cancelled")},operatorListChanged:function(){if(!this.graphicsReady)return void(this.graphicsReadyCallback||(this.graphicsReadyCallback=this._continueBound));this.stepper&&this.stepper.updateOperatorList(this.operatorList),this.running||this._continue()},_continue:function(){this.running=!0,this.cancelled||(this.task.onContinue?this.task.onContinue.call(this.task,this._scheduleNextBound):this._scheduleNext())},_scheduleNext:function(){this.useRequestAnimationFrame&&"undefined"!=typeof window?window.requestAnimationFrame(this._nextBound):Promise.resolve(void 0).then(this._nextBound)},_next:function(){this.cancelled||(this.operatorListIdx=this.gfx.executeOperatorList(this.operatorList,this.operatorListIdx,this._continueBound,this.stepper),this.operatorListIdx===this.operatorList.argsArray.length&&(this.running=!1,this.operatorList.lastChunk&&(this.gfx.endDrawing(),this.callback())))}},t}(),tt=function(){var t=[];return{listen:function(e){k("Global UnsupportedManager.listen is used:  use PDFDocumentLoadingTask.onUnsupportedFeature instead"),t.push(e)},notify:function(e){for(var n=0,i=t.length;n<i;n++)t[n](e)}}}();t.version="1.6.214",t.build="86bdfab",t.getDocument=c,t.PDFDataRangeTransport=Y,t.PDFWorker=J,t.PDFDocumentProxy=q,t.PDFPageProxy=V,t._UnsupportedManager=tt}),function(t,e){e(t.pdfjsDisplayGlobal={},t.pdfjsSharedUtil,t.pdfjsDisplayDOMUtils,t.pdfjsDisplayAPI,t.pdfjsDisplayAnnotationLayer,t.pdfjsDisplayTextLayer,t.pdfjsDisplayMetadata,t.pdfjsDisplaySVG)}(this,function(t,e,n,i,r,a,s,o){var c=e.globalScope,l=e.deprecated,h=e.warn,u=n.LinkTarget,d="undefined"==typeof window;c.PDFJS||(c.PDFJS={});var p=c.PDFJS;p.version="1.6.214",p.build="86bdfab",p.pdfBug=!1,void 0!==p.verbosity&&e.setVerbosityLevel(p.verbosity),delete p.verbosity,Object.defineProperty(p,"verbosity",{get:function(){return e.getVerbosityLevel()},set:function(t){e.setVerbosityLevel(t)},enumerable:!0,configurable:!0}),p.VERBOSITY_LEVELS=e.VERBOSITY_LEVELS,p.OPS=e.OPS,p.UNSUPPORTED_FEATURES=e.UNSUPPORTED_FEATURES,p.isValidUrl=e.isValidUrl,p.shadow=e.shadow,p.createBlob=e.createBlob,p.createObjectURL=function(t,n){return e.createObjectURL(t,n,p.disableCreateObjectURL)},Object.defineProperty(p,"isLittleEndian",{configurable:!0,get:function(){var t=e.isLittleEndian();return e.shadow(p,"isLittleEndian",t)}}),p.removeNullCharacters=e.removeNullCharacters,p.PasswordResponses=e.PasswordResponses,p.PasswordException=e.PasswordException,p.UnknownErrorException=e.UnknownErrorException,p.InvalidPDFException=e.InvalidPDFException,p.MissingPDFException=e.MissingPDFException,p.UnexpectedResponseException=e.UnexpectedResponseException,p.Util=e.Util,p.PageViewport=e.PageViewport,p.createPromiseCapability=e.createPromiseCapability,p.maxImageSize=void 0===p.maxImageSize?-1:p.maxImageSize,p.cMapUrl=void 0===p.cMapUrl?null:p.cMapUrl,p.cMapPacked=void 0!==p.cMapPacked&&p.cMapPacked,p.disableFontFace=void 0!==p.disableFontFace&&p.disableFontFace,p.imageResourcesPath=void 0===p.imageResourcesPath?"":p.imageResourcesPath,p.disableWorker=void 0!==p.disableWorker&&p.disableWorker,p.workerSrc=void 0===p.workerSrc?null:p.workerSrc,p.disableRange=void 0!==p.disableRange&&p.disableRange,p.disableStream=void 0!==p.disableStream&&p.disableStream,p.disableAutoFetch=void 0!==p.disableAutoFetch&&p.disableAutoFetch,p.pdfBug=void 0!==p.pdfBug&&p.pdfBug,p.postMessageTransfers=void 0===p.postMessageTransfers||p.postMessageTransfers,p.disableCreateObjectURL=void 0!==p.disableCreateObjectURL&&p.disableCreateObjectURL,p.disableWebGL=void 0===p.disableWebGL||p.disableWebGL,p.externalLinkTarget=void 0===p.externalLinkTarget?u.NONE:p.externalLinkTarget,p.externalLinkRel=void 0===p.externalLinkRel?"noreferrer":p.externalLinkRel,p.isEvalSupported=void 0===p.isEvalSupported||p.isEvalSupported;var f=p.openExternalLinksInNewWindow;delete p.openExternalLinksInNewWindow,Object.defineProperty(p,"openExternalLinksInNewWindow",{get:function(){return p.externalLinkTarget===u.BLANK},set:function(t){if(t&&l('PDFJS.openExternalLinksInNewWindow, please use "PDFJS.externalLinkTarget = PDFJS.LinkTarget.BLANK" instead.'),p.externalLinkTarget!==u.NONE)return void h("PDFJS.externalLinkTarget is already initialized");p.externalLinkTarget=t?u.BLANK:u.NONE},enumerable:!0,configurable:!0}),f&&(p.openExternalLinksInNewWindow=f),p.getDocument=i.getDocument,p.PDFDataRangeTransport=i.PDFDataRangeTransport,p.PDFWorker=i.PDFWorker,Object.defineProperty(p,"hasCanvasTypedArrays",{configurable:!0,get:function(){var t=n.hasCanvasTypedArrays();return e.shadow(p,"hasCanvasTypedArrays",t)}}),p.CustomStyle=n.CustomStyle,p.LinkTarget=u,p.addLinkAttributes=n.addLinkAttributes,p.getFilenameFromUrl=n.getFilenameFromUrl,p.isExternalLinkTargetSet=n.isExternalLinkTargetSet,p.AnnotationLayer=r.AnnotationLayer,p.renderTextLayer=a.renderTextLayer,p.Metadata=s.Metadata,p.SVGGraphics=o.SVGGraphics,p.UnsupportedManager=i._UnsupportedManager,t.globalScope=c,t.isWorker=d,t.PDFJS=c.PDFJS})}).call(n),t.PDFJS=n.pdfjsDisplayGlobal.PDFJS,t.build=n.pdfjsDisplayAPI.build,t.version=n.pdfjsDisplayAPI.version,t.getDocument=n.pdfjsDisplayAPI.getDocument,t.PDFDataRangeTransport=n.pdfjsDisplayAPI.PDFDataRangeTransport,t.PDFWorker=n.pdfjsDisplayAPI.PDFWorker,t.renderTextLayer=n.pdfjsDisplayTextLayer.renderTextLayer,t.AnnotationLayer=n.pdfjsDisplayAnnotationLayer.AnnotationLayer,t.CustomStyle=n.pdfjsDisplayDOMUtils.CustomStyle,t.PasswordResponses=n.pdfjsSharedUtil.PasswordResponses,t.InvalidPDFException=n.pdfjsSharedUtil.InvalidPDFException,t.MissingPDFException=n.pdfjsSharedUtil.MissingPDFException,t.SVGGraphics=n.pdfjsDisplaySVG.SVGGraphics,t.UnexpectedResponseException=n.pdfjsSharedUtil.UnexpectedResponseException,t.OPS=n.pdfjsSharedUtil.OPS,t.UNSUPPORTED_FEATURES=n.pdfjsSharedUtil.UNSUPPORTED_FEATURES,t.isValidUrl=n.pdfjsSharedUtil.isValidUrl,t.createObjectURL=n.pdfjsSharedUtil.createObjectURL,t.removeNullCharacters=n.pdfjsSharedUtil.removeNullCharacters,t.shadow=n.pdfjsSharedUtil.shadow,t.createBlob=n.pdfjsSharedUtil.createBlob,t.getFilenameFromUrl=n.pdfjsDisplayDOMUtils.getFilenameFromUrl,t.addLinkAttributes=n.pdfjsDisplayDOMUtils.addLinkAttributes});(function(){/*

 Copyright The Closure Library Authors.
 SPDX-License-Identifier: Apache-2.0
*/
var e,p=this||self;function aa(a){var b=typeof a;b="object"!=b?b:a?Array.isArray(a)?"array":b:"null";return"array"==b||"object"==b&&"number"==typeof a.length}function ba(a){var b=typeof a;return"object"==b&&null!=a||"function"==b}function ca(a){return Object.prototype.hasOwnProperty.call(a,da)&&a[da]||(a[da]=++ea)}var da="closure_uid_"+(1E9*Math.random()>>>0),ea=0;function fa(a,b,c){return a.call.apply(a.bind,arguments)}
function ha(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var f=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(f,d);return a.apply(b,f)}}return function(){return a.apply(b,arguments)}}function ia(a,b,c){ia=Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?fa:ha;return ia.apply(null,arguments)}
function ja(a,b){a=a.split(".");var c=p;a[0]in c||"undefined"==typeof c.execScript||c.execScript("var "+a[0]);for(var d;a.length&&(d=a.shift());)a.length||void 0===b?c=c[d]&&c[d]!==Object.prototype[d]?c[d]:c[d]={}:c[d]=b}function r(a,b){function c(){}c.prototype=b.prototype;a.W=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.Ds=function(d,f,g){for(var h=Array(arguments.length-2),l=2;l<arguments.length;l++)h[l-2]=arguments[l];return b.prototype[f].apply(d,h)}};function ka(){return la||ma()||void 0===window.orientation?window.innerWidth>window.innerHeight:!!(window.orientation%180)}function ma(){return 0<=window.location.search.indexOf("ispringpreview=1")};var t={Hs:96/72,qm:!0,Ab:640,Uh:480,up:.2,Ye:0,Xe:1,Gr:4,Zr:2628E3,ts:250,ks:200,ms:350,os:200,pm:200,Hr:500,ps:"data/thumbs",pp:.1,Am:35,Tr:20,Js:!1,fb:50,$s:.7,As:{Us:7,Ts:3,Is:200,minWidth:150,maxWidth:400,Zs:25},$j:{className:"lineSpreadThumbnail",qb:8,rp:.12,animationDuration:200,Zc:10,Ve:40,Wf:2,fg:5,Vh:3,jc:2,ii:2,Xf:24,Qh:15,dg:2,minHeight:70,ci:2},Zj:{className:"linePageThumbnail",qb:15,rp:.12,animationDuration:200,Ul:30,Zc:10,Ve:10,Wf:2,Oo:5,fg:5,Vh:3,jc:2,ii:2,Xf:24,Qh:15,dg:2,minHeight:70,
ci:2},oe:{className:"pageViewer",qp:"pages",Ga:9},cf:{className:"bookViewer",zm:9,sp:50},ys:{className:"slideViewer",Ga:9,Yj:30},og:{className:"slideWithTransitionViewer",Ga:0,Jr:5,Fr:2,Yj:4,tp:200}};function na(a,b){if(Error.captureStackTrace)Error.captureStackTrace(this,na);else{const c=Error().stack;c&&(this.stack=c)}a&&(this.message=String(a));void 0!==b&&(this.cause=b)}r(na,Error);na.prototype.name="CustomError";var oa;function pa(a,b){a=a.split("%s");let c="";const d=a.length-1;for(let f=0;f<d;f++)c+=a[f]+(f<b.length?b[f]:"%s");na.call(this,c+a[d])}r(pa,na);pa.prototype.name="AssertionError";function qa(a){throw a;}function ra(a,b){qa(new pa("Failure"+(a?": "+a:""),Array.prototype.slice.call(arguments,1)))};const sa=Array.prototype.indexOf?function(a,b){return Array.prototype.indexOf.call(a,b,void 0)}:function(a,b){if("string"===typeof a)return"string"!==typeof b||1!=b.length?-1:a.indexOf(b,0);for(let c=0;c<a.length;c++)if(c in a&&a[c]===b)return c;return-1},ta=Array.prototype.forEach?function(a,b,c){Array.prototype.forEach.call(a,b,c)}:function(a,b,c){const d=a.length,f="string"===typeof a?a.split(""):a;for(let g=0;g<d;g++)g in f&&b.call(c,f[g],g,a)},ua=Array.prototype.filter?function(a,b){return Array.prototype.filter.call(a,
b,void 0)}:function(a,b){const c=a.length,d=[];let f=0;const g="string"===typeof a?a.split(""):a;for(let h=0;h<c;h++)if(h in g){const l=g[h];b.call(void 0,l,h,a)&&(d[f++]=l)}return d};function va(a,b){a:{const c=a.length,d="string"===typeof a?a.split(""):a;for(let f=0;f<c;f++)if(f in d&&b.call(void 0,d[f],f,a)){b=f;break a}b=-1}return 0>b?null:"string"===typeof a?a.charAt(b):a[b]}function wa(a,b){b=sa(a,b);let c;(c=0<=b)&&Array.prototype.splice.call(a,b,1);return c}
function xa(a){const b=a.length;if(0<b){const c=Array(b);for(let d=0;d<b;d++)c[d]=a[d];return c}return[]}function ya(a,b){for(let c=1;c<arguments.length;c++){const d=arguments[c];if(aa(d)){const f=a.length||0,g=d.length||0;a.length=f+g;for(let h=0;h<g;h++)a[f+h]=d[h]}else a.push(d)}}function za(a,b,c,d){Array.prototype.splice.apply(a,Aa(arguments,1))}function Aa(a,b,c){return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};function Ba(a){var b=b||0;return function(){return a.apply(this,Array.prototype.slice.call(arguments,0,b))}};function Ca(a,b,c){return Math.min(Math.max(a,b),c)}function Da(a){return 0<a?1:0>a?-1:a};function Ea(){}Ea.prototype.next=function(){return Fa};var Fa={done:!0,value:void 0};function Ga(a){return{value:a,done:!1}}Ea.prototype.Tb=function(){return this};function Ha(a){if(a instanceof Ea)return a;if("function"==typeof a.Tb)return a.Tb(!1);if(aa(a)){let b=0;const c=new Ea;c.next=function(){for(;;){if(b>=a.length)return Fa;if(b in a)return Ga(a[b++]);b++}};return c}throw Error("Not implemented");}
function Ia(a,b,c){if(aa(a))ta(a,b,c);else for(a=Ha(a);;){const {done:d,value:f}=a.next();if(d)break;b.call(c,f,void 0,a)}};function Ja(a,b){return(new Ka(b)).rm(a)}function Ka(a){this.Mj=a}Ka.prototype.rm=function(a){const b=[];La(this,a,b);return b.join("")};
function La(a,b,c){if(null==b)c.push("null");else{if("object"==typeof b){if(Array.isArray(b)){var d=b;b=d.length;c.push("[");var f="";for(var g=0;g<b;g++)c.push(f),f=d[g],La(a,a.Mj?a.Mj.call(d,String(g),f):f,c),f=",";c.push("]");return}if(b instanceof String||b instanceof Number||b instanceof Boolean)b=b.valueOf();else{c.push("{");g="";for(d in b)Object.prototype.hasOwnProperty.call(b,d)&&(f=b[d],"function"!=typeof f&&(c.push(g),Ma(d,c),c.push(":"),La(a,a.Mj?a.Mj.call(b,d,f):f,c),g=","));c.push("}");
return}}switch(typeof b){case "string":Ma(b,c);break;case "number":c.push(isFinite(b)&&!isNaN(b)?String(b):"null");break;case "boolean":c.push(String(b));break;case "function":c.push("null");break;default:throw Error("Unknown type: "+typeof b);}}}var Na={'"':'\\"',"\\":"\\\\","/":"\\/","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t","\v":"\\u000b"},Oa=/\uffff/.test("\uffff")?/[\\"\x00-\x1f\x7f-\uffff]/g:/[\\"\x00-\x1f\x7f-\xff]/g;
function Ma(a,b){b.push('"',a.replace(Oa,function(c){let d=Na[c];d||(d="\\u"+(c.charCodeAt(0)|65536).toString(16).slice(1),Na[c]=d);return d}),'"')};function Pa(a){this.Fj=a}Pa.prototype.set=function(a,b){void 0===b?this.Fj.remove(a):this.Fj.set(a,Ja(b))};Pa.prototype.get=function(a){let b;try{b=this.Fj.get(a)}catch(c){return}if(null!==b)try{return JSON.parse(b)}catch(c){throw"Storage: Invalid value was encountered";}};Pa.prototype.remove=function(a){this.Fj.remove(a)};function Qa(){};function Ra(a){if(a instanceof Sa||a instanceof Ta||a instanceof Ua)return a;if("function"==typeof a.next)return new Sa(()=>a);if("function"==typeof a[Symbol.iterator])return new Sa(()=>a[Symbol.iterator]());if("function"==typeof a.Tb)return new Sa(()=>a.Tb());throw Error("Not an iterator or iterable.");}class Sa{constructor(a){this.cm=a}Tb(){return new Ta(this.cm())}[Symbol.iterator](){return new Ua(this.cm())}Wj(){return new Ua(this.cm())}}
class Ta extends Ea{constructor(a){super();this.Mh=a}next(){return this.Mh.next()}[Symbol.iterator](){return new Ua(this.Mh)}Wj(){return new Ua(this.Mh)}}class Ua extends Sa{constructor(a){super(()=>a);this.Mh=a}next(){return this.Mh.next()}};function Va(){}r(Va,Qa);Va.prototype[Symbol.iterator]=function(){return Ra(this.Tb(!0)).Wj()};Va.prototype.clear=function(){const a=Array.from(this);for(const b of a)this.remove(b)};function Wa(a){this.Mc=a}r(Wa,Va);e=Wa.prototype;e.im=function(){if(!this.Mc)return!1;try{return this.Mc.setItem("__sak","1"),this.Mc.removeItem("__sak"),!0}catch(a){return!1}};e.set=function(a,b){try{this.Mc.setItem(a,b)}catch(c){if(0==this.Mc.length)throw"Storage mechanism: Storage disabled";throw"Storage mechanism: Quota exceeded";}};e.get=function(a){a=this.Mc.getItem(a);if("string"!==typeof a&&null!==a)throw"Storage mechanism: Invalid value was encountered";return a};e.remove=function(a){this.Mc.removeItem(a)};
e.Tb=function(a){var b=0,c=this.Mc,d=new Ea;d.next=function(){if(b>=c.length)return Fa;var f=c.key(b++);if(a)return Ga(f);f=c.getItem(f);if("string"!==typeof f)throw"Storage mechanism: Invalid value was encountered";return Ga(f)};return d};e.clear=function(){this.Mc.clear()};e.key=function(a){return this.Mc.key(a)};function Xa(){var a=null;try{a=window.localStorage||null}catch(b){}this.Mc=a}r(Xa,Wa);class Ya{constructor(a,b){this.Dr=a[p.Symbol.iterator]();this.Sr=b}[Symbol.iterator](){return this}next(){const a=this.Dr.next();return{value:a.done?void 0:this.Sr.call(void 0,a.value),done:a.done}}}function Za(a,b){return new Ya(a,b)};function $a(a,b){this.ad={};this.rb=[];this.gi=this.size=0;var c=arguments.length;if(1<c){if(c%2)throw Error("Uneven number of arguments");for(var d=0;d<c;d+=2)this.set(arguments[d],arguments[d+1])}else a&&this.addAll(a)}function ab(a){bb(a);return a.rb.concat()}e=$a.prototype;e.has=function(a){return db(this.ad,a)};e.clear=function(){this.ad={};this.gi=this.size=this.rb.length=0};e.remove=function(a){return this.delete(a)};
e.delete=function(a){return db(this.ad,a)?(delete this.ad[a],--this.size,this.gi++,this.rb.length>2*this.size&&bb(this),!0):!1};function bb(a){if(a.size!=a.rb.length){for(var b=0,c=0;b<a.rb.length;){var d=a.rb[b];db(a.ad,d)&&(a.rb[c++]=d);b++}a.rb.length=c}if(a.size!=a.rb.length){var f={};for(c=b=0;b<a.rb.length;)d=a.rb[b],db(f,d)||(a.rb[c++]=d,f[d]=1),b++;a.rb.length=c}}e.get=function(a,b){return db(this.ad,a)?this.ad[a]:b};
e.set=function(a,b){db(this.ad,a)||(this.size+=1,this.rb.push(a),this.gi++);this.ad[a]=b};e.addAll=function(a){if(a instanceof $a)for(var b=ab(a),c=0;c<b.length;c++)this.set(b[c],a.get(b[c]));else for(b in a)this.set(b,a[b])};e.forEach=function(a,b){for(var c=ab(this),d=0;d<c.length;d++){var f=c[d],g=this.get(f);a.call(b,g,f,this)}};e.clone=function(){return new $a(this)};e.keys=function(){return Ra(this.Tb(!0)).Wj()};e.values=function(){return Ra(this.Tb(!1)).Wj()};
e.entries=function(){const a=this;return Za(this.keys(),function(b){return[b,a.get(b)]})};e.Tb=function(a){bb(this);var b=0,c=this.gi,d=this,f=new Ea;f.next=function(){if(c!=d.gi)throw Error("The map has changed since the iterator was created");if(b>=d.rb.length)return Fa;var g=d.rb[b++];return Ga(a?g:d.ad[g])};return f};function db(a,b){return Object.prototype.hasOwnProperty.call(a,b)};var eb=String.prototype.trim?function(a){return a.trim()}:function(a){return/^[\s\xa0]*([\s\S]*?)[\s\xa0]*$/.exec(a)[1]};
function fb(a,b){let c=0;a=eb(String(a)).split(".");b=eb(String(b)).split(".");const d=Math.max(a.length,b.length);for(let h=0;0==c&&h<d;h++){var f=a[h]||"",g=b[h]||"";do{f=/(\d*)(\D*)(.*)/.exec(f)||["","","",""];g=/(\d*)(\D*)(.*)/.exec(g)||["","","",""];if(0==f[0].length&&0==g[0].length)break;c=gb(0==f[1].length?0:parseInt(f[1],10),0==g[1].length?0:parseInt(g[1],10))||gb(0==f[2].length,0==g[2].length)||gb(f[2],g[2]);f=f[3];g=g[3]}while(0==c)}return c}function gb(a,b){return a<b?-1:a>b?1:0};function hb(){var a=p.navigator;return a&&(a=a.userAgent)?a:""}function u(a){return-1!=hb().indexOf(a)};function ib(){return u("Firefox")||u("FxiOS")}function jb(){return(u("Chrome")||u("CriOS"))&&!u("Edge")||u("Silk")};function kb(){return u("iPhone")&&!u("iPod")&&!u("iPad")}function lb(){return kb()||u("iPad")||u("iPod")};function mb(a){mb[" "](a);return a}mb[" "]=function(){};var nb=u("Opera"),v=u("Trident")||u("MSIE"),ob=u("Edge"),pb=ob||v,qb=u("Gecko")&&!(-1!=hb().toLowerCase().indexOf("webkit")&&!u("Edge"))&&!(u("Trident")||u("MSIE"))&&!u("Edge"),rb=-1!=hb().toLowerCase().indexOf("webkit")&&!u("Edge"),sb=u("Macintosh"),tb=u("Windows"),ub=u("Linux")||u("CrOS"),vb=u("Android"),wb=kb(),xb=u("iPad"),yb=u("iPod"),zb=lb();function Ab(){var a=p.document;return a?a.documentMode:void 0}var Bb;
a:{var Cb="",Db=function(){var a=hb();if(qb)return/rv:([^\);]+)(\)|;)/.exec(a);if(ob)return/Edge\/([\d\.]+)/.exec(a);if(v)return/\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(a);if(rb)return/WebKit\/(\S+)/.exec(a);if(nb)return/(?:Version)[ \/]?(\S+)/.exec(a)}();Db&&(Cb=Db?Db[1]:"");if(v){var Eb=Ab();if(null!=Eb&&Eb>parseFloat(Cb)){Bb=String(Eb);break a}}Bb=Cb}var Fb;if(p.document&&v){var Gb=Ab();Fb=Gb?Gb:parseInt(Bb,10)||void 0}else Fb=void 0;var Hb=Fb;function Ib(a,b){this.mp=a;this.ub=null;if(v&&!(9<=Number(Hb))){Jb||(Jb=new $a);this.ub=Jb.get(a);this.ub||(b?this.ub=document.getElementById(b):(this.ub=document.createElement("userdata"),this.ub.addBehavior("#default#userData"),document.body.appendChild(this.ub)),Jb.set(a,this.ub));try{this.ub.load(this.mp)}catch(c){this.ub=null}}}r(Ib,Va);var Kb={".":".2E","!":".21","~":".7E","*":".2A","'":".27","(":".28",")":".29","%":"."},Jb=null;
function Lb(a){return"_"+encodeURIComponent(a).replace(/[.!~*'()%]/g,function(b){return Kb[b]})}e=Ib.prototype;e.im=function(){return!!this.ub};e.set=function(a,b){this.ub.setAttribute(Lb(a),b);Mb(this)};e.get=function(a){a=this.ub.getAttribute(Lb(a));if("string"!==typeof a&&null!==a)throw"Storage mechanism: Invalid value was encountered";return a};e.remove=function(a){this.ub.removeAttribute(Lb(a));Mb(this)};
e.Tb=function(a){var b=0,c=this.ub.XMLDocument.documentElement.attributes,d=new Ea;d.next=function(){if(b>=c.length)return Fa;var f=c[b++];if(a)return Ga(decodeURIComponent(f.nodeName.replace(/\./g,"%")).slice(1));f=f.nodeValue;if("string"!==typeof f)throw"Storage mechanism: Invalid value was encountered";return Ga(f)};return d};e.clear=function(){for(var a=this.ub.XMLDocument.documentElement,b=a.attributes.length;0<b;b--)a.removeAttribute(a.attributes[b-1].nodeName);Mb(this)};
function Mb(a){try{a.ub.save(a.mp)}catch(b){throw"Storage mechanism: Quota exceeded";}};function Nb(a,b){this.Oh=a;this.eg=b+"::"}r(Nb,Va);Nb.prototype.set=function(a,b){this.Oh.set(this.eg+a,b)};Nb.prototype.get=function(a){return this.Oh.get(this.eg+a)};Nb.prototype.remove=function(a){this.Oh.remove(this.eg+a)};Nb.prototype.Tb=function(a){const b=this.Oh[Symbol.iterator](),c=this,d=new Ea;d.next=function(){var f=b.next();if(f.done)return f;for(f=f.value;f.slice(0,c.eg.length)!=c.eg;){f=b.next();if(f.done)return f;f=f.value}return Ga(a?f.slice(c.eg.length):c.Oh.get(f))};return d};function Ob(){}r(Ob,Qa);Ob.prototype.set=function(){};Ob.prototype.get=function(){return null};Ob.prototype.remove=function(){};function Pb(a,b){const c=Qb();try{c.set(a,b)}catch(d){}}function Rb(a){Qb().remove(a)}var Sb=null;function Qb(){if(!Sb){var a=new Xa;(a=a.im()?new Nb(a,"ispring"):null)||(a=new Ib("ispring"),a=a.im()?a:null);Sb=new Pa(a||new Ob)}return Sb};function Tb(a,b){this.fk=Ub+b+"/"+a}var Ub="book/";Tb.prototype.getState=function(){return Vb(this.fk)};function Wb(a){let b=null,c=null,d=!0;const f=Math.floor(Date.now()/1E3),g=Qb();g instanceof Va&&(Ia(g.Tb(!0),h=>{const l=Vb(h);l&&(l.updated+t.Zr<f&&(Rb(h),d=!1),d&&(null==b||l.updated<b)&&(b=l.updated,c=h))},a),d&&Rb(c))}function Vb(a){a=Qb().get(a);a=void 0!==a?a:null;return null==a?null:JSON.parse(a)};function Xb(a,b,c){this.po=a;this.Xm=b;this.fa=c}function Yb(a){return a.Xm-a.po+1}Xb.prototype.inRange=function(a){return this.po<=a&&a<=this.Xm};Xb.prototype.size=function(){return this.fa};Xb.prototype.getViewport=function(){const a=[0,0,this.fa.width(),this.fa.height()];return new PDFJS.PageViewport(a,1,0,0,0,!1)};function w(a,b){this.Fc=Math.floor(a);this.yc=Math.floor(b)}w.prototype.width=function(){return this.Fc};w.prototype.height=function(){return this.yc};w.prototype.isEqual=function(a){return this.Fc==a.width()&&this.yc==a.height()};function Zb(a){this.Kb=[];this.Ui(a);this.Uk=this.Vk=-1}function $b(a,b){let c=null;for(let d=0;d<a.Kb.length;++d)a.Kb[d].inRange(b)&&(c=a.Kb[d].getViewport());return c}function ac(a){if(-1==a.Vk){if(1==a.Kb.length)var b=0;else{b=Yb(a.Kb[0]);var c=0;for(let d=1;d<a.Kb.length;++d)Yb(a.Kb[d])>b&&(b=Yb(a.Kb[d]),c=d);b=c}a.Vk=b}return a.Kb[a.Vk].getViewport()}Zb.prototype.Ui=function(a){for(let b=0;b<a.length;++b){const c=a[b];this.Kb.push(new Xb(c.range[0],c.range[1],new w(c.size[0],c.size[1])))}};function bc(){0!=cc&&(dc[ca(this)]=this);this.vj=this.vj;this.bg=this.bg}var cc=0,dc={};bc.prototype.vj=!1;bc.prototype.Yf=function(){if(!this.vj&&(this.vj=!0,this.dc(),0!=cc)){var a=ca(this);if(0!=cc&&this.bg&&0<this.bg.length)throw Error(this+" did not empty its onDisposeCallbacks queue. This probably means it overrode dispose() or disposeInternal() without calling the superclass' method.");delete dc[a]}};bc.prototype.dc=function(){if(this.bg)for(;this.bg.length;)this.bg.shift()()};function ec(){this.id="mousewheel"}ec.prototype.toString=function(){return this.id};function fc(a,b){this.type=a instanceof ec?String(a):a;this.currentTarget=this.target=b;this.defaultPrevented=this.Rh=!1}fc.prototype.stopPropagation=function(){this.Rh=!0};fc.prototype.preventDefault=function(){this.defaultPrevented=!0};var gc=function(){if(!p.addEventListener||!Object.defineProperty)return!1;var a=!1,b=Object.defineProperty({},"passive",{get:function(){a=!0}});try{p.addEventListener("test",()=>{},b),p.removeEventListener("test",()=>{},b)}catch(c){}return a}();function hc(a,b){fc.call(this,a?a.type:"");this.relatedTarget=this.currentTarget=this.target=null;this.button=this.screenY=this.screenX=this.clientY=this.clientX=this.offsetY=this.offsetX=0;this.key="";this.charCode=this.keyCode=0;this.metaKey=this.shiftKey=this.altKey=this.ctrlKey=!1;this.state=null;this.pointerId=0;this.pointerType="";this.Qa=null;if(a){var c=this.type=a.type,d=a.changedTouches&&a.changedTouches.length?a.changedTouches[0]:null;this.target=a.target||a.srcElement;this.currentTarget=
b;if(b=a.relatedTarget){if(qb){a:{try{mb(b.nodeName);var f=!0;break a}catch(g){}f=!1}f||(b=null)}}else"mouseover"==c?b=a.fromElement:"mouseout"==c&&(b=a.toElement);this.relatedTarget=b;d?(this.clientX=void 0!==d.clientX?d.clientX:d.pageX,this.clientY=void 0!==d.clientY?d.clientY:d.pageY,this.screenX=d.screenX||0,this.screenY=d.screenY||0):(this.offsetX=rb||void 0!==a.offsetX?a.offsetX:a.layerX,this.offsetY=rb||void 0!==a.offsetY?a.offsetY:a.layerY,this.clientX=void 0!==a.clientX?a.clientX:a.pageX,
this.clientY=void 0!==a.clientY?a.clientY:a.pageY,this.screenX=a.screenX||0,this.screenY=a.screenY||0);this.button=a.button;this.keyCode=a.keyCode||0;this.key=a.key||"";this.charCode=a.charCode||("keypress"==c?a.keyCode:0);this.ctrlKey=a.ctrlKey;this.altKey=a.altKey;this.shiftKey=a.shiftKey;this.metaKey=a.metaKey;this.pointerId=a.pointerId||0;this.pointerType="string"===typeof a.pointerType?a.pointerType:ic[a.pointerType]||"";this.state=a.state;this.Qa=a;a.defaultPrevented&&hc.W.preventDefault.call(this)}}
r(hc,fc);var ic={2:"touch",3:"pen",4:"mouse"};hc.prototype.stopPropagation=function(){hc.W.stopPropagation.call(this);this.Qa.stopPropagation?this.Qa.stopPropagation():this.Qa.cancelBubble=!0};hc.prototype.preventDefault=function(){hc.W.preventDefault.call(this);var a=this.Qa;a.preventDefault?a.preventDefault():a.returnValue=!1};var jc="closure_listenable_"+(1E6*Math.random()|0);function kc(a){return!(!a||!a[jc])};var lc=0;function mc(a,b,c,d,f){this.listener=a;this.proxy=null;this.src=b;this.type=c;this.capture=!!d;this.zj=f;this.key=++lc;this.Sh=this.uj=!1}function nc(a){a.Sh=!0;a.listener=null;a.proxy=null;a.src=null;a.zj=null};function oc(a,b){for(const c in a)b.call(void 0,a[c],c,a)}function pc(a,b){const c={};for(const d in a)b.call(void 0,a[d],d,a)&&(c[d]=a[d]);return c}function qc(a){const b=[];let c=0;for(const d in a)b[c++]=a[d];return b}function rc(a,b){for(const c in a)if(b.call(void 0,a[c],c,a))return c}function sc(){var a=tc;for(const b in a)return!1;return!0}function uc(a,b){for(const c in a)if(!(c in b)||a[c]!==b[c])return!1;for(const c in b)if(!(c in a))return!1;return!0}
function vc(){const a={};for(const b in t)a[b]=t[b];return a}const wc="constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" ");function xc(a,b){let c,d;for(let f=1;f<arguments.length;f++){d=arguments[f];for(c in d)a[c]=d[c];for(let g=0;g<wc.length;g++)c=wc[g],Object.prototype.hasOwnProperty.call(d,c)&&(a[c]=d[c])}};function yc(a){this.src=a;this.Sb={};this.fi=0}yc.prototype.add=function(a,b,c,d,f){var g=a.toString();a=this.Sb[g];a||(a=this.Sb[g]=[],this.fi++);var h=zc(a,b,d,f);-1<h?(b=a[h],c||(b.uj=!1)):(b=new mc(b,this.src,g,!!d,f),b.uj=c,a.push(b));return b};yc.prototype.remove=function(a,b,c,d){a=a.toString();if(!(a in this.Sb))return!1;var f=this.Sb[a];b=zc(f,b,c,d);return-1<b?(nc(f[b]),Array.prototype.splice.call(f,b,1),0==f.length&&(delete this.Sb[a],this.fi--),!0):!1};
function Ac(a,b){var c=b.type;if(!(c in a.Sb))return!1;var d=wa(a.Sb[c],b);d&&(nc(b),0==a.Sb[c].length&&(delete a.Sb[c],a.fi--));return d}yc.prototype.Ih=function(a,b,c,d){a=this.Sb[a.toString()];var f=-1;a&&(f=zc(a,b,c,d));return-1<f?a[f]:null};function zc(a,b,c,d){for(var f=0;f<a.length;++f){var g=a[f];if(!g.Sh&&g.listener==b&&g.capture==!!c&&g.zj==d)return f}return-1};var Bc="closure_lm_"+(1E6*Math.random()|0),Cc={},Dc=0;function x(a,b,c,d,f){if(d&&d.once)return Ec(a,b,c,d,f);if(Array.isArray(b)){for(var g=0;g<b.length;g++)x(a,b[g],c,d,f);return null}c=Fc(c);return kc(a)?a.Dd.add(String(b),c,!1,ba(d)?!!d.capture:!!d,f):Gc(a,b,c,!1,d,f)}
function Gc(a,b,c,d,f,g){if(!b)throw Error("Invalid event type");var h=ba(f)?!!f.capture:!!f,l=Hc(a);l||(a[Bc]=l=new yc(a));c=l.add(b,c,d,h,g);if(c.proxy)return c;d=Ic();c.proxy=d;d.src=a;d.listener=c;if(a.addEventListener)gc||(f=h),void 0===f&&(f=!1),a.addEventListener(b.toString(),d,f);else if(a.attachEvent)a.attachEvent(Jc(b.toString()),d);else if(a.addListener&&a.removeListener)a.addListener(d);else throw Error("addEventListener and attachEvent are unavailable.");Dc++;return c}
function Ic(){function a(c){return b.call(a.src,a.listener,c)}const b=Kc;return a}function Ec(a,b,c,d,f){if(Array.isArray(b)){for(var g=0;g<b.length;g++)Ec(a,b[g],c,d,f);return null}c=Fc(c);return kc(a)?a.Dd.add(String(b),c,!0,ba(d)?!!d.capture:!!d,f):Gc(a,b,c,!0,d,f)}function y(a,b,c,d,f){if(Array.isArray(b))for(var g=0;g<b.length;g++)y(a,b[g],c,d,f);else d=ba(d)?!!d.capture:!!d,c=Fc(c),kc(a)?a.Dd.remove(String(b),c,d,f):a&&(a=Hc(a))&&(b=a.Ih(b,c,d,f))&&Lc(b)}
function Lc(a){if("number"===typeof a||!a||a.Sh)return!1;var b=a.src;if(kc(b))return Ac(b.Dd,a);var c=a.type,d=a.proxy;b.removeEventListener?b.removeEventListener(c,d,a.capture):b.detachEvent?b.detachEvent(Jc(c),d):b.addListener&&b.removeListener&&b.removeListener(d);Dc--;(c=Hc(b))?(Ac(c,a),0==c.fi&&(c.src=null,b[Bc]=null)):nc(a);return!0}function Jc(a){return a in Cc?Cc[a]:Cc[a]="on"+a}
function Kc(a,b){if(a.Sh)a=!0;else{b=new hc(b,this);var c=a.listener,d=a.zj||a.src;a.uj&&Lc(a);a=c.call(d,b)}return a}function Hc(a){a=a[Bc];return a instanceof yc?a:null}var Mc="__closure_events_fn_"+(1E9*Math.random()>>>0);function Fc(a){if("function"===typeof a)return a;a[Mc]||(a[Mc]=function(b){return a.handleEvent(b)});return a[Mc]};function Nc(){bc.call(this);this.Dd=new yc(this);this.Ar=this;this.mm=null}r(Nc,bc);Nc.prototype[jc]=!0;e=Nc.prototype;e.addEventListener=function(a,b,c,d){x(this,a,b,c,d)};e.removeEventListener=function(a,b,c,d){y(this,a,b,c,d)};
e.dispatchEvent=function(a){var b,c=this.mm;if(c)for(b=[];c;c=c.mm)b.push(c);c=this.Ar;var d=a.type||a;if("string"===typeof a)a=new fc(a,c);else if(a instanceof fc)a.target=a.target||c;else{var f=a;a=new fc(d,c);xc(a,f)}f=!0;if(b)for(var g=b.length-1;!a.Rh&&0<=g;g--){var h=a.currentTarget=b[g];f=Oc(h,d,!0,a)&&f}a.Rh||(h=a.currentTarget=c,f=Oc(h,d,!0,a)&&f,a.Rh||(f=Oc(h,d,!1,a)&&f));if(b)for(g=0;!a.Rh&&g<b.length;g++)h=a.currentTarget=b[g],f=Oc(h,d,!1,a)&&f;return f};
e.dc=function(){Nc.W.dc.call(this);if(this.Dd){var a=this.Dd,b=0,c;for(c in a.Sb){for(var d=a.Sb[c],f=0;f<d.length;f++)++b,nc(d[f]);delete a.Sb[c];a.fi--}}this.mm=null};function Oc(a,b,c,d){b=a.Dd.Sb[String(b)];if(!b)return!0;b=b.concat();for(var f=!0,g=0;g<b.length;++g){var h=b[g];if(h&&!h.Sh&&h.capture==c){var l=h.listener,m=h.zj||h.src;h.uj&&Ac(a.Dd,h);f=!1!==l.call(m,d)&&f}}return f&&!d.defaultPrevented}e.Ih=function(a,b,c,d){return this.Dd.Ih(String(a),b,c,d)};let Pc=0;function Qc(a,b){if(a.kc&&a.kc[b]){var {Vl:c,$f:d,context:f,priority:g}=a.kc[b];c.removeHandler(d,f,g);delete a.kc[b]}else ra("unknown handler key")}function Rc(a){return void 0!==a.displayObject?a.displayObject():a}function z(a,b,c,d,f=null,g=!1){a.ib=a.ib||[];if(Array.isArray(c)){const h=[];for(const l of c)c=x(Rc(b),l,d,g,f),h.push(c);a.ib.push(h)}else b=x(Rc(b),c,d,g,f),a.ib.push(b)}
function Sc(a,b,c,d,f){if(Array.isArray(c)){let g=!1;for(const h of c)g=Sc(a,b,h,d,f)||g;return g}b=Rc(b);d=Fc(d);c=kc(b)?b.Ih(c,d,!1,f):b?(b=Hc(b))?b.Ih(c,d,!1,f):null:null;return!!c&&Tc(a,c)}function Tc(a,b){if(Array.isArray(b)){let c=!1;for(const d of b)c=Tc(a,d)||c;return c}wa(a.ib,b);return Lc(b)}function A(a,b,c,d){a.kc=a.kc||{};b.addHandler(c,d,void 0);const f=++Pc;a.kc[f]={Vl:b,$f:c,context:d,priority:void 0};return f}
function Uc(a,b,c,d){const f=rc(a.kc,g=>uc(g,{Vl:b,$f:c,context:d,priority:void 0}));f&&Qc(a,f)}function Vc(a,b,c,d){const f=(...g)=>{c.apply(d,g);Uc(a,b,f,d)};A(a,b,f,d)}function Wc(a,b){if(b){if(a.kc){var c=pc(a.kc,d=>d.Vl.Mn==b);for(const d of Object.keys(c))Qc(a,d)}if(a.ib){const d=Rc(b);c=ua(a.ib,f=>f.src==d);for(const f of c)Tc(a,f)}}}function B(a,b){a.Nd=a.Nd||[];a.Nd.push(b);return b}function Xc(a,...b){if(a.Nd)for(const c of b)c&&(a.vg(c),b=sa(a.Nd,c),0<=b&&(a.Nd.splice(b,1),Yc(c)))}
class Zc{constructor(){this.Nd=this.kc=this.ib=null}Yf(){this.Md();if(this.Nd)for(const a of this.Nd)Yc(a);if(this.ib){for(const a of this.ib)if(Array.isArray(a))for(const b of a)Lc(b);else Lc(a);this.ib=null}if(this.kc)for(const a of Object.keys(this.kc))Qc(this,a)}vg(a){Wc(this,a)}Md(){}};function $c(a,b){return 0==b?a.Tf:a.Qe[b]}function ad(a,b){return 0==b?a.Tf||[]:b in a.Qe?$c(a,b):[]}function cd(a){if(!a.Qe)return a.Tf?a.Tf.slice():[];const b=[],c=a.$i;for(let d=0;d<c.length;++d){const f=$c(a,c[d]);f&&ya(b,f)}return b}
class dd{constructor(){this.Tf=this.Qe=this.$i=null}push(a,b){if(0==b)this.Tf=this.Tf||[];else if(this.$i=this.$i||[0],this.Qe=this.Qe||{},!(b in this.Qe)){this.Qe[b]=[];var c=this.$i;var d=0;let g=c.length,h;for(;d<g;){const l=d+(g-d>>>1);var f=void 0;f=c[l];f=b>f?1:b<f?-1:0;0<f?d=l+1:(g=l,h=!f)}d=h?d:-d-1;0>d&&za(c,-(d+1),0,b)}$c(this,b).push(a)}remove(a,b){(b=$c(this,b))&&wa(b,a)}};function ed(a){return a.La?cd(a.La).length:0}
class D extends Zc{constructor(a=null){super();this.Vd=this.La=null;this.Mn=a}Ir(){return this.Mn}addHandler(a,b,c){this.La=this.La||new dd;this.La.push({$f:a,context:b},c||0)}removeHandler(a,b,c){c=c||0;if(this.La){var d=ad(this.La,c),f=d.length;for(let g=0;g<f;++g){const h=d[g];if(h.$f==a&&h.context==b){(a=$c(this.La,c))&&Array.prototype.splice.call(a,g,1);break}}}else ra("EventDispatcher has no handlers!")}Or(a,b,c){if(!this.La)return!1;c=ad(this.La,c||0);const d=c.length;for(let f=0;f<d;++f){const g=
c[f];if(g.$f==a&&g.context==b)return!0}return!1}i(...a){if(this.La){const b=cd(this.La),c=b.length;for(let d=0;d<c;++d){const f=b[d];if(-1!=sa(cd(this.La),f))try{f.$f.apply(f.context,arguments)}catch(g){fd(g,!0)}}}this.Vd&&this.Vd.forEach(b=>{b.i(...a)})}Md(){super.Md()}}D.prototype.dispatch=D.prototype.i;D.prototype.hasHandler=D.prototype.Or;D.prototype.removeHandler=D.prototype.removeHandler;D.prototype.addHandler=D.prototype.addHandler;D.prototype.eventOwner=D.prototype.Ir;function gd(a,b,c){this.Ee=a;this.Sc=b;this.Ff=null;this.Ne=c}e=gd.prototype;e.getViewport=function(a){return this.Ee.getViewport(a)};e.getTextContent=function(a){return this.Ee.getTextContent(a)};e.render=function(a,b){this.Ff=a=this.Ee.render(a);a.promise.then(()=>{this.Ff=null;b&&b(null)},c=>{console.warn("render",c);b&&b(c)})};e.renderTextLayer=function(a,b){this.Ne?this.Ne.renderTextLayer(this.Ee,a,b):b()};
function hd(a,b,c){const d=b.viewport.clone({dontFlip:!0});a.Ee.getAnnotations({intent:"display"}).then(f=>{if(0<f.length){for(let g=0;g<f.length;++g)2==f[g].annotationType&&(f[g].newWindow=!0);PDFJS.AnnotationLayer.render({viewport:d,div:b.container,annotations:f,page:a.Ee,linkService:a.Sc})}c()})}e.cleanup=function(){this.Ee.cleanup()};function E(a,b){this.x=void 0!==a?a:0;this.y=void 0!==b?b:0}e=E.prototype;e.clone=function(){return new E(this.x,this.y)};function id(a,b){var c=a.x-b.x;a=a.y-b.y;return c*c+a*a}function jd(a,b){return new E(a.x-b.x,a.y-b.y)}e.ceil=function(){this.x=Math.ceil(this.x);this.y=Math.ceil(this.y);return this};e.floor=function(){this.x=Math.floor(this.x);this.y=Math.floor(this.y);return this};e.round=function(){this.x=Math.round(this.x);this.y=Math.round(this.y);return this};
e.translate=function(a,b){a instanceof E?(this.x+=a.x,this.y+=a.y):(this.x+=Number(a),"number"===typeof b&&(this.y+=b));return this};e.scale=function(a,b){this.x*=a;this.y*="number"===typeof b?b:a;return this};function kd(a,b,c,d){this.top=a;this.right=b;this.bottom=c;this.left=d}e=kd.prototype;e.clone=function(){return new kd(this.top,this.right,this.bottom,this.left)};e.contains=function(a){return this&&a?a instanceof kd?a.left>=this.left&&a.right<=this.right&&a.top>=this.top&&a.bottom<=this.bottom:a.x>=this.left&&a.x<=this.right&&a.y>=this.top&&a.y<=this.bottom:!1};
e.expand=function(a,b,c,d){ba(a)?(this.top-=a.top,this.right+=a.right,this.bottom+=a.bottom,this.left-=a.left):(this.top-=a,this.right+=Number(b),this.bottom+=Number(c),this.left-=Number(d));return this};e.ceil=function(){this.top=Math.ceil(this.top);this.right=Math.ceil(this.right);this.bottom=Math.ceil(this.bottom);this.left=Math.ceil(this.left);return this};
e.floor=function(){this.top=Math.floor(this.top);this.right=Math.floor(this.right);this.bottom=Math.floor(this.bottom);this.left=Math.floor(this.left);return this};e.round=function(){this.top=Math.round(this.top);this.right=Math.round(this.right);this.bottom=Math.round(this.bottom);this.left=Math.round(this.left);return this};
e.translate=function(a,b){a instanceof E?(this.left+=a.x,this.right+=a.x,this.top+=a.y,this.bottom+=a.y):(this.left+=a,this.right+=a,"number"===typeof b&&(this.top+=b,this.bottom+=b));return this};e.scale=function(a,b){b="number"===typeof b?b:a;this.left*=a;this.right*=a;this.top*=b;this.bottom*=b;return this};const ld=/\S/;function md(a,b){return new E(a[0]*b[0]+a[1]*b[2]+b[4],a[0]*b[1]+a[1]*b[3]+b[5])}
function nd(a,b,c){let d=null;a.forEach(f=>{if(ld.test(f.str)){var g=c.transform,h=f.transform;var l=[g[0]*h[0]+g[2]*h[1],g[1]*h[0]+g[3]*h[1],g[0]*h[2]+g[2]*h[3],g[1]*h[2]+g[3]*h[3],g[0]*h[4]+g[2]*h[5]+g[4],g[1]*h[4]+g[3]*h[5]+g[5]];h=Math.atan2(l[1],l[0]);var m=b[f.fontName];m.vertical&&(h+=Math.PI/2);var k=Math.sqrt(l[2]*l[2]+l[3]*l[3]),n=k;m.ascent?n*=m.ascent:m.descent&&(n*=1+m.descent);0===h?(g=l[4],l=l[5]-n):(g=l[4]+n*Math.sin(h),l=l[5]-n*Math.cos(h));n=1;var q=0;0!==h&&(n=Math.cos(h),q=Math.sin(h));
f=(m.vertical?f.height:f.width)*c.scale;0!==h?(f=[0,0,f,k],m=[n,q,-q,n,g,l],g=md(f,m),h=md(f.slice(2,4),m),k=md([f[0],f[3]],m),f=md([f[2],f[1]],m),f=new kd(Math.min(g.y,h.y,k.y,f.y),Math.max(g.x,h.x,k.x,f.x),Math.max(g.y,h.y,k.y,f.y),Math.min(g.x,h.x,k.x,f.x))):f=new kd(l,g+f,l+k,g);f=new od(f.left,f.top,f.right-f.left,f.bottom-f.top)}else f=null;f&&(d&&(d&&f?(g=new od(d.left,d.top,d.width,d.height),h=Math.max(g.left+g.width,f.left+f.width),k=Math.max(g.top+g.height,f.top+f.height),g.left=Math.min(g.left,
f.left),g.top=Math.min(g.top,f.top),g.width=h-g.left,g.height=k-g.top,f=g):f=null),d=f)});return d};function G(a,b){this.width=a;this.height=b}e=G.prototype;e.clone=function(){return new G(this.width,this.height)};e.aspectRatio=function(){return this.width/this.height};e.ceil=function(){this.width=Math.ceil(this.width);this.height=Math.ceil(this.height);return this};e.floor=function(){this.width=Math.floor(this.width);this.height=Math.floor(this.height);return this};e.round=function(){this.width=Math.round(this.width);this.height=Math.round(this.height);return this};
e.scale=function(a,b){this.width*=a;this.height*="number"===typeof b?b:a;return this};function od(a,b,c,d){this.left=a;this.top=b;this.width=c;this.height=d}e=od.prototype;e.clone=function(){return new od(this.left,this.top,this.width,this.height)};e.contains=function(a){return a instanceof E?a.x>=this.left&&a.x<=this.left+this.width&&a.y>=this.top&&a.y<=this.top+this.height:this.left<=a.left&&this.left+this.width>=a.left+a.width&&this.top<=a.top&&this.top+this.height>=a.top+a.height};
e.ceil=function(){this.left=Math.ceil(this.left);this.top=Math.ceil(this.top);this.width=Math.ceil(this.width);this.height=Math.ceil(this.height);return this};e.floor=function(){this.left=Math.floor(this.left);this.top=Math.floor(this.top);this.width=Math.floor(this.width);this.height=Math.floor(this.height);return this};e.round=function(){this.left=Math.round(this.left);this.top=Math.round(this.top);this.width=Math.round(this.width);this.height=Math.round(this.height);return this};
e.translate=function(a,b){a instanceof E?(this.left+=a.x,this.top+=a.y):(this.left+=a,"number"===typeof b&&(this.top+=b));return this};e.scale=function(a,b){b="number"===typeof b?b:a;this.left*=a;this.width*=a;this.top*=b;this.height*=b;return this};function pd(a){return String(a).replace(/\-([a-z])/g,function(b,c){return c.toUpperCase()})}function qd(a){return a.replace(RegExp("(^|[\\s]+)([a-z])","g"),function(b,c,d){return c+d.toUpperCase()})};function rd(a){return a?new sd(td(a)):oa||(oa=new sd)}function ud(a,b){oc(b,function(c,d){c&&"object"==typeof c&&c.Ns&&(c=c.Ms());"style"==d?a.style.cssText=c:"class"==d?a.className=c:"for"==d?a.htmlFor=c:vd.hasOwnProperty(d)?a.setAttribute(vd[d],c):0==d.lastIndexOf("aria-",0)||0==d.lastIndexOf("data-",0)?a.setAttribute(d,c):a[d]=c})}
var vd={cellpadding:"cellPadding",cellspacing:"cellSpacing",colspan:"colSpan",frameborder:"frameBorder",height:"height",maxlength:"maxLength",nonce:"nonce",role:"role",rowspan:"rowSpan",type:"type",usemap:"useMap",valign:"vAlign",width:"width"};function wd(a,b,c){var d=arguments,f=document,g=d[1],h=xd(f,String(d[0]));g&&("string"===typeof g?h.className=g:Array.isArray(g)?h.className=g.join(" "):ud(h,g));2<d.length&&yd(f,h,d,2);return h}
function yd(a,b,c,d){function f(l){l&&b.appendChild("string"===typeof l?a.createTextNode(l):l)}for(;d<c.length;d++){var g=c[d];if(!aa(g)||ba(g)&&0<g.nodeType)f(g);else{a:{if(g&&"number"==typeof g.length){if(ba(g)){var h="function"==typeof g.item||"string"==typeof g.item;break a}if("function"===typeof g){h="function"==typeof g.item;break a}}h=!1}ta(h?xa(g):g,f)}}}function xd(a,b){b=String(b);"application/xhtml+xml"===a.contentType&&(b=b.toLowerCase());return a.createElement(b)}
function zd(a,b){a.appendChild(b)}function Ad(a,b){yd(td(a),a,arguments,1)}function Bd(a){return a&&a.parentNode?a.parentNode.removeChild(a):null}function Cd(a,b){if(!a||!b)return!1;if(a.contains&&1==b.nodeType)return a==b||a.contains(b);if("undefined"!=typeof a.compareDocumentPosition)return a==b||!!(a.compareDocumentPosition(b)&16);for(;b&&a!=b;)b=b.parentNode;return b==a}function td(a){return 9==a.nodeType?a:a.ownerDocument||a.document}
function Dd(a,b){if("textContent"in a)a.textContent=b;else if(3==a.nodeType)a.data=String(b);else if(a.firstChild&&3==a.firstChild.nodeType){for(;a.lastChild!=a.firstChild;)a.removeChild(a.lastChild);a.firstChild.data=String(b)}else{for(var c;c=a.firstChild;)a.removeChild(c);a.appendChild(td(a).createTextNode(String(b)))}}var Ed={SCRIPT:1,STYLE:1,HEAD:1,IFRAME:1,OBJECT:1},Fd={IMG:" ",BR:"\n"};
function Gd(a,b,c){if(!(a.nodeName in Ed))if(3==a.nodeType)c?b.push(String(a.nodeValue).replace(/(\r\n|\r|\n)/g,"")):b.push(a.nodeValue);else if(a.nodeName in Fd)b.push(Fd[a.nodeName]);else for(a=a.firstChild;a;)Gd(a,b,c),a=a.nextSibling}function Hd(){var a=document;try{var b=a&&a.activeElement;return b&&b.nodeName?b:null}catch(c){return null}}function sd(a){this.Zf=a||p.document||document}e=sd.prototype;e.eb=function(a){this.Zf=a};e.getDocument=function(){return this.Zf};
e.getElementsByTagName=function(a,b){return(b||this.Zf).getElementsByTagName(String(a))};e.createElement=function(a){return xd(this.Zf,a)};e.createTextNode=function(a){return this.Zf.createTextNode(String(a))};e.appendChild=zd;e.append=Ad;e.canHaveChildren=function(a){if(1!=a.nodeType)return!1;switch(a.tagName){case "APPLET":case "AREA":case "BASE":case "BR":case "COL":case "COMMAND":case "EMBED":case "FRAME":case "HR":case "IMG":case "INPUT":case "IFRAME":case "ISINDEX":case "KEYGEN":case "LINK":case "NOFRAMES":case "NOSCRIPT":case "META":case "OBJECT":case "PARAM":case "SCRIPT":case "SOURCE":case "STYLE":case "TRACK":case "WBR":return!1}return!0};
e.removeNode=Bd;e.contains=Cd;e.V=Dd;e.getTextContent=function(a){var b=[];Gd(a,b,!0);a=b.join("");a=a.replace(/ \xAD /g," ").replace(/\xAD/g,"");a=a.replace(/\u200B/g,"");a=a.replace(/ +/g," ");" "!=a&&(a=a.replace(/^\s*/,""));return a};function Id(a,b,c){if("string"===typeof b)(b=Jd(a,b))&&(a.style[b]=c);else for(var d in b){c=a;var f=b[d],g=Jd(c,d);g&&(c.style[g]=f)}}var Kd={};function Jd(a,b){var c=Kd[b];if(!c){var d=pd(b);c=d;void 0===a.style[d]&&(d=(rb?"Webkit":qb?"Moz":v?"ms":null)+qd(d),void 0!==a.style[d]&&(c=d));Kd[b]=c}return c}function Ld(a,b){var c=td(a);return c.defaultView&&c.defaultView.getComputedStyle&&(a=c.defaultView.getComputedStyle(a,null))?a[b]||a.getPropertyValue(b)||"":""}
function Md(a){return Ld(a,"direction")||(a.currentStyle?a.currentStyle.direction:null)||a.style&&a.style.direction}function Nd(a){return new E(a.offsetLeft,a.offsetTop)}function Od(a){if(1==a.nodeType){try{var b=a.getBoundingClientRect()}catch(c){b={left:0,top:0,right:0,bottom:0}}return new E(b.left,b.top)}a=a.changedTouches?a.changedTouches[0]:a;return new E(a.clientX,a.clientY)}function Pd(a){"number"==typeof a&&(a=Math.round(a)+"px");return a}
function Qd(a){return new G(a.offsetWidth,a.offsetHeight)}function Rd(a,b,c,d){if(/^\d+px?$/.test(b))return parseInt(b,10);var f=a.style[c],g=a.runtimeStyle[c];a.runtimeStyle[c]=a.currentStyle[c];a.style[c]=b;b=a.style[d];a.style[c]=f;a.runtimeStyle[c]=g;return+b}function Sd(a,b){return(b=a.currentStyle?a.currentStyle[b]:null)?Rd(a,b,"left","pixelLeft"):0}var Td={thin:2,medium:4,thick:6};
function Ud(a,b){if("none"==(a.currentStyle?a.currentStyle[b+"Style"]:null))return 0;b=a.currentStyle?a.currentStyle[b+"Width"]:null;return b in Td?Td[b]:Rd(a,b,"left","pixelLeft")};function I(a,b){const c=new D(a);B(a,c);if(b)if(Array.isArray(b))for(const d of b)a=d,b=c,a.Vd||(a.Vd=[]),a.Vd.push(b);else b.Vd||(b.Vd=[]),b.Vd.push(c);return c}class K extends Zc{};class Vd extends D{constructor(a){super(a);this.Kg=B(this,new D);this.Dk=B(this,new D)}addHandler(a,b,c){super.addHandler(a,b,c);this.Kg.i()}removeHandler(a,b,c){super.removeHandler(a,b,c);this.Dk.i()}};var Wd=ib(),Xd=kb()||u("iPod"),Yd=u("iPad"),Zd=u("Android")&&!(jb()||ib()||u("Opera")||u("Silk")),$d=jb(),ae=u("Safari")&&!(jb()||u("Coast")||u("Opera")||u("Edge")||u("Edg/")||u("OPR")||ib()||u("Silk")||u("Android"))&&!lb();var be={},ce=null,de=qb||rb||"function"==typeof p.btoa;function ee(a){var b=[];fe(a,function(c){b.push(c)});return b}function fe(a,b){function c(m){for(;d<a.length;){var k=a.charAt(d++),n=ce[k];if(null!=n)return n;if(!/^[\s\xa0]*$/.test(k))throw Error("Unknown base64 encoding at char: "+k);}return m}ge();for(var d=0;;){var f=c(-1),g=c(0),h=c(64),l=c(64);if(64===l&&-1===f)break;b(f<<2|g>>4);64!=h&&(b(g<<4&240|h>>2),64!=l&&b(h<<6&192|l))}}
function ge(){if(!ce){ce={};for(var a="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".split(""),b=["+/=","+/","-_=","-_.","-_"],c=0;5>c;c++){var d=a.concat(b[c].split(""));be[c]=d;for(var f=0;f<d.length;f++){var g=d[f];void 0===ce[g]&&(ce[g]=f)}}}};function he(a,b){Nc.call(this);this.ag=a||1;this.di=b||p;this.No=ia(this.qs,this);this.To=Date.now()}r(he,Nc);e=he.prototype;e.enabled=!1;e.Nc=null;e.setInterval=function(a){this.ag=a;this.Nc&&this.enabled?(this.stop(),this.start()):this.Nc&&this.stop()};e.qs=function(){if(this.enabled){var a=Date.now()-this.To;0<a&&a<.8*this.ag?this.Nc=this.di.setTimeout(this.No,this.ag-a):(this.Nc&&(this.di.clearTimeout(this.Nc),this.Nc=null),this.dispatchEvent("tick"),this.enabled&&(this.stop(),this.start()))}};
e.start=function(){this.enabled=!0;this.Nc||(this.Nc=this.di.setTimeout(this.No,this.ag),this.To=Date.now())};e.stop=function(){this.enabled=!1;this.Nc&&(this.di.clearTimeout(this.Nc),this.Nc=null)};e.dc=function(){he.W.dc.call(this);this.stop();delete this.di};function ie(a,b){if("function"!==typeof a)if(a&&"function"==typeof a.handleEvent)a=ia(a.handleEvent,a);else throw Error("Invalid listener argument");return 2147483647<Number(b)?-1:p.setTimeout(a,b||0)};function je(a,b){this.pr=a;this.yp=b||[]}ja("iSpring.ios.mobile.MobileAppCommand",je);je.prototype.id=function(){return ca(this)};function ke(a){try{const b=xd(document,"iframe");Id(b,{width:"1px",height:"1px",border:"0"});b.src=a;document.body.appendChild(b);ie(()=>{Bd(b)},100)}catch(b){}};function le(a){this.length=a.length||a;for(let b=0;b<this.length;b++)this[b]=a[b]||0}le.prototype.BYTES_PER_ELEMENT=4;le.prototype.set=function(a,b){b=b||0;for(let c=0;c<a.length&&b+c<this.length;c++)this[b+c]=a[c]};le.prototype.toString=Array.prototype.join;"undefined"==typeof Float32Array&&(le.BYTES_PER_ELEMENT=4,le.prototype.BYTES_PER_ELEMENT=le.prototype.BYTES_PER_ELEMENT,le.prototype.set=le.prototype.set,le.prototype.toString=le.prototype.toString,ja("Float32Array",le));function me(a){this.length=a.length||a;for(let b=0;b<this.length;b++)this[b]=a[b]||0}me.prototype.BYTES_PER_ELEMENT=8;me.prototype.set=function(a,b){b=b||0;for(let c=0;c<a.length&&b+c<this.length;c++)this[b+c]=a[c]};me.prototype.toString=Array.prototype.join;if("undefined"==typeof Float64Array){try{me.BYTES_PER_ELEMENT=8}catch(a){}me.prototype.BYTES_PER_ELEMENT=me.prototype.BYTES_PER_ELEMENT;me.prototype.set=me.prototype.set;me.prototype.toString=me.prototype.toString;ja("Float64Array",me)};new Float64Array(3);new Float64Array(3);new Float64Array(4);new Float64Array(4);new Float64Array(4);new Float64Array(16);function ne(a,b){a:{var c=["transformOrigin","webkitTransformOrigin","msTransformOrigin","MozTransformOrigin","OTransformOrigin"];for(let d=0;d<c.length;++d)if(void 0!==a.style[c[d]]){c=c[d];break a}throw Error("browser doesn't support css style "+c[0]);}Id(a,c,b)};let oe;function pe(a){a instanceof hc&&(a=a.Qa);oe||(oe=new WeakMap);return oe.has(a)}function qe(a){a instanceof hc&&(a=a.Qa);return a.defaultPrevented?!0:pe(a)};function re(){if(se)return new G(document.documentElement.clientWidth,document.documentElement.clientHeight);if(L&&v)return new G(screen.width,screen.height);var a=void 0!==window.devicePixelRatio?window.devicePixelRatio:1;return te?new G(screen.width/a,screen.height/a):L?ue&&(a=Math.max(screen.width,screen.height),document.documentElement.clientWidth>a)?new G(Math.max(document.documentElement.clientWidth,a),Math.max(document.documentElement.clientHeight,Math.min(screen.width,screen.height))):new G(screen.width,
screen.height):new G(screen.width*a,screen.height*a)}function ve(a){var b=window.location.search.substr(1);if(!b)return{};const c={};b=b.split("&");for(let g=0;g<b.length;++g){const h=b[g].split("=");if(2==h.length){try{var d=decodeURIComponent(h[0].replace(/\+/g," "))}catch(l){d=h[0]}try{var f=decodeURIComponent(h[1].replace(/\+/g," "))}catch(l){f=h[1]}a||(d=d.toLowerCase());c[d]=f}}return c}
function we(a){if(!a)return!1;for(;a;){if("A"==a.nodeName.toLocaleUpperCase())return!0;a=a.parentNode}return!1}function xe(a){return a&&"VIDEO"==a.nodeName&&a.controls};(function(){function a(b){try{return b.ISPlayer&&(window.ISPlayer=b.ISPlayer),b.ISPVideoPlayer&&(window.ISPVideoPlayer=b.ISPVideoPlayer),b.ISPQuizPlayer&&(window.ISPQuizPlayer=b.ISPQuizPlayer),b.ISPInteractionPlayerCore&&(window.ISPInteractionPlayerCore=b.ISPInteractionPlayerCore),b.ISPBookPlayer&&(window.ISPBookPlayer=b.ISPBookPlayer),b.ISPScenarioPlayer&&(window.ISPScenarioPlayer=b.ISPScenarioPlayer),b.ISPFlipPlayer&&(window.ISPFlipPlayer=b.ISPFlipPlayer),!0}catch(c){return!1}}if(function(){let b;
try{b=window.frameElement}catch(c){}return null!=b}()){let b=window,c=7;for(;b&&b.parent!=b&&0!=c--&&!a(b.parent);)b=b.parent}})();var ye;const ze=ve().user_agent;ye=ze?ze:hb()||"";var ue=Yd||Xd,se="1"==ve().small_screen,Ae="1"==ve().tablet_screen,Be;let Ce;try{Ce=window.top.location.href?window.frameElement:null}catch(a){}var De=(Be=null!=Ce)&&window.frameElement&&window.frameElement.parentNode&&"FRAMESET"==window.frameElement.parentNode.tagName?!0:!1,Ee=Xd&&Be;
function Fe(){const a=ye.toLowerCase();return-1!=a.indexOf("android")||-1!=a.indexOf("mobile")||-1!=a.indexOf("wpdesktop")||se||Ae}var Ge=-1!=ye.toLowerCase().indexOf("chrome"),He=-1==ye.toLowerCase().indexOf("windows phone")&&-1!=ye.toLowerCase().indexOf("android"),L=Fe(),Ie=L&&(Fe()?"ontouchstart"in window||void 0!==window.DocumentTouch&&document instanceof window.DocumentTouch||-1!=ye.toLowerCase().indexOf("touch"):!1);let Je="";
if(ue){const a=/CPU.+OS\s(\d+)_(\d+)/.exec(ye);Je=a?a[1]+"."+a[2]:""}var Ke=parseInt(Je,10),Le=ue&&12<=Ke,Me=v&&"9."==Bb.substr(0,2),Oe=Ne&&v,te=He&&!Ge&&!Wd&&!nb,Pe=-1!=ye.toLowerCase().indexOf("micromessenger"),Qe=-1!=ye.indexOf("ismobile"),Re;if(Re=!window._ispringFullsizeSkin){var Se;if(!(Se=se))if(window._ispringFullsizeSkin)Se=!1;else{var Te=re();Se=(Xd||700>Math.min(Te.width,Te.height))&&!Ae}Re=Se}var Ne=Re,Ue=void 0!==window.ISPlayer,la=Ue&&Ne;
const Ve=document.createElement("audio"),We=Ve.play&&Ve.play();We&&We.then(()=>{Ve.pause()},()=>{});ve();ve();function Xe(){return 1==window._ispringDebug||"1"==ve().isdebug}
if(u("Windows")){const a=hb();let b;if(u("Windows"))b=/Windows (?:NT|Phone) ([0-9.]+)/,b.exec(a);else if(lb()){b=/(?:iPhone|iPod|iPad|CPU)\s+OS\s+(\S+)/;const c=b.exec(a);c&&c[1].replace(/_/g,".")}else if(u("Macintosh")){b=/Mac OS X ([0-9_.]+)/;const c=b.exec(a);c&&c[1].replace(/_/g,".")}else-1!=hb().toLowerCase().indexOf("kaios")?(b=/(?:KaiOS)\/(\S+)/i,b.exec(a)):u("Android")?(b=/Android\s+([^\);]+)(\)|;)/,b.exec(a)):u("CrOS")&&(b=/(?:CrOS\s+(?:i686|x86_64)\s+([0-9.]+))/,b.exec(a))}
setTimeout(function(){Ye=Xe},0);var Ze=["touchstart","mousedown"],$e=["touchend","mouseup"],af=["touchmove","mousemove"];function bf(a,b,c,d,f){this.Sp=a;this.Bp=b;this.Cp=c;this.Sq=d;this.Tq=f}e=bf.prototype;e.id=function(){return this.Sp};e.clientX=function(){return this.Bp};e.clientY=function(){return this.Cp};e.screenX=function(){return this.Sq};e.screenY=function(){return this.Tq};function cf(a,b){this.Od=a;this.jr=b}function df(a){const b=[];for(let c=0;c<a.length;++c){const d=a[c];b.push(new bf(d.pointerId,d.clientX,d.clientY,d.screenX,d.screenY))}return new cf(a[0],b)}cf.prototype.touches=function(){return this.jr};cf.prototype.scale=function(){return this.Od.scale};cf.prototype.rotation=function(){return this.Od.rotation};var ef={passive:!1},ff={passive:!0};function gf(a){this.Ld=a;this.ld={};this.we={}}e=gf.prototype;e.uh=!1;e.Fi=-1;function hf(a){const b=a.Ld;window.navigator.msPointerEnabled?(x(b,"MSPointerDown",a.Bn,!1,a),x(b,"MSPointerUp",a.Dn,!1,a),x(b,"MSPointerMove",a.Cn,!1,a)):(x(b,Ze,a.Ln,ef,a),x(b,$e,a.Jn,!1,a),x(b,af,a.Kn,ef,a))}function jf(a){const b=a.Ld;window.navigator.msPointerEnabled?(y(b,"MSPointerDown",a.Bn,!1,a),y(b,"MSPointerUp",a.Dn,!1,a),y(b,"MSPointerMove",a.Cn,!1,a)):(y(b,Ze,a.Ln,ef,a),y(b,$e,a.Jn,!1,a),y(b,af,a.Kn,ef,a))}
e.Ln=function(a){const b=a.Qa;if(!this.uh||b.touches&&1==b.touches.length)this.uh=!0,a=kf(a),lf(this,"touchStart",a)};e.Jn=function(a){if(this.uh){this.uh=!1;var b=kf(a);if(lf(this,"touchEnd",b)){if(b=a.target)if("TEXTAREA"==b.nodeName)b=!0;else{var c=b.getAttribute("type");b="INPUT"==b.nodeName&&(!c||"text"==c||"number"==c)}else b=!1;b||we(a.target)||xe(a.target)||a.preventDefault()}}};e.Kn=function(a){!xe(a.target)&&this.uh&&(a=kf(a),lf(this,"touchMove",a))};
function kf(a){a=a.Qa;if(void 0!==window.TouchEvent&&a instanceof TouchEvent){var b=[];for(let c=0;c<a.touches.length;++c){const d=a.touches[c];b.push(new bf(d.identifier,d.clientX,d.clientY,d.screenX,d.screenY))}a=new cf(a,b)}else b=[],b.push(new bf(0,a.clientX,a.clientY,a.screenX,a.screenY)),a=new cf(a,b);return a}e.Bn=function(a){var b=a.Qa;this.ld[b.pointerId]=b;mf(this,a);b=qc(this.ld);a=1==b.length?"touchStart":"touchMove";b=df(b);lf(this,a,b)};
e.Dn=function(a){const b=a.Qa;if(b.pointerId in this.ld){delete this.ld[b.pointerId];mf(this,a);var c=qc(this.ld);a=0<c.length?"touchMove":"touchEnd";0==c.length&&(c=[b]);c=df(c);lf(this,a,c)&&b.preventDefault()}};e.Cn=function(a){const b=a.Qa;b.pointerId in this.ld&&(this.ld[b.pointerId]=b,mf(this,a),a=qc(this.ld),a=df(a),lf(this,"touchMove",a))};function mf(a,b){"touch"==b.pointerType&&(0<a.Fi&&clearTimeout(a.Fi),a.Fi=setTimeout(a.Tp.bind(a),200))}
e.Tp=function(){this.ld={};this.Fi=-1;for(const a in this.we)this.we.hasOwnProperty(a)&&this.we[a].he()};function lf(a,b,c){let d=0,f=null;for(const g in a.we)if(a.we.hasOwnProperty(g)){const h=a.we[g],l=h.yj(b,c);l>d&&(d=l,f=h)}return f?(c.Od.defaultPrevented?f.he():f.sj(c),!0):!1}function nf(a,b){a.we[b.Hh()]=b};function of(){this.lj=new D;this.Vm=new D;this.tl=new D;this.sl=new D}e=of.prototype;e.cc=null;e.oj=!1;e.Hh=function(){return"tap"};e.yj=function(a,b){if("touchEnd"==a)return this.oj?1:0;const c=new E(b.touches()[0].clientX(),b.touches()[0].clientY());if("touchStart"==a&&1==b.touches().length)return this.cc=c,this.oj=!0,this.tl.i(),Oe||x(window,"scroll",this.he,!1,this),0;if(!this.cc)return 0;50>=id(c,this.cc)||this.oj&&this.he();return 0};
e.sj=function(a){this.lj.i(this.cc.x,this.cc.y,a.Od);let b=!1;const c=Date.now();this.Rk&&1E3>c-this.Rk&&50>=id(this.aq,this.cc)&&(b=!0,this.Vm.i(this.cc.x,this.cc.y,a.Od));this.Rk=b?null:c;this.aq=this.cc};e.he=function(){y(window,"scroll",this.he,!1,this);this.oj=!1;this.sl.i()};function pf(a){return"string"==typeof a.className?a.className:a.getAttribute&&a.getAttribute("class")||""}function qf(a){return a.classList?a.classList:pf(a).match(/\S+/g)||[]}function rf(a,b){"string"==typeof a.className?a.className=b:a.setAttribute&&a.setAttribute("class",b)}function sf(a,b){a.classList?b=a.classList.contains(b):(a=qf(a),b=0<=sa(a,b));return b}function M(a,b){if(a.classList)a.classList.add(b);else if(!sf(a,b)){var c=pf(a);rf(a,c+(0<c.length?" "+b:b))}}
function N(a,b){a.classList?a.classList.remove(b):sf(a,b)&&rf(a,Array.prototype.filter.call(qf(a),function(c){return c!=b}).join(" "))};function tf(a,b,c,d,f,g){if(6==arguments.length)this.setTransform(a,b,c,d,f,g);else{if(0!=arguments.length)throw Error("Insufficient matrix parameters");this.ec=this.ic=1;this.hc=this.fc=this.rc=this.sc=0}}e=tf.prototype;e.isIdentity=function(){return 1==this.ec&&0==this.hc&&0==this.fc&&1==this.ic&&0==this.rc&&0==this.sc};e.clone=function(){return new tf(this.ec,this.hc,this.fc,this.ic,this.rc,this.sc)};
e.setTransform=function(a,b,c,d,f,g){if("number"!==typeof a||"number"!==typeof b||"number"!==typeof c||"number"!==typeof d||"number"!==typeof f||"number"!==typeof g)throw Error("Invalid transform parameters");this.ec=a;this.hc=b;this.fc=c;this.ic=d;this.rc=f;this.sc=g;return this};e.scale=function(a,b){this.ec*=a;this.hc*=a;this.fc*=b;this.ic*=b;return this};e.translate=function(a,b){this.rc+=a*this.ec+b*this.fc;this.sc+=a*this.hc+b*this.ic;return this};
e.rotate=function(a,b,c){var d=new tf;const f=Math.cos(a);a=Math.sin(a);b=d.setTransform(f,a,-a,f,b-b*f+c*a,c-b*a-c*f);c=this.ec;d=this.fc;this.ec=b.ec*c+b.hc*d;this.fc=b.fc*c+b.ic*d;this.rc+=b.rc*c+b.sc*d;c=this.hc;d=this.ic;this.hc=b.ec*c+b.hc*d;this.ic=b.fc*c+b.ic*d;this.sc+=b.rc*c+b.sc*d;return this};e.toString=function(){return"matrix("+[this.ec,this.hc,this.fc,this.ic,this.rc,this.sc].join()+")"};
e.transform=function(a,b,c,d,f){let g=b;for(b+=2*f;g<b;){f=a[g++];const h=a[g++];c[d++]=f*this.ec+h*this.fc+this.rc;c[d++]=f*this.hc+h*this.ic+this.sc}};function O(a,b,c){c=c||b;b=(new tf).setTransform(b,0,0,c,0,0);if(uf)c=uf;else{c=null;var d=wd("DIV"),f=[["transform",vf,{transform:"transform",transformOrigin:"transformOrigin"}],["webkitTransform",vf,{transform:"webkitTransform",transformOrigin:"webkitTransformOrigin"}],["msTransform",vf,{transform:"msTransform",transformOrigin:"msTransformOrigin"}],["MozTransform",wf,{transform:"MozTransform",transformOrigin:"MozTransformOrigin"}],["OTransform",vf,{transform:"OTransform",transformOrigin:"OTransformOrigin"}]];
for(let g=0;g<f.length;++g)if(void 0!==d.style[f[g][0]]){c=new f[g][1](f[g][2]);break}if(!c)throw Error("browser doesn't support css matrix transformation");uf=c}a.style[c.aj.transform]=b.isIdentity()?"":"matrix("+c.yl(b).join(",")+")"}function xf(a){return Math.floor(1E6*a)/1E6}var uf=null;function vf(a){this.aj=a}
vf.prototype.getTransform=function(a){a="none"!=Ld(a,"display")?Ld(a,this.aj.transform):a.style[this.aj.transform];if(0==a.lastIndexOf("matrix(",0))a:{const b=[];for(let c=0;6>c;++c){const d=a.match(/^.*?(-?\d+(?:\.\d+)?(e-?\d+)?)/);if(!d){a=null;break a}b[c]=parseFloat(d[1]);a=a.substr(d[0].length)}a=b}else a=null;return a?new tf(a[0],a[1],a[2],a[3],a[4],a[5]):null};vf.prototype.yl=function(a){return[xf(a.ec),xf(a.hc),xf(a.fc),xf(a.ic),xf(a.rc),xf(a.sc)]};function wf(a){this.aj=a}r(wf,vf);
wf.prototype.yl=function(a){a=wf.W.yl.call(this,a);a[4]+="px";a[5]+="px";return a};var yf=window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||setTimeout;function zf(a){return"string"!==typeof a.className}function Af(a,b){a.className.baseVal=b}function Bf(a){return zf(a)?(a=a.className.baseVal,"string"===typeof a&&a.match(/\S+/g)||[]):qf(a)}function Cf(a,b){zf(a)?(a=Bf(a),b=0<=sa(a,b)):b=sf(a,b);return b}function Df(a,b){if(zf(a)){if(!Cf(a,b)){let c=a.className.baseVal;c+=0<a.className.baseVal.length?` ${b}`:b;Af(a,c)}}else M(a,b)}function Ef(a,b){zf(a)?Cf(a,b)&&Af(a,ua(Bf(a),c=>c!=b).join(" ")):N(a,b)};function Ff(a,b){return`${a.className()}_${b}`}function Gf(a,b,c){return`${Ff(a,b)}_${c}`}function Hf(a,b,c){b=qf(b);const d=Gf(a,c,"");return va(b,f=>0==f.indexOf(d))}class If{constructor(a,b){this.ek=a;this.ue=b}className(){return this.ue?`${this.ek}__${this.ue}`:this.ek}};let Jf;function Kf(a,b){b?a.setAttribute("role",b):a.removeAttribute("role")}function Lf(a,b,c){Array.isArray(c)&&(c=c.join(" "));var d="aria-"+b;""===c||void 0==c?(Jf||(Jf={atomic:!1,autocomplete:"none",dropeffect:"none",haspopup:!1,live:"off",multiline:!1,multiselectable:!1,orientation:"vertical",readonly:!1,relevant:"additions text",required:!1,sort:"none",busy:!1,disabled:!1,hidden:!1,invalid:"false"}),c=Jf,b in c?a.setAttribute(d,c[b]):a.removeAttribute(d)):a.setAttribute(d,c)}
function Mf(a,b){a=a.getAttribute("aria-"+b);return null==a||void 0==a?"":String(a)};let Nf;const Of=[];if(window.MutationObserver){Nf=new MutationObserver(b=>{b&&b.forEach(c=>{for(const d of c.removedNodes)for(const f of Of)"function"===typeof d.contains&&d.contains(f.displayObject())&&f.Bc()})});const a={subtree:!0,childList:!0};yf(()=>{Nf.observe(document.body,a)})}function Pf(a,b){a.ti.push(b);Df(a.j,b.className())}
function Qf(a){const b=new ResizeObserver(c=>{for(const d of c)void 0!==d.target&&0<d.contentRect.width&&0<d.contentRect.height&&(a.ja(a.j.clientWidth,a.j.clientHeight),a.Ie.i(a))});b.observe(a.j);return b}
function Rf(a,b){const c=B(a,new gf(a.j));A(a,b.Kg,()=>{1==ed(b)&&hf(c);z(a,a.j,"mouseover",()=>{a.enabled()&&0<ed(a.H)&&a.pg()});z(a,a.j,"mouseout",()=>{a.Bc()})});A(a,b.Dk,()=>{0==ed(b)&&jf(c)});const d=new of;A(a,d.lj,(f,g,h)=>{a.Bc();a.enabled()&&a.kf(h);a.fh&&h.target==a.j&&h.preventDefault()});A(a,d.sl,()=>{a.Bc()});A(a,d.tl,()=>{a.enabled()&&a.pg()});nf(c,d)}
function Sf(a){Nf?Of.push(a):v?z(a,window,"DOMNodeRemoved",b=>{Cd(b.target,a.j)&&a.Bc()}):z(a,a.j,"DOMNodeRemovedFromDocument",()=>{a.Bc()})}function P(a,b){B(a,b);a.h(b)}function Tf(a,b){b instanceof If||(b=new If(b));Pf(a,b)}function R(a,b){return new If(a.ti[0].ek,b)}function Uf(a){a.ja(a.width(),a.height());a.Ie.i()}
class T extends K{constructor(a){let {M:b,X:c,Po:d,Mo:f,Uf:g,$o:h,Lo:l,Ks:m,me:k,cp:n,tabIndex:q,Br:C}=a||{};super();f||(f=wd(g||"DIV"));this.j=f;this.ti=[];if(b||c)b=b||new If(c,d),Pf(this,b);this.fh=void 0!==h?h:!0;this.Cf=this.yc=this.Fc=this.ge=this.fe=this.hf=void 0;this.Zg=1;this.vo={};this.pj=null;k&&(this.Je=Qf(this));(this.Wq=n)&&this.ai(!1);void 0!==q&&this.xm(q);this.H=B(this,new Vd(this));Rf(this,this.H);m&&A(this,this.H,()=>{});C&&Sf(this);this.Ie=I(this);if(!1===l){let F=!1;z(this,this.displayObject(),
"mousedown",()=>{F=!0});z(this,this.displayObject(),"focusout",H=>{H.target==H.currentTarget&&(F=!1)});z(this,this.displayObject(),"focusin",H=>{F&&H.target==H.currentTarget&&yf(()=>{this.displayObject().blur()})})}}focus(){(()=>{this.j.focus()})()}getAttribute(a){return this.j.getAttribute(a)}setAttribute(a,b){(()=>{this.j.setAttribute(a,b)})()}removeAttribute(a){(()=>{this.j.removeAttribute(a)})()}xm(a){this.hf=a;this.lh(a)}la(a){this.fe=a;(()=>{this.j.style.left=a+"px"})()}Lc(a){this.ge=a;(()=>
{this.j.style.top=a+"px"})()}move(a,b){this.la(a);this.Lc(b)}ca(a){this.resize(a)}ta(a){this.resize(void 0,a)}resize(a,b){this.kl(a,b);void 0!==a&&(this.Fc=a);void 0!==b&&(this.yc=b);this.ja(this.width(),this.height());this.Ie.i(this)}Ra(a){void 0!==this.hf&&this.lh(a?this.hf:-1);(()=>{a?this.j.removeAttribute("disabled"):this.j.setAttribute("disabled","")})()}ip(a){this.pj=a;(()=>{this.pj=null;this.j.style.display=a?"":"none"})()}fd(a){(()=>{this.xa("opacity",a)})();this.Cf=a}h(a){const b=this.Fb(a);
(()=>{this.j.appendChild(b)})()}qj(a,b){const c=this.Fb(a);this.j==c.parentNode&&this.j.childNodes[b]==c||(()=>{var d=this.j;d.insertBefore(c,d.childNodes[b]||null)})()}removeChild(a){const b=this.Fb(a);this.gm(b)&&(()=>{this.j.removeChild(b)})()}V(a){(()=>{Dd(this.j,a)})()}Xh(a){(()=>{this.j.innerHTML=a})()}xa(a,b){(()=>{Id(this.j,a,b)})()}hg(a){this.Fd("label",a)}tm(a){Array.isArray(a)&&(a=a.join(" "));(()=>{Kf(this.j,a)})()}Wh(a){this.Fd("hidden",a)}Fd(a,b){(()=>{Lf(this.j,a,b)})()}aa(a,b){if(this.ti.length)for(const c of this.ti)if("string"===
typeof b){const d=Hf(c,this.j,a);d&&(delete this.vo[a],(()=>{Ef(this.j,d)})());if(b){const f=Gf(c,a,b);this.vo[a]=f;(()=>{Df(this.j,f)})()}}else{const d=Ff(c,a);(()=>{var f=this.j,g=d;b?M(f,g):N(f,g)})()}else(()=>{var c=this.j;b?M(c,a):N(c,a)})(),ra("component has no bemInfo")}ai(a){this.Fd("selected",a)}selected(){return"true"==Mf(this.j,"selected")}gm(a){return this.Fb(a).parentNode==this.displayObject()}x(){return void 0!==this.fe?this.fe:Nd(this.displayObject()).x}y(){return void 0!==this.ge?
this.ge:Nd(this.displayObject()).y}width(){return void 0!==this.Fc?this.Fc:this.uk()}height(){return void 0!==this.yc?this.yc:this.tk()}enabled(){return!this.j.hasAttribute("disabled")}visible(){return"boolean"===typeof this.pj?this.pj:"none"!=this.displayObject().style.display}opacity(){if(void 0!==this.Cf)return this.Cf;var a=this.j.style;var b="";"opacity"in a?b=a.opacity:"MozOpacity"in a?b=a.MozOpacity:"filter"in a&&(a=a.filter.match(/alpha\(opacity=([\d.]+)\)/))&&(b=String(a[1]/100));b=""==b?
b:Number(b);return"number"===typeof b?b:1}displayObject(){return this.j}Rj(a){this.j.scrollTop=a}setScale(a,b="0 0"){(()=>{O(this.j,a,a);ne(this.j,b)})()}wm(a){this.Zg=a}contains(a){if(!a)return!1;a=this.Fb(a);return Cd(this.j,a)}vg(a){(a instanceof Node||"function"===typeof a.displayObject)&&this.removeChild(a);super.vg(a)}Fb(a){return a instanceof Node?a:a.displayObject()}uk(){const a=this.j;return a.tagName.toUpperCase()=="SVG".toString()?a.width.baseVal.value:Qd(a).width}tk(){const a=this.j;return a.tagName.toUpperCase()==
"SVG".toString()?a.height.baseVal.value:Qd(a).height}kl(a,b){(()=>{void 0!==a&&(this.j.style.width=Pd(a));void 0!==b&&(this.j.style.height=Pd(b))})()}ja(){}kf(a){this.H.i(this,a)}pg(){this.aa("active",!0)}Bc(){this.aa("active",!1)}Gm(){z(this,this.j,"keydown",this.$k,this)}$k(a){document.activeElement!=this.displayObject()||a.defaultPrevented||13!=a.keyCode&&32!=a.keyCode||(a.preventDefault(),this.kf())}lh(a){(()=>{this.setAttribute("tabindex",a+"")})()}Md(){this.Je&&this.Je.disconnect();const a=
Of.indexOf(this);0<=a&&Of.splice(a,1)}};function Vf(a){ba(a)&&1==a.nodeType?this.ya=this.j=a:(this.j=wd("DIV",Wf("component_container",a)),this.ya=wd("DIV",Wf("component_base",a)),this.j.appendChild(this.ya));this.ib=[];this.fh=!1;if(Ie){const b=new gf(this.displayObject());this.H=new Vd;this.H.Kg.addHandler(function(){1==ed(this.H)&&hf(b)},this);this.H.Dk.addHandler(function(){0==ed(this.H)&&jf(b)},this);a=new of;a.lj.addHandler(function(c,d,f){this.Bc();this.fh&&f.preventDefault();this.enabled()&&this.kf(f)},this);a.sl.addHandler(function(){this.Bc()},
this);a.tl.addHandler(function(){this.enabled()&&this.pg()},this);nf(b,a)}else this.fh=!0,this.H=new Vd,this.H.Kg.addHandler(function c(){this.H.Kg.removeHandler(c,this);var d=x(this.displayObject(),"mouseover",function(){this.enabled()&&0<ed(this.H)&&this.pg()},!1,this);this.ib.push(d);d=x(this.displayObject(),"mouseout",function(){this.Bc()},!1,this);this.ib.push(d);d=x(this.displayObject(),"click",function(f){this.Bc();this.fh&&0<ed(this.H)&&(f.preventDefault(),f.stopPropagation());this.kf(f)},
!1,this);this.ib.push(d)},this);this.Ie=new D}e=Vf.prototype;e.Cf=1;e.wp=!0;e.kf=function(a){!this.wp&&a&&(this.displayObject().blur(),this.ya.blur());this.H.i(this,a)};e.setAttribute=function(a,b){this.displayObject().setAttribute(a,b)};e.removeAttribute=function(a){this.displayObject().removeAttribute(a)};e.xm=function(a){this.hf=a;this.lh(a)};
e.me=function(){this.yc=this.Fc=void 0;this.Je=new ResizeObserver(a=>{for(const b of a)void 0!==b.target&&(a=b.contentRect,this.Fc=a.width,this.yc=a.height,this.ja(a.width,a.height),this.Ie.i(this))});this.Je.observe(this.j);this.ja(parseInt(this.j.style.width,10),parseInt(this.j.style.height,10));this.Ie.i(this)};e.pg=function(){this.aa("active",!0)};e.Bc=function(){this.aa("active",!1)};e.Mo=function(){return this.ya};Vf.prototype.baseElement=Vf.prototype.Mo;Vf.prototype.displayObject=function(){return this.j};
Vf.prototype.displayObject=Vf.prototype.displayObject;e=Vf.prototype;e.width=function(){return void 0!==this.Fc?this.Fc:this.uk(this.ya)};e.uk=function(a){return"SVG"==a.tagName.toUpperCase()?a.width.baseVal.value:Qd(a).width};e.ca=function(a){this.resize(a)};e.height=function(){return void 0!==this.yc?this.yc:this.tk(this.ya)};e.tk=function(a){return"SVG"==a.tagName.toUpperCase()?a.height.baseVal.value:Qd(a).height};e.ta=function(a){this.resize(void 0,a)};
e.resize=function(a,b){if(void 0!==this.Je)throw Error("ResizeObserver is turned on");this.kl(a,b);void 0!==a&&(this.Fc=a);void 0!==b&&(this.yc=b);this.Ie.i(this)};e.kl=function(a,b){void 0!==a&&(this.displayObject().style.width=Pd(a),this.ya.style.width=Pd(a));void 0!==b&&(this.displayObject().style.height=Pd(b),this.ya.style.height=Pd(b));void 0!==a&&void 0!==b&&this.ja(a,b)};e.ja=function(){};e.x=function(){return void 0!==this.fe?this.fe:Nd(this.displayObject()).x};
e.la=function(a){this.fe=a;this.displayObject().style.left=a+"px"};e.y=function(){return void 0!==this.ge?this.ge:Nd(this.displayObject()).y};e.Lc=function(a){this.ge=a;this.displayObject().style.top=a+"px"};e.move=function(a,b){this.la(a);this.Lc(b)};e.enabled=function(){return!this.ya.hasAttribute("disabled")};e.Ra=function(a){void 0!==this.hf&&this.lh(a?this.hf:-1);a?this.ya.removeAttribute("disabled"):this.ya.setAttribute("disabled","")};e.visible=function(){return"none"!=this.displayObject().style.display};
e.ip=function(a){this.displayObject().style.display=a?"":"none"};e.opacity=function(){return this.Cf};e.fd=function(a){U(this,"opacity",a);this.Cf=a};e.h=function(a){a=this.Fb(a);this.displayObject().appendChild(a)};e.qj=function(a,b){a=this.Fb(a);var c=this.displayObject();c.insertBefore(a,c.childNodes[b]||null)};e.removeChild=function(a){a=this.Fb(a);this.gm(a)&&this.displayObject().removeChild(a)};e.gm=function(a){return(a instanceof Vf?a.displayObject():a).parentNode==this.displayObject()};
e.V=function(a){Dd(this.ya,a)};e.Xh=function(a){this.ya.innerHTML=a};function U(a,b,c){Id(a.displayObject(),b,c)}e.hg=function(a){this.Fd("label",a)};e.tm=function(a){Array.isArray(a)&&(a=a.join(" "));Kf(this.rr?this.ya:this.j,a)};e.Wh=function(a){this.Fd("hidden",a)};e.Fd=function(a,b){Lf(this.rr?this.ya:this.j,a,b)};function Wf(a,b){return void 0===b?a:b instanceof Array?(b=xa(b),b.push(a),b):[a,b]}
e.aa=function(a,b){a=this.zp?Ff(this.zp,a):a;var c=this.j;b?M(c,a):N(c,a);this.j!=this.ya&&(c=this.ya,b?M(c,a):N(c,a))};e.K=function(a){var b=this.displayObject();M(b,a)};e.U=function(a){var b=this.displayObject();N(b,a)};e.Gm=function(){x(this.displayObject(),"keydown",this.$k,!1,this)};e.$k=function(a){document.activeElement!=this.displayObject()||a.defaultPrevented||13!=a.keyCode&&32!=a.keyCode||(a.preventDefault(),this.kf(null))};e.lh=function(a){this.setAttribute("tabindex",a+"")};
e.Yf=function(){for(let a=0;a<this.ib.length;++a){const b=this.ib[a];b&&Lc(b)}this.Je&&this.Je.disconnect()};e.Fb=function(a){return a instanceof Vf||a instanceof T?a.displayObject():a};function V(a,b){Vf.call(this,wd(b||"DIV",a))}r(V,Vf);function Xf(a){var b=Math.floor((a.Ua.height-a.C.height)/2);0<b&&(a.xg.top=b,a.S.style.top=b+"px",a.cb&&U(a.cb,"top",b+"px"));b=Math.floor((a.Ua.width-a.C.width)/2);0<b&&(a.xg.left=b,Yf(a,a.Pi,b))}function Zf(a){const b=a.C.width/a.Gf.width;a.S.style.width=a.C.width+"px";a.S.style.height=a.C.height+"px";a.cb&&(Id(a.cb.ya,"transform","scale("+b+", "+b+") "),Id(a.cb.ya,"transformOrigin","0% 0%"))}
function $f(a){a=(window.devicePixelRatio||1)/(a.bt||a.Ps||a.Qs||a.Rs||a.Cs||1);return{np:a,op:a,js:1!==a}}function ag(a){if(Math.floor(a)===a)return[a,1];var b=1/a;if(8<b)return[1,8];if(Math.floor(b)===b)return[1,b];b=1<a?b:a;let c=0,d=1,f=1,g=1;for(;;){let h=c+f,l=d+g;if(8<l)break;b<=h/l?(f=h,g=l):(c=h,d=l)}return b-c/d<f/g-b?b===a?[c,d]:[d,c]:b===a?[f,g]:[g,f]}function bg(a,b){const c=a%b;return 0===c?a:Math.round(a-c+b)}
function cg(a){const b=new V("textLayer","P"),c={viewport:a.C,container:b.displayObject(),timeout:t.os};a.ha.renderTextLayer(c,()=>{const d=0<b.displayObject().childElementCount;d&&(a.cb=b,a.cb.xm(-1),a.h(a.cb));dg(a,a.Rd&&d)})}function Yf(a,b,c){b=0==b?"left":"right";a.S.style[b]=c+"px";a.cb&&U(a.cb,b,c+"px")}function eg(a,b){if(a.Pi!=b){var c=Math.floor((a.Ua.width-a.C.width)/2);if(0<c){const d=0==a.Pi?"left":"right";a.S.style[d]="";a.cb&&U(a.cb,d,"");Yf(a,b,c)}a.Pi=b}}
function fg(a,b){a:{var c=Math.max(a.left,b.left);var d=Math.min(a.left+a.width,b.left+b.width);if(c<=d){var f=Math.max(a.top,b.top);a=Math.min(a.top+a.height,b.top+b.height);if(f<=a){c=new od(c,f,d-c,a-f);break a}}c=null}return c?.9<c.width*c.height/(b.width*b.height):!1}function gg(a,b){const c=a.firstElementChild.cloneNode(!0);for(c.onclick=a.firstElementChild.onclick;b.childNodes.length;)c.appendChild(b.firstChild);b.appendChild(c)}
function hg(a,b){b=[...b.displayObject().children].filter(c=>"linkAnnotation"===c.className);a=[...a.cb.displayObject().children];for(const c of b){b=c.getBoundingClientRect();for(const d of a){const f=d.getBoundingClientRect();fg(b,f)&&gg(c,d)}}}function dg(a,b){const c=new V("annotationsLayer"),d={viewport:a.C,container:c.displayObject()};hd(a.ha,d,()=>{0<c.displayObject().childElementCount&&(a.h(c),b&&hg(a,c),b&&a.removeChild(c));a.Mk&&(a.Mk=!1,a.focus());a.$=3;a.ab.i()})}
class ig extends V{constructor(a,b,c,d=!1){super("page");this.za=a;this.Ua=b;this.Sf=this.Ua.scale/c;this.Rd=d;this.C=b;this.Gf=this.O=null;this.$=0;this.ha=this.S=null;this.xg={top:0,left:0};this.Pi=0;this.ab=new D;this.gf=new V("canvasWrapper","DIV");this.h(this.gf);this.cb=null;this.kn=0;this.Mk=!1;this.Sk=new V("loadingIcon","DIV");this.h(this.Sk);this.ca(this.Ua.width);this.ta(this.Ua.height)}pageNumber(){return this.za}Cd(){return this.Ua}bd(){return this.O}Jh(){return null!==this.ha}Zh(a){this.ha=
a;this.O=a.getViewport(1);a=this.Wa(this.Ua,this.O);this.C=this.O.clone({scale:a})}ca(a){super.ca(Math.floor(a))}ta(a){super.ta(Math.floor(a))}xa(a,b){U(this,a,b)}setScale(a){this.Ua=this.Ua.clone({scale:this.Sf*a});this.ca(this.Ua.width);this.ta(this.Ua.height);null!==this.O&&(a=this.Wa(this.Ua,this.O),this.C=this.O.clone({scale:a}));null!==this.S&&(Xf(this),Zf(this))}da(a,b){this.Sf=a.scale/b;this.Ua=a;this.ca(this.Ua.width);this.ta(this.Ua.height);this.O&&(a=this.Wa(this.Ua,this.O),this.C=this.O.clone({scale:a}),
null!==this.S&&(Xf(this),Zf(this)))}render(){if(0!==this.$)throw Error("Page renderingState is wrong");this.$=1;const a=Date.now();this.kn=a;let b=null!==this.S?this.S:null;const c=this.C,d=xd(document,"canvas"),f=d.getContext("2d"),{np:g,op:h,js:l}=$f(f);this.Gf=this.C;if(0<PDFJS.maxCanvasPixels){var m=(Math.floor(c.width)*g|0)*(Math.floor(c.height)*h|0);m>PDFJS.maxCanvasPixels&&(m=PDFJS.maxCanvasPixels/(g*h),this.Gf=c.clone({scale:Math.floor(Math.sqrt(1/(c.width/c.height)*m))/c.height*this.C.scale*
.9}))}m=ag(g);const k=ag(h);d.width=bg(this.Gf.width*g,m[0]);d.height=bg(this.Gf.height*h,k[0]);d.style.width=bg(c.width,m[1])+"px";d.style.height=bg(c.height,k[1])+"px";d.className="content";d.setAttribute("hidden","hidden");this.gf.h(d);this.S=d;Xf(this);this.ha.render({canvasContext:f,transform:l?[g,0,0,h,0,0]:null,viewport:this.Gf},n=>{null!==n?this.$=0:(this.S.removeAttribute("hidden"),null!==b&&(b.width=0,b.height=0,this.gf.removeChild(b),b=null),a==this.kn&&(this.Sk&&this.removeChild(this.Sk),
cg(this)))})}reset(){this.$=0;this.cb&&this.removeChild(this.cb)}destroy(){this.reset();if(this.ha){var a=this.ha;null!==a.Ff&&a.Ff.cancel();this.ha.cleanup()}this.S&&(this.S.width=0,this.S.height=0,this.gf.removeChild(this.S),this.S=null)}focus(){if(this.cb){var a=this.cb.displayObject().firstElementChild;a&&a.focus({preventScroll:!0})}else this.Mk=!0}Wa(a,b){return Math.min(a.height/b.height,a.width/b.width)}fm(){return this.ha.getTextContent({}).then(a=>nd(a.items,a.styles,this.C))}};class jg{constructor(a){this.Tk=a}ka(a,b,c){c=this.Tk.hasOwnProperty(a)?this.Tk[a]:c;if(void 0!==c){if(void 0!==b){a=this.Pp;for(let d in b)if(b.hasOwnProperty(d)){const f=b[d];a&&(d=a(d));c=c.replace(new RegExp(d,"g"),f)}}return c}ra("unknown message id: "+a);return a}messages(){return this.Tk}Pp(a){return"%"+a.toUpperCase()+"%"}}jg.prototype.getMessage=jg.prototype.ka;function kg(a,b,c){const d=new Image;d.src=a;this.Gb=d;this.qr=b;this.ba=c}
kg.prototype.render=function(a,b,c,d){b=d||{top:0,left:0};c=.31*a.width();d=c*this.Gb.height/this.Gb.width;var f=a.gf.displayObject();for(var g=0;g<f.childElementCount;++g){const h=f.childNodes[g];if("content"==h.className){const l=h.getContext("2d"),{np:m,op:k}=$f(l);l.drawImage(this.Gb,h.width-c*m,0,c*m,d*k)}}a:{f=a.displayObject();for(g=0;g<f.childElementCount;++g)if("ispring"==f.childNodes[g].className){f=f.childNodes[g];break a}f=null}f||(f=xd(document,"a"),f.className="ispring",f.href=this.qr,
f.target="_blank",Lf(f,"label",this.ba.ka("PB_ACCESSIBILITY_CREATED_WITH")),Kf(f,"banner"),a.h(f));f.style.width=c+"px";f.style.height=d+"px";b.top&&(f.style.top=b.top+"px");b.left&&(f.style.right=b.left+"px")};var lg=function(){function a(){throw Error("stream error");}function b(m){return"undefined"==typeof m}function c(m){var k=0,n=m[k++],q=m[k++];(-1==n||-1==q||8!=(n&15)||0!=((n<<8)+q)%31||q&32)&&a();this.Sl=m;this.Vf=k;this.Bh=this.Dh=this.Eh=0;this.Yl=!1;this.tj=null}var d=[],f=[],g=[],h,l;(function(){var m=[],k,n=2;for(k=0;8>k;++k)m.push(n),n+=1<<(k>>1);for(k=0;3>k;++k)d.push(k+16);for(k=0;7>=k;++k)d.push((8-k)%8),d.push(8+k);for(k=1;3>k;++k)f.push(k);for(k=0;28>k;++k){var q=k>>1<<16;n=k%8;q+=(m[n]<<
(k-n)/2)+1;f.push(q)}for(k=3;7>k;++k)g.push(k);n=7;for(k=0;24>k;++k)m=k>>2,q=(m<<16)+n,n+=1<<m,g.push(q);for(k=0;3>k;++k)g.push(258)})();c.prototype.Xl=function(m){var k=this.tj,n=k?k.length:0;if(m<n)return k;for(var q=1024;q<m;)q<<=1;m=Array(q);for(q=0;q<n;++q)m[q]=k[q];return this.tj=m};c.prototype.Mr=function(){for(;!this.Yl;)this.es();return this.tj.slice(0,this.Bh)};c.prototype.ie=function(m){for(var k=this.Eh,n=this.Dh,q=this.Sl,C=this.Vf,F;k<m;)b(F=q[C++])&&a(),n|=F<<k,k+=8;this.Dh=n>>m;this.Eh=
k-m;this.Vf=C;return n&(1<<m)-1};c.prototype.dm=function(m){var k=m[0],n=m[1];m=this.Eh;for(var q=this.Dh,C=this.Sl,F=this.Vf;m<n;){var H;b(H=C[F++])&&a();q|=H<<m;m+=8}n=k[q&(1<<n)-1];k=n>>16;n&=65535;(0==m||m<k||0==k)&&a();this.Dh=q>>k;this.Eh=m-k;this.Vf=F;return n};c.prototype.Gh=function(m){for(var k=m.length,n=0,q=0;q<k;++q)m[q]>n&&(n=m[q]);for(var C=1<<n,F=Array(C),H=1,J=0,Q=2;H<=n;++H,J<<=1,Q<<=1)for(var S=0;S<k;++S)if(m[S]==H){var cb=0,bd=J;for(q=0;q<H;++q)cb=cb<<1|bd&1,bd>>=1;for(q=cb;q<
C;q+=Q)F[q]=H<<16|S;++J}return[F,n]};c.prototype.es=function(){function m(cb,bd,jk,kk,lk){for(cb=cb.ie(jk)+kk;0<cb--;)bd[J++]=lk}var k=this.ie(3);k&1&&(this.Yl=!0);k>>=1;if(0==k){var n=this.Sl,q=this.Vf,C;b(C=n[q++])&&a();var F=C;b(C=n[q++])&&a();F|=C<<8;b(C=n[q++])&&a();k=C;b(C=n[q++])&&a();(k|C<<8)!=(~F&65535)&&a();this.Eh=this.Dh=0;C=this.Bh;k=this.Xl(C+F);this.Bh=F=C+F;for(var H=C;H<F;++H){if(b(C=n[q++])){this.Yl=!0;break}k[H]=C}this.Vf=q}else{if(1==k){if(!h){n=Array(288);for(var J=0;143>=J;++J)n[J]=
8;for(;255>=J;++J)n[J]=9;for(;279>=J;++J)n[J]=7;for(;287>=J;++J)n[J]=8;h=this.Gh(n);k=Array(31);for(J=0;32>J;++J)k[J]=5;l=this.Gh(k);l[0][15]=0;l[0][31]=0}q=h;C=l}else if(2==k){k=this.ie(5)+257;C=this.ie(5)+1;q=this.ie(4)+4;n=Array(d.length);for(J=0;J<q;)n[d[J++]]=this.ie(3);q=this.Gh(n);J=n=0;C=k+C;for(F=Array(C);J<C;)H=this.dm(q),16==H?m(this,F,2,3,n):17==H?m(this,F,3,3,n=0):18==H?m(this,F,7,11,n=0):F[J++]=n=H;q=this.Gh(F.slice(0,k));C=this.Gh(F.slice(k,C))}else a();F=(k=this.tj)?k.length:0;for(H=
this.Bh;;){var Q=this.dm(q);if(256>Q)H+1>=F&&(k=this.Xl(H+1),F=k.length),k[H++]=Q;else{if(256==Q){this.Bh=H;break}Q-=257;Q=g[Q];var S=Q>>16;0<S&&(S=this.ie(S));n=(Q&65535)+S;Q=this.dm(C);Q=f[Q];S=Q>>16;0<S&&(S=this.ie(S));Q=(Q&65535)+S;H+n>=F&&(k=this.Xl(H+n),F=k.length);for(S=0;S<n;++S,++H)k[H]=k[H-Q]}}}};return c}();function mg(a,b){a=ee(a);a=(new lg(a)).Mr();const c=[];let d=0,f,g,h,l=-1;const m=a.length;for(;d<m;)(f=a[d])?128>f?(c[++l]=String.fromCharCode(f),++d):191<f&&224>f?(g=a[d+1],c[++l]=String.fromCharCode((f&31)<<6|g&63),d+=2):(g=a[d+1],h=a[d+2],c[++l]=String.fromCharCode((f&15)<<12|(g&63)<<6|h&63),d+=3):++d;b(c.join(""))};function ng(a){this.yb="FlippingBook";this.jb=null;this.dn=!1;this.Zn="";this.ba=null;this.Zm="";this.en=this.Qn=!1;this.Pa=null;this.Rd=this.Ok=!1;"string"===typeof a?mg(a,b=>{b=JSON.parse(b);this.Ui(b)}):this.Ui(a)}e=ng.prototype;e.title=function(){return this.yb};e.salt=function(){return this.Zn};e.Hc=function(){return this.ba};e.fingerprint=function(){return this.Zm};e.ji=function(){return this.Pa};
e.Ui=function(a){this.yb=a.title;this.dn=a.hasLocalVersion;a.pageSizes&&(this.jb=new Zb(a.pageSizes));this.Zn=a.salt;this.ba=new jg(a.i18n);this.Zm=a.fingerprint;this.Qn=a.protectFromCopying;this.en=a.hasPassword;this.Ok=a.ispringPlayIntegration;this.Rd=a.enableAccessibilityMode;if(a=a.watermark)this.Pa=new kg(a.image,a.url,this.ba)};const og={1:"resume",2:"startover"};function pg(){this.il=Object.create(null);this.o=this.Y=null}pg.prototype.eb=function(a){this.Y=a};pg.prototype.Tj=function(a){this.o=a};pg.prototype.Nr=function(a){return a instanceof Array?"#page="+this.Ig(a[0]):""};pg.prototype.getDestinationHash=pg.prototype.Nr;pg.prototype.Wr=function(a){const b=function(c){c instanceof Array&&qg(this,c[0])}.bind(this);"string"===typeof a?this.Y.getDestination(a,b):b(a)};pg.prototype.navigateTo=pg.prototype.Wr;
pg.prototype.Ig=function(a){return a instanceof Object?this.il[rg(a)]:parseInt(a,10)+1};function rg(a){return a.num+" "+a.gen+" R"}function qg(a,b){let c=a.Ig(b);c?(c>a.Y.v()&&(c=a.Y.v()),a.o.B(c)):a.Y.getPageIndex(b,d=>{a.il[rg(b)]=d+1;qg(a,b)})};class sg{constructor(a,b,c){this.Pk=a;this.za=b;this.Hi=c}label(){return this.Pk}pageNumber(){return this.za}items(){return this.Hi}};function tg(){this.sh={}}
tg.prototype.renderTextLayer=function(a,b,c){const d=a.pageNumber;a.getTextContent({normalizeWhitespace:!0}).then(f=>{if(0==f.items.length)c();else{this.sh[d]&&this.sh[d].cancel();var g=document.createDocumentFragment();this.sh[d]=PDFJS.renderTextLayer({textContent:f,container:g,viewport:b.viewport,timeout:b.timeout});this.sh[d].promise.then(()=>{b.container.appendChild(g);[...b.container.childNodes].forEach(l=>{l.tabIndex=0});const h=document.createElement("div");h.className="endOfContent";b.container.appendChild(h);
ug(b.container);c();delete this.sh[d]},()=>{})}})};function ug(a){a.addEventListener("mousedown",b=>{const c=a.querySelector(".endOfContent");if(c){if(b.target!==a&&"none"!==window.getComputedStyle(c).getPropertyValue("-moz-user-select")){const d=a.getBoundingClientRect();c.style.top=(100*Math.max(0,(b.pageY-d.top)/d.height)).toFixed(2)+"%"}M(c,"active")}});a.addEventListener("mouseup",()=>{const b=a.querySelector(".endOfContent");b&&(b.style.top="",N(b,"active"))})};function vg(a,b){b.eb(a);a.Sc=b}function wg(a,b,c){b=b.map(d=>{const f=xg(a,d),g=c||!d.items?Promise.resolve(null):wg(a,d.items,!0);return Promise.all([f,g]).then(([h,l])=>new sg(d.title,h,l)).catch(()=>null)});return Promise.all(b).then(d=>d.filter(f=>!!f).sort((f,g)=>f.pageNumber()-g.pageNumber()))}function xg(a,b){b=b.dest;return Array.isArray(b)?yg(a,b):"string"===typeof b?a.De.getDestination(b).then(c=>yg(a,c)):Promise.reject()}
function yg(a,b){return b?a.De.getPageIndex(b[0]).then(c=>c+1):Promise.reject()}class zg{constructor(a){this.De=a;this.Ne=this.Sc=null}v(){return this.De.numPages}getPage(a,b){this.De.getPage(a).then(c=>{this.Sc.il[rg(c.ref)]=a;b(new gd(c,this.Sc,this.Ne),a)})}getPageIndex(a,b){this.De.getPageIndex(a).then(c=>{b(c)})}getDestination(a,b){this.De.getDestination(a).then(c=>{b(c)})}getOutline(){return this.De.getOutline().then(a=>a?wg(this,a,!1):null)}};function Ag(a,b,c){void 0!==b&&(a=Math.max(a,b));void 0!==c&&(a=Math.min(a,c));return a};function Bg(){this.nn=new D;this.eq=new D;this.Hp=new D;this.Yk=new D;this.yb=null}e=Bg.prototype;e.Ej=function(a,b){this.yb=a.split("/").pop();a=PDFJS.getDocument(a);a.onProgress=this.pn.bind(this);a.onPassword=function(c){b?c(b):this.Yk.i(c)}.bind(this);a.promise.then(this.mn.bind(this),this.on.bind(this))};
e.lm=function(a,b,c){this.yb=b;b=Object.create(null);b.data=a;a=PDFJS.getDocument(b);a.onProgress=this.pn.bind(this);a.onPassword=function(d){c?d(c):this.Yk.i(d)}.bind(this);a.promise.then(this.mn.bind(this),this.on.bind(this))};e.pn=function(a){this.eq.i(Ag(a.loaded/a.total,0,1))};e.mn=function(a){this.nn.i(new zg(a));a.getDownloadInfo().then(this.Ip.bind(this))};
e.on=function(a){const b=a&&a.message;let c="An error occurred while loading the PDF.";a instanceof PDFJS.ws?c="Invalid or corrupted PDF file.":a instanceof PDFJS.xs?c="Missing PDF file.":a instanceof PDFJS.zs&&(c="Unexpected server response.");console.log(c,{message:b});throw Error(c);};e.Ip=function(){this.Hp.i()};function Cg(a,b){x(b.displayObject(),"focus",a.Ep,!1,a);x(b.displayObject(),"blur",a.Dp,!1,a);a.yg.push(b)}class Dg{constructor(){this.yg=[];this.zg=0}Ep(a){a=a.Qa;const b=a.currentTarget;a:{var c=a.currentTarget;for(let d=0;d<this.yg.length;++d)if(this.yg[d].displayObject()==c){c=d;break a}c=0}this.zg=c;"BUTTON"==a.currentTarget.tagName&&M(b,"active")}Dp(a){a=a.Qa;const b=a.currentTarget;"BUTTON"==a.currentTarget.tagName&&N(b,"active")}};function Eg(a){V.call(this,"dialogContainerOverlay");this.rl=new Dg;this.hn=!1;this.ba=a;this.Of=new D;this.tf=new D;const b=new V("dialogCenter");this.wb=new V(["dialog","askPassword"]);let c=new V(["row","text"]);c.V(a.ka("ED_ASK_PASSWORD_DIALOG_LABEL"));this.wb.h(c);c=new V(["row","control"]);this.Ia=new V("passwordInput","INPUT");Cg(this.rl,this.Ia);this.Ia.displayObject().type="password";this.Ia.hg(a.ka("ED_ASK_PASSWORD_DIALOG_LABEL"));c.h(this.Ia);this.wb.h(c);this.od=new V(["row","error","hidden"]);
this.od.V(a.ka("ED_ASK_PASSWORD_DIALOG_INVALID_PASSWORD_LABEL"));this.wb.h(this.od);this.ik(this.wb);b.h(this.wb);this.h(b);x(window,"keydown",this.xe,!0,this)}r(Eg,V);e=Eg.prototype;e.Yf=function(){y(window,"keydown",this.xe,!0,this)};e.hp=function(a){this.hn=a};e.focus=function(){this.Ia.displayObject().focus()};
e.da=function(a){if(this.hn){var b=a.width()/t.Ab,c=a.height()/t.Uh;b=Math.min(b,c);1>b?(ne(this.wb.displayObject(),"center center"),O(this.wb.displayObject(),b),a.height()<this.wb.height()&&U(this.wb,"margin-top",(a.height()-this.wb.height())/2+"px"),a.width()<this.wb.width()&&U(this.wb,"margin-left",(a.width()-this.wb.width())/2+"px")):(ne(this.wb.displayObject(),""),O(this.wb.displayObject(),1))}};e.gp=function(){this.od.tm("");this.od.tm("alert");this.od.U("hidden")};
e.ik=function(a){const b=new V(["row","control"]),c=new V(["submit"],"BUTTON");Cg(this.rl,c);c.V(this.ba.ka("ED_OK"));c.H.addHandler(this.ql,this);b.h(c);a.h(b)};e.xe=function(a){a.stopPropagation();13==a.keyCode?(a=this.Ia.displayObject().value,0<a.length&&this.Of.i(a)):9==a.keyCode&&(a.preventDefault(),a=this.rl,++a.zg,a.zg>=a.yg.length&&(a.zg=0),a.yg[a.zg].displayObject().focus())};e.ql=function(){const a=this.Ia.displayObject().value;0<a.length&&this.Of.i(a)};class Fg extends K{constructor(){super();this.Mg=!1;this.nh=I(this);this.Tg=I(this);this.ma=I(this)}nk(a,b){this.nh.i(a,b)}mk(a,b){this.Tg.i(a,b)}};function Gg(a,b,c){bc.call(this);this.pb=null;this.Bm=!1;this.Nh=a;this.Aj=c;this.kd=b||window;this.Ch=ia(this.Wl,this)}r(Gg,bc);e=Gg.prototype;e.start=function(){this.stop();this.Bm=!1;var a=Hg(this),b=Ig(this);a&&!b&&this.kd.mozRequestAnimationFrame?(this.pb=x(this.kd,"MozBeforePaint",this.Ch),this.kd.mozRequestAnimationFrame(null),this.Bm=!0):this.pb=a&&b?a.call(this.kd,this.Ch):this.kd.setTimeout(Ba(this.Ch),20)};
e.stop=function(){if(this.isActive()){var a=Hg(this),b=Ig(this);a&&!b&&this.kd.mozRequestAnimationFrame?Lc(this.pb):a&&b?b.call(this.kd,this.pb):this.kd.clearTimeout(this.pb)}this.pb=null};e.isActive=function(){return null!=this.pb};e.Wl=function(){this.Bm&&this.pb&&Lc(this.pb);this.pb=null;this.Nh.call(this.Aj,Date.now())};e.dc=function(){this.stop();Gg.W.dc.call(this)};
function Hg(a){a=a.kd;return a.requestAnimationFrame||a.webkitRequestAnimationFrame||a.mozRequestAnimationFrame||a.oRequestAnimationFrame||a.msRequestAnimationFrame||null}function Ig(a){a=a.kd;return a.cancelAnimationFrame||a.cancelRequestAnimationFrame||a.webkitCancelRequestAnimationFrame||a.mozCancelRequestAnimationFrame||a.oCancelRequestAnimationFrame||a.msCancelRequestAnimationFrame||null};function Jg(a){return new Gg(()=>{if(!a.Gi){a.Vb.x=.5*-Da(a.Vb.x);a.Vb.y+=.5*-Da(a.Vb.y);a.Ub=a.Ub.translate(a.Vb);a.R.scrollTo(a.Ub.x,a.Ub.y);var b=a.R.scrollTop(),c=a.R.scrollLeft();b=0==b||b>=a.R.scrollHeight();c=0==c||c>=a.R.scrollWidth();b&&c?a.kj.stop():.5>Math.abs(a.Vb.x)&&.5>Math.abs(a.Vb.y)||.5>=Math.abs(a.Vb.x)&&.5>=Math.abs(a.Vb.y)||a.kj.start()}})}
class Kg extends K{constructor(){super();this.R=null;this.Vb=new E(0,0);this.Wi=new E(0,0);this.Gi=!1;this.Ub=new E(0,0);this.kj=Jg(this)}Hd(a){this.R=a}};function Lg(){this.Dg=new D;this.Km=new D;this.yi=new D;this.pk=new D}e=Lg.prototype;e.nf=!1;e.mf=!1;e.ij=null;e.dh=null;e.Hh=function(){return"drag"};e.yj=function(a,b){if(1==b.touches().length){if("touchStart"==a)return this.nf&&(this.mf=this.nf=!1),this.mf=!1,1;if("touchMove"==a&&this.mf)return 1}this.nf&&(this.mf=this.nf=!1,this.pk.i(this.dh.x,this.dh.y));return 0};
e.sj=function(a){a=new E(a.touches()[0].clientX(),a.touches()[0].clientY());if(this.mf){const b=jd(a,this.ij);a=this.dh;b==a||b&&a&&b.x==a.x&&b.y==a.y||(this.nf||(this.nf=!0,this.yi.i(this.ij.x,this.ij.y)),this.dh=b,this.Dg.i(b.x,b.y))}else this.mf=!0,this.ij=a,this.dh=new E,this.Km.i()};e.We=function(){return this.Dg};e.he=function(){};class Mg extends Fg{constructor(){super();this.Va=this.Y=this.Na=null;this.qk=this.oi=this.pi=!1;this.qg=new E(0,0);this.yf=new Kg;B(this,this.yf)}enable(a){this.Na=a;this.Y=a.ownerDocument;this.Va=new gf(this.Na);B(this,this.Va);a=new Lg;A(this,a.Km,()=>{var b=this.yf;b.Gi=!0;b.kj.stop()},this);A(this,a.yi,this.sq,this);A(this,a.We(),this.rq,this);A(this,a.pk,this.qq,this);nf(this.Va,a);hf(this.Va)}disable(){this.Va&&(jf(this.Va),Xc(this,this.Va),this.Va=null)}Hd(a){this.yf.Hd(a)}sq(a,b){this.qk=
!1;this.qg=new E(0,0);var c=this.yf;c.Gi=!0;c.Vb=new E(0,0);c.Wi=new E(0,0);this.nk(a,b)}rq(a,b){this.qk||(this.pi=Math.abs(b)>Math.abs(a),this.oi=Math.abs(a)>Math.abs(b));this.qk=!0;this.pi&&70<Math.abs(a)&&(this.pi=!1,this.qg=new E(a,0));this.oi&&70<Math.abs(b)&&(this.oi=!1,this.qg=new E(0,b));a=this.pi?0:a-this.qg.x;b=this.oi?0:b-this.qg.y;this.mk(a,b);var c=this.yf;const d=a-c.Wi.x,f=b-c.Wi.y;5>Math.abs(d)&&5>Math.abs(f)?c.Vb=new E(0,0):(c.Vb=new E(-Da(d)*Ca(Math.abs(d),0,25),-Da(f)*Ca(Math.abs(f),
0,25)),c.Wi=new E(a,b))}qq(){var a=this.yf;a.Gi=!1;a.Ub=new E(a.R.scrollLeft(),a.R.scrollTop());a.kj.start();this.ma.i()}};class Ng extends Fg{constructor(){super();this.Y=this.Na=null;this.cc=new E(0,0)}enable(a){this.Na=a;this.Y=a.ownerDocument;this.Mg=!1;x(this.Na,"mousedown",this.rn,!0,this);x(this.Y,"mousemove",this.sn,!0,this);x(this.Y,"mouseup",this.un,!0,this)}disable(){y(this.Na,"mousedown",this.rn,!0,this);y(this.Y,"mousemove",this.sn,!0,this);y(this.Y,"mouseup",this.un,!0,this)}rn(a){a.preventDefault();0==a.button&&(M(this.Na,"holdHand"),this.cc=new E(a.clientX,a.clientY),this.nk(a.clientX,a.clientY),this.Mg=
!0)}sn(a){this.Mg&&this.mk(a.clientX-this.cc.x,a.clientY-this.cc.y)}un(){this.Mg&&(N(this.Na,"holdHand"),this.Mg=!1)}};class Og extends Fg{constructor(){super();this.Va=this.Y=this.Na=null}enable(a){this.Na=a;this.Y=a.ownerDocument;this.Va=new gf(this.Na);B(this,this.Va);a=new Lg;A(this,a.yi,this.nk,this);A(this,a.We(),this.mk,this);nf(this.Va,a);hf(this.Va)}disable(){this.Va&&(jf(this.Va),Xc(this,this.Va),this.Va=null)}};class Pg extends K{constructor(a){super();this.j=a;this.Na=null;this.Lg=!1;this.se=Ie&&Ne?new Mg:Ie?new Og:new Ng;A(this,this.se.nh,this.er,this);A(this,this.se.Tg,this.jq,this);A(this,this.se.ma,this.Jp,this);this.qh=this.ph=0;this.xn=I(this);this.Tg=I(this);this.vn=I(this)}isActive(){return this.Lg}Hd(a){this.se instanceof Mg&&this.se.Hd(a)}enable(){if(this.Lg)throw Error("HandMotion already enable");M(this.Na,"handMotionOverlay");this.se.enable(this.Na);this.Lg=!0}disable(){if(!this.Lg)throw Error("HandMotion already disable");
N(this.Na,"handMotionOverlay");this.se.disable();this.Lg=!1}er(){this.ph=this.j.scrollLeft;this.qh=this.j.scrollTop;this.xn.i()}jq(a,b){a=this.ph-a;b=this.qh-b;this.j.scrollLeft=a;this.j.scrollTop=b;this.Tg.i(this.j.scrollLeft-a,this.j.scrollTop-b)}Jp(){this.vn.i()}};function Qg(a,b,c){V.call(this,"thumbnail");this.za=a;this.Z=c;this.Gb=null;this.$=0;this.ab=new D;this.O=null;this.Jb=b.width()/b.height();this.Yb=b.width()*t.pp;this.Yb<b.width()&&(this.Yb=b.width());this.Rg=Math.floor(this.Yb/this.Jb);this.Di=this.Yb;this.Gk=this.Rg;this.ca(b.width());this.ta(b.height())}r(Qg,V);e=Qg.prototype;e.pageNumber=function(){return this.za};e.Zh=function(a){this.O=a.getViewport(1)};e.Jh=function(){return!0};e.bd=function(){return this.O};
e.da=function(a){this.ca(a.width());this.ta(a.height());this.Di=a.width();this.Gk=a.height();this.Di<this.Yb&&(this.Di=this.Yb,this.Gk=this.Rg);null!==this.Gb&&(this.Gb.style.width=a.width()+"px",this.Gb.style.height=a.height()+"px")};e.reset=function(){3!=this.$&&(this.$=0)};
e.render=function(){if(0!=this.$)throw Error("Page renderingState is wrong");this.$=1;const a=xd(document,"img");a.className="content";a.width=this.Di;a.height=this.Gk;a.style.width=this.width()+"px";a.style.height=this.height()+"px";a.setAttribute("hidden","hidden");this.h(a);this.Gb=a;a.onload=function(){this.Gb.removeAttribute("hidden");this.$=3;this.ab.i()}.bind(this);a.src=t.ps+"/page-"+Rg(this.za,this.Z.toString().length)+".jpg"};
e.destroy=function(){this.$=0;this.Gb&&(this.Gb.width=0,this.Gb.height=0,this.removeChild(this.Gb),this.Gb=null)};function Rg(a,b){a=a.toString();b-=a.length;for(let c=0;c<b;++c)a="0"+a;return a};function Sg(a,b){V.call(this,"thumbnail");this.za=a;this.ha=this.S=null;this.$=0;this.ab=new D;this.O=null;this.Jb=b.width()/b.height();this.Yb=b.width()*t.pp;this.Yb<b.width()&&(this.Yb=b.width());this.Rg=Math.floor(this.Yb/this.Jb);this.ff=this.Yb;this.gk=this.Rg;this.ml=0;this.ca(b.width());this.ta(b.height())}r(Sg,V);e=Sg.prototype;e.pageNumber=function(){return this.za};e.Zh=function(a){this.ha=a;this.O=a.getViewport(1);this.ml=this.ff/this.O.width};e.Jh=function(){return null!==this.ha};
e.bd=function(){return this.O};e.da=function(a){this.ca(a.width());this.ta(a.height());this.ff=a.width();this.gk=a.height();this.ff<this.Yb&&(this.ff=this.Yb,this.gk=this.Rg);null!==this.O&&(this.ml=this.ff/this.O.width);null!==this.S&&(this.S.style.width=a.width()+"px",this.S.style.height=a.height()+"px")};e.reset=function(){this.$=0};
e.render=function(){if(0!=this.$)throw Error("Page renderingState is wrong");this.$=1;let a=null!==this.S?this.S:null;var b=xd(document,"canvas");b.className="content";b.width=this.ff;b.height=this.gk;b.style.width=this.width()+"px";b.style.height=this.height()+"px";b.setAttribute("hidden","hidden");this.h(b);this.S=b;b={canvasContext:b.getContext("2d"),viewport:this.O.clone({scale:this.ml})};this.ha.render(b,c=>{null!==c?this.$=0:(this.S.removeAttribute("hidden"),null!==a&&(a.width=0,a.height=0,
this.removeChild(a),a=null),this.$=3,this.ab.i())})};e.destroy=function(){this.$=0;if(this.ha){var a=this.ha;null!==a.Ff&&a.Ff.cancel();this.ha.cleanup()}this.S&&(this.S.width=0,this.S.height=0,this.removeChild(this.S),this.S=null)};function Tg(){this.Wm=!1;this.Z=0}Tg.prototype.um=function(a){this.Wm=a};Tg.prototype.ua=function(a){this.Z=a};function Ug(a,b,c){return a.Wm?new Sg(b,c):new Qg(b,c,a.Z)};function Vg(){}Vg.prototype.encode=function({pageNumber:a,hi:b,zb:c}){return{p:a,m:b,b:c}};Vg.prototype.decode=function(a){return{pageNumber:a.p,hi:a.m,zb:a.b}};class Wg{constructor({title:a,creationTime:b,pageNumber:c}){this.yb=a;this.Fp=b;this.za=c}title(){return this.yb}pageNumber(){return this.za}creationTime(){return this.Fp}};function Xg(a){const b=Object.assign({},a),c={};for(const d in b)"object"==typeof b[d]&&(b[d]=Xg(b[d]),a=b[d],a._d&&(c[a._d]=a));b.toString=()=>b._;b.Ls=d=>c[d];return b};var Yg={title:{_:"t"},creationTime:{_:"ct"},pageNumber:{_:"pn"}};const Zg={};for(const a in Yg)Yg.hasOwnProperty(a)&&(Zg[a]=Xg(Yg[a]));class $g{load(a,b){a.forEach((c,d)=>{b.hb.splice(d||0,0,new Wg({title:c[Zg.title],creationTime:c[Zg.creationTime],pageNumber:c[Zg.pageNumber]}));b.re.i()})}};class ah{rm(a){return a.zb().map(b=>({[Zg.title]:b.title(),[Zg.creationTime]:b.creationTime(),[Zg.pageNumber]:b.pageNumber()}))}};class bh extends T{constructor(a){super({X:"mobile-password-dialog-view"});this.ba=a;this.Of=I(this);this.tf=I(this);this.xb=new T({X:"ask-password-dialog-container"});var b=new T({M:R(this.xb,"header")});b.V(a.ka("ED_ASK_PASSWORD_DIALOG_LABEL"));this.xb.h(b);b=new T({M:R(this.xb,"password-container")});this.xb.h(b);this.Ia=new T({M:R(this.xb,"input"),Uf:"INPUT"});this.Ia.setAttribute("type","password");const c=new T({M:R(this.xb,"password-placeholder")});b.h(c);c.V(this.ba.ka("ED_ASK_PASSWORD_DIALOG_PLACEHOLDER"));
b.h(this.Ia);this.od=new T({M:R(this.xb,"error")});this.od.V(a.ka("ED_ASK_PASSWORD_DIALOG_INVALID_PASSWORD_LABEL"));this.xb.h(this.od);this.ik();this.h(this.xb);z(this,this.Ia.displayObject(),"input",this.Hk,this);z(this,this.Ia.displayObject(),"focus",this.Hk,this);z(this,this.Ia.displayObject(),"focusout",()=>{this.Hk();this.tf.i()},this);z(this,this.Ia.displayObject(),"keydown",this.xe,this);this.aa("mobile-app",Ue);this.xb.xa("margin-bottom","50px")}focus(){this.Ia.focus()}da(){this.aa("landscape",
ka())}hp(){}gp(){this.xb.aa("incorrect-password",!0);this.xb.xa("margin-bottom",`${50-this.od.height()}px`)}xe(a){a.stopPropagation();13==a.keyCode&&(a=this.Ia.displayObject().value,0<a.length&&this.Of.i(a))}ik(){const a=new T({M:R(this.xb,"submit"),Uf:"BUTTON"});a.V(this.ba.ka("ED_OK"));A(this,a.H,this.ql,this);this.xb.h(a)}ql(){const a=this.Ia.displayObject().value;0<a.length&&this.Of.i(a)}Hk(){const a=!!this.Ia.displayObject().value.length||document.activeElement==this.Ia.displayObject();this.xb.aa("hide-placeholder",
a)}};function W(a,b,c,d,f,g){this.fa=new w(a.clientWidth,a.clientHeight);this.Hb=b;this.Ka=null;this.wa=[];this.Y=this.s=null;this.nb=[];this.T=null;this.lc=c;this.ea=new Pg(this.g.ga.displayObject());this.Sc=new pg;this.l=d;this.ra={Vj:0,Ea:1,Bj:!1};this.hb=f;this.to=new Vg;this.ee=new Tg;this.Ya=new D;this.ce=new D;this.so=new D;this.tf=new D;this.Ii={};document.title=b.title();g&&ch(this,g);this.hb.re.addHandler(this.Cl,this);L&&Ne&&(x(document.body,"focusin",()=>{const h=Hd();!h||"INPUT"!=h.nodeName&&
"TEXTAREA"!=h.nodeName||M(document.body,"keyboard-showed")},!1,this),x(document.body,"focusout",()=>{N(document.body,"keyboard-showed")},!1,this))}W.prototype.hi=function(){return this.lc};W.prototype.viewMode=W.prototype.hi;W.prototype.Jj=function(){return this.Ya};W.prototype.pageChangedEvent=W.prototype.Jj;W.prototype.lp=function(){return this.ce};W.prototype.stateChangedEvent=W.prototype.lp;W.prototype.ns=function(){return this.so};W.prototype.startupCompletedEvent=W.prototype.ns;
W.prototype.Ej=function(a){dh(this,"loadFromUrl",[a])};W.prototype.lm=function(a,b){dh(this,"loadBinary",[a,b])};W.prototype.title=function(){return this.Hb.title()};W.prototype.title=W.prototype.title;W.prototype.v=function(){return this.Y.v()};W.prototype.pagesCount=W.prototype.v;W.prototype.ls=function(a){this.ra.Ea=a};W.prototype.setPageNumber=W.prototype.ls;W.prototype.um=function(){this.g.dd(!1);this.ee.um(!0)};W.prototype.$r=function(){return this.Ii};W.prototype.persistState=W.prototype.$r;
e=W.prototype;e.Cl=function(){var a=(new ah).rm(this.hb);a={pageNumber:this.s.Ea(),hi:this.lc,zb:a};a=this.to.encode(a);uc(a,this.Ii)||(this.Ii=a,this.ce.i())};e.mc=function(a){this.Ya.i(a)};e.Ac=function(a,b){this.wa[a]=new b(this.g.ga);this.wa[a].sm(this.Hb.Rd);this.wa[a].Qj(this.Hb.jb);this.wa[a].ea=this.ea;this.wa[a].Ya.addHandler(this.Te,this)};e.Xd=function(a,b,c){this.nb[a]=new b(this.g,c,this.ee);this.nb[a].Qj(this.Hb.jb)};
e.Wb=function(a){this.s&&this.s.disable();this.T&&this.T.disable();this.s=this.wa[a];this.nb[a]&&(this.T=this.nb[a]);this.lc=a;this.Sc.Tj(this.s)};function ch(a,b){b=a.to.decode(b);a.ra.Ea=b.pageNumber;a.lc=b.hi;(b=b.zb)&&(new $g).load(b,a.hb)}function dh(a,b,c){const d=new Bg;d.nn.addHandler(a.td,a);d.Yk.addHandler(a.lq,a);let f="";a.Hb.en||""==a.Hb.salt()||(f=a.Hb.salt());c.push(f);"loadFromUrl"==b?d.Ej(...c):d.lm(...c)}
e.lq=function(a){eh(this.g);this.g.wj(!0);null==this.Ka?(this.Ka=Ne?new bh(this.Hb.Hc()):new Eg(this.Hb.Hc()),this.l.qm&&this.Ka.hp(!0),this.Ka.da(this.fa),this.Ka.tf.addHandler(this.Um,this),this.Ka.Of.addHandler(b=>{a(b+this.Hb.salt())},this),this.g.h(this.Ka.displayObject()),L||this.Ka.focus()):this.Ka.gp()};e.td=function(a){this.Y=a;this.Ka&&(this.g.wj(!1),this.g.removeChild(this.Ka.displayObject()),Yc(this.Ka));this.ee.ua(a.v());Ne&&(N(window.document.body,"keyboard-showed"),this.Um())};
function fh(a){a.g.ym();eh(a.g);a.ra.Bj=!0;a.so.i()}e.Te=function(a){this.ra.Ea=a;this.Cl()};e.Um=function(){this.tf.i()};function gh(){Nc.call(this);this.jd=hh;this.endTime=this.startTime=null}r(gh,Nc);var hh=0;gh.prototype.Dj=function(){return 1==this.jd};gh.prototype.Hj=function(){this.$c("begin")};gh.prototype.Ph=function(){this.$c("end")};gh.prototype.$c=function(a){this.dispatchEvent(a)};function ih(a,b,c){bc.call(this);this.Nh=a;this.ag=b||0;this.Aj=c;this.Ch=ia(this.Wl,this)}r(ih,bc);e=ih.prototype;e.pb=0;e.dc=function(){ih.W.dc.call(this);this.stop();delete this.Nh;delete this.Aj};e.start=function(a){this.stop();this.pb=ie(this.Ch,void 0!==a?a:this.ag)};e.stop=function(){this.isActive()&&p.clearTimeout(this.pb);this.pb=0};e.isActive=function(){return 0!=this.pb};e.Wl=function(){this.pb=0;this.Nh&&this.Nh.call(this.Aj)};var tc={},jh=null;function kh(a){a=ca(a);delete tc[a];sc()&&jh&&jh.stop()}function lh(){jh||(jh=new ih(function(){mh()},20));var a=jh;a.isActive()||a.start()}function mh(){var a=Date.now();oc(tc,function(b){nh(b,a)});sc()||lh()};function oh(a,b,c,d){gh.call(this);if(!Array.isArray(a)||!Array.isArray(b))throw Error("Start and end parameters must be arrays");if(a.length!=b.length)throw Error("Start and end points must be the same length");this.kg=a;this.Qo=b;this.duration=c;this.Jo=d;this.coords=[];this.us=!1;this.progress=0}r(oh,gh);e=oh.prototype;
e.play=function(a){if(a||this.jd==hh)this.progress=0,this.coords=this.kg;else if(this.Dj())return!1;kh(this);this.startTime=a=Date.now();-1==this.jd&&(this.startTime-=this.duration*this.progress);this.endTime=this.startTime+this.duration;this.progress||this.Hj();this.$c("play");-1==this.jd&&this.$c("resume");this.jd=1;var b=ca(this);b in tc||(tc[b]=this);lh();nh(this,a);return!0};e.stop=function(a){kh(this);this.jd=hh;a&&(this.progress=1);ph(this,this.progress);this.$c("stop");this.Ph()};
e.pause=function(){this.Dj()&&(kh(this),this.jd=-1,this.$c("pause"))};e.dc=function(){this.jd==hh||this.stop(!1);this.Xo();oh.W.dc.call(this)};e.destroy=function(){this.Yf()};function nh(a,b){b<a.startTime&&(a.endTime=b+a.endTime-a.startTime,a.startTime=b);a.progress=(b-a.startTime)/(a.endTime-a.startTime);1<a.progress&&(a.progress=1);ph(a,a.progress);1==a.progress?(a.jd=hh,kh(a),a.$c("finish"),a.Ph()):a.Dj()&&a.Gj()}
function ph(a,b){"function"===typeof a.Jo&&(b=a.Jo(b));a.coords=Array(a.kg.length);for(var c=0;c<a.kg.length;c++)a.coords[c]=(a.Qo[c]-a.kg[c])*b+a.kg[c]}e.Gj=function(){this.$c("animate")};e.Xo=function(){this.$c("destroy")};e.$c=function(a){this.dispatchEvent(new qh(a,this))};function qh(a,b){fc.call(this,a);this.coords=b.coords;this.x=b.coords[0];this.y=b.coords[1];this.z=b.coords[2];this.duration=b.duration;this.progress=b.progress;this.state=b.jd}r(qh,fc);function X(a,b,c,d){oh.call(this,a,b,c,d);this.dk=new D;this.xp=new D;this.ma=new D}r(X,oh);e=X.prototype;e.ob=function(a){this.sg&&this.sg.animate(a)};e.Ge=function(){this.sg&&this.sg.Ss()};e.yd=function(){this.sg&&this.sg.Fs()};e.Gj=function(){this.ob(this.coords);this.xp.i()};e.Xo=function(){};e.Ph=function(){this.ob(this.coords);this.yd();this.ma.i()};e.Hj=function(){this.dk.i();this.Ge();this.ob(this.coords)};class rh extends X{constructor({Jc:a,nextPage:b,Gc:c,duration:d,Xr:f,Er:g,ds:h}){super([0],[1],d);this.G=a;this.I=c;this.Mf=(this.J=b)?this.J.x():0;this.Ug=f-this.Mf;this.Lf=this.I?this.I.x():0;this.Ag=g-this.Lf;this.Nf=this.G?this.G.x():0;this.eh=h-this.Nf}ob(a){a=a[0];this.G.la(this.Nf+this.eh*a);this.I.la(this.Lf+this.Ag*a);this.J.la(this.Mf+this.Ug*a)}};class sh extends X{constructor({scrollTop:a,scrollLeft:b,scale:c,duration:d,Kc:f,ne:g}){super([0],[1],d);this.o=g;this.R=f;this.qh=this.R.scrollTop();this.Vq=this.qh-a;this.ph=this.R.scrollLeft();this.Uq=this.ph-b;this.qo=this.o.scale();this.Pq=this.qo-c}ob(a){a=a[0];this.o.setScale(this.qo-this.Pq*a);this.R.scrollTo(this.ph-this.Uq*a,this.qh-this.Vq*a)}};function th(a,b){this.fe=a;this.ge=b}th.prototype.x=function(){return this.fe};th.prototype.y=function(){return this.ge};function uh(a){const b=Math.pow(10,2);return Math.round(a*b)/b}function vh(a){var b=t.up;return a==t.Xe?a:uh(Math.min(a+b,t.Xe))}function wh(a){var b=t.up;return a==t.Ye?a:uh(Math.max(a-b,t.Ye))}function xh(a){const b=re();return Math.max(a.width/b.width,a.height/b.height)};function yh(a){this.j=a;this.O=null;this.Db=this.$b=0;this.P=1;this.F=0;this.ea=this.Fa=null;this.bb=t.Gr;this.Z=0;this.Y=null;this.Xb=!1;this.Ya=new D;this.Jf=new D;this.Ec=new D}e=yh.prototype;e.container=function(){return this.j};function zh(a){return a.j.displayObject()}e.v=function(){return this.Z};e.document=function(){return this.Y};e.eb=function(a){this.Y=a;this.Z=a.v()};e.bd=function(){return this.O};e.Ea=function(){return this.F};e.scale=function(){return this.Db};e.Ed=function(){return this.P};
e.Jj=function(){return this.Ya};e.disable=function(){this.ea.isActive()&&this.ea.disable();this.Xb=!1;this.Db=0;this.P=1;this.F=0};e.mc=function(){this.Ya.i(this.F)};function Ah(a){a.Xb=!0;a.Ec.i()}function Bh(a,b){return a.Y&&a.F!=b&&0<b&&b<=a.v()};function Ch(a){yh.call(this,a);this.Pa=this.nc=null}r(Ch,yh);Ch.prototype.Qj=function(a){this.nc=a};Ch.prototype.Zl=function(){};function Dh(){}e=Dh.prototype;e.pageNumber=function(){return 0};e.Cd=function(){};e.bd=function(){};e.K=function(){};e.U=function(){};e.reset=function(){};e.destroy=function(){};e.la=function(){};e.x=function(){return 0};e.Lc=function(){};e.y=function(){return 0};e.da=function(){};e.setScale=function(){};e.fm=function(){return Promise.resolve(null)};e.xa=function(){};e.displayObject=function(){};class Eh{constructor(a){this.o=a}Rj(a){this.o.container().displayObject().scrollTop=a}scrollTo(a,b){this.o.container().displayObject().scrollLeft=a;this.Rj(b)}scrollTop(){return this.Fb().scrollTop}scrollLeft(){return this.Fb().scrollLeft}scrollWidth(){return this.Fb().scrollWidth}scrollHeight(){return this.Fb().scrollHeight}Fb(){return this.o.container().displayObject()}};function Fh(){this.pe=[];this.dk=new D;this.ma=new D}e=Fh.prototype;e.add=function(a){this.pe.push(a);a.ma.addHandler(this.yn,this)};e.remove=function(a){const b=this.pe.indexOf(a);-1!=b&&(this.pe.splice(b,1),a.ma.removeHandler(this.yn,this))};e.play=function(a){this.dk.i();this.pe.length&&(this.$m=0,this.On=!0,ta(this.pe,b=>{b.play(void 0!==a?a:!0)},this));return!0};e.stop=function(a){ta(this.pe,b=>{b.stop(void 0!==a?a:!0)},this)};e.Dj=function(){return this.On};
e.yn=function(){++this.$m;this.$m==this.pe.length&&(this.On=!1,this.ma.i())};function Gh(a,b,c,d){return function(f){if(a!=b||c!=d){let m=f;for(let k=0;4>k;++k){var g=m,h=a,l=c;g=3*(1-3*l+3*h)*g*g+2*(3*l-6*h)*g+3*h;if(0==g)break;m-=((((1-3*c+3*a)*m+(3*c-6*a))*m+3*a)*m-f)/g}f=(((1-3*d+3*b)*m+(3*d-6*b))*m+3*b)*m}return f}}var Hh=Gh(.25,.1,.25,1),Ih=Gh(0,0,.58,1);var Jh=Gh(.64,.04,.35,1),Kh=Gh(.09,.74,.35,1),Lh=Gh(.35,.02,.67,.19);const Mh=t.og;
class Nh extends X{constructor({duration:a,sb:b,Jc:c,Gc:d,nextPage:f,Kr:g}){super([0],[1],a,Jh);this.Ha=b;this.G=c;this.I=d;this.J=f;this.Fg=g;a=this.xc(this.Fg);this.Fg.la(this.Ha.width()+a);a=this.xc(this.G);this.Xi=this.G.x();this.eh=a;a=this.xc(this.I);this.Bg=this.I.x();this.Ag=this.Bg- -a;a=this.xc(this.J);a=Math.floor(this.Ha.width()/2-a/2);a=Math.max(a,0);this.Li=this.J.x();this.Ug=this.Li-a;a=this.xc(this.Fg);this.Mp=this.Fg.x();this.Lp=a}ob(a){a=a[0];this.G.la(this.Xi-this.eh*a);this.I.la(this.Bg-
this.Ag*a);this.J.la(this.Li-this.Ug*a);this.Fg.la(this.Mp-this.Lp*a)}xc(a){return 0==a.pageNumber()?0:a.Cd().width+2*Mh.Ga}};const Oh=t.og;
class Ph extends X{constructor({duration:a,sb:b,Jc:c,Gc:d,nextPage:f,Lr:g}){super([0],[1],a,Jh);this.Ha=b;this.G=c;this.I=d;this.J=f;this.Gg=g;a=this.xc(this.Gg);this.Gg.la(-2*a);a=this.xc(this.J);this.Li=this.J.x();this.Ug=a;this.Bg=this.I.x();this.Ag=this.Ha.width()-this.Bg;a=this.xc(this.G);a=Math.floor(this.Ha.width()/2-a/2);a=Math.max(a,0);this.Xi=this.G.x();this.eh=a-this.Xi;a=this.xc(this.Gg);this.Op=this.Gg.x();this.Np=a}ob(a){a=a[0];this.J.la(this.Li+this.Ug*a);this.I.la(this.Bg+this.Ag*
a);this.G.la(this.Xi+this.eh*a);this.Gg.la(this.Op+this.Np*a)}xc(a){return 0==a.pageNumber()?0:a.Cd().width+2*Oh.Ga}};function Qh(a,b,c){return b&&c?new E(b,c):new E(a.width()/2,a.height()/2)}function Rh(a){return a.scale()*(a.bb-1)+1}
function Sh({ne:a,page:b,lg:c,jp:d,clientX:f,clientY:g}){var h=Qh(a.container(),f,g);f=d.Fr;b=b.displayObject().getBoundingClientRect();c&&(h=a.container().displayObject().getBoundingClientRect(),d=2*d.Jr,a=Rh(a),f=(h.width-d)*a/c.width,a=a/f*(h.height-d),d=b.top+c.top+.5*a,h=new E(b.left+c.left+c.width/2,Ca(g||d,d,b.top+(new kd(c.top,c.left+c.width,c.top+c.height,c.left)).bottom-.5*a)));return{scale:f,position:new E(Math.max(h.x-b.left,0),Math.max(h.y-b.top,0))}}
function Th({ne:a,scale:b,position:c}){const d=Rh(a),f=(b-1)/(a.bb-1);b/=d;a=a.container().displayObject().getBoundingClientRect();return{Ed:f,scrollTop:c.y*b-a.height/2,scrollLeft:c.x*b-a.width/2}};const Uh=t.og;function Vh(a){a.o.Gc().xa("transform",`translateY(-${a.R.scrollTop()}px)`);a.R.Rj(0)}function Wh(a,b,c,d,f){if(!a.ze){a.rg=f;c||Vh(a);f=[a.ze];for(var g of f)g&&a.vg(g);g=a.zi;f=a.o.view();b=new Nh({duration:g,sb:f.sb(),Jc:a.o.Jc(),Gc:a.o.Gc(),nextPage:a.o.nextPage(),Kr:b});c=a.vi({duration:a.zi,ap:c,lg:d,Yo:a.o.nextPage()});d=new Fh;d.add(b);d.add(c);a.ze=d;A(a,a.ze.ma,a.Hm,a);a.ze.play()}}
function Xh(a,b,c,d,f){if(!a.He){a.rg=f;c||Vh(a);f=[a.He];for(var g of f)g&&a.vg(g);g=a.zi;f=a.o.view();b=new Ph({duration:g,sb:f.sb(),Jc:a.o.Jc(),Gc:a.o.Gc(),nextPage:a.o.nextPage(),Lr:b});c=a.vi({duration:a.zi,ap:c,Yo:a.o.Jc(),lg:d});d=new Fh;d.add(b);d.add(c);a.He=d;A(a,a.He.ma,a.Hm,a);a.He.play()}}
class Yh extends K{constructor(a,b){var c=t.ms;super();this.o=a;this.zi=c;this.rg=null;this.R=b;this.Pd=null;this.ri=I(this);this.He=this.ze=null}vm(a){this.Pd=a}playing(){return!!this.ze||!!this.He}Hm(){null!==this.rg&&(this.rg(),this.rg=null);this.He=this.ze=null}bk(){this.ri.i()}vi({duration:a,ap:b,Yo:c,lg:d}){if(this.Pd&&this.Pd.pf&&d){const {position:l,scale:m}=Sh({ne:this.o,page:c,jp:Uh,lg:d}),{scrollTop:k,scrollLeft:n,Ed:q}=Th({ne:this.o,position:l,scale:m,lg:d});b={scale:q,scrollLeft:n,scrollTop:b?
k:0}}else b={scrollLeft:this.R.scrollLeft(),scrollTop:b?0:this.R.scrollTop(),scale:this.o.scale()};const {scrollTop:f,scrollLeft:g,scale:h}=b;return new sh({duration:a,scrollTop:f,scrollLeft:g,scale:h,Kc:this.R,ne:this.o})}};function Zh(){this.Mb=[]}Zh.prototype.render=function(a){const b=this.Hg(a);b&&!this.Og(b)&&(b.Jh()?this.Yd(b):(a=b.pageNumber(),this.Mb[a]||(this.Mb[a]=!0,this.Y().getPage(a,(c,d)=>{b.Zh(c);this.Mb[d]=!1;this.Yd(b)}))))};Zh.prototype.Ng=function(a){return 3==a.$};Zh.prototype.Og=function(a){return 1==a.$};Zh.prototype.Hg=function(a){for(let b=0;b<a.length;++b)if(!this.Ng(a[b].page))return a[b].page;return null};function $h(a){this.Mb=[];this.o=a}r($h,Zh);$h.prototype.Ja=function(){const a=[];var b=this.o.Gc();a.push({je:b.pageNumber(),page:b});b=this.o.nextPage();0!=b.pageNumber()&&a.push({je:b.pageNumber(),page:b});b=this.o.Jc();0!=b.pageNumber()&&a.push({je:b.pageNumber(),page:b});return{Qc:a}};$h.prototype.update=function(){this.o.Gc().reset();this.o.nextPage().reset();this.o.Jc().reset();const a=this.Ja();this.render(a.Qc)};
$h.prototype.Yd=function(a){switch(a.$){case 3:break;case 2:break;case 1:break;case 0:a.ab.addHandler(()=>{const b=this.Ja();this.render(b.Qc)},this);a.render();break;default:throw Error("renderingState is wrong");}};$h.prototype.Y=function(){return this.o.document()};function ai(){V.call(this,["viewer",t.og.className]);this.Ha=new V("pageContainer");this.h(this.Ha);this.o=null}r(ai,V);e=ai.prototype;e.bi=function(a){this.o=a};e.sb=function(){return this.Ha};e.ca=function(a){this.Ha.ca(a)};e.width=function(){return this.Ha.width()};e.ta=function(a){this.Ha.ta(a)};e.height=function(){return this.Ha.height()};const Y=t.og;function bi(a){ci(a.I);ci(a.G);ci(a.J)}function di(a,b){a.I=ei(a,b);a.I.K("current");fi(a,a.I,1);a.G=ei(a,b-1);fi(a,a.G,0);a.J=ei(a,b+1);fi(a,a.J,2);gi(a);hi(a)}function ii(a){a.Lf=a.I.x();a.Mf=a.J?a.J.x():0;a.Nf=a.G?a.G.x():0}function ji(a,b){a.Kf.playing()||(a.ye=new rh({duration:150,Gc:a.I,nextPage:a.J,Jc:a.G,Xr:a.Mf+b,Er:a.Lf+b,ds:a.Nf+b}),a.ye.ma.addHandler(()=>{a.ye=null;bi(a)}),a.ye.play())}
function ki(a,b,c){0>b&&a.F>=a.v()||0<b&&1>=a.F||(c?ji(a,b):((c=a.I)&&c.la(a.Lf+b),(c=a.J)&&c.la(a.Mf+b),(c=a.G)&&c.la(a.Nf+b),b=a.Kc().scrollTop(),a.G.xa("transform",`translate(-1px, ${b}px)`),a.J.xa("transform",`translate(1px, ${b}px)`)))}function ci(a){a&&a.xa("transform","")}
function fi(a,b,c){if(0!=b.pageNumber()){var d=b.Cd().width+2*Y.Ga;switch(c){case 0:b.la(-d);break;case 1:b.la(Math.max(a.Fa.width()/2-d/2,0));break;case 2:b.la(a.g.width());break;default:throw Error("slidePath is wrong");}c=b.Cd().height+2*Y.Ga;b.Lc(Math.max((a.Fa.height()-c)/2,0))}}function gi(a){var b=a.I.Cd(),c=a.Fa.width();const d=b.width+2*(Y.Ga+Y.Yj);d>c&&(c=d);a.g.ca(c);c=a.Fa.height();b=b.height+2*(Y.Ga+Y.Yj);b>c&&(c=b);a.g.ta(c)}
function li(a,b,c){if(0!=b.pageNumber()){var d=b.bd(),f=a.Wa(d);d=d.clone({scale:f*a.P});b.da(d,a.P);fi(a,b,c)}}function mi(a,b,c,d){const {scrollLeft:f,scrollTop:g,Ed:h}=Th({ne:a,scale:b,position:c});a.Kl=a.vi(f,g,h,d)}
function ei(a,b){if(0>=b||b>a.v()){var c=$b(a.nc,1);return new Dh}const d=$b(a.nc,b);c=a.Wa(d);c=d.clone({scale:c*a.P});b=new ig(b,c,a.P);b.O=d;c=c.height+2*Y.Ga;b.Lc(Math.max((a.Fa.height()-c)/2,0));a.g.Ha.h(b.displayObject());a.Pa&&b.ab.addHandler(function(f,g){g=this.Wa(g)*xh(g);this.Pa.render(f,this.P,g)}.bind(a,b,d));return b}function hi(a){a.F=a.pc;a.mc();a.Zb();a.pc=0;bi(a)}function ni(a,b){return b&&a.Pd&&a.Pd.pf?b.fm():Promise.resolve(null)}
class oi extends Ch{constructor(a){super(a);this.R=new Eh(this);this.J=this.I=this.G=this.g=this.Pd=null;this.df=0;this.lk=!0;this.pc=0;this.Kl=null;this.Nf=this.Mf=this.Lf=0;this.$a=new $h(this);this.Kf=new Yh(this,this.R);this.ye=null;this.wc=new th(0,0);this.te=new th(0,0);this.Le=new G(0,0);this.Ec.addHandler(function(){var b=this.g.displayObject();this.ea.Na=b},this)}Kc(){return this.R}vm(a){this.Pd=a;this.Kf.vm(a)}Jc(){return this.G}Gc(){return this.I}nextPage(){return this.J}view(){return this.g}B(a,
b=!0){if(Bh(this,a)&&0==this.pc)if(this.pc=a,bi(this),this.lk)di(this,a),Ah(this),this.lk=!1;else{this.ye&&(this.ye.pause(),this.ye=null);let c;switch(this.Bk(a)){case 0:c=this.br;break;case 2:c=this.cr;break;case 1:c=this.Xp;break;case 3:c=this.Zp;break;default:throw Error("TransitionType is wrong");}c.call(this,a,b)}}$e(a=!0){1>=this.F||this.B(this.F-1,a)}Ze(a=!0){this.F>=this.v()||this.B(this.F+1,a)}$l(){}sm(){}setScale(a){this.Db!=a&&0==this.pc&&(this.Db=a,this.P=a*(this.bb-1)+1,this.I.setScale(this.P),
fi(this,this.I,1),gi(this),this.J.setScale(this.P),fi(this,this.J,2),this.G.setScale(this.P),fi(this,this.G,0),this.Jf.i(this.Db))}ke(a){this.setScale(a);var b=this.I.displayObject().getBoundingClientRect();a=b.width/this.Le.width;b=b.height/this.Le.height;a*=this.te.x();b*=this.te.y();a=a-this.wc.x()+Y.Ga;b=b-this.wc.y()+Y.Ga;this.R.scrollTo(a,b)}Gd(a,b){const c=this.I.displayObject().getBoundingClientRect();this.wc=new th(a,b);this.te=new th(Math.max(a-c.left,0),Math.max(b-c.top,0));this.Le=new G(c.width,
c.height)}resize(a){this.Fa=a;this.Bl();this.Xb&&(this.P=this.Db*(this.bb-1)+1,li(this,this.I,1),gi(this),li(this,this.J,2),li(this,this.G,0))}enable(a){this.g=new ai;this.g.bi(this);this.container().h(this.g);this.B(a)}disable(){super.disable();this.container().removeChild(this.g);this.g=null;this.lk=!0}update(){this.$a.update()}Pc(){return[this.F-1]}Zl({clientX:a,clientY:b,Ko:c}){this.Kl||(this.Pd.pf?this.I.fm().then(d=>{const {scale:f,position:g}=Sh({ne:this,jp:Y,page:this.I,lg:d,clientX:a,clientY:b});
mi(this,f,g,c)}):mi(this,1,Qh(this.j,a,b),!c))}vi(a,b,c,d){a=new sh({ne:this,Kc:this.R,scrollLeft:a,scrollTop:b,scale:c,duration:d?Y.tp/2:Y.tp});a.play();a.ma.addHandler(()=>{this.Kl=null;this.update()});return a}br(a,b){const c=ei(this,a+1);c.K("future-next");ni(this,this.J).then(d=>{Wh(this.Kf,c,b,d,()=>{this.lb(this.G);this.I.U("current");this.I.K("prev");this.G=this.I;this.J.U("next");this.J.K("current");this.I=this.J;c.U("future-next");c.K("next");this.J=c;hi(this)})})}cr(a,b){const c=ei(this,
a-1);c.K("future-prev");ni(this,this.G).then(d=>{Xh(this.Kf,c,b,d,()=>{this.lb(this.J);this.I.U("current");this.I.K("next");this.J=this.I;this.G.U("prev");this.G.K("current");this.I=this.G;c.U("future-prev");c.K("prev");this.G=c;hi(this)})})}Xp(a,b){this.lb(this.J);this.J=ei(this,a);this.J.la(this.g.width());const c=ei(this,a+1);ni(this,this.J).then(d=>{Wh(this.Kf,c,b,d,()=>{this.lb(this.G);this.lb(this.I);this.G=ei(this,a-1);this.G.la(-(this.G.Cd().width+2*Y.Ga));this.G.K("prev");this.J.U("next");
this.J.K("current");this.I=this.J;c.K("next");this.J=c;hi(this)})})}Zp(a,b){this.lb(this.G);this.G=ei(this,a);this.G.la(-(this.G.Cd().width+2*Y.Ga));const c=ei(this,a-1);ni(this,this.G).then(d=>{Xh(this.Kf,c,b,d,()=>{this.lb(this.J);this.lb(this.I);this.J=ei(this,a+1);this.J.la(this.g.width());this.G.U("prev");this.G.K("current");this.I=this.G;c.K("prev");this.G=c;hi(this);bi(this)})})}Bk(a){let b=this.F;return a>b?a==b+1?0:1:a==b-1?2:3}lb(a){a&&0!=a.pageNumber()&&(this.g.Ha.removeChild(a.displayObject()),
a.destroy())}Zb(){const a=this.$a.Ja().Qc;this.$a.render(a)}Wa(a){const b=2*(Y.Ga+Y.Yj),c=(this.Fa.width()-b)/a.width;a=(this.Fa.height()-b)/a.height;return Math.min(a,c)}Bl(){var a=ac(this.nc),b=this.Wa(a);a=a.clone({scale:b});a=a.width+2*Y.Ga;a=this.Fa.width()/a*2;this.bb=Math.max(a,this.bb);if(ue){a=this.nc;if(-1==a.Uk){if(1==a.Kb.length)b=0;else{var c=b=0;for(let f=1;f<a.Kb.length;++f){var d=a.Kb[f].size();d=d.width()*d.height();d>b&&(b=d,c=f)}b=c}a.Uk=b}a=a.Kb[a.Uk].getViewport();b=this.Wa(a);
a=a.clone({scale:b});a=a.width*a.height*this.bb;a>PDFJS.maxCanvasPixels&&(this.bb*=PDFJS.maxCanvasPixels/a)}}xc(a){return 0==a.pageNumber()?0:a.Cd().width+2*Y.Ga}};function pi(a,b){b=Ag(b,a.ud,a.oc);a.Da!=b&&(a.Da=b,qi(a),a.Zd.i())}function ri(a,b,c){a.gh=b;z(a,a.gh,"mouseover",a.Gn,a);z(a,a.gh,"mouseout",a.Fn,a);z(a,document,$e,a.Xn,a);a.Hf.stop();a.cj=function(){pi(this,this.Da+this.Wn)};a.Wn=c;a.Hf.start()}
class si extends T{constructor(a){super({X:a.X,me:!0});this.fq=15;this.Da=this.oc=this.ud=this.jb=0;this.cq=a.Ic||1;this.Wn=this.hl=0;this.Oq=100;this.Rf=B(this,new T({M:R(this,"up")}));this.h(this.Rf);this.Oa=B(this,new T({X:"thumb"}));this.h(this.Oa);this.Oa.h(B(this,new T({M:R(this.Oa,"background")})));this.lf=B(this,new T({M:R(this,"down")}));this.h(this.lf);this.cj=this.gh=null;this.Zd=I(this);this.gr=I(this);this.Hf=new he(this.Oq);z(this,this.Hf,"tick",this.Bq,this);z(this,this,Ze,this.Do,
this,ff);z(this,this.Rf,Ze,this.Fq,this,ff);z(this,this.Oa,Ze,this.dl,this,ff);z(this,this.lf,Ze,this.pq,this,ff);z(this,document.body,$e,this.uq,this)}le(a){pi(this,a)}Ic(){return this.cq}scale(){return this.Zg}setScale(a){this.wm(a)}ig(a,b,c,d=0){this.jb=a;this.ud=b;this.oc=c;this.hl=d;ti(this);this.le(this.Da)}Do(){}Fq(a){a.preventDefault();a=-this.Ic();pi(this,this.Da+a);ri(this,this.Rf,-this.Ic())}pq(a){a.preventDefault();a=this.Ic();pi(this,this.Da+a);ri(this,this.lf,this.Ic())}Xn(){Sc(this,
this.gh,"mouseover",this.Gn,this);Sc(this,this.gh,"mouseout",this.Fn,this);Sc(this,document,$e,this.Xn,this);this.Hf.stop();this.cj=null}Gn(){this.Hf.start()}Fn(){this.Hf.stop()}Bq(){this.cj&&this.cj()}dl(a){this.gr.i();a.preventDefault();z(this,document.body,af,this.Qi,this);this.Dl(!0)}Dl(a){this.Oa.aa("active",a)}uq(){Sc(this,document.body,af,this.Qi,this);this.Dl(!1)}Qi(){}ja(){ti(this)}};function ti(a){const b=a.height()-a.Rf.height()-a.lf.height();a.Oa.ta(0==a.oc-a.ud?b:Math.max(a.fq,Math.ceil(a.jb/(a.oc-a.ud+a.jb)*b)));qi(a)}function qi(a){const b=ui(a);0==a.oc-a.ud?a.Oa.Lc(b.top):a.Oa.Lc(b.top+Math.round((a.Da-a.ud)/(a.oc-a.ud)*b.height));a.Rf.Ra(!!a.Da);a.lf.Ra(a.Da!=a.oc)}function ui(a){const b=new od(0,0,0,0);b.top=a.Rf.height();b.height=a.height()-a.lf.height()-a.Oa.height()-b.top;b.left=a.Oa.x();return b}
class vi extends si{constructor(a){super(a);this.tn=0}Do(a){var b;if(b=!a.defaultPrevented)b=this.Oa.displayObject().getBoundingClientRect(),b=!(a.clientY>=b.top&&a.clientY<=b.top+b.height);if(b){b=this.displayObject().getBoundingClientRect();var c=ui(this),d=0==this.hl?this.jb:this.hl;a=(a.clientY-(b.top-c.top))/this.Zg<=this.Oa.y()?-d:d;this.le(this.Da+a)}}dl(a){super.dl(a);const b=this.Oa.displayObject().getBoundingClientRect();this.tn=a.clientY-Math.round(b.top);this.Qi(a)}Qi(a){const b=this.displayObject().getBoundingClientRect(),
c=ui(this);pi(this,(a.clientY-b.top-c.top*this.Zg-this.tn)/(c.height*this.Zg)*(this.oc-this.ud)+this.ud)}};function wi(a,b){Nc.call(this);a=this.Fh=a;a=ba(a)&&1==a.nodeType?this.Fh:this.Fh?this.Fh.body:null;this.Rr=!!a&&"rtl"==Md(a);this.Uo=x(this.Fh,qb?"DOMMouseScroll":"mousewheel",this,b)}r(wi,Nc);
wi.prototype.handleEvent=function(a){var b=0,c=0,d=a.Qa;"mousewheel"==d.type?(a=xi(-d.wheelDelta),void 0!==d.wheelDeltaX?(b=xi(-d.wheelDeltaX),c=xi(-d.wheelDeltaY)):c=a):(a=d.detail,100<a?a=3:-100>a&&(a=-3),void 0!==d.axis&&d.axis===d.HORIZONTAL_AXIS?b=a:c=a);"number"===typeof this.Vo&&(b=Ca(b,-this.Vo,this.Vo));"number"===typeof this.Wo&&(c=Ca(c,-this.Wo,this.Wo));this.Rr&&(b=-b);b=new yi(a,d,b,c);this.dispatchEvent(b)};function xi(a){return rb&&(sb||ub)&&0!=a%40?a:a/40}
wi.prototype.dc=function(){wi.W.dc.call(this);Lc(this.Uo);this.Uo=null};function yi(a,b,c,d){hc.call(this,b);this.type="mousewheel";this.detail=a;this.deltaX=c;this.deltaY=d}r(yi,hc);var zi=new ec;function Ai(a){a.Qp&&a.fd(a.yo||a.Wk?.5:0)}function Bi(a,b){z(a,new wi(b.displayObject(),{passive:!0}),zi,c=>{!qe(c.Qa)&&c.deltaY&&(c=0<c.deltaY?a.Ic():-a.Ic(),a.le(a.Da+c))},a)}
class Ci extends vi{constructor({X:a,Ic:b,Lj:c,Pr:d,bp:f=null}){super({X:a,Ic:b});this.Ef=c;this.Wk=this.yo=!1;this.Qp=d;this.ih=f;c.xa("overflow","hidden");A(this,this.Zd,()=>{c.displayObject().scrollTop=this.Da});z(this,c,"scroll",()=>{this.le(c.displayObject().scrollTop)},this);this.ih?Bi(this,this.ih):(Bi(this,this.Ef),Bi(this,this));d?(this.fd(0),this.ih?(z(this,this.ih,"mouseenter",this.cl,this),z(this,this.ih,"mouseleave",this.bl,this)):(z(this,this.Ef,"mouseover",this.cl,this),z(this,this,
"mouseover",this.cl,this),z(this,this.Ef,"mouseout",this.bl,this),z(this,this,"mouseout",this.bl,this))):this.fd(1)}ig(a,b,c,d=0){this.ip(0<c);super.ig(a,b,c,d)}Cj(){this.le(this.Ef.displayObject().scrollTop)}Dl(a){this.yo=a;Ai(this)}cl(a){a&&(this.contains(a.relatedTarget)||this.Ef.contains(a.relatedTarget))||(this.Wk=!0,Ai(this))}bl(a){a&&(null==a.relatedTarget||this.contains(a.relatedTarget)||this.Ef.contains(a.relatedTarget))||(this.Wk=!1,Ai(this))}};class Di extends T{constructor(a){super({X:a});a=new T({M:R(this,"thumb")});P(this,a)}}class Ei{constructor(a,b){this.qd=a;this.Zd=b}scrollY(){const a=this.qd.getComputedPosition().y;return isNaN(a)?0:-a}Ij(){return this.Zd}Sj(a){this.scrollY()!=a&&this.qd.scrollTo(0,-a)}}class Fi extends K{constructor(a){super();this.j=a;this.Vg=I(this);z(this,a,"scroll",()=>{this.Vg.i()})}scrollY(){return this.j.scrollTop}Ij(){return this.Vg}Sj(a){this.j.scrollTop=a}}
class Gi extends K{constructor({X:a="vertical-scrollbar",Os:b="mobile-vertical-scrollbar",Lj:c,Ws:d,Es:f,bp:g=null,Ic:h=20,preventDefault:l=!0}){super();this.Ba=this.qd=null;this.Co=d||null;this.Lm=f||null;this.oc=0;if(L){const m=I(this);a={fadeScrollbars:!0,scrollX:!1,scrollY:!0,bounce:!1,deceleration:.006,useTransition:!1,preventDefault:l,disablePointer:!0,disableTouch:!1,disableMouse:!1,onScrollHandler:()=>{m.i()}};b=new Di(b);a.indicators={el:b.displayObject(),shrink:"scale"};this.qd=new IScroll(c.displayObject(),
a);this.R=new Ei(this.qd,m)}else this.Ba=B(this,new Ci({X:a,Ic:h,Lj:c,Pr:!0,bp:g})),this.R=new Fi(c.displayObject()),b=this.Ba;A(this,this.R.Ij(),this.Rn,this);this.eo=b}Kc(){return this.R}ig(a,b){this.oc=Math.max(0,b-a);this.qd?this.qd.setScrollHeight(b):this.Ba&&this.Ba.ig(a,0,Math.max(this.oc,0));this.Rn()}wm(a){this.Ba&&this.Ba.wm(a)}Cj(){this.Ba&&this.Ba.Cj()}Rn(){if(this.Co){var a=Math.min(this.Kc().scrollY(),60);this.Co.style.height=Pd(a)}this.Lm&&(a=this.oc-this.Kc().scrollY(),this.Lm.style.height=
Pd(Math.min(a,60)))}Md(){super.Md();this.qd&&this.qd.destroy()}};class Hi extends K{constructor(a){super();this.j=a;this.Vg=I(this);z(this,this.j,"scroll",()=>{this.Vg.i()})}scrollY(){return this.j.scrollTop}Ij(){return this.Vg}Sj(a){this.j.scrollTop=a}}function Ii(a){const b=Ji(a.kb);a.yh.forEach((c,d)=>{0>b.indexOf(d)&&(a.yh.delete(d),a.Ld.removeChild(c),Xc(a,c))});for(let c=0;c<b.length;++c){const d=b[c];let f;a.yh.has(d)?f=a.yh.get(d):(f=a.Sm(d),B(a,f),a.yh.set(d,f));a.Ld.qj(f,c);f.ta(a.kb.uf)}a.R.Sj(a.kb.Da)}
class Ki extends T{constructor({X:a,Zo:b,me:c,Gs:d}){super({X:a,me:c,tabIndex:-1});this.yh=new Map;this.Rm=d||this;this.Ld=new T;P(this.Rm,this.Ld);this.Hd(new Hi(this.Rm.displayObject()));this.kb=b;A(this,this.kb.re,this.Aq,this)}Kc(){return this.R}Hd(a){Xc(this,this.R);this.R=a;B(this,this.R);A(this,this.R.Ij(),()=>{document.body.contains(this.displayObject())&&this.kb.le(this.R.scrollY())})}ja(){var a=this.displayObject();var b=td(a),c=v&&a.currentStyle;if(c&&"CSS1Compat"==rd(b).Zf.compatMode&&
"auto"!=c.width&&"auto"!=c.height&&!c.boxSizing)b=Rd(a,c.width,"width","pixelWidth"),a=Rd(a,c.height,"height","pixelHeight"),a=new G(b,a);else{c=Qd(a);if(v){b=Sd(a,"paddingLeft");var d=Sd(a,"paddingRight"),f=Sd(a,"paddingTop"),g=Sd(a,"paddingBottom");b=new kd(f,d,g,b)}else b=Ld(a,"paddingLeft"),d=Ld(a,"paddingRight"),f=Ld(a,"paddingTop"),g=Ld(a,"paddingBottom"),b=new kd(parseFloat(f),parseFloat(d),parseFloat(g),parseFloat(b));!v||9<=Number(Hb)?(d=Ld(a,"borderLeftWidth"),f=Ld(a,"borderRightWidth"),
g=Ld(a,"borderTopWidth"),a=Ld(a,"borderBottomWidth"),a=new kd(parseFloat(g),parseFloat(f),parseFloat(a),parseFloat(d))):(d=Ud(a,"borderLeft"),f=Ud(a,"borderRight"),g=Ud(a,"borderTop"),a=Ud(a,"borderBottom"),a=new kd(g,f,a,d));a=new G(c.width-a.left-b.left-b.right-a.right,c.height-a.top-b.top-b.bottom-a.bottom)}c=this.kb;c.Re=isNaN(a.height)?0:a.height;Li(c)}Aq(){this.aa("with-scroll",this.kb.Oe>this.kb.Re);this.Ld.ta(this.kb.Oe);this.R.Sj(this.kb.Da);this.Ld.xa("padding-top",this.kb.Ek+"px");Ii(this)}}
;function Ji(a){return a.Hi.slice(a.Ai,a.Ai+a.jn)}function Mi(a,b,c){c&&(a.uf=c);a.Hi=b;a.Oe=a.uf*b.length;a.rd()}function Li(a){a.Da=Ag(a.Da,0,Math.max(a.Oe-a.Re,0));a.rd()}
class Ni extends K{constructor(){super();this.uf=this.Oe=this.Re=this.Da=0;this.Hi=[];this.jn=this.Ai=this.Ek=0;this.re=I(this)}invalidate(){this.rd()}le(a){void 0!==this.Re&&this.Da!=a&&(this.Da=a,Li(this))}rd(){this.Ai=Math.floor(Math.max(0,this.Da-(L?this.Re:0))/this.uf);this.Ek=this.uf*this.Ai;this.jn=Math.ceil((Math.min(this.Oe,this.Da+this.Re+(L?this.Re:0))-this.Ek)/this.uf);this.re.i()}};class Oi extends T{constructor(a,b){super(b);this.Wp=a}item(){return this.Wp}};function Pi(a,b){a=new Date(a);b=new Date(b);return Math.floor((new Date(a.getFullYear(),a.getMonth(),a.getDate())-new Date(b.getFullYear(),b.getMonth(),b.getDate()))/864E5)}class Qi{constructor({hs:a,Ur:b,Qr:c,days:d,Vr:f,vs:g,Cr:h}){this.Nq=a;this.gq=b;this.Rp=c;this.Gp=d;this.hq=f;this.vr=g;this.vp=h}};class Ri extends Oi{constructor(a,b){super(a,{X:"bookmarks-item-view"});this.xl=b;this.yb=new T({M:R(this,"title")});this.h(this.yb);this.yb.V(a.title());this.za=new T({M:R(this,"page-number")});this.h(this.za);this.za.V(a.pageNumber().toString());this.zo=new T({M:R(this,"time-passed")});this.h(this.zo);b=this.zo;var c=b.V;a:{var d=this.xl;var f=Date.now();a=a.creationTime();const h=f-a;if(6E4>h)d=d.Nq;else{var g=Pi(f,a);if(1==Pi(f,a))d=d.vr;else{if(36E5>h)f=`${Math.floor(h/6E4)} ${d.gq}`;else if(864E5>
h)f=`${Math.floor(h/36E5)} ${d.Rp}`;else if(7>g)f=`${g} ${d.Gp}`;else{f=new Date(a);d=`${f.getDate()} ${d.hq[f.getMonth()]} ${f.getFullYear()}`;break a}d=`${f} ${d.vp}`}}}c.call(b,d)}};class Si extends Ki{constructor(a,b){const c=new Ni;super({X:"bookmarks-list-view",Zo:c});B(this,c);this.ba=a;this.xl=new Qi({hs:this.ba.ka("PB_RECENTLY_ADDED"),Ur:this.ba.ka("PB_MINUTES_LABEL"),Qr:this.ba.ka("PB_HOURS_LABEL"),days:this.ba.ka("PB_DAYS_LABEL"),Vr:this.ba.ka("PB_MONTH_LABELS").split("|"),vs:this.ba.ka("PB_YESTERDAY_LABEL"),Cr:this.ba.ka("PB_AGO_LABEL")});this.hb=b;this.Ba=new Gi({Lj:this});B(this,this.Ba);this.h(this.Ba.eo);this.ac=I(this);(a=this.Ba.Kc())&&this.Hd(a);Mi(this.kb,this.hb.zb(),
70)}Sm(a){const b=new Ri(a,this.xl);A(this,b.H,()=>this.ac.i(a.pageNumber()),this);return b}ja(a,b){super.ja(a,b);a&&b&&this.Ik(b)}Ik(a){this.Ba&&(this.Ba.ig(a,this.kb.Oe),this.Ba.Cj())}};class Ti extends T{constructor(a,b){super({X:"bookmarks-view"});this.ba=a;a=new T({X:"add-bookmark-container"});Tf(a,R(this,"add-bookmarks"));var c=new T({M:R(a,"header")});c.V(this.ba.ka("PB_ADD_BOOKMARK_HEADER"));a.h(c);c=new T({M:R(a,"text")});c.V(this.ba.ka("PB_ADD_BOOKMARK_TEXT"));a.h(c);this.ak=a;this.h(this.ak);this.zc=new Si(this.ba,b);Tf(this.zc,R(this,"bookmarks-list"));P(this,this.zc);this.ac=I(this,this.zc.ac);this.aa("without-bookmarks",!b.zb().length)}invalidate(a){Uf(this);a=(this.height()-
a-this.ak.height())/2;this.ak.Lc(a)}ja(a,b){super.ja(a,b);Uf(this.zc)}Nj(){}};const Ui={outline:"PB_OUTLINE_TAB",bookmarks:"PB_BOOKMARKS_TAB"};function Vi(a){["outline","bookmarks"].forEach(b=>{const c=new T({M:R(a,"tab"),cp:!0});P(a,c);A(a,c.H,()=>Wi(a,b),a);c.V(a.ba.ka(Ui[b]));a.xo.set(b,c);c.ai(b==a.ni)})}function Wi(a,b){a.ni!=b&&(a.ni=b,a.xo.forEach((c,d)=>{c.ai(d==b)}),a.wo.i())}class Xi extends T{constructor(a){super({X:"popup-tabs"});this.ba=a;this.wo=I(this);this.ni="outline";this.xo=new Map;Vi(this)}};class Yi{constructor({label:a,Yr:b,jm:c,selected:d}){this.Pk=a;this.za=b;this.Vp=c;this.Xq=d}label(){return this.Pk}pageNumber(){return this.za}jm(){return this.Vp}selected(){return this.Xq}};function Zi(a,b,c){function d(){l=h<b.length?b.substr(0,h)+"\u2026":b;f.V(l)}a.vh=!1;const f=a;f.V(b);if(void 0!==c&&a.displayObject().parentNode){f.displayObject().style.height="";var g=f.displayObject().scrollHeight;g=v?--g:g;if(!(c>=g)&&(a.vh=!0,a.tr)){var h=Math.floor(c/f.displayObject().scrollHeight*b.length),l="";for(d();f.displayObject().scrollHeight<=c;)h+=10,d();for(;0<h&&f.displayObject().scrollHeight>c;)d(),--h;d()}}}
class $i extends T{constructor({M:a,X:b,Xs:c=!0,me:d=!0,Ys:f=!0}){super({M:a,X:b,me:d});this.sr=c;this.tr=f;this.Fk=this.vh=!1;this.kr=I(this)}ja(a,b){super.ja(a,b);this.Fk=!0;a=this.vh;const c=this.displayObject().textContent;Zi(this,c,ob||v?b+1:b);this.Fk=!1;a!=this.vh&&(this.sr&&this.setAttribute("title",this.vh?Mf(this.j,"label"):""),this.kr.i())}V(a){super.V(a);this.Fk||(this.hg(a),Uf(this))}Xh(){throw Error("html text is not supported");}};class aj extends Oi{constructor(a){super(a,{X:"outline-item-view",cp:!0});this.yb=new $i({M:R(this,"title")});this.h(this.yb);this.yb.V(a.label());this.za=new T({M:R(this,"page-number")});this.h(this.za);this.za.V(a.pageNumber().toString());this.aa("subitem",a.jm());this.ai(a.selected())}ja(a,b){super.ja(a,b);a&&b&&(a=(b-1-this.yb.height())/2,this.yb.Lc(a))}};function bj(a,b,c){const d=b.find((g,h)=>{if(h==b.length-1)return!0;const l=g.pageNumber()<=a&&b[h+1].pageNumber()>a;return h?l:g.pageNumber()>=a||l}),f=d.items();return c?d.pageNumber()>a?null:d:f&&f.length?bj(a,f,!0)||d:d};function cj(a,b,c,d){let f=[];for(const g of b)f.push(new Yi({label:g.label(),Yr:g.pageNumber(),jm:c,selected:g==d})),(b=g.items())&&!c&&f.push(...cj(a,b,!0,d));return f}function dj(a,b,c){a.fn=b.some(d=>(d=d.items())&&!!d.length);c=bj(c,b,!1);a.fl=cj(a,b,!1,c);Mi(a.kb,a.fl,60)}
class ej extends Ki{constructor(){var a=new Ni;super({X:"outline-list-view",Zo:a});B(this,a);this.Ba=new Gi({Lj:this});B(this,this.Ba);this.h(this.Ba.eo);this.fn=!1;this.fl=[];this.ac=I(this);a=this.Ba.Kc();this.Hd(a)}Nj(){const a=this.fl.findIndex(b=>b.selected());this.kb.le(60*(a-2))}Sm(a){const b=new aj(a);b.aa("has-subitems",this.fn);A(this,b.H,()=>this.ac.i(a.pageNumber()),this);return b}ja(a,b){super.ja(a,b);a&&b&&this.Ik(b)}Ik(a){this.Ba&&(this.Ba.ig(a,this.kb.Oe),this.Ba.Cj())}};class fj extends T{constructor(a,b,c){super({X:"outline-view"});this.ba=a;this.Oi=new T({M:R(this,"no-outline-label")});this.h(this.Oi);this.Oi.V(this.ba.ka("PB_NO_OUTLINE"));this.zc=new ej;Tf(this.zc,R(this,"outline-list"));this.h(this.zc);this.ac=I(this,this.zc.ac);b&&dj(this.zc,b,c);this.aa("without-outline",!b)}invalidate(a){Uf(this);a=(this.height()-a-this.Oi.height())/2;this.Oi.Lc(a)}Nj(){this.zc.Nj()}ja(a,b){super.ja(a,b);Uf(this.zc)}};class gj extends T{constructor(a,b){super({X:"popup-panel"});this.ba=a;this.hb=b;this.F=0;this.Uc=new T({X:"popup-menu"});Tf(this.Uc,R(this,"popup-menu"));P(this,this.Uc);this.Bo=new T({M:R(this.Uc,"title")});this.Uc.h(this.Bo);this.bh=new Xi(a);P(this.Uc,this.bh);A(this,this.bh.wo,this.Zk,this);this.Pm=new T({M:R(this.Uc,"close-button")});P(this.Uc,this.Pm);A(this,this.Pm.H,()=>this.Qm.i(),this);this.hk=new T({M:R(this,"content-view")});this.h(this.hk);this.Xg=this.nd=null;this.Qm=I(this);this.ac=
I(this);this.Zk()}Yh(a){this.Xg=a}B(a){this.F=a}$h(a){this.Bo.V(a||"")}ja(a,b){super.ja(a,b);this.aa("landscape",ka());this.bh.aa("landscape",ka());this.Uc.aa("landscape",ka());this.nd.invalidate(this.Uc.height())}Zk(){var a=this.bh.ni;this.nd&&(this.hk.removeChild(this.nd),Xc(this,this.nd));switch(a){case "outline":a=new fj(this.ba,this.Xg,this.F);B(this,a);A(this,a.ac,this.In,this);this.nd=a;break;case "bookmarks":a=new Ti(this.ba,this.hb);B(this,a);A(this,a.ac,this.In,this);this.nd=a;break;default:throw Error("unknown tab type");
}this.hk.h(this.nd);this.nd.invalidate(this.Uc.height());this.nd.Nj()}In(a){this.ac.i(a)}};class hj extends T{constructor(a){super({X:a});this.I=new T({M:R(this,"current-page"),Uf:"SPAN"});this.h(this.I);this.I.V("0");a=new T({M:R(this,"separator"),Uf:"SPAN"});this.h(a);a.Xh("&nbsp/&nbsp");this.Z=new T({M:R(this,"pages-count"),Uf:"SPAN"});this.h(this.Z);this.Z.V("0")}B(a){this.I.V(a.toString())}ua(a){this.Z.V(a.toString())}};function ij(a,b){const c=a.ef.j.getBoundingClientRect();a=a.ef.displayObject();b=Od(b);a=Od(a);return Ca((new E(b.x-a.x,b.y-a.y)).x/c.width,0,1)}
class jj extends T{constructor(){super({X:"seek-bar"});this.ef=new T({M:R(this,"background")});this.h(this.ef);this.Pn=new T({M:R(this,"progress")});this.ef.h(this.Pn);this.Oa=new T({M:R(this,"thumb")});this.ef.h(this.Oa);this.Z=this.Ub=0;this.fo=I(this);this.ro=I(this);this.Ym=I(this);z(this,this.displayObject(),Ze,this.Dq,this,ef)}Ea(){return Math.min(Math.ceil(this.Ub*(this.Z-1))+1,this.Z)}ua(a){this.Z=a}B(a){this.Ub=1==this.Z?1:(a-1)/(this.Z-1);this.rd()}ja(a,b){super.ja(a,b);this.rd();this.aa("landscape",
ka())}Dq(a){this.enabled()&&(z(this,document,af,this.zn,this),z(this,document,$e,this.An,this),this.Ub=ij(this,a),this.rd(),this.Oa.aa("dragged",!0),this.ro.i(),a.preventDefault())}zn(a){this.Ub=ij(this,a);this.rd();this.fo.i();a.preventDefault()}An(a){Sc(this,document,af,this.zn,this);Sc(this,document,$e,this.An,this);this.Ub=ij(this,a);this.rd();this.Oa.aa("dragged",!1);this.Ym.i();a.preventDefault()}rd(){const a=this.ef.width();this.Oa.xa("transform",`translateX(${this.Ub*a}px)`);this.Pn.ca(this.Ub*
a)}};class kj extends T{constructor(a){super({X:"bottom-toolbar"});this.Fe=a;this.Ce=new hj("pages-count");Tf(this.Ce,R(this,"pages-count"));this.h(this.Ce);this.zd=new jj;P(this,this.zd);A(this,this.zd.ro,this.Hn,this);A(this,this.zd.fo,this.Hn,this);A(this,this.zd.Ym,this.Cq,this);this.Z=0;this.Wc=I(this)}Bb(){return this.Wc}Ea(){return this.zd.Ea()}B(a){this.Ce.B(a);this.zd.B(a)}ua(a){this.Z=a;this.Ce.ua(a);this.zd.ua(a)}Hn(){var a=this.Fe,b=this.zd.Ea(),c=this.Z;lj(a);const d=!a.Lb;a.Lb||(a.Lb=new hj("pages-count-popup"),
a.Qf.appendChild(a.Lb.displayObject()));a.Lb.B(b);a.Lb.ua(c);b=(a.g.width()-a.Lb.width())/2;c=a.g.height()-a.g.fb()-58;a.Lb.xa("transform",`translate(${b}px, ${c}px)`);d&&(a.Lb.fd(0),(new mj(a.Lb,150,!1)).play())}Cq(){nj(this.Fe);this.Wc.i()}ja(a,b){super.ja(a,b);Uf(this.zd)}};class mj extends X{constructor(a,b,c){super([0],[1],b);this.ue=a;this.Up=c}ob(a){a=Hh(a[0]);this.Up?this.ue.fd(1-a):this.ue.fd(a)}};class oj extends X{constructor(a,b){super([0],[1],350,Lh);this.qa=a;this.xd=b}ob(a){a=Ih(a[0]);this.qa.xa("transform",`translateY(${this.qa.height()*a}px)`);this.xd.fd(1-a)}yd(){this.qa.xa("transform","")}};class pj extends X{constructor(a,b){super([0],[1],350,Kh);this.qa=a;this.xd=b}play(){this.qa.xa("top","");return super.play()}ob(a){a=Ih(a[0]);this.qa.xa("transform",`translateY(${this.qa.height()*(1-a)}px)`);this.xd.fd(a)}yd(){this.qa.xa("transform","")}};function nj(a){lj(a);a.Ci=setTimeout(()=>{if(a.Lb){var b=new mj(a.Lb,250,!0);a.Bi=A(a,b.ma,()=>{lj(a);a.Qf.removeChild(a.Lb.displayObject());a.Lb=null;a.Ci=null});b.play()}},500)}function lj(a){null!=a.Bi&&(Qc(a,a.Bi),a.Bi=null);a.Ci&&clearTimeout(a.Ci)}
class qj extends K{constructor({rs:a,view:b,cs:c}){super();this.Qf=a;this.g=b;this.xd=new T({X:"popup-layer"});this.qa=c;this.xd.h(this.qa);A(this,this.qa.Qm,this.Ro,this);A(this,this.qa.ac,this.Ro,this);this.Ci=this.Bi=this.Lb=null}Ro(){const a=new oj(this.qa,this.xd);Vc(this,a.ma,()=>{this.Qf.removeChild(this.xd.displayObject());this.Qf.removeChild(this.qa.displayObject())},this);a.play()}};class rj extends T{constructor({M:a,X:b,Po:c,$o:d,Lo:f,tabIndex:g,Vs:h,toggle:l,me:m}){super({M:a,X:b,Po:c,$o:d,Lo:f,tabIndex:g,Uf:"BUTTON",Br:!0,me:m});h&&(a=h.top,b=h.right,c=h.bottom,h=h.left,this.Yc=new T,P(this,this.Yc),this.Yc.xa("position","absolute"),this.Yc.xa("top",a?`${-a}px`:0),this.Yc.xa("right",b?`${-b}px`:0),this.Yc.xa("bottom",c?`${-c}px`:0),this.Yc.xa("left",h?`${-h}px`:0));(this.hr=l)&&this.Fd("pressed",!1);this.Gm()}selected(){return!1}ai(){}pressed(){return"true"==Mf(this.j,"pressed")}V(a){super.V(a);
this.Yc&&this.qj(this.Yc,0)}Xh(a){super.Xh(a);this.Yc&&this.qj(this.Yc,0)}};function sj(a,b){const c=b.zb().findIndex(d=>d.pageNumber()==a);tj(b,c)}function uj({pageNumber:a,zb:b,outline:c,Hc:d}){c=c?bj(a,c,!1).label():d.ka("PB_PAGE_LABEL").replace("%PAGE_NUMBER%",a.toString());b.hb.splice(0,0,new Wg({title:c,pageNumber:a,creationTime:Date.now()}));b.re.i()};function vj(a){const b=a.hb.zb().some(c=>c.pageNumber()==a.F);a.tg.Fd("pressed",b)}
class wj extends T{constructor({bs:a,zb:b,Hc:c}){super({X:"top-toolbar"});this.Fe=a;this.hb=b;this.ba=c;this.Xg=null;this.F=0;a=new T({M:R(this,"container")});a.aa("position","left");P(this,a);Ue&&(b=new rj({M:R(this,"close-window-button")}),P(a,b),A(this,a.H,this.oq,this),this.aa("mobile-app",!0));this.Ao=new T({M:R(this,"title")});a.h(this.Ao);this.dj=new T({M:R(this,"container")});this.dj.aa("position","right");P(this,this.dj);this.lo=new rj({M:R(this,"show-popup-button")});P(this.dj,this.lo);
this.tg=new rj({M:R(this,"bookmark-button"),toggle:!0});A(this,this.tg.H,this.mq,this);P(this.dj,this.tg);A(this,this.lo.H,()=>{var d=this.Fe;d.Qf.appendChild(d.xd.displayObject());d.Qf.appendChild(d.qa.displayObject());const f=new pj(d.qa,d.xd);d=d.qa;Wi(d.bh,"outline");d.Zk();f.play()})}Yh(a){this.Xg=a}$h(a){this.Ao.V(a)}B(a){this.F=a;vj(this)}mq(){const a=this.tg.pressed();a?sj(this.F,this.hb):uj({pageNumber:this.F,zb:this.hb,outline:this.Xg,Hc:this.ba});this.tg.Fd("pressed",!a)}oq(){var a=new je("closeWindow");
if(Qe){var b=a.pr,c=a.yp;a=a.id();var d=Ja(c,null);if(de)c=p.btoa(d);else{c=[];for(var f=0,g=0;g<d.length;g++){var h=d.charCodeAt(g);255<h&&(c[f++]=h&255,h>>=8);c[f++]=h}d=void 0;void 0===d&&(d=0);ge();d=be[d];f=Array(Math.floor(c.length/3));g=d[64]||"";let q=0;for(h=0;q<c.length-2;q+=3){var l=c[q],m=c[q+1],k=c[q+2],n=d[l>>2];l=d[(l&3)<<4|m>>4];m=d[(m&15)<<2|k>>6];k=d[k&63];f[h++]=""+n+l+m+k}n=0;k=g;switch(c.length-q){case 2:n=c[q+1],k=d[(n&15)<<2]||g;case 1:c=c[q],f[h]=""+d[c>>2]+d[(c&3)<<4|n>>4]+
k+g}c=f.join("")}ke("isplayer://"+b+"/"+a+"/"+c)}}};function eh(a){a.removeChild(a.wf)}function xj(a,b){a.fd(b?1:0);a.aa("hidden",!b)}function yj(a){a.Cb.Ra(!1);a.Qb.Ra(!1);xj(a.Cb,!1);xj(a.Qb,!1)}
class zj extends V{constructor({width:a,height:b,Hc:c,zb:d}){super(["mainContainer","mobile"]);this.ca(a);this.ta(b);this.qa=new gj(c,d);this.qa.ac.addHandler(f=>this.Wc.i(f),this);this.Fe=new qj({rs:document.body,view:this,cs:this.qa});this.wf=new V("loaderIcon");this.h(this.wf);this.ga=new V("viewerContainer mobile");this.h(this.ga);this.Qb=new wj({bs:this.Fe,Hc:c,zb:d});this.h(this.Qb);this.Cb=new kj(this.Fe);this.h(this.Cb);this.Cb.Bb().addHandler(()=>{const f=this.Cb.Ea();this.Wc.i(f)});this.Ad=
new D;this.Dc=new D;this.Wc=new D;this.ve=new D}fb(){return this.Cb.height()}ua(a){this.Cb.ua(a)}B(a){this.Cb.B(a);this.Qb.B(a);this.qa.B(a)}gb(){return new w(this.width(),this.height())}Ta(){return this.Ad}Sa(){return this.Dc}Bb(){return this.Wc}Rb(){return this.ve}ym(){}ed(){}dd(){}wj(a){Ue?(this.Qb.aa("above-auth-popup",a),this.Qb.Ra(!0),xj(this.Qb,!0)):(this.Qb.Ra(!a),xj(this.Qb,!a));this.Cb.Ra(!a);xj(this.Cb,!a)}cd(){}Yh(a){this.qa.Yh(a);this.Qb.Yh(a)}$h(a){this.qa.$h(a);this.Qb.$h(a)}invalidate(){const a=
ka();this.Cb.aa("landscape",a);this.Qb.aa("landscape",a);this.qa.aa("landscape",a);window.requestAnimationFrame(()=>{Uf(this.qa);Uf(this.Cb)})}};function Aj(a){switch(a.keyCode){case 61:case 107:case 187:case 171:return!0;case 173:case 109:case 189:return!0;case 48:case 96:return!0}return!1}function Bj(a,b){switch(b.keyCode){case 8:case 37:return a.Ad.i(),!0;case 32:case 39:return a.Dc.i(),!0;case 36:return a.Wc.i(1),!0;case 35:return a.Wc.i(a.Z),!0;case 38:case 40:return v}return!1}
class Cj extends K{constructor(){super();x(window,"keydown",this.xe,!1,this);this.Z=0;this.Ad=I(this);this.Dc=I(this);this.Wc=I(this);this.ve=I(this);this.Jk=!1}ua(a){this.Z=a}Ta(){return this.Ad}Sa(){return this.Dc}Rb(){return this.ve}Bb(){return this.Wc}xe(a){if(this.Jk)a.preventDefault();else{var b=(a.ctrlKey?1:0)|(a.altKey?2:0)|(a.shiftKey?4:0)|(a.metaKey?8:0);if(1!==b&&8!==b||!Aj(a)){var c;if(c=4===b)a:{switch(a.keyCode){case 32:this.Ad.i();c=!0;break a}c=!1}if(c)a.preventDefault();else{if(!(c=
3!==b&&10!==b)){a:{switch(a.keyCode){case 70:this.ve.i();c=!0;break a}c=!1}c=!c}c?0===b&&Bj(this,a)&&a.preventDefault():a.preventDefault()}}else a.preventDefault()}}Md(){super.Md();y(window,"keydown",this.xe,!1,this)}};function Dj(){this.pl=new D}e=Dj.prototype;e.rh=null;e.Wd=null;e.Pe=!1;
e.yj=function(a,b){if("touchEnd"==a)return this.Pe&&this.rh&&this.Wd?this.Eo(this.Wd,this.rh)?1:0:0;if(1!=b.touches().length||pe(b.Od))return this.Pe=!1,0;const c=new E(b.touches()[0].screenX(),b.touches()[0].screenY());if("touchStart"==a){if(qe(b.Od))return this.Pe=!1,0;this.rh=this.Wd=c;this.Pe=!0;return 0}if(!this.Pe||!this.rh||!this.Wd)return 0;(this.Pe=this.rh==this.Wd?this.Fo(c,this.Wd):this.Go(c,this.Wd))&&b.Od.preventDefault();this.Wd=c;return 0};e.sj=function(){this.pl.i()};e.he=function(){};class Ej extends Dj{Hh(){return"scrollRight"}Go(a,b){return a.x+20>=b.x}Fo(a,b){return a.x-b.x>=Math.abs(a.y-b.y)}Eo(a,b){const c=a.x-b.x;return 80<c&&.7*c>=Math.abs(a.y-b.y)}};class Fj extends Dj{Hh(){return"scrollLeft"}Go(a,b){return a.x-20<=b.x}Fo(a,b){return b.x-a.x>=Math.abs(a.y-b.y)}Eo(a,b){const c=b.x-a.x;return 80<c&&.7*c>=Math.abs(a.y-b.y)}};function Gj(){this.ao=new D;this.$n=new D;this.ol=new D;this.Dg=new D;this.oo=this.Pg=null;this.nl=!1}e=Gj.prototype;e.Qg=-1;e.Ei=0;e.Hh=function(){return"scale"};e.yj=function(a,b){a=2==b.touches().length;const c=!a&&0<this.Qg;a!=this.nl&&(this.nl||(this.oo=Hj(b),this.ao.i()),this.nl=a);return a||c?1:0};
e.sj=function(a){if(2==a.touches().length){var b=Hj(a);if(this.Pg&&b){var c=jd(b.xj,this.Pg.xj);const d=jd(b.Oj,this.Pg.Oj),f=0>c.x&&0>d.x||0<c.x&&0<d.x;(0>c.y&&0>d.y||0<c.y&&0<d.y||f)&&this.Dg.i(Math.abs(c.x)<Math.abs(d.x)?c.x:d.x,Math.abs(c.y)<Math.abs(d.y)?c.y:d.y)}this.Pg=b;b=a.scale();void 0===b&&(b=a.touches()[0],c=a.touches()[1],a=new E(b.clientX(),b.clientY()),c=new E(c.clientX(),c.clientY()),b=a.x-c.x,a=a.y-c.y,a=Math.sqrt(b*b+a*a),this.Ei?b=a/this.Ei:(b=1,this.Ei=a));a=b;this.$n.i(a);this.Qg=
a}else 0<this.Qg&&(this.ol.i(this.Qg),this.Pg=null,this.Qg=-1,this.Ei=0)};function Hj(a){a=a.touches();return 2!=a.length?null:{xj:new E(a[0].clientX(),a[0].clientY()),Oj:new E(a[1].clientX(),a[1].clientY())}}e.We=function(){return this.Dg};e.he=function(){};class Ij extends K{constructor(a){super();this.j=a;this.Ol=I(this);this.sd=!1;const b=new gf(a.displayObject());this.Ke=new Gj;A(this,this.Ke.ao,this.Qq,this);nf(b,this.Ke);this.Sg=this.de=null;this.zf=new gf(a.displayObject());const c=new Lg;nf(this.zf,c);this.fr=I(this,c.yi);this.wn=I(this);A(this,c.pk,this.tq,this);this.kq=I(this,c.We());hf(this.zf);this.mj=new of;nf(b,this.mj);this.an=I(this);A(this,this.mj.lj,this.Eq,this);A(this,this.mj.Vm,(d,f)=>{this.de&&(clearTimeout(this.de),this.de=null);
this.an.i(d,f)},this);hf(b);this.Ae=new gf(a.displayObject());a=new Fj;nf(this.Ae,a);this.Dc=I(this);A(this,a.pl,()=>{this.Sg&&clearTimeout(this.Sg);this.Dc.i(!0)});a=new Ej;nf(this.Ae,a);A(this,a.pl,()=>{this.Sg&&clearTimeout(this.Sg);this.Ad.i(!0)});this.Ad=I(this);hf(this.Ae);this.Nm=I(this);this.Sd=this.sd=!0}tq(){this.Sg=setTimeout(()=>{this.wn.i()},0)}We(){return this.Ke.We()}ng(){return this.Ke.$n}Ta(){return this.Ad}Sa(){return this.Dc}Qq(){const a=this.Ke.oo;this.Ol.i((a.xj.x+a.Oj.x)/2,(a.xj.y+
a.Oj.y)/2)}Eq(a){if(this.de)clearTimeout(this.de),this.de=null;else{var b=this.j.displayObject().getBoundingClientRect(),c=ka()?a>b.width-120:a>b.width-70,d=ka()?120>a:70>a;this.de=setTimeout(()=>{d?this.Ad.i(!1):c?this.Dc.i(!1):this.Nm.i();this.de=this.mj.Rk=null},d||c?300:500)}}};var Jj,Kj=rd().getDocument().documentElement;Jj=Kj.requestFullscreen?"fullscreenchange":Kj.webkitRequestFullscreen?"webkitfullscreenchange":Kj.mozRequestFullScreen?"mozfullscreenchange":Kj.msRequestFullscreen?"MSFullscreenChange":"fullscreenchange";function Lj(a){a.requestFullscreen?a.requestFullscreen(void 0):a.webkitRequestFullscreen?a.webkitRequestFullscreen():a.mozRequestFullScreen?a.mozRequestFullScreen():a.msRequestFullscreen&&a.msRequestFullscreen()}
function Mj(){var a=rd().getDocument();a.exitFullscreen?a.exitFullscreen():a.webkitCancelFullScreen?a.webkitCancelFullScreen():a.mozCancelFullScreen?a.mozCancelFullScreen():a.msExitFullscreen&&a.msExitFullscreen()};class Nj{constructor(){this.ve=new D;x(document,Jj,()=>{var a=this.ve,b=a.i,c=rd().getDocument();b.call(a,!!(c.webkitIsFullScreen||c.mozFullScreen||c.msFullscreenElement||c.fullscreenElement))},!1,this)}fp(a){a?(a=document.body,a.mozRequestFullScreenWithKeys?a.mozRequestFullScreenWithKeys():Lj(a)):Mj()}Rb(){return this.ve}};class Oj extends Nj{constructor(a){super();this.g=a;this.ue=a.displayObject();this.sk=this.Lk=!1;if(Qe||Pe||Le||De)a=0;else{a=rd().getDocument();var b=a.body;a=!!(b.webkitRequestFullscreen&&a.webkitFullscreenEnabled||b.mozRequestFullScreen&&a.mozFullScreenEnabled||b.msRequestFullscreen&&a.msFullscreenEnabled||b.requestFullscreen&&a.fullscreenEnabled)}a||this.g.cd();this.Rb().addHandler(this.pd,this)}toggle(){this.sk||(this.sk=!0,this.fp(!this.Lk))}fp(a){a?(a=this.ue,a.mozRequestFullScreenWithKeys?
a.mozRequestFullScreenWithKeys():Lj(a)):Mj()}pd(a){this.Lk=a;this.sk=!1;this.g.ed(this.Lk)}};var Pj=vc();Pj.qm=!1;class Qj extends K{constructor(){super();this.s=null;this.Qk=0;this.Ya=I(this)}Jj(){return this.Ya}};function tj(a,b){a.hb.splice(b,1);a.re.i()}class Rj extends K{constructor(){super();this.hb=[];this.re=I(this)}zb(){return this.hb.slice()}};function Sj(a,b,c){const d=new Rj;this.g=new zj({width:a.clientWidth,height:a.clientHeight,Hc:b.Hc(),zb:d});a.appendChild(this.g.ya);W.call(this,a,b,1,Pj,d,c);this.Eg=new Oj(this.g);this.oh=this.jf=this.Cc=0;this.pf=!1;this.Ti=!0;this.Nk=!1;this.ej=new E;this.Ma=new Cj;this.Ma.Ta().addHandler(this.Xc,this);this.Ma.Sa().addHandler(this.Vc,this);this.Ma.Bb().addHandler(this.ae,this);this.pa=new Ij(this.g.ga);this.pa.Ol.addHandler(this.Pl,this);this.pa.ng().addHandler(this.Ah,this);this.pa.Ke.ol.addHandler(this.Ll,
this);this.pa.Ta().addHandler(this.Xc,this);this.pa.fr.addHandler(()=>{ii(this.s)},this);this.pa.kq.addHandler(f=>{ki(this.s,f,!1)},this);this.pa.wn.addHandler(()=>{ki(this.s,0,!0)},this);this.pa.Sa().addHandler(this.Vc,this);this.pa.an.addHandler(this.vq,this);this.pa.Nm.addHandler(this.nq,this);this.pa.We().addHandler((f,g)=>{const h=this.g.ga.displayObject();h.scrollLeft-=f;h.scrollTop-=g;f=this.ej.x+f;g=this.ej.y+g;this.ej=new E(f,g);this.s.Gd(f,g)},this);Tj(this);this.hh=new Qj;this.hh.Ya.addHandler(this.al,
this);this.g.Ta().addHandler(this.Xc,this);this.g.Sa().addHandler(this.Vc,this);this.g.Bb().addHandler(this.ae,this);this.g.Rb().addHandler(this.pd,this);this.Vi=new T({X:"preloader-view"});this.g.h(this.Vi);this.Ac(1,oi);this.ah();this.g.$h(this.Hb.title());M(document.body,"mobile")}r(Sj,W);e=Sj.prototype;e.enable=function(){};e.disable=function(){};
e.resize=function(a,b){this.Cc&&clearTimeout(this.Cc);this.g.resize(a,b);this.g.invalidate();const c=1<a/b;this.ra.Bj?(this.s.resize(this.Qd()),this.Cc=setTimeout(()=>{this.s.update();this.pf&&c!=this.Nk&&this.s.Zl({Ko:!0});this.Nk=c},Pj.pm)):this.Nk=c;this.Ka&&this.Ka.da(this.fa)};e.nq=function(){if(this.Ti)yj(this.g);else{var a=this.g;a.Cb.Ra(!0);a.Qb.Ra(!0);xj(a.Cb,!0);xj(a.Qb,!0)}this.Ti=!this.Ti};e.Pc=function(){return this.s.Pc()};Sj.prototype.viewPages=Sj.prototype.Pc;
function Tj(a){a.ea.xn.addHandler(()=>{ii(a.hh.s)},a);a.ea.Tg.addHandler(b=>{var c=a.hh;b=0==b?0:(0>b?Math.max(b/2.5,-50):Math.min(b/2.5,50))+(0>b?Math.min(b+125,0):Math.max(b-125,0));c.Qk=b;ki(c.s,b,!1)},a);a.ea.vn.addHandler(()=>{var b=a.hh;ki(b.s,0,!0);b.s.container().displayObject();50<b.Qk&&(b.s.$e(!1),b.Ya.i());-50>b.Qk&&(b.s.Ze(!1),b.Ya.i())},a)}e=Sj.prototype;e.ah=function(){if(window.location.hash){var a=this.$g(window.location.hash.substring(1));"page"in a&&(this.ra.Ea=parseInt(a.page,10))}};
e.$g=function(a){a=a.split("&");const b={};for(let c=0;c<a.length;++c){const d=a[c].split("=");b[decodeURIComponent(d[0].toLowerCase())]=1<d.length?decodeURIComponent(d[1]):null}return b};e.Ac=function(a,b){Sj.W.Ac.call(this,a,b);this.wa[a].Jf.addHandler(this.ur,this);this.wa[a].vm(this)};e.Xc=function(a=!0){this.al();this.s.$e(a)};e.Vc=function(a=!0){this.al();this.s.Ze(a)};e.al=function(){yj(this.g);this.Ti=!1};e.pd=function(){this.Eg.toggle()};e.Qd=function(){return this.g.gb()};
e.ae=function(a){var b=this.s;b.lb(b.I);b.lb(b.G);b.lb(b.J);b.pc=a;di(b,a);b.R.Rj(0)};e.td=function(a){Sj.W.td.call(this,a);vg(a,this.Sc);const b=a.v();this.g.B(1);this.g.ua(b);this.Ma.ua(b);this.wa[1].eb(a);this.Wb(1);fh(this);this.Y.getOutline().then(c=>{this.g.Yh(c)});this.Vi&&(this.g.removeChild(this.Vi),this.Vi=null)};e.Wb=function(a){Sj.W.Wb.call(this,a);this.s.resize(this.Qd());this.s.enable(this.ra.Ea);this.hh.s=this.s;this.ea.Hd(this.s.Kc())};
e.Te=function(a){Sj.W.Te.call(this,a);this.g.B(a);this.mc(a)};e.ur=function(a){0<a?(this.ea.isActive()||this.ea.enable(),a=this.pa,a.sd&&(jf(a.Ae),a.sd=!1),a=this.pa,a.Sd&&(jf(a.zf),a.Sd=!1)):(this.ea.isActive()&&this.ea.disable(),a=this.pa,a.sd||(hf(a.Ae),a.sd=!0),a=this.pa,a.Sd||(hf(a.zf),a.Sd=!0))};e.Pl=function(a,b){this.oh=this.s.Ed();this.ej=new E(a,b);this.s.Gd(a,b)};e.Ah=function(a){this.pf=!1;a=this.rf(this.oh*a);a=Ca(a,Pj.Ye,Pj.Xe);this.s.ke(a)};e.Ll=function(){this.s.update()};
e.rf=function(a){return(a-1)/(this.s.bb-1)};e.vq=function(a,b){this.pf=1==this.s.Ed();this.s.Zl({clientX:a,clientY:b,Ko:!1})};function Uj(a){const b=new T({X:"spread"});b.aa("type",a);a=new T({M:R(b,"backLight")});b.h(a);const c=new T({M:R(b,"arrow")});a.h(c);return b}
class Vj extends V{constructor(){super(["viewer",t.cf.className]);this.Zi=Uj("prev");this.h(this.Zi);this.mh=new V("bookSpread");this.h(this.mh);this.Ha=new V("pageContainer");this.mh.h(this.Ha);this.Ni=Uj("next");this.h(this.Ni);this.Dc=new D;this.io=new D;this.Ni.H.addHandler(()=>this.Dc.i());this.Zi.H.addHandler(()=>this.io.i())}sb(){return this.Ha}ca(a){this.Ha.ca(a);this.mh.ca(a)}ta(a){this.Ha.ta(a);this.mh.ta(a)}tc(a){var b=a.width()/t.Ab;a=a.height()/t.Uh;b=Math.min(b,a);a=this.Zi.displayObject().firstElementChild;
const c=this.Ni.displayObject().firstElementChild;1>b?(ne(a,"right center"),O(a,b),ne(c,"left center"),O(c,b)):(ne(a,""),O(a,1),ne(c,""),O(c,1))}Ta(){return this.io}Sa(){return this.Dc}};function Wj(a,b){switch(b){case 0:a=2*a-1;break;case 1:a*=2;break;default:throw Error("sheetSideId is wrong");}return a}function Xj(a,b){switch(b){case 0:a-=2;break;case 1:--a;break;case 2:break;case 3:a+=1;break;default:throw Error("bookSheetId is wrong");}return a}function Yj(a,b){const c=Math.floor(b/2)+1;return 1==a||a==c&&0==b%2};function Zj(a,b,c){const d=c.container;this.j=d;this.gj=b;this.qc=c.Ed;this.C=c.viewport;this.$b=this.C.scale/this.qc;this.Ob=c.Uj;this.Ud=new D;let f=Wj(a,0);this.u=new ig(f,this.C,this.qc);(this.Pa=c.ji)&&this.u.ab.addHandler(()=>{this.Pa.render(this.u,this.qc,this.$b*xh(this.u.bd()),this.u.xg);this.Ud.i(this.u)});d.h(this.u);f=Wj(a,1);this.N=new ig(f,this.C,this.qc);this.N.ab.addHandler(function(){this.Ud.i(this.N)},this);d.h(this.N);0==b?(this.u.K("front"),eg(this.u,0),this.N.K("back"),eg(this.N,
0)):(this.u.K("back"),eg(this.u,1),this.N.K("front"),eg(this.N,1));this.Eb=ak(this.Ob,this.u,1);this.qe=ak(this.Ob,this.N,2)}e=Zj.prototype;e.am=function(){return this.u};e.Ql=function(){return this.N};e.bm=function(){return this.u.displayObject()};e.Rl=function(){return this.N.displayObject()};e.kp=function(){return this.gj};e.cg=function(){return this.Ud};
e.setScale=function(a){this.u.setScale(a);this.N.setScale(a);this.qc=a;this.C=this.C.clone({scale:this.$b*a});this.Eb&&(this.Eb.style.width=this.C.width+"px",this.Eb.style.height=this.C.height+"px");this.qe&&(this.qe.style.width=this.C.width+"px",this.qe.style.height=this.C.height+"px")};
e.da=function(a,b){this.$b=a.scale/b;this.C=a;this.Eb&&(this.Eb.style.width=this.C.width+"px",this.Eb.style.height=this.C.height+"px");this.qe&&(this.qe.style.width=this.C.width+"px",this.qe.style.height=this.C.height+"px");this.u.da(a,b);this.N.da(a,b)};e.destroy=function(){this.lb(this.u);this.lb(this.N)};
e.ei=function(){this.gj=0==this.gj?1:0;if(0==this.gj){var a=this.u;a.U("back");a.K("front");eg(this.u,0);a=this.N;a.U("front");a.K("back");eg(this.N,0)}else a=this.u,a.U("front"),a.K("back"),eg(this.u,1),a=this.N,a.U("back"),a.K("front"),eg(this.N,1)};e.Oc=function(a,b){this.om(a);this.rj(b)};e.rj=function(a){this.u.K(a);this.N.K(a)};e.om=function(a){this.u.U(a);this.N.U(a)};
e.em=function(a){switch(a){case "front":a=this.u;break;case "back":a=this.N;break;default:throw Error("pageName is wrong");}return a};
e.Th=function(a,b){let c=0==a?this.u:this.N,d=c.displayObject();const f=d.style.cssText,g=d.className;this.lb(c);b=Wj(b,a);0==a?(this.u=c=new ig(b,this.C,this.qc),this.Pa&&this.u.ab.addHandler(()=>{this.Pa.render(this.u,this.qc,this.$b*xh(this.u.bd()),this.u.xg);this.Ud.i(this.u)}),this.Eb=ak(this.Ob,this.u,1)):(this.N=c=new ig(b,this.C,this.qc),this.qe=ak(this.Ob,this.N,2));d=c.displayObject();d.style.cssText=f;d.className=g;this.j.h(c)};e.lb=function(a){null!==a&&(this.j.removeChild(a),a.reset())};function bk(a,b){const c=b.container;this.j=c;this.qc=b.Ed;this.C=b.viewport;this.$b=this.C.scale;this.Ob=b.Uj;this.Ud=new D;this.Pa=b.ji;a=Wj(a,0);this.u=new ig(a,this.C,this.qc);this.Pa&&this.u.ab.addHandler(()=>{this.Pa.render(this.u,this.qc,this.$b*xh(this.u.bd()),this.u.xg);this.Ud.i(this.u)});this.u.ab.addHandler(function(){this.Ud.i(this.u)},this);c.h(this.u);this.u.K("front");this.Eb=ak(this.Ob,this.u,1)}r(bk,Zj);e=bk.prototype;e.cg=function(){return this.Ud};
e.setScale=function(a){this.u.setScale(a);this.qc=a;this.C=this.C.clone({scale:this.$b*a});this.Eb&&(this.Eb.style.width=this.C.width+"px",this.Eb.style.height=this.C.height+"px")};e.da=function(a,b){this.$b=a.scale/b;this.C=a;this.Eb&&(this.Eb.style.width=this.C.width+"px",this.Eb.style.height=this.C.height+"px");this.u.da(a,b)};e.destroy=function(){this.lb(this.u)};e.rj=function(a){this.u.K(a)};e.om=function(a){this.u.U(a)};
e.em=function(a){switch(a){case "front":a=this.u;break;case "back":a=null;break;default:throw Error("pageName is wrong");}return a};function ck(){}e=ck.prototype;e.cg=function(){return new D};e.destroy=function(){};e.Oc=function(){};e.rj=function(){};e.om=function(){};e.ei=function(){};e.setScale=function(){};e.Th=function(){};e.em=function(){};e.bm=function(){};e.Rl=function(){};e.am=function(){};e.Ql=function(){};e.da=function(){};e.kp=function(){};var dk=[{Jd:"left",Id:"back"},{Jd:"right",Id:"front"},{Jd:"right",Id:"back"},{Jd:"left",Id:"front"},{Jd:"next",Id:"front"},{Jd:"next",Id:"back"},{Jd:"prev",Id:"back"},{Jd:"prev",Id:"front"}];function ek(a){this.Mb=[];this.o=a}r(ek,Zh);
ek.prototype.Ja=function(){let a=[];for(let f=0;f<dk.length;++f){var b=dk[f].Jd;var c=dk[f].Id;var d=this.o;switch(b){case "prev":b=d.Za;break;case "left":b=d.na;break;case "right":b=d.oa;break;case "next":b=d.Xa;break;default:throw Error("sheetName is wrong");}(c=b.em(c))&&0!=c.pageNumber()&&a.push({je:c.pageNumber(),page:c})}return{Qc:a}};ek.prototype.update=function(){const a=this.Ja().Qc;for(let b=0;b<a.length;++b)a[b].page.reset();this.render(a)};ek.prototype.Y=function(){return this.o.document()};
ek.prototype.Yd=function(a){switch(a.$){case 3:break;case 2:break;case 1:break;case 0:a.ab.addHandler(function(){const b=this.Ja();this.render(b.Qc)},this);a.render();break;default:throw Error("renderingState is wrong");}};var fk={mi:[0,.03,.04,.05,.1,.11,.3],ki:[.6,.09,.02,.01,.15,.16,0],li:[0,0,0,255,255,255,255]},gk={mi:[.78,.88,.9,.94,.95,.98,1],ki:[0,.09,.09,.03,.06,.22,.6],li:[255,255,255,255,0,0,0]},hk={mi:[.43,.44,.46,.48,.5,.52,.54,.58,.61],ki:[0,.05,.2,.2,.5,.4,.3,.1,0],li:[255,255,255,0,0,0,0,0,0]},ik={mi:[.46,.47,.49,.5,.51,.52,.53,.54,.55],ki:[0,.1,.3,.5,.1,.3,.2,.1,0],li:[0,0,0,0,0,255,255,255,255]};function mk(){this.Jl=[]}
function ak(a,b,c){a:{var d=b.pageNumber();for(let f=0;f<a.Jl.length;++f)if(a.Jl[f]==d){d=!0;break a}d=!1}if(d)return null;d=b.gf;a=a.ui(b.width(),b.height());nk(a,c);d.h(a);return a}function nk(a,b){const c=a.getContext("2d"),d=c.createLinearGradient(0,0,a.width,0);var f=ok(b);b=f.mi;const g=f.ki;f=f.li;for(let h=0;h<b.length;++h)d.addColorStop(b[h],"rgba("+f[h]+", "+f[h]+", "+f[h]+", "+g[h]+")");c.rect(0,0,a.width,a.height);c.fillStyle=d;c.fill()}
mk.prototype.ui=function(a,b){const c=xd(document,"canvas");c.className="shadow";c.width=a;c.height=b;c.style.width=a+"px";c.style.height=b+"px";return c};function ok(a){switch(a){case 1:return fk;case 2:return gk;case 3:return hk;case 4:return ik;default:throw Error("shadowType is wrong");}};function pk(a){X.call(this,[0],[1],a);this.bc=this.N=this.u=null;this.xi=0;this.g=null}r(pk,X);pk.prototype.Ge=function(){this.u.style.width="0px";this.u.style.right="0px";this.N.style.right="0px";this.ko();this.xi=parseInt(this.N.style.width,10)};
pk.prototype.ob=function(a){const b=this.xi;a=Math.ceil(b*a[0]);this.u.style.width=b-a+"px";this.N.style.width=a+"px";2!=this.bc&&3!=this.bc&&this.ho(a);let c=null,d=!1;1==this.bc?(c=2*a,d=c>b):2==this.bc?(c=2*b-a,d=a<b):3==this.bc&&(c=b-a,a>c&&(c=a),d=!0);d&&this.g.ca(c)};pk.prototype.yd=function(){this.u.style.width=this.xi+"px";this.Un();this.Om();2==this.bc&&this.g.ca(this.xi)};var qk=1/(1-.9);function rk(a,b){X.call(this,[0],[1],a);this.Ob=b;this.g=this.S=this.bc=this.C=null}r(rk,X);rk.prototype.tb=function(a,b,c){this.g=b;this.C=a;this.bc=c};rk.prototype.Ge=function(){const a=this.C.width,b=this.C.height,c=xd(document,"canvas");c.className="turn-shadow";c.width=a;c.height=b;c.style.width=a+"px";c.style.height=b+"px";this.S=c;nk(c,this.cn());this.g.sb().h(c);2==this.bc?this.jh(-(a/2)):this.jh(0);c.style.width="0px"};
rk.prototype.ob=function(a){a=a[0];let b=this.S;const c=Math.ceil(this.C.width*a),d=Math.min(c,600);.9<=a&&(b.style.opacity=(1-(a-.9)*qk*.6).toFixed(2));b.style.width=d+"px";2!=this.bc&&3!=this.bc?this.jh(c-d/2):this.jh(-(d/2))};rk.prototype.yd=function(){this.g.sb().removeChild(this.S)};function sk(a,b){Fh.call(this);this.zl=a;this.lr=b;this.add(a);this.add(b)}r(sk,Fh);function tk(a){pk.call(this,a)}r(tk,pk);e=tk.prototype;e.tb=function(a,b,c){this.u=a.bm();this.N=a.Rl();this.g=b;this.bc=c};e.ko=function(){M(this.u,"front-flipping");M(this.N,"front-flipping")};e.Un=function(){N(this.u,"front-flipping");N(this.N,"front-flipping")};e.ho=function(a){this.u.style.right=a+"px";this.N.style.right=a+"px"};e.Om=function(){this.u.style.right="";this.N.style.right=""};function uk(a){pk.call(this,a)}r(uk,pk);e=uk.prototype;e.tb=function(a,b,c){this.u=a.Rl();this.N=a.bm();this.g=b;this.bc=c};e.ko=function(){M(this.u,"back-flipping");M(this.N,"back-flipping")};e.Un=function(){N(this.u,"back-flipping");N(this.N,"back-flipping")};e.ho=function(a){this.u.style.left=a+"px";this.N.style.left=a+"px"};e.Om=function(){this.u.style.left="";this.N.style.left=""};function vk(a,b){rk.call(this,a,b)}r(vk,rk);vk.prototype.jh=function(a){this.S.style.right=a+"px"};vk.prototype.cn=function(){return 3};function wk(a,b){rk.call(this,a,b)}r(wk,rk);wk.prototype.jh=function(a){this.S.style.left=a+"px"};wk.prototype.cn=function(){return 4};function xk(a){var b=t.ts;this.o=a;this.si=null;this.ri=new D;a=a.Uj();this.rk=new sk(new tk(b),new vk(b,a));this.ck=new sk(new uk(b),new wk(b,a));this.rk.zl.ma.addHandler(this.Im,this);this.ck.zl.ma.addHandler(this.Im,this);this.rk.ma.addHandler(this.bk,this);this.ck.ma.addHandler(this.bk,this)}
xk.prototype.play=function(a,b){var c=0==a.kp();this.si=b;b=this.o.vb;var d=this.o.Bf,f=this.o.v();d=Yj(d,f);b=Yj(b,f)?d?3:1:d?2:null;f=this.o.view();d=this.o.bd();c=c?this.rk:this.ck;c.zl.tb(a,f,b);c.lr.tb(d,f,b);c.play()};xk.prototype.Im=function(){null!==this.si&&(this.si(),this.si=null)};xk.prototype.bk=function(){this.ri.i()};function yk(a,b,c){v&&(a.style.visibility="hidden");a.scrollLeft=b;a.scrollTop=c;v&&(a.style.visibility="visible")};function zk(a){Ch.call(this,a);this.g=null;this.Ya.addHandler(this.Gq,this);this.be=this.vb=0;this.Xa=this.oa=this.na=this.Za=null;this.kk=!0;this.Ob=new mk;this.$a=new ek(this);this.Bf=0;this.wc=new th(0,0);this.te=new th(0,0);this.Le=new G(0,0);this.sf=null;this.Ho=new D;this.wh=new xk(this);this.wh.ri.addHandler(this.jo,this);this.Ec.addHandler(function(){var b=this.g.mh.displayObject();this.ea.Na=b},this)}r(zk,Ch);e=zk.prototype;e.Uj=function(){return this.Ob};e.view=function(){return this.g};
e.Pc=function(){const a=[];var b=this.na.Ql();b&&(b=b.pageNumber()-1,a.push(b));if(b=this.oa.am())b=b.pageNumber()-1,a.push(b);return a};
e.B=function(a){if(Bh(this,a)&&0==this.Bf)if(this.F=a,a=Math.floor(a/2+1),this.vb!=a)if(this.Bf=a,this.kk)this.Za=Ak(this,a,0),this.na=Ak(this,a,1),this.na.cg().addHandler(this.fj,this),this.oa=Ak(this,a,2),this.oa.cg().addHandler(this.fj,this),this.Xa=Ak(this,a,3),this.jo(),Ah(this),this.kk=!1;else{let b;switch(this.Bk(a)){case 0:b=this.mr;break;case 2:b=this.nr;break;case 1:b=this.Yp;break;case 3:b=this.$p;break;default:throw Error("TransitionType is wrong");}b.call(this,a)}else this.mc()};
e.$e=function(){1>=this.F||this.B(this.F-(2<this.F?2:1))};e.Ze=function(){if(!(this.F>=this.v())){var a=1<this.v()-this.F?2:1;this.B(this.F+a)}};e.setScale=function(a){this.Db!=a&&0==this.Bf&&(this.Db=a,this.P=a*(this.bb-1)+1,this.O=this.O.clone({scale:this.$b*this.P}),Bk(this),Ck(this),this.na.setScale(this.P),this.oa.setScale(this.P),this.Za.setScale(this.P),this.Xa.setScale(this.P),this.Jf.i(this.Db))};
e.ke=function(a){this.setScale(a);var b=this.g.sb().displayObject().getBoundingClientRect();a=b.width/this.Le.width;b=b.height/this.Le.height;a*=this.te.x();b*=this.te.y();const c=1<this.Z?t.cf.sp:0;yk(this.j.displayObject(),a-this.wc.x()+t.cf.zm+c,b-this.wc.y()+t.cf.zm)};e.Gd=function(a,b){const c=this.g.sb().displayObject().getBoundingClientRect();this.wc=new th(a,b);this.te=new th(Math.max(a-c.left,0),Math.max(b-c.top,0));this.Le=new G(c.width,c.height)};
e.resize=function(a){this.Fa=a;this.Xb&&(this.g.tc(a),this.P=this.Db*(this.bb-1)+1,this.$b=this.Wa(this.sf),this.O=this.sf.clone({scale:this.$b*this.P}),Bk(this),Ck(this),this.na.da(this.O,this.P),this.oa.da(this.O,this.P),this.Za.da(this.O,this.P),this.Xa.da(this.O,this.P))};e.update=function(){this.$a.update()};e.eb=function(a){zk.W.eb.call(this,a);this.be=Math.floor(this.v()/2)+1;a=this.Ob;const b=[1];0==this.v()%2&&b.push(this.v());a.Jl=b;this.sf=ac(this.nc)};
e.enable=function(a){this.g=new Vj;this.g.tc(this.Fa);this.g.Ta().addHandler(this.$e,this);this.g.Sa().addHandler(this.Ze,this);1==this.v()&&this.g.K("onePage");this.container().h(this.g);const b=this.Wa(this.sf);this.O=this.sf.clone({scale:b});this.$b=this.O.scale;this.B(a);Bk(this);Ck(this)};e.disable=function(){zk.W.disable.call(this);this.container().removeChild(this.g);this.g=null;Dk(this.Za);Dk(this.na);Dk(this.oa);Dk(this.Xa);this.j.displayObject().style.marginTop="";this.vb=0;this.kk=!0};
e.$l=function(){};e.sm=function(){};e.Zb=function(){const a=this.$a.Ja();this.$a.render(a.Qc)};e.jo=function(){this.vb=this.Bf;this.Zb();this.mc();this.Bf=0};e.mr=function(a){this.wh.play(this.oa,()=>{Dk(this.Za);this.na.Oc("left","prev");this.Za=this.na;this.oa.ei();this.oa.Oc("right","left");this.na=this.oa;this.Xa.Oc("next","right");this.oa=this.Xa;this.Xa=Ak(this,a,3)})};
e.nr=function(a){this.wh.play(this.na,()=>{Dk(this.Xa);this.oa.Oc("right","next");this.Xa=this.oa;this.na.ei();this.na.Oc("left","right");this.oa=this.na;this.Za.Oc("prev","left");this.na=this.Za;this.Za=Ak(this,a,0)})};
e.Yp=function(a){Dk(this.Za);Dk(this.Xa);const b=Xj(a,1);this.oa.Th(1,b);this.Xa=Ak(this,a,2);this.wh.play(this.oa,()=>{Dk(this.na);this.oa.ei();this.oa.Oc("right","left");this.na=this.oa;this.na.Th(0,b);this.Xa.Oc("next","right");this.oa=this.Xa;this.Xa=Ak(this,a,3);this.Za=Ak(this,a,0)})};
e.$p=function(a){Dk(this.Za);Dk(this.Xa);const b=Xj(a,2);this.na.Th(0,b);this.Za=Ak(this,a,1);this.wh.play(this.na,()=>{Dk(this.oa);this.na.ei();this.na.Oc("left","right");this.oa=this.na;this.oa.Th(1,b);this.Za.Oc("prev","left");this.na=this.Za;this.Za=Ak(this,a,0);this.Xa=Ak(this,a,3)})};function Dk(a){a&&a.destroy()}e.fj=function(){var a=this.na.Ql();a&&3!=a.$||(a=this.oa.am(),a&&3!=a.$||(this.Ho.i(),this.na.cg().removeHandler(this.fj,this),this.oa.cg().removeHandler(this.fj,this)))};
e.Bk=function(a){let b=this.vb;return a>b?a==b+1?0:1:a==b-1?2:3};function Ak(a,b,c){b=Xj(b,c);switch(c){case 0:case 1:var d=1;break;case 2:case 3:d=0;break;default:throw Error("bookSheetId is wrong");}const f={container:a.g.sb(),Ed:a.P,viewport:a.O,Uj:a.Ob,ji:a.Pa};a=0<b&&b<a.be?new Zj(b,d,f):0==a.v()%2||b!=a.be?new ck:new bk(b,f);switch(c){case 0:c="prev";break;case 1:c="left";break;case 2:c="right";break;case 3:c="next";break;default:throw Error("bookSheetId is wrong");}a.rj(c);return a}
e.Wa=function(a){let b=t.cf.zm;var c=t.cf.sp;let d=this.Fa.width()-2*b;1<this.v()&&(d-=2*c);2<this.v()&&(d/=2);c=d/a.width;a=(this.Fa.height()-2*b)/a.height;return Math.min(a,c)};function Bk(a){let b=Math.floor(a.O.width);const c=Math.floor(a.O.height);Yj(a.vb,a.v())||(b*=2);a.g.ca(b);a.g.ta(c)}function Ck(a){var b=Math.round(a.O.height);b=(a.Fa.height()-b-18)/2;0<b?a.j.displayObject().style.marginTop=b+"px":a.j.displayObject().style.marginTop=""}
e.Gq=function(a){this.g.Zi.aa("invisible",!(1<a));this.g.Ni.aa("invisible",!(Math.floor(a/2+1)<this.be))};function Ek(a){const b=new V("btn","BUTTON");a=new V(["icon",a]);b.h(a);return b};function Fk(){const a=document.location.search.split("+").join(" ");let b={},c,d=/[?&]?([^=]+)=([^&]*)/g;for(;c=d.exec(a);)b[decodeURIComponent(c[1])]=decodeURIComponent(c[2]);return b}function Gk(a,b){const c=document.createElement("script");c.src=a;c.onload=function(){b(window.PDF_DATA)};document.head.appendChild(c)};function Hk(a){V.call(this,"pageNavigationToolbarContainer");this.Z=0;this.gl=new D;this.Df=Ek("previous");a&&this.Df.hg(a.ka("PB_ACCESSIBILITY_GOTO_PREV"));this.h(this.Df);var b=new V("pageNumber");this.h(b);const c=new V("view");b.h(c);L&&Ne?b=new V("currentPage mobile","DIV"):(b=new V("currentPage","INPUT"),b.setAttribute("type","text"),b.setAttribute("maxlength","4"),x(b.displayObject(),"keydown",this.yq,!1,this),x(b.displayObject(),"keyup",this.En,!1,this),x(b.displayObject(),"paste",this.zq,
!1,this),x(b.displayObject(),"input",this.xq,!1,this));this.Ri=b;a&&this.Ri.hg(a.ka("PB_ACCESSIBILITY_CURRENT_PAGE"));c.h(this.Ri);b=document.createTextNode("\u00a0/\u00a0");Ad(c.displayObject(),b);this.Ce=new V("pagesCount","SPAN");c.h(this.Ce);this.Af=Ek("next");a&&this.Af.hg(a.ka("PB_ACCESSIBILITY_GOTO_NEXT"));this.h(this.Af)}r(Hk,V);e=Hk.prototype;e.ua=function(a){this.Z=a;this.Ce.V(a.toString())};
e.B=function(a){this.Df.Ra(1!=a);this.Af.Ra(a!=this.Z);L&&Ne?this.Ri.V(a.toString()):this.Ri.displayObject().value=a.toString()};e.vc=function(a){const b=this.Df.displayObject().firstElementChild,c=this.Af.displayObject().firstElementChild;switch(a){case 1:M(b,"up");M(c,"down");break;case 2:N(b,"up"),N(c,"down")}};e.xq=function(a){const b=a.target.value;b.match(/[^0-9]/g)&&(a.target.value=b.replace(/[^0-9]/g,""))};
e.yq=function(a){a.stopPropagation();Ik(a)&&a.preventDefault();const b=a.which||a.keyCode;v&&10>=parseInt(Bb,10)&&13==b&&(a.preventDefault(),this.En(a))};e.En=function(a){13==a.keyCode&&(a=Jk(a.target.value),isNaN(a)||this.gl.i(a))};e.zq=function(a){const b=Jk((a.Qa.clipboardData||window.clipboardData).getData("text"));isNaN(b)&&a.preventDefault()};
function Ik(a){switch(a.which||a.keyCode){case 9:return!1;case 8:case 46:case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 96:case 97:case 98:case 99:case 100:case 101:case 102:case 103:case 104:case 105:return a.shiftKey||a.metaKey;case 13:return!1;case 65:case 67:case 88:case 86:return!0!==a.ctrlKey;case 37:case 39:return!1}return!0}function Jk(a){return/^\d+$/.test(a)?parseInt(a,10):NaN};function Kk(){V.call(this,"viewerToolbarContainer");this.Wh(!0);this.Pf=Ek("thumbnail");this.h(this.Pf);this.zh=Ek("viewMode");this.h(this.zh);this.qf=Ek("fullscreen");this.h(this.qf)}r(Kk,V);e=Kk.prototype;e.vc=function(a){const b=this.zh.displayObject().firstElementChild;switch(a){case 1:N(b,"book");M(b,"pages");break;case 2:N(b,"pages"),M(b,"book")}};e.ed=function(a){const b=this.qf.displayObject().firstElementChild;a?M(b,"selected"):N(b,"selected")};
e.gd=function(a){const b=this.Pf.displayObject().firstElementChild;switch(a){case 1:M(b,"open");break;case 0:N(b,"open")}};e.setScale=function(a){this.Pf.Ra(0==a)};e.uc=function(a){this.Pf.Ra(a)};e.hd=function(a){this.zh.Ra(a)};e.dd=function(a){this.qf.Ra(a)};e.cd=function(){this.removeChild(this.qf)};function Lk(){V.call(this,["toolbar","mobile","hidden"]);this.Sf=1;this.fa=new w(0,0);const a=new V("toolbarCenter");this.Ib=new Hk(null);a.h(this.Ib);this.sa=new Kk;a.h(this.sa);this.h(a)}r(Lk,V);e=Lk.prototype;e.width=function(){return this.fa.width()};e.height=function(){return this.fa.height()};e.ua=function(a){this.Ib.ua(a)};e.B=function(a){this.Ib.B(a)};e.vc=function(a){this.sa.vc(a)};e.ed=function(a){this.sa.ed(a)};e.gd=function(a){this.sa.gd(a)};e.setScale=function(a){this.sa.setScale(a)};
e.tc=function(a){var b=a.width()/t.Ab,c=a.height()/t.Uh;b=Math.min(b,c);c=a.width();let d=t.fb;1>b?(ne(this.displayObject(),"left bottom"),O(this.displayObject(),b),d=Math.floor(t.fb*b),this.ca(a.width()*(1/b))):(ne(this.displayObject(),""),O(this.displayObject(),1),U(this,"width",""));this.Sf=Math.min(1,b);this.fa=new w(c,d)};e.uc=function(a){this.sa.uc(a)};e.hd=function(a){this.sa.hd(a)};e.dd=function(a){this.sa.dd(a)};e.bf=function(){return this.sa.zh.H};e.Ta=function(){return this.Ib.Df.H};
e.Sa=function(){return this.Ib.Af.H};e.Bb=function(){return this.Ib.gl};e.Rb=function(){return this.sa.qf.H};e.af=function(){return this.sa.Pf.H};e.cd=function(){this.sa.cd()};function Mk(a,b){V.call(this,"mainContainer");this.fa=new w(0,0);this.wf=new V("loaderIcon");this.h(this.wf);this.ga=new V("viewerContainer");this.h(this.ga);this.A=new Lk;this.h(this.A);this.iq=new D;this.tc(new w(a,b));a=new wi(this.ga.displayObject());x(a,"mousewheel",this.Gl,!1,this)}r(Mk,V);e=Mk.prototype;e.ua=function(a){this.A.ua(a)};e.B=function(a){this.A.B(a)};e.gb=function(){return new w(this.fa.width(),this.fa.height()-this.A.height())};e.fb=function(){return this.A.height()};e.vc=function(a){this.A.vc(a)};
e.ed=function(a){this.A.ed(a)};e.gd=function(a){this.A.gd(a)};e.setScale=function(a){this.A.setScale(a)};e.tc=function(a){this.fa=a;this.resize(a.width(),a.height());this.A.tc(a);a=Math.round(this.A.height());U(this.ga,"bottom",a+"px")};e.bf=function(){return this.A.bf()};e.Ta=function(){return this.A.Ta()};e.Sa=function(){return this.A.Sa()};e.Bb=function(){return this.A.Bb()};e.Rb=function(){return this.A.Rb()};e.jg=function(){return new D};e.af=function(){return this.A.af()};e.ym=function(){this.A.U("hidden")};
e.cd=function(){this.A.cd()};e.wj=function(){};e.uc=function(a){this.A.uc(a)};e.hd=function(a){this.A.hd(a)};e.dd=function(a){this.A.dd(a)};e.Gl=function(a){this.iq.i(a.Qa)};var Nk=vc();Nk.qm=!1;xc(Nk.$j,{Zc:3,ci:3,dg:3,Wf:6,fg:7,Xf:34});xc(Nk.Zj,{ci:4});function Ok(a,b,c,d){V.call(this,"thumbnailView");this.mo=a;this.hj=new D;c=this.Ig(a,0);const f=this.Ig(a,1);this.Nb=new V("selection");this.h(this.Nb);this.mb=new V("thumbnailSpread");this.mb.ca(b.width());this.mb.ta(b.height());this.mb.H.addHandler(function(){this.hj.i(a,f)},this);this.Nb.h(this.mb);b=new w(b.width()/2,b.height());this.vf=Ug(d,c,b);this.vf.K("left");this.mb.h(this.vf.displayObject());c=this.ui(b);nk(c,2);this.ln=c;this.vf.h(c);this.If=Ug(d,f,b);this.If.K("right");this.mb.h(this.If.displayObject());
c=this.ui(b);nk(c,1);this.Yn=c;this.If.h(c)}r(Ok,V);e=Ok.prototype;e.da=function(a){this.mb.ca(a.width());this.mb.ta(a.height());a=new w(a.width()/2,a.height());this.vf.da(a);this.If.da(a);this.ln.style.width=a.width()+"px";this.ln.style.height=a.height()+"px";this.Yn.style.width=a.width()+"px";this.Yn.style.height=a.height()+"px"};e.update=function(){this.vf.reset();this.If.reset()};e.setActive=function(a){a?this.Nb.K("selected"):this.Nb.U("selected")};
e.ui=function(a){const b=xd(document,"canvas");b.className="shadow";b.width=a.width();b.height=a.height();return b};e.Ig=function(a,b){switch(b){case 0:a=2*(a-1);break;case 1:a=2*(a-1)+1;break;default:throw Error("spreadSideId is wrong");}return a};function Pk(a,b,c,d){V.call(this,"thumbnailView");this.hj=new D;const f=c.width()/2;this.Nb=new V("selection");this.h(this.Nb);this.mb=new V("thumbnailSpread");this.mb.ca(f);this.mb.ta(c.height());this.mb.H.addHandler(function(){this.hj.i(a,b)},this);this.Nb.h(this.mb);this.mo=a;c=new w(f,c.height());this.ha=Ug(d,b,c);this.mb.h(this.ha.displayObject())}r(Pk,V);Pk.prototype.page=function(){return this.ha};
Pk.prototype.da=function(a){const b=a.width()/2;this.mb.ca(b);this.mb.ta(a.height());a=new w(b,a.height());this.ha.da(a)};Pk.prototype.update=function(){this.ha.reset()};Pk.prototype.setActive=function(a){a?this.Nb.K("selected"):this.Nb.U("selected")};function Qk(a){this.Mb=[];this.th=a}e=Qk.prototype;e.Ja=function(){const a=[],b=this.th.Pb;for(let c=0;c<b.length;++c){const d=b[c];d instanceof Pk?a.push(d.page()):d instanceof Ok&&(a.push(d.vf),a.push(d.If))}return a};e.render=function(a){const b=this.Hg(a);b&&!this.Og(b)&&(b.Jh()?this.Yd(b):(a=b.pageNumber(),this.Mb[a]||(this.Mb[a]=!0,this.th.document().getPage(a,(c,d)=>{b.Zh(c);this.Mb[d]=!1;this.render(this.Ja())}))))};
e.Yd=function(a){switch(a.$){case 3:break;case 2:break;case 1:break;case 0:a.ab.addHandler(function(){this.render(this.Ja())},this);a.render();break;default:throw Error("renderingState is wrong");}};e.Hg=function(a){for(let b=0;b<a.length;++b)if(!this.Ng(a[b]))return a[b];return null};e.Ng=function(a){return 3==a.$};e.Og=function(a){return 1==a.$};function Rk(){this.Z=0;this.Y=null;this.ra=0;this.ce=new D;this.Ec=new D;this.Ya=new D}e=Rk.prototype;e.state=function(){return this.ra};e.v=function(){return this.Z};e.lp=function(){return this.ce};e.Jj=function(){return this.Ya};e.document=function(){return this.Y};e.eb=function(a){this.Y=a;this.Z=a.v()};function Sk(a,b){a.ra=b;a.ce.i(b)}e.mc=function(a){this.Ya.i(a)};function Tk(a,b){Rk.call(this);this.D=a;this.Ca=0;this.nc=this.Aa=this.Td=null;this.l=b;this.Tc=0;this.wd=[];this.Mi=this.Yi=null;this.Si=t.Am;this.Ji=this.Rc=this.Se=0;this.Yg=null}r(Tk,Rk);Tk.prototype.Qj=function(a){this.nc=a};Tk.prototype.disable=function(){this.Ca=this.Tc=0;this.wd=[];this.Ji=this.Rc=0;this.Yg=null};
function Uk(a,b,c){if(1!=a.Ca)if(a.Yi.displayObject().firstChild.style.height=b+"px",a.Mi.displayObject().firstChild.style.height=b+"px",b=Vk(a,c),a.Si=b.width,b.v!=a.Se){c=b.v-a.Se;a.Se=b.v;const d=a.Tc-a.Rc;if(0>c&&d>b.v/2||0<c&&d<b.v/2)a.Rc=Math.max(1,a.Rc-c);Wk(a,a.Rc);Xk(a,a.Tc)}else for(c=0;c<a.wd.length;++c)a.wd[c].displayObject().firstChild.style.width=b.width+"px"}
function Yk(a,b,c){const d=new V("thumbnailContainer");if(1<a.Ca){d.K("withPagination");const f=new V("thumbnailControlsContainer");d.h(f);a.Yi=Zk(a,b);f.h(a.Yi);a.Td=new V("itemsContainer");f.h(a.Td);a.Mi=$k(a,b);f.h(a.Mi);a.Yg=new V("thumbnailPagination");d.h(a.Yg);b=Vk(a,c);a.Se=b.v;a.Si=b.width}else a.Td=new V("itemsContainer"),d.h(a.Td);return d}
function al(a,b){a.Tc!=b&&(a.Vn(b),1<a.Ca&&((b<=a.Rc||b>=a.Ji)&&Wk(a,Math.max(b-Math.floor(a.Se/2),1)),Xk(a,b),U(a.Yi,"visibility",1==b?"hidden":"visible"),U(a.Mi,"visibility",b==a.Ca?"hidden":"visible")),a.Tc=b,a.Zb())}function Z(a){return a.D.fb()}function Xk(a,b){const c=a.Tc-a.Rc;b=Math.max(0,b-a.Rc);a.Rc<=a.Tc&&a.Tc<=a.Ji&&0<=c&&a.wd[c].U("selected");a.wd[b].K("selected")}
function Wk(a,b){bl(a);let c=b+a.Se-1;c>a.Ca&&(c=a.Ca,b=Math.max(c-(a.Se-1),1));a.Rc=b;for(a.Ji=c;b<=c;++b){var d=a.bn(b);d=cl(a,d);d.H.addHandler(function(f){al(this,f)}.bind(a,b),a);a.wd.push(d);a.Yg.h(d)}}function Vk(a,b){let c=t.Tr+2*a.l.ci,d=Math.floor(b/c);d=Math.min(d,a.Ca);b-=d*c;b>d&&(c+=Math.floor(b/d));c=Math.min(c,t.Am);return{v:d,width:c-2*a.l.ci}}function bl(a){for(let b=0;b<a.wd.length;++b)a.Yg.removeChild(a.wd[b]);a.wd=[]}
function cl(a,b){const c=new V("selection");c.setAttribute("title",b.left+" - "+b.right);b=new V("paginationPage");a.Si!=t.Am&&b.ca(a.Si);c.h(b);return c}function $k(a,b){const c=new V(["next","paginationPage"],"A"),d=new V("backLight");U(d,"height",b+"px");d.H.addHandler(function(){al(this,this.Tc+1)},a);c.h(d);a=new V("arrow");d.h(a);return c}
function Zk(a,b){const c=new V(["prev","paginationPage"],"A"),d=new V("backLight");U(d,"height",b+"px");d.H.addHandler(function(){al(this,this.Tc-1)},a);c.h(d);a=new V("arrow");d.h(a);return c};function dl(a){X.call(this,[0],[1],a);this.D=this.va=null;this.L=0;this.o=this.Fa=null}r(dl,X);dl.prototype.tb=function(a,b,c){this.o=c;this.D=b;this.va=a.view();this.L=a.height()};dl.prototype.Ge=function(){const a=this.D.fb();U(this.va,"bottom",a-this.L+"px");U(this.o.container(),"bottom",a+"px");this.va.U("close")};
dl.prototype.ob=function(a){var b=a[0];const c=this.D.fb();a=this.L*(1-b);U(this.va,"bottom",c-a+"px");a=this.L*b;U(this.o.container(),"bottom",Math.ceil(c+a)+"px");b=this.D.gb();a=b.height()-a;this.o.resize(new w(b.width(),a))};dl.prototype.yd=function(){this.va.K("open");this.o.update()};function el(a){X.call(this,[0],[1],a);this.D=this.va=null;this.L=0;this.o=this.Fa=null}r(el,X);el.prototype.tb=function(a,b,c){this.o=c;this.D=b;this.va=a.view();this.L=a.height()};el.prototype.Ge=function(){const a=this.D.fb();U(this.va,"bottom",a-this.L+"px");U(this.o.container(),"bottom",a+"px");this.va.U("close")};
el.prototype.ob=function(a){var b=a[0];const c=this.D.fb();a=this.L*b;U(this.va,"bottom",c-a+"px");a=this.L*(1-b);U(this.o.container(),"bottom",Math.ceil(c+a)+"px");b=this.D.gb();a=b.height()-a;this.o.resize(new w(b.width(),a))};el.prototype.yd=function(){this.va.K("open");this.o.update()};function fl(a,b,c){this.l=b;this.Jb=a;this.Ca=c}function gl(a,b){b=Math.floor(b.height()*a.l.rp);return Math.max(b,a.l.minHeight)}e=fl.prototype;e.yk=function(a){a=a-this.l.Zc-2*(this.l.fg+this.l.jc);a=1==this.Ca?a-this.l.Zc:a-(this.l.Wf+this.l.Qh+this.l.dg);return Math.floor(a)};e.zk=function(a){a=a+this.l.Zc+2*(this.l.fg+this.l.jc);a=1==this.Ca?a+this.l.Zc:a+(this.l.Wf+this.l.Qh+this.l.dg);return Math.floor(a)};e.Ak=function(a){a+=2*this.l.Ve;1<this.Ca&&(a+=2*this.l.Xf);return a};
e.xk=function(a){a-=2*this.l.Ve;1<this.Ca&&(a-=2*this.l.Xf);return a};e.rf=function(a,b,c){let d=1,f=1;a.width()<b&&(d=a.width()/b);a.height()<c&&(f=a.height()/c);return Math.min(d,f)};function hl(a,b,c){fl.call(this,a,b,c)}r(hl,fl);hl.prototype.Tl=function(a){let b=gl(this,a),c=this.yk(b),d=this.wk(c),f=(d+2*(this.l.Vh+this.l.jc+this.l.ii))*this.l.qb,g=this.Ak(f);g>a.width()&&(a.width()>t.Ab?g=a.width():g>t.Ab&&(g=t.Ab),f=this.xk(g),d=f/this.l.qb-2*(this.l.Vh+this.l.jc+this.l.ii),c=this.vk(d),b=this.zk(c));a=this.rf(a,t.Ab,t.Uh);1!=a&&(g*=a,b*=a);return{mg:new w(g,b),Lh:f,Kh:new w(d,c),scale:a}};hl.prototype.wk=function(a){return Math.floor(a*this.Jb*2)};
hl.prototype.vk=function(a){return a/this.Jb/2};function il(a,b,c){Tk.call(this,a,b);this.g=null;this.Ob=new mk;this.Pb=[];this.be=0;this.$a=new Qk(this);this.Me=null;this.df=this.vb=this.Jb=0;this.Xb=!1;this.L=0;this.o=null;this.ee=c;this.vd=new dl(this.l.animationDuration);this.vd.ma.addHandler(this.Wg,this);this.md=new el(this.l.animationDuration);this.md.ma.addHandler(this.wg,this)}r(il,Tk);e=il.prototype;e.view=function(){return this.g};e.height=function(){return this.L};
e.B=function(a){this.Xb&&(a=Math.floor(a/2+1),this.vb!=a&&(al(this,Math.ceil(a/this.l.qb)),jl(this,a),this.vb=a))};e.eb=function(a){il.W.eb.call(this,a);this.be=Math.floor(this.v()/2)+1};e.Tj=function(a){this.o=a};e.toggle=function(a){1==this.state()?this.close(a):this.open(a)};e.open=function(a){if(a)this.vd.play();else{U(this.D.ga,"bottom",Math.ceil(this.L+Z(this))+"px");U(this.g,"bottom",Z(this)+"px");this.g.U("close");a=this.D.gb();const b=a.height()-this.L;this.o.resize(new w(a.width(),b));this.Wg()}};
e.close=function(a){a?this.md.play():(U(this.g,"bottom",Z(this)-this.L+"px"),this.g.U("open"),this.wg())};
e.enable=function(a){this.g=new V(["thumbnailWrapper",this.l.className,"close"]);this.g.Wh(!0);this.D.h(this.g);var b=ac(this.nc);this.Jb=b.width/b.height;this.Ca=Math.ceil(this.be/this.l.qb);b=this.Jg();this.L=b.mg.height();this.Me=b.Kh;const c=this.Me.height()+2*this.l.jc;this.Aa=Yk(this,c,b.Lh);this.g.h(this.Aa);this.kh(b.scale);this.vd.tb(this,this.D,this.o);this.md.tb(this,this.D,this.o);this.Xb=!0;this.B(a);U(this.g,"bottom",Z(this)-this.L+"px");this.Ec.i();this.Zb()};
e.hm=function(){U(this.D.ga,"bottom","");const a=this.D.gb();this.o.resize(a);U(this.g,"display","none");Sk(this,2)};e.show=function(){U(this.D.ga,"bottom",Math.ceil(this.L+Z(this))+"px");const a=this.D.gb(),b=a.height()-this.L;this.o.resize(new w(a.width(),b));U(this.g,"display","");Sk(this,1)};e.disable=function(){il.W.disable.call(this);this.Pb=[];this.vb=0;this.Xb=!1;this.L=0;U(this.D.ga,"bottom",Z(this)+"px");this.D.removeChild(this.g)};
e.resize=function(){const a=this.Jg();this.L=a.mg.height();this.kh(a.scale);this.vd.tb(this,this.D,this.o);this.md.tb(this,this.D,this.o);0==this.state()?U(this.g,"bottom",Z(this)-this.L+"px"):1==this.state()&&(U(this.D.ga,"bottom",Math.ceil(this.L+Z(this))+"px"),U(this.g,"bottom",Z(this)+"px"));this.Me=a.Kh;for(var b=0;b<this.Pb.length;++b)this.Pb[b].da(this.Me);b=this.Me.height()+2*this.l.jc;Uk(this,b,a.Lh)};e.update=function(){for(let a=0;a<this.Pb.length;++a)this.Pb[a].update();this.Zb()};
e.Vn=function(a){for(var b=0;b<this.Pb.length;++b)this.Td.removeChild(this.Pb[b]);this.Pb=[];b=(a-1)*this.l.qb+1;a=Math.min(b+this.l.qb-1,this.be);for(var c;b<=a;++b)Yj(b,this.v())?(c=1==b?1:this.v(),c=new Pk(b,c,this.Me,this.ee)):c=new Ok(b,this.Me,this.Ob,this.ee),c.hj.addHandler(this.dr,this),this.Td.h(c),this.Pb.push(c);jl(this,this.vb)};e.Zb=function(){const a=this.$a.Ja();this.$a.render(a)};e.dr=function(a,b){this.vb!=a&&this.mc(b)};e.Wg=function(){Sk(this,1)};e.wg=function(){Sk(this,0)};
function jl(a,b){for(let c=0;c<a.Pb.length;++c){const d=a.Pb[c].mo;0!=a.vb&&a.vb!=b&&a.vb==d&&a.Pb[c].setActive(!1);d==b&&a.Pb[c].setActive(!0)}}e.Jg=function(){return(new hl(this.Jb,this.l,this.Ca)).Tl(this.D.gb())};
e.kh=function(a){this.D.gb().width()<t.Ab?this.Aa.ca(t.Ab-2*this.l.Ve):this.Aa.displayObject().style.width="";1>a?(this.Aa.K("scaled"),O(this.Aa.displayObject(),a),this.D.gb().width()<t.Ab?U(this.Aa,"margin-left",(this.D.gb().width()-t.Ab)/2+"px"):U(this.Aa,"margin-left","")):(O(this.Aa.displayObject(),1),this.Aa.U("scaled"),U(this.Aa,"margin-left",""))};e.bn=function(a){let b=(a-1)*this.l.qb*2;0==b&&(b=1);a=a*this.l.qb*2-1;a>this.v()&&(a=this.v());return{left:b,right:a}};function kl(a,b,c){V.call(this,"thumbnailView");this.za=a;this.Nn=new D;this.Nb=new V("selection");this.h(this.Nb);this.ha=Ug(c,a,b);this.ha.H.addHandler(function(){this.Nn.i(a)},this);this.Nb.h(this.ha.displayObject())}r(kl,V);e=kl.prototype;e.page=function(){return this.ha};e.pageNumber=function(){return this.za};e.da=function(a){this.ha.da(a)};e.update=function(){this.ha.reset()};e.setActive=function(a){a?this.Nb.K("selected"):this.Nb.U("selected")};function ll(a){this.Mb=[];this.th=a}e=ll.prototype;e.Ja=function(){const a=[],b=this.th.ia;for(let c=0;c<b.length;++c)a.push(b[c].page());return a};e.render=function(a){const b=this.Hg(a);b&&!this.Og(b)&&(b.Jh()?this.Yd(b):(a=b.pageNumber(),this.Mb[a]||(this.Mb[a]=!0,this.th.document().getPage(a,(c,d)=>{b.Zh(c);this.Mb[d]=!1;this.render(this.Ja())}))))};
e.Yd=function(a){switch(a.$){case 3:break;case 2:break;case 1:break;case 0:a.ab.addHandler(function(){this.render(this.Ja())},this);a.render();break;default:throw Error("renderingState is wrong");}};e.Hg=function(a){for(let b=0;b<a.length;++b)if(!this.Ng(a[b]))return a[b];return null};e.Ng=function(a){return 3==a.$};e.Og=function(a){return 1==a.$};function ml(a){X.call(this,[0],[1],a);this.D=this.va=null;this.L=0}r(ml,X);ml.prototype.tb=function(a,b,c){this.va=a;this.D=b;this.L=c};ml.prototype.Ge=function(){const a=this.D.fb()-this.L;U(this.va,"bottom",a+"px");this.va.U("close")};ml.prototype.ob=function(a){a=this.L*(1-a[0]);U(this.va,"bottom",this.D.fb()-a+"px")};ml.prototype.yd=function(){this.va.K("open")};function nl(a){X.call(this,[0],[1],a);this.D=this.va=null;this.L=0}r(nl,X);nl.prototype.tb=function(a,b,c){this.va=a;this.D=b;this.L=c};nl.prototype.Ge=function(){U(this.va,"bottom",this.D.fb()+"px");this.va.U("open")};nl.prototype.ob=function(a){a=this.L*a[0];U(this.va,"bottom",this.D.fb()-a+"px")};nl.prototype.yd=function(){this.va.K("close")};function ol(a,b,c,d){fl.call(this,a,b,c);this.Z=d}r(ol,fl);e=ol.prototype;e.Tl=function(a){let b=gl(this,a),c=this.yk(b),d=this.wk(c);const f=Math.min(this.Z,this.l.qb);let g=(d+2*(this.l.Vh+this.l.jc+this.l.ii))*f,h=this.Ak(g);h>a.width()&&(a.width()>t.Ab?h=a.width():h>t.Ab&&(h=t.Ab),g=this.xk(h),d=g/f-2*(this.l.Vh+this.l.jc+this.l.ii),c=this.vk(d),b=this.zk(c));a=this.rf(a,h,b);return{mg:new w(h,b),Lh:g,Kh:new w(d,c),scale:a}};
e.yk=function(a){a=a-this.l.Zc-2*(this.l.fg+this.l.jc)-this.l.Oo;a=1==this.Ca?a-this.l.Zc:a-(this.l.Wf+this.l.Qh+this.l.dg);return Math.floor(a)};e.zk=function(a){a=a+this.l.Zc+2*(this.l.fg+this.l.jc)+this.l.Oo;a=1==this.Ca?a+this.l.Zc:a+(this.l.Wf+this.l.Qh+this.l.dg);return Math.floor(a)};e.Ak=function(a){a+=2*(this.l.Ve+this.l.Ul);1<this.Ca&&(a+=2*this.l.Xf);return a};e.xk=function(a){a-=2*(this.l.Ve+this.l.Ul);1<this.Ca&&(a-=2*this.l.Xf);return a};e.wk=function(a){return Math.floor(a*this.Jb)};
e.vk=function(a){return a/this.Jb};function pl(a,b,c){Tk.call(this,a,b);this.g=null;this.Ob=new mk;this.ia=[];this.$a=new ll(this);this.jb=null;this.df=this.F=this.Jb=0;this.Xb=!1;this.L=0;this.ee=c;this.vd=new ml(this.l.animationDuration);this.vd.ma.addHandler(this.Wg,this);this.md=new nl(this.l.animationDuration);this.md.ma.addHandler(this.wg,this)}r(pl,Tk);e=pl.prototype;e.view=function(){return this.g};e.B=function(a){this.Xb&&this.F!=a&&(al(this,Math.ceil(a/this.l.qb)),ql(this,a),this.F=a)};
e.toggle=function(a){1==this.state()?this.close(a):this.open(a)};e.open=function(a){a?this.vd.play():(U(this.g,"bottom",Z(this)+"px"),this.g.U("close"),this.Wg())};e.close=function(a){a?this.md.play():(U(this.g,"bottom",Z(this)-this.L+"px"),this.g.U("open"),this.wg())};e.hm=function(){U(this.g,"display","none");Sk(this,2)};e.show=function(){U(this.g,"display","");Sk(this,1)};
e.enable=function(a){this.g=new V(["thumbnailWrapper",this.l.className,"close"]);this.g.Wh(!0);this.D.h(this.g);var b=ac(this.nc);this.Jb=b.width/b.height;this.Ca=Math.ceil(this.v()/this.l.qb);b=this.Jg();this.L=b.mg.height();this.jb=b.Kh;const c=this.jb.height()+2*this.l.jc;this.Aa=Yk(this,c,b.Lh);this.g.h(this.Aa);this.kh(b);this.vd.tb(this.g,this.D,this.L);this.md.tb(this.g,this.D,this.L);this.Xb=!0;this.B(a);U(this.g,"bottom",Z(this)-this.L+"px");this.Ec.i();this.Zb()};
e.disable=function(){pl.W.disable.call(this);this.ia=[];this.F=0;this.Xb=!1;this.L=0;U(this.D.ga,"bottom",Z(this)+"px");this.D.removeChild(this.g)};
e.resize=function(){const a=this.Jg();this.L=a.mg.height();this.kh(a);this.vd.tb(this.g,this.D,this.L);this.md.tb(this.g,this.D,this.L);0==this.state()?U(this.g,"bottom",Z(this)-this.L+"px"):1==this.state()&&(U(this.D.ga,"bottom",Z(this)+"px"),U(this.g,"bottom",Z(this)+"px"));this.jb=a.Kh;for(var b=0;b<this.ia.length;++b)this.ia[b].da(this.jb);b=this.jb.height()+2*this.l.jc;Uk(this,b,a.Lh)};e.update=function(){for(let a=0;a<this.ia.length;++a)this.ia[a].update();this.Zb()};
e.Vn=function(a){for(var b=0;b<this.ia.length;++b)this.Td.removeChild(this.ia[b]);this.ia=[];b=(a-1)*this.l.qb+1;for(a=Math.min(b+this.l.qb-1,this.v());b<=a;++b){const c=new kl(b,this.jb,this.ee);c.Nn.addHandler(this.Hq,this);this.Td.h(c);this.ia.push(c)}ql(this,this.F)};e.Zb=function(){const a=this.$a.Ja();this.$a.render(a)};e.Hq=function(a){this.F!=a&&this.mc(a)};e.Wg=function(){Sk(this,1)};e.wg=function(){Sk(this,0)};
e.kh=function(a){if(1>a.scale){this.Aa.K("scaled");const b=this.l.Ve+this.l.Ul,c=a.mg.width();this.Aa.ca(c-2*b);O(this.Aa.displayObject(),a.scale);this.D.gb().width()<c?U(this.Aa,"margin-left",(this.D.gb().width()-c+b)/2+"px"):U(this.Aa,"margin-left","")}else O(this.Aa.displayObject(),1),this.Aa.U("scaled"),U(this.Aa,"margin-left",""),this.Aa.displayObject().style.width=""};
function ql(a,b){for(let c=0;c<a.ia.length;++c){const d=a.ia[c].pageNumber();0!=a.F&&a.F!=b&&a.F==d&&a.ia[c].setActive(!1);d==b&&a.ia[c].setActive(!0)}}e.Jg=function(){return(new ol(this.Jb,this.l,this.Ca,this.v())).Tl(this.D.gb())};e.bn=function(a){const b=(a-1)*this.l.qb+1;a*=this.l.qb;a>this.v()&&(a=this.v());return{left:b,right:a}};function rl(a,b,c){const d=new Rj;this.g=new Mk(a.clientWidth,a.clientHeight);a.appendChild(this.g.ya);W.call(this,a,b,2,Nk,d,c);this.Eg=new Oj(this.g);this.oh=this.jf=this.Cc=0;this.Ma=new Cj;this.Ma.Ta().addHandler(this.Xc,this);this.Ma.Sa().addHandler(this.Vc,this);this.Ma.Bb().addHandler(this.ae,this);this.Ma.Rb().addHandler(this.pd,this);this.pa=new Ij(this.g.ga);this.pa.Ol.addHandler(this.Pl,this);this.pa.ng().addHandler(this.Ah,this);this.pa.Ke.ol.addHandler(this.Ll,this);this.pa.Ta().addHandler(this.Xc,
this);this.pa.Sa().addHandler(this.Vc,this);this.g.bf().addHandler(this.El,this);this.g.Ta().addHandler(this.Xc,this);this.g.Sa().addHandler(this.Vc,this);this.g.Bb().addHandler(this.ae,this);this.g.Rb().addHandler(this.pd,this);this.g.af().addHandler(this.Fl,this);this.g.setScale(0);this.Ac(1,oi);this.Ac(2,zk);this.Xd(1,pl,Nk.Zj);this.Xd(2,il,Nk.$j);this.ah()}r(rl,W);rl.prototype.view=function(){return this.g};
rl.prototype.resize=function(a,b){this.Cc&&clearTimeout(this.Cc);this.fa=new w(a,b);this.g.tc(this.fa);this.Ka&&this.Ka.da(this.fa);this.ra.Bj&&(this.T.resize(),this.s.resize(this.Qd()),this.Cc=setTimeout(this.Al.bind(this),Nk.pm));document.body.scrollTop=0};rl.prototype.Pc=function(){return this.s.Pc()};rl.prototype.viewPages=rl.prototype.Pc;e=rl.prototype;e.Al=function(){this.s.update();this.T.update()};
e.Wb=function(a){rl.W.Wb.call(this,a);this.T.enable(this.ra.Ea);this.T.view().K("tablet");this.s.resize(this.Qd());this.s.enable(this.ra.Ea);this.g.vc(a)};e.ah=function(){if(window.location.hash){var a=this.$g(window.location.hash.substring(1));"page"in a&&(this.ra.Ea=parseInt(a.page,10));if("mode"in a)switch(a.mode){case "book":this.lc=2;break;case "pages":this.lc=1}}};
e.$g=function(a){a=a.split("&");const b={};for(let c=0;c<a.length;++c){const d=a[c].split("=");b[decodeURIComponent(d[0].toLowerCase())]=1<d.length?decodeURIComponent(d[1]):null}return b};e.Xc=function(){this.s.$e()};e.Vc=function(){this.s.Ze()};e.El=function(){switch(this.lc){case 2:this.Wb(1);break;case 1:this.Wb(2)}};e.Qd=function(){const a=this.g.gb();let b=a.height();this.T instanceof il&&0!=this.T.state()&&(b-=this.T.height());return new w(a.width(),b)};e.ae=function(a){this.s.B(a)};e.pd=function(){this.Eg.toggle()};
e.Ac=function(a,b){rl.W.Ac.call(this,a,b);if(b=this.Hb.ji())this.wa[a].Pa=b;this.wa[a].Qj(this.Hb.jb);this.wa[a].Jf.addHandler(this.Hl,this);this.wa[a].Ec.addHandler(this.Il,this)};e.Xd=function(a,b,c){rl.W.Xd.call(this,a,b,c);this.nb[a].Ya.addHandler(this.ul,this);this.nb[a].ce.addHandler(this.vl,this);this.nb[a].Ec.addHandler(this.wl,this)};
e.td=function(a){rl.W.td.call(this,a);vg(a,this.Sc);const b=a.v();this.g.B(1);this.g.ua(b);this.wa[2].eb(a);this.wa[1].eb(a);this.nb[2].eb(a);this.nb[1].eb(a);a=this.nb[2];a instanceof il&&a.Tj(this.wa[2]);this.Wb(this.lc);this.Ma.ua(b);1==b&&(this.g.uc(!1),this.g.hd(!1));fh(this)};e.Te=function(a){rl.W.Te.call(this,a);this.g.B(a);null!==this.T&&this.T.B(a);this.mc(a)};
e.Hl=function(a){this.g.setScale(a);0<a?(this.ea.isActive()||this.ea.enable(),1==this.T.state()&&this.T.hm(),a=this.pa,a.sd&&(jf(a.Ae),a.sd=!1),a=this.pa,a.Sd&&(jf(a.zf),a.Sd=!1)):(this.ea.isActive()&&this.ea.disable(),2==this.T.state()&&this.T.show(),1==this.Y.v()&&this.g.uc(!1),a=this.pa,a.sd||(hf(a.Ae),a.sd=!0),a=this.pa,a.Sd||(hf(a.zf),a.Sd=!0))};e.Il=function(){this.s.setScale(0);this.g.setScale(0);this.ea.isActive()&&this.ea.disable()};e.ul=function(a){this.ra.Ea=a;this.g.B(a);this.s.B(a)};
e.vl=function(a){this.ra.Vj=a;this.g.gd(a)};e.wl=function(){1==this.ra.Vj?this.T.open():this.T.close()};e.Fl=function(){this.T.toggle(!0)};e.Pl=function(a,b){this.oh=this.s.Ed();this.s.Gd(a,b)};e.Ah=function(a){a=this.rf(this.oh*a);a=Ca(a,Nk.Ye,Nk.Xe);this.s.ke(a)};e.Ll=function(){this.s.update()};e.rf=function(a){return(a-1)/(this.s.bb-1)};function sl(){V.call(this,["viewer",t.oe.className]);this.o=null}r(sl,V);sl.prototype.bi=function(a){this.o=a};sl.prototype.sb=function(){return this};function tl(a){this.Mb=[];this.o=a;this.Be=[];this.gn=!0}r(tl,Zh);
tl.prototype.Ja=function(){let a=this.o;var b=zh(a),c=b.scrollTop;let d=c+b.clientHeight;var f=b=ul(this,c);let g=[],h=a.v(),l;let m,k;for(let q=b;q<h;++q){l=a.getPage(q);var n=l.displayObject();m=n.offsetTop+n.clientTop;if(m>d)break;k=n.offsetLeft+n.clientLeft;f=n.clientHeight;n=Math.max(0,c-m)+Math.max(0,m+f-d);n=100*(f-n)/f|0;f=q;g.push({je:l.pageNumber(),top:m,left:k,page:l,Kj:n})}c=g[0];g.sort((q,C)=>{const F=q.Kj-C.Kj;return.001<Math.abs(F)?-F:q.id-C.id});a.$d.So&&f+1<=h-1&&g.push({je:f+2,page:a.getPage(f+
1),Kj:0});0<b&&g.push({je:b-1,page:a.getPage(b-1),Kj:0});return{ss:c,Qc:g}};tl.prototype.update=function(){for(var a=0;a<this.Be.length;++a)this.Be[a].reset();a=this.Ja();this.render(a.Qc)};tl.prototype.Y=function(){return this.o.document()};
tl.prototype.Yd=function(a){switch(a.$){case 3:break;case 2:break;case 1:break;case 0:vl(this,a);a.ab.addHandler(function(){const b=this.Ja();this.gn&&a.focus();this.gn=!1;this.render(b.Qc)},this);a.render();break;default:throw Error("renderingState is wrong");}};function vl(a,b){const c=a.Be.indexOf(b);0<=c&&a.Be.splice(c,1);a.Be.push(b);10<a.Be.length&&a.Be.shift().destroy()}
function ul(a,b){function c(h){h=h.displayObject();return h.offsetTop+h.clientTop+h.clientHeight>b}a=a.o;let d=0,f=a.v()-1,g=a.getPage(d);if(c(g))return d;for(;d<f;){const h=d+f>>1;g=a.getPage(h);c(g)?f=h:d=h+1}return d};var wl=function(){if(tb){var a=/Windows NT ([0-9.]+)/;return(a=a.exec(hb()))?a[1]:"0"}return sb?(a=/1[0|1][_.][0-9_.]+/,(a=a.exec(hb()))?a[0].replace(/_/g,"."):"10"):vb?(a=/Android\s+([^\);]+)(\)|;)/,(a=a.exec(hb()))?a[1]:""):wb||xb||yb?(a=/(?:iPhone|CPU)\s+OS\s+(\S+)/,(a=a.exec(hb()))?a[1].replace(/_/g,"."):""):""}();function xl(a){return(a=a.exec(hb()))?a[1]:""}var yl=function(){if(Wd)return xl(/Firefox\/([0-9.]+)/);if(v||ob||nb)return Bb;if($d){if(lb()||u("Macintosh")){var a=xl(/CriOS\/([0-9.]+)/);if(a)return a}return xl(/Chrome\/([0-9.]+)/)}if(ae&&!lb())return xl(/Version\/([0-9.]+)/);if(Xd||Yd){if(a=/Version\/(\S+).*Mobile\/(\S+)/.exec(hb()))return a[1]+"."+a[2]}else if(Zd)return(a=xl(/Android\s+([0-9.]+)/))?a:xl(/Version\/([0-9.]+)/);return""}();function zl(a,b,c,d,f){oh.call(this,b,c,d,f);this.element=a}r(zl,oh);zl.prototype.Xj=function(){};zl.prototype.Gj=function(){this.Xj();zl.W.Gj.call(this)};zl.prototype.Ph=function(){this.Xj();zl.W.Ph.call(this)};zl.prototype.Hj=function(){this.Xj();zl.W.Hj.call(this)};function Al(a,b,c,d,f){if(2!=b.length||2!=c.length)throw Error("Start and end points must be 2D");zl.call(this,a,b,c,d,f)}r(Al,zl);
Al.prototype.Xj=function(){if(this.us){var a=this.element,b=Math.round(this.coords[0]);b=Math.max(b,0);if("rtl"==Md(a)){var c=ae&&0<=fb(yl,10),d;if(d=zb)d=0<=fb(wl,10);const f=$d&&0<=fb(yl,85);a.scrollLeft=qb||c||d||f?-b:pb?b:a.scrollWidth-b-a.clientWidth}else a.scrollLeft=b}else this.element.scrollLeft=Math.round(this.coords[0]);this.element.scrollTop=Math.round(this.coords[1])};function Bl(a,b){Al.call(this,a,[0,0],[0,0],b)}r(Bl,Al);function Cl(a,b,c){this.za=a||0;this.ir=b||0;this.bq=c||0}Cl.prototype.pageNumber=function(){return this.za};Cl.prototype.top=function(){return this.ir};Cl.prototype.left=function(){return this.bq};function Dl(a){Ch.call(this,a);this.g=null;this.Io=0;this.ia=[];this.df=0;this.$a=new tl(this);this.$d={So:!0,km:0,position:0};this.wi=!0;this.Kk=!1;this.pc=0;this.qn=new Cl;this.sf=null;this.Rd=!1;this.wc=new th(0,0);this.bo=new Bl(a.displayObject(),t.ks);x(this.bo,"finish",this.co,!1,this);this.Ec.addHandler(function(){var b=this.g.displayObject();this.ea.Na=b},this)}r(Dl,Ch);e=Dl.prototype;e.$l=function(){this.ia[this.F-1].focus()};e.sm=function(a){this.Rd=a};e.view=function(){return this.g};
e.Pc=function(){return[this.F-1]};e.B=function(a){if(Bh(this,a)&&0==this.pc){var b=zh(this),c=this.ia[a-1].displayObject();const d=b.scrollTop;c=c.offsetTop+c.clientTop-t.oe.Ga;this.pc=a;this.Kk=!0;this.wi?(b.scrollTop=c,this.$d.position=c/b.scrollHeight,this.wi=!1,this.co()):(a=this.bo,b=c,a.kg=[0,d],a.Qo=[0,b],a.play(!0))}};e.$e=function(){1>=this.F||this.B(this.F-1)};e.Ze=function(){this.F>=this.v()||this.B(this.F+1)};
e.getPage=function(a){if(0>a||a>this.v())throw Error("PageNumber is wrong");return this.ia[a]};e.setScale=function(a){if(this.Db!=a&&0==this.pc){var b=this.P;this.Db=a;this.P=a*(this.bb-1)+1;for(a=0;a<this.ia.length;++a)this.ia[a].setScale(this.P);El(this);this.Jf.i(this.Db);Fl(this,.5,this.P/b-1)}};
e.ke=function(a){const b=this.P;this.setScale(a);var c=zh(this);a=this.g.sb().displayObject().getBoundingClientRect();const d=c.getBoundingClientRect();c=Math.min(this.wc.x(),a.right);c=Math.max(c,a.left);c=(c-a.left)/a.width;a=this.wc.y()/d.height;Fl(this,c,a*(this.P/b-1)*2)};e.Gd=function(a,b){this.wc=new th(a,b)};
e.resize=function(a){this.Fa=a;this.Bl();if(this.Xb){this.P=this.Db*(this.bb-1)+1;for(a=0;a<this.ia.length;++a){var b=this.ia[a].bd(),c=this.Wa(b);b=b.clone({scale:c*this.P});this.ia[a].da(b,this.P)}El(this);a=this.qn;b=a.left();c=a.top();a=this.ia[a.pageNumber()-1];c=[a.C.convertToViewportPoint(b,c),a.C.convertToViewportPoint(b,c)];b=Math.min(c[0][0],c[1][0]);c=Math.min(c[0][1],c[1][1]);a:{a=a.displayObject();b={left:b,top:c};let d=a.offsetParent;if(d){c=a.offsetTop+a.clientTop;for(a=a.offsetLeft+
a.clientLeft;d.clientHeight===d.scrollHeight;)if(d.dataset.Rq&&(c/=d.dataset.Rq,a/=d.dataset.Bs),c+=d.offsetTop,a+=d.offsetLeft,d=d.offsetParent,!d){a=0;break a}b&&(void 0!==b.top&&(c+=b.top),void 0!==b.left&&(a+=b.left,d.scrollLeft=a));a=c}else console.error("offsetParent is not set -- cannot scroll"),a=0}zh(this).scrollTop=a}};
e.enable=function(a){this.g=new sl;this.g.bi(this);this.container().K(t.oe.qp);this.container().h(this.g);const b=zh(this);x(b,"scroll",this.Zd,!1,this);Gl(this);El(this);1==a&&(this.wi=!1);this.B(a);this.Zb();Ah(this)};e.disable=function(){Dl.W.disable.call(this);this.container().U(t.oe.qp);this.container().removeChild(this.g);this.g=null;const a=this.container().displayObject();y(a,"scroll",this.Zd,!1,this);this.wi=!0;this.ia=[]};e.update=function(){this.$a.update()};
function Gl(a){let b=0;for(let f=1;f<=a.v();++f){var c=$b(a.nc,f),d=a.Wa(c);d=c.clone({scale:d});d.width>b&&(b=d.width,a.Io=f-1);d=new ig(f,d,a.P,a.Rd);d.O=c;a.Pa&&d.ab.addHandler(function(g,h){h=this.Wa(h)*xh(h);this.Pa.render(g,this.P,h)}.bind(a,d,c));a.ia.push(d);c=new V("shadowOffset");c.h(d);a.g.h(c)}}
e.Zd=function(){0!=this.df||this.Kk||(this.df=window.requestAnimationFrame(()=>{const a=zh(this).scrollTop;a!==this.$d.km&&(this.$d.So=a>this.$d.km);this.$d.km=a;const b=this.g.sb().displayObject();this.$d.position=a/b.clientHeight;this.df=0;this.Zb()}))};e.Zb=function(){var a=this.$a.Ja(),b=a.Qc;a=a.ss;this.$a.render(b);b=b[0].je;b!=this.F&&(this.F=b,this.mc());b=zh(this).scrollLeft-a.left;var c=zh(this).scrollTop-a.top;b=a.page.C.convertToPdfPoint(b,c);this.qn=new Cl(a.je,Math.round(b[1]),Math.round(b[0]))};
e.co=function(){const a=this.pc;this.pc=0;this.F=a;this.Kk=!1;this.Zd();this.mc()};e.Wa=function(a){const b=2*t.oe.Ga,c=(this.Fa.width()-b)/a.width;a=(this.Fa.height()-b)/a.height;return Math.min(a,c)};function El(a){const b=Math.round(a.ia[a.Io].width()+2*t.oe.Ga);a.g.ca(b)}e.Bl=function(){var a=ac(this.nc);const b=this.Wa(a);a=a.clone({scale:b}).width+2*t.oe.Ga;a=this.Fa.width()/a*2;this.bb=Math.max(a,this.bb)};
function Fl(a,b,c){const d=zh(a),f=a.g.sb().displayObject(),g=f.getBoundingClientRect(),h=d.getBoundingClientRect();yk(d,Math.max(g.width-h.width,0)*b,f.clientHeight*a.$d.position+h.height/2*c)};function Hl(a,b){V.call(this,"slider");this.xh=a;this.Tm=!1;this.jj=[];if(a>b)throw Error("An incorrect range");this.xf=a;this.Ki=b;this.Jm=new V("slider__slider-base");this.Ck=new V("slider__handler");this.Jm.h(this.Ck);this.h(this.Jm);this.Mm=new D;this.nh=new D;this.ma=new D;x(this.Ck.displayObject(),"mousedown",this.wq,!1,this)}r(Hl,V);Hl.prototype.value=function(){return this.xh};
function Il(a,b){if(!(a.xf<=b&&b<=a.Ki))throw Error("Value is out of range");if(a.xh!=b){const c=0<=a.jj.indexOf(b);if(a.Tm&&!c)throw Error("Incorrect value");a.xh=b;a.Ck.displayObject().style.left=100*(Math.abs(a.xf)+b)/(a.Ki-a.xf)+"%"}}
Hl.prototype.wq=function(a){if(!(a.defaultPrevented||0<a.button)){this.nh.i(this.value());var b=x(document,"mousemove",function(d){d=d.clientX-this.displayObject().getBoundingClientRect().left;var f=this.width()/(this.Ki-this.xf);d=Ag(d/f-Math.abs(this.xf),this.xf,this.Ki);if(this.Tm){f=this.xh;let g=d;for(let h=0;h<=this.jj.length;++h){const l=this.jj[h],m=this.jj[h-1];if(f<d&&d>=l)g=l;else if(f>=d&&d<=m){g=m;break}}d=g}d!=this.xh&&(this.Mm.i(d),Il(this,d))},!1,this),c=x(document,"mouseup",function(){this.ma.i(this.value());
Lc(b);Lc(c)},!1,this);a.preventDefault()}};function Jl(){V.call(this,"zoomToolbarContainer");this.Wh(!0);this.Nl=Ek("zoomOut");this.h(this.Nl);this.Ue=new Hl(t.Ye,t.Xe);this.h(this.Ue);this.Ml=Ek("zoomIn");this.h(this.Ml)}r(Jl,V);Jl.prototype.setScale=function(a){this.Ml.Ra(a!=t.Xe);this.Nl.Ra(a!=t.Ye);this.Ue.value()!=a&&Il(this.Ue,a)};Jl.prototype.jg=function(){return this.Ue.ma};function Kl(a){V.call(this,["toolbar","hidden"]);this.Sf=1;this.fa=new w(0,0);const b=new V("toolbarCenter");this.Bd=new Jl;b.h(this.Bd);this.Ib=new Hk(a);b.h(this.Ib);this.sa=new Kk;b.h(this.sa);this.h(b)}r(Kl,V);e=Kl.prototype;e.width=function(){return this.fa.width()};e.height=function(){return this.fa.height()};e.ua=function(a){this.Ib.ua(a)};e.B=function(a){this.Ib.B(a)};e.vc=function(a){this.Bd.setScale(0);this.sa.vc(a);this.Ib.vc(a)};e.ed=function(a){this.sa.ed(a)};e.gd=function(a){this.sa.gd(a)};
e.setScale=function(a){this.Bd.setScale(a);this.sa.setScale(a)};e.tc=function(a){var b=a.width()/t.Ab,c=a.height()/t.Uh;b=Math.min(b,c);c=a.width();let d=t.fb;1>b?(ne(this.displayObject(),"left bottom"),O(this.displayObject(),b),d=Math.floor(t.fb*b),this.ca(a.width()*(1/b))):(ne(this.displayObject(),""),O(this.displayObject(),1),U(this,"width",""));this.Sf=Math.min(1,b);this.fa=new w(c,d)};e.uc=function(a){this.sa.uc(a)};e.hd=function(a){this.sa.hd(a)};e.dd=function(a){this.sa.dd(a)};e.bf=function(){return this.sa.zh.H};
e.Ta=function(){return this.Ib.Df.H};e.Sa=function(){return this.Ib.Af.H};e.Cm=function(){return this.Bd.Ml.H};e.Dm=function(){return this.Bd.Nl.H};e.Fm=function(){return this.Bd.Ue.nh};e.ng=function(){return this.Bd.Ue.Mm};e.Em=function(){return this.Bd.Ue.ma};e.Bb=function(){return this.Ib.gl};e.Rb=function(){return this.sa.qf.H};e.jg=function(){return this.Bd.jg()};e.af=function(){return this.sa.Pf.H};e.cd=function(){this.sa.cd()};function Ll(a,b,c){V.call(this,"mainContainer");this.fa=new w(0,0);this.wf=new V("loaderIcon");this.h(this.wf);this.ga=new V("viewerContainer");this.ga.displayObject().tabIndex=-1;this.h(this.ga);this.A=new Kl(a);this.h(this.A);this.tc(new w(b,c))}r(Ll,V);e=Ll.prototype;e.ua=function(a){this.A.ua(a)};e.B=function(a){this.A.B(a)};e.toolbar=function(){return this.A};e.gb=function(){return new w(this.fa.width(),this.fa.height()-this.A.height())};e.fb=function(){return this.A.height()};e.vc=function(a){this.A.vc(a)};
e.ed=function(a){this.A.ed(a)};e.gd=function(a){this.A.gd(a)};e.setScale=function(a){this.A.setScale(a)};e.tc=function(a){this.fa=a;this.resize(a.width(),a.height());this.A.tc(a);a=Math.round(this.A.height());U(this.ga,"bottom",a+"px")};e.bf=function(){return this.A.bf()};e.Ta=function(){return this.A.Ta()};e.Sa=function(){return this.A.Sa()};e.Bb=function(){return this.A.Bb()};e.Rb=function(){return this.A.Rb()};e.Cm=function(){return this.A.Cm()};e.Dm=function(){return this.A.Dm()};e.Fm=function(){return this.A.Fm()};
e.ng=function(){return this.A.ng()};e.Em=function(){return this.A.Em()};e.jg=function(){return this.A.jg()};e.af=function(){return this.A.af()};e.ym=function(){this.A.U("hidden")};e.cd=function(){this.A.cd()};e.wj=function(){};e.uc=function(a){this.A.uc(a)};e.hd=function(a){this.A.hd(a)};e.dd=function(a){this.A.dd(a)};function Ml(){this.o=null;this.jf=0}function Nl(a,b){b=new wi(b.displayObject());x(b,"mousewheel",a.Gl,!1,a)}Ml.prototype.bi=function(a){this.o=a};function Ol(){Ml.call(this)}r(Ol,Ml);Ol.prototype.Gl=function(a){if(a.ctrlKey||a.metaKey){a.preventDefault();var b=a.deltaY,c=a.clientX;a=a.clientY;const d=this.o.scale();b=0>b?vh(d):wh(d);d!=b&&(this.jf&&clearTimeout(this.jf),this.o.Gd(c,a),this.o.ke(b),this.jf=setTimeout(this.o.update.bind(this.o),t.Hr))}};function Pl(a,b,c){const d=new Rj;this.g=new Ll(b.Hc(),a.clientWidth,a.clientHeight);a.appendChild(this.g.ya);W.call(this,a,b,b.Rd?1:2,t,d,c);this.Ne=b.Qn?null:new tg;this.Eg=new Oj(this.g);this.jf=this.Cc=0;this.Xk=new Ol;Nl(this.Xk,this.g.ga);Nl(this.Xk,this.g.toolbar());this.Ma=new Cj;this.Ma.Ta().addHandler(this.Xc,this);this.Ma.Sa().addHandler(this.Vc,this);this.Ma.Bb().addHandler(this.ae,this);this.Ma.Rb().addHandler(this.pd,this);this.g.bf().addHandler(this.El,this);this.g.Ta().addHandler(this.Xc,
this);this.g.Sa().addHandler(this.Vc,this);this.g.Bb().addHandler(this.ae,this);this.g.Rb().addHandler(this.pd,this);this.g.Cm().addHandler(this.wr,this);this.g.Dm().addHandler(this.xr,this);this.g.Fm().addHandler(this.zr,this);this.g.ng().addHandler(this.Ah,this);this.g.Em().addHandler(this.yr,this);this.g.jg().addHandler(this.ar,this);this.g.af().addHandler(this.Fl,this);this.g.setScale(0);this.Ac(1,Dl);this.Ac(2,zk);this.Xd(1,pl,t.Zj);this.Xd(2,il,t.$j);this.ah()}r(Pl,W);Pl.prototype.view=function(){return this.g};
Pl.prototype.Pc=function(){return this.s.Pc()};Pl.prototype.viewPages=Pl.prototype.Pc;e=Pl.prototype;e.resize=function(a,b){this.Cc&&clearTimeout(this.Cc);this.fa=new w(a,b);this.g.tc(this.fa);this.Ka&&this.Ka.da(this.fa);this.ra.Bj&&(this.T.resize(),this.s.resize(this.Qd()),this.Cc=setTimeout(this.Al.bind(this),t.pm))};e.Al=function(){this.s.update();this.T.update()};
e.Wb=function(a){Pl.W.Wb.call(this,a);this.T.enable(this.ra.Ea);this.s.resize(this.Qd());this.s.enable(this.ra.Ea);this.Xk.bi(this.s);this.g.vc(a)};e.ah=function(){if(window.location.hash){var a=this.$g(window.location.hash.substring(1));"page"in a&&(this.ra.Ea=parseInt(a.page,10));if("mode"in a)switch(a.mode){case "book":this.lc=2;break;case "pages":this.lc=1}}};
e.$g=function(a){a=a.split("&");const b={};for(let c=0;c<a.length;++c){const d=a[c].split("=");b[decodeURIComponent(d[0].toLowerCase())]=1<d.length?decodeURIComponent(d[1]):null}return b};e.Xc=function(){this.s.$e()};e.Vc=function(){this.s.Ze()};e.El=function(){switch(this.lc){case 2:this.Wb(1);break;case 1:this.Wb(2)}};e.Qd=function(){const a=this.g.gb();let b=a.height();this.T instanceof il&&0!=this.T.state()&&(b-=this.T.height());return new w(a.width(),b)};e.ae=function(a){this.s.B(a)};
e.pd=function(){this.Eg.toggle();this.g.ga.displayObject().focus()};e.Ac=function(a,b){Pl.W.Ac.call(this,a,b);if(b=this.Hb.ji())this.wa[a].Pa=b;this.wa[a].Jf.addHandler(this.Hl,this);this.wa[a].Ec.addHandler(this.Il,this)};e.Xd=function(a,b,c){Pl.W.Xd.call(this,a,b,c);this.nb[a].Ya.addHandler(this.ul,this);this.nb[a].ce.addHandler(this.vl,this);this.nb[a].Ec.addHandler(this.wl,this)};
e.td=function(a){Pl.W.td.call(this,a);vg(a,this.Sc);a.Ne=this.Ne;const b=a.v();this.g.B(1);this.g.ua(b);this.wa[2].eb(a);this.wa[1].eb(a);this.nb[2].eb(a);this.nb[1].eb(a);a=this.nb[2];a instanceof il&&a.Tj(this.wa[2]);this.Wb(this.lc);this.Ma.ua(b);1==b&&(this.g.uc(!1),this.g.hd(!1));fh(this)};e.Te=function(a){Pl.W.Te.call(this,a);this.g.B(a);null!==this.T&&this.T.B(a);this.s.$l();this.mc(a)};
e.Hl=function(a){this.g.setScale(a);0<a?(this.ea.isActive()||this.ea.enable(),1==this.T.state()&&this.T.hm()):(this.ea.isActive()&&this.ea.disable(),2==this.T.state()&&this.T.show(),1==this.Y.v()&&this.g.uc(!1));this.g.ga.displayObject().focus()};e.Il=function(){this.s.setScale(0);this.g.setScale(0);this.ea.isActive()&&this.ea.disable();this.Cl()};e.ul=function(a){this.ra.Ea=a;this.g.B(a);this.s.B(a)};e.vl=function(a){this.ra.Vj=a;this.g.gd(a)};e.wl=function(){1==this.ra.Vj?this.T.open():this.T.close()};
e.wr=function(){const a=this.s.scale();if(a!=t.Xe){var b=this.g.ga.displayObject().getBoundingClientRect();this.s.Gd(b.width/2,b.height/2);this.s.ke(vh(a));this.s.update()}};e.xr=function(){const a=this.s.scale();if(a!=t.Ye){var b=this.g.ga.displayObject().getBoundingClientRect();this.s.Gd(b.width/2,b.height/2);this.s.ke(wh(a));this.s.update()}};e.zr=function(){this.Ma.Jk=!0;const a=this.g.ga.displayObject().getBoundingClientRect();this.s.Gd(a.width/2,a.height/2)};e.Ah=function(a){this.s.ke(a)};
e.yr=function(){this.Ma.Jk=!1};e.ar=function(){this.s.update()};e.Fl=function(){this.T.toggle(!0);this.g.ga.displayObject().focus()};class Ql{constructor(){this.bj=this.ll=null;this.jl=new Promise((a,b)=>{this.ll=a;this.bj=b})}resolveFunc(){return this.ll}rejectFunc(){return this.bj}resolve(a){(0,this.ll)(a)}reject(a){(0,this.bj)(a)}cancel(){(0,this.bj)("canceled")}then(a,b){return this.jl.then(a,b)}catch(a){return this.jl.catch(a)}toPromise(){return this.jl}};class Rl{cancel(){}};var Sl={Pj:"cefclientSendQuery",ep:"cefclientCancelQuery",gg:"cefclientSendCallbackResult",gs:"cefclientDispatch",fs:"cefclientDispatchCancel"};function Tl(a){return window[a]&&"function"===typeof window[a]}class Ul{constructor(){if(!Tl(Sl.Pj)||!Tl(Sl.ep)||!Tl(Sl.gg))throw Error("Cef interaction functions not found");this.Zq=window[Sl.Pj];this.Yq=window[Sl.ep];this.$q=window[Sl.gg];this.Tn=new D;this.Sn=new D;window[Sl.gs]=this.Mq.bind(this);window[Sl.fs]=this.Kq.bind(this)}nm(){return this.Tn}Pj(a,b,c,d){return this.Zq(a,b,c,d)}gg(a,b,c,d){this.$q(a,b,c,d)}Mq(a,b,c){this.Tn.i(a,b,c)}Kq(a){this.Sn.i(a)}};function Vl(a){return a instanceof Object&&void 0!==a.message&&void 0!==a.stack?`"${a.message}", stack:\n${a.stack}`:`<${typeof a}> ${a}`}
class Wl{constructor(a){this.Kd=a||new Ul;this.La={};this.ug={};this.Kd.nm().addHandler(this.Lq,this);this.Kd.Sn.addHandler(this.Jq,this)}nm(){return this.Kd.nm()}call(a,...b){const c=new Ql;b=this.Kd.Pj(a,b,c.resolveFunc(),(d,f)=>{c.rejectFunc()("cef.Client call '"+a+"' failed: "+f)});c.catch(this.Iq.bind(this,b));return c}addHandler(a,b,c){this.La[a]=b.bind(c)}removeHandler(a){delete this.La[a]}Iq(a,b){"canceled"==b&&this.Kd.Yq(a)}Lq(a,b,c){if(this.La[a]){this.ug[b]=new Rl;var d=this.La[a];try{const g=
d.apply(d,[this.ug[b]].concat(c));var f="function"===typeof g?new Promise(g):new Promise(h=>h(g))}catch(g){f=new Promise((h,l)=>{l(g)})}f.then(g=>{this.Kd.gg(b,a,!0,g);delete this.ug[b]},g=>{this.Kd.gg(b,a,!1,Vl(g));delete this.ug[b]})}else c=`Request ${a} have no handler`,this.Kd.gg(b,a,!1,Vl(Error(c))),p.console.error(c)}Jq(a){this.ug[a].cancel()}}ja("cef.Client",Wl);function Xl(a,b,c){Pl.call(this,a,b,c);this.Ap=new Wl;this.wa[2].Ho.addHandler(function(){this.Ap.call("Player_initializationFinished")},this)}r(Xl,Pl);Xl.prototype.td=function(a){const b=a.v();this.ra.Ea=2<b?2:1;Xl.W.td.call(this,a)};class Yl{constructor(a,b){this.Kp=a;this.uo=b}create(a,b,c){var d=Pl;Ne?d=Sj:L?d=rl:this.Kp.cefclientRequired&&(d=Xl);this.uo&&(c=this.uo.getState());var f=ve(!0).resume;f="resume"!=(og[f]||null);c=ma()&&f?void 0:c;return new d(a,b,c)}};function Zl(a,b){window.scrollTo(a,b)}window.yPos=function(){return window.pageYOffset};window.scrollPageTo=Zl;function $l(){this.no=new D;this.jk=this.Cg=0;this.nj=!1;this.j=xd(document,"DIV");this.j.style.width=Me?"100%":"100vw";this.j.style.height=ue?"50vh":"100vh";this.j.style.position="absolute";this.j.style.zIndex="-1";this.j.style.top="0";L&&!Ne&&(document.body.style.position="fixed");let a=window;if(Be)try{a=window.top}catch(c){}document.body.insertAdjacentElement("afterbegin",this.j);(new ResizeObserver(()=>{ue&&Ne?setTimeout(()=>{am(this)},100):am(this)})).observe(this.j);window.invalidatePlayerSize=
()=>{};window.setPlayerSize=()=>{};window.removeResizeListeners=()=>{};document.addEventListener("touchend",c=>{0==c.touches.length&&(this.nj=!1,setTimeout(()=>{am(this,!1,!1)},100))},!0);document.addEventListener("touchstart",c=>{1==window.event.touches.length&&(this.nj=!0);1<c.touches.length&&c.preventDefault()},!0);const b=a.onresize;a.onresize=()=>{b&&b();am(this)};a.onorientationchange=()=>{const c=Hd();c&&L&&(ue?setTimeout(()=>{c.blur();Le&&am(this)},800):c.blur())};Ee&&window.frameElement&&
window.frameElement.setAttribute("scrolling","no")}
function am(a,b=!1,c=!0){function d(n,q){if(b||k.Cg!=n||k.jk!=q){const C=k.Cg;k.Cg=n;k.jk=q;k.no.i(k.Cg,k.jk);C!=k.Cg&&ue&&!k.nj&&setTimeout(()=>{f(0,0)},100)}}const f=Zl;if(b||!a.nj){var g=ue?2*a.j.clientHeight:a.j.clientHeight;if(Be||!(He&&.7>g/screen.height||Xd&&.7>window.innerHeight/g)){var h=1,l=a.j.clientWidth;c&&Ee&&window.frameElement&&(l=0,h=l/window.innerWidth);var m=window.innerHeight*h,k=a;d(l,m);c&&Ee&&window.frameElement&&setTimeout(()=>{l=window.frameElement.clientWidth;h=l/window.innerWidth;
m=window.innerHeight*h;d(l,m)},0)}}};function bm(a){V.call(this,"banner");var b=new V("no-local-view");this.h(b);b=new V("message");var c=new V("title");c.V(a.ka("PB_UNAVAILABLE_BANNER_TITLE"));b.h(c);c=new V("text");c.V(a.ka("PB_UNAVAILABLE_BANNER_TEXT"));b.h(c);this.h(b)}r(bm,V);PDFJS.workerSrc="data/js/pdf.worker.js";ja("PDFJS.workerSrc",PDFJS.workerSrc);PDFJS.disableAutoFetch=!0;ja("PDFJS.disableAutoFetch",PDFJS.disableAutoFetch);
ja("PdfViewer.open",function(a,b,c,d,f){c=new ng(c);const g=Fk();if(!L||!c.Ok||g.ispringpreview||Qe||0<location.hash.length){var h=void 0!==f?null:new Tb(c.fingerprint(),c.salt()),l=(new Yl(a,h)).create(b,c,f);h&&l.ce.addHandler(()=>{var n=l.Ii;n.updated=Math.floor(Date.now()/1E3);try{Pb(h.fk,JSON.stringify(n))}catch(q){Wb(h),Pb(h.fk,JSON.stringify(n))}});(f=g.ispringpreview||a.localPermission)&&l.um();d&&d(l);"query"==a.type&&g.file?l.Ej(g.file):"fileName"==a.type&&("file:"!=document.location.protocol||
f||L?l.Ej(a.filePath):c.dn?Gk(a.filePath+".js",n=>{n=window.atob(n);var q=a.filePath;const C=q.lastIndexOf("/")+1;l.lm(n,q.substr(C,q.lastIndexOf(".")-C))}):(b.innerHTML="",d=new bm(c.Hc()),zd(b,d.displayObject())));var m=new $l;m.no.addHandler((n,q)=>{l.resize(n,q)});am(m,!0);var k=null;l.tf.addHandler(()=>{k&&clearTimeout(k);k=setTimeout(()=>{am(m,!0)},200)});Ue&&ISPFlipPlayer.initFlip(Ja({apiVersion:1}))}else location.replace("ismplayer.html"+location.search)});
ja("PdfViewer.checkMobileIntegration",function(a){a=new ng(a);const b=Fk();L&&a.Ok&&!b.ispringpreview&&(Qe||0<location.hash.length||location.replace("ismplayer.html"+location.search))});let Ye=()=>!1;function Yc(a){a&&("function"===typeof a.Yf&&a.Yf(),a.disposed=!0)}function cm(a,b){Ye()&&(b?p.console.error(a):p.console.warn(a))}function fd(a,b){const c=a.stack||a.toString();0>String(c).indexOf(a.message)&&cm(a.message,b);cm(c,b)}window.onerror=function(...a){const [b,,,,c]=a;c?fd(c,!0):cm(b,!0);return!0};qa=a=>{try{throw Error(a.message);}catch(b){fd(b,!1)}};
p.console||(window._log="",p.console={log:function(a){window._log+="\n"+a},warn:function(a){window._log+="\nwarn: "+a},error:function(a){window._log+="\nerror: "+a}});})();

!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):t.ResizeObserver=e()}(this,function(){"use strict";function t(t){return window.getComputedStyle(t)}function e(t){return parseFloat(t)||0}function n(t){for(var n=arguments.length,r=Array(n>1?n-1:0),i=1;i<n;i++)r[i-1]=arguments[i];return r.reduce(function(n,r){var i=t["border-"+r+"-width"];return n+e(i)},0)}function r(t){for(var n=["top","right","bottom","left"],r={},i=n,o=Array.isArray(i),s=0,i=o?i:i[Symbol.iterator]();;){var a;if(o){if(s>=i.length)break;a=i[s++]}else{if(s=i.next(),s.done)break;a=s.value}var u=a,c=t["padding-"+u];r[u]=e(c)}return r}function i(t,e,n,r){return{width:t,height:e,top:n,right:t+r,bottom:e+n,left:r}}function o(t){var e=t.getBBox();return i(e.width,e.height,0,0)}function s(){var n=t(document.documentElement),r=e(n.width),o=e(n.height);return i(r,o,0,0)}function a(o){var s=o.clientWidth,a=o.clientHeight;if(!s&&!a)return O;var u=t(o),c=r(u),h=c.left+c.right,f=c.top+c.bottom,l=e(u.width),p=e(u.height);"border-box"===u.boxSizing&&(Math.round(l+h)!==s&&(l-=n(u,"left","right")+h),Math.round(p+f)!==a&&(p-=n(u,"top","bottom")+f));var d=Math.round(l+h)-s,_=Math.round(p+f)-a;return 1!==Math.abs(d)&&(l-=d),1!==Math.abs(_)&&(p-=_),i(l,p,c.top,c.left)}function u(t){return t instanceof window.SVGElement}function c(t){return t===document.documentElement}function h(t){return u(t)?o(t):c(t)?s():a(t)}function f(t,e){for(var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},r={configurable:n.configurable||!1,writable:n.writable||!1,enumerable:n.enumerable||!1},i=Object.keys(e),o=Array.isArray(i),s=0,i=o?i:i[Symbol.iterator]();;){var a;if(o){if(s>=i.length)break;a=i[s++]}else{if(s=i.next(),s.done)break;a=s.value}var u=a;r.value=e[u],Object.defineProperty(t,u,r)}return t}var l=function(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")},p=function(){function t(t,e){for(var n=0;n<e.length;n++){var r=e[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(t,r.key,r)}}return function(e,n,r){return n&&t(e.prototype,n),r&&t(e,r),e}}(),d=function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function, not "+typeof e);t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}}),e&&(Object.setPrototypeOf?Object.setPrototypeOf(t,e):t.__proto__=e)},_=function(t,e){if(!t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!e||"object"!=typeof e&&"function"!=typeof e?t:e},b="function"==typeof window.WeakMap&&"function"==typeof window.Map,v=function(){function t(t,e){var n=-1;return t.some(function(t,r){var i=t[0]===e;return i&&(n=r),i}),n}return b?window.WeakMap:function(){function e(){l(this,e),this.__entries__=[]}return e.prototype.get=function(e){var n=t(this.__entries__,e);return this.__entries__[n][1]},e.prototype.set=function(e,n){var r=t(this.__entries__,e);~r?this.__entries__[r][1]=n:this.__entries__.push([e,n])},e.prototype.delete=function(e){var n=this.__entries__,r=t(n,e);~r&&n.splice(r,1)},e.prototype.has=function(e){return!!~t(this.__entries__,e)},e}()}(),y=function(){return b?window.Map:function(t){function e(){return l(this,e),_(this,t.apply(this,arguments))}return d(e,t),e.prototype.clear=function(){this.__entries__.splice(0,this.__entries__.length)},e.prototype.entries=function(){return this.__entries__.slice()},e.prototype.keys=function(){return this.__entries__.map(function(t){return t[0]})},e.prototype.values=function(){return this.__entries__.map(function(t){return t[1]})},e.prototype.forEach=function(t){for(var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,n=this.__entries__,r=Array.isArray(n),i=0,n=r?n:n[Symbol.iterator]();;){var o;if(r){if(i>=n.length)break;o=n[i++]}else{if(i=n.next(),i.done)break;o=i.value}var s=o;t.call(e,s[1],s[0])}},p(e,[{key:"size",get:function(){return this.__entries__.length}}]),e}(v)}(),w=function(){return"function"==typeof window.requestAnimationFrame?window.requestAnimationFrame:function(t){return setTimeout(function(){return t(Date.now())},1e3/60)}}(),g=function(t){function e(){t.apply.apply(t,s),s=null,a&&(r.apply.apply(r,a),a=null)}function n(){o?w(e):e()}function r(){for(var t=arguments.length,e=Array(t),r=0;r<t;r++)e[r]=arguments[r];var o=[this,e];s?a=o:(s=o,setTimeout(n,i))}var i=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,o=arguments.length>2&&void 0!==arguments[2]&&arguments[2],s=null,a=null;return r},m="function"==typeof window.MutationObserver,E=function(){function t(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];l(this,t),this._isCycleContinuous=!m||e,this._listenersEnabled=!1,this._mutationsObserver=null,this._observers=[],this.refresh=g(this.refresh.bind(this),30,!0),this._continuousUpdateHandler=g(this.refresh,70)}return t.prototype.connect=function(t){this.isConnected(t)||this._observers.push(t),this._listenersEnabled||this._addListeners()},t.prototype.disconnect=function(t){var e=this._observers,n=e.indexOf(t);~n&&e.splice(n,1),!e.length&&this._listenersEnabled&&this._removeListeners()},t.prototype.isConnected=function(t){return!!~this._observers.indexOf(t)},t.prototype.refresh=function(){var t=this._updateObservers();t?this.refresh():this._isCycleContinuous&&this._listenersEnabled&&this._continuousUpdateHandler()},t.prototype._updateObservers=function(){for(var t=!1,e=this._observers,n=Array.isArray(e),r=0,e=n?e:e[Symbol.iterator]();;){var i;if(n){if(r>=e.length)break;i=e[r++]}else{if(r=e.next(),r.done)break;i=r.value}var o=i;o.gatherActive(),o.hasActive()&&(t=!0,o.broadcastActive())}return t},t.prototype._addListeners=function(){this._listenersEnabled||(window.addEventListener("resize",this.refresh),m&&(this._mutationsObserver=new MutationObserver(this.refresh),this._mutationsObserver.observe(document,{attributes:!0,childList:!0,characterData:!0,subtree:!0})),this._listenersEnabled=!0,this._isCycleContinuous&&this.refresh())},t.prototype._removeListeners=function(){this._listenersEnabled&&(window.removeEventListener("resize",this.refresh),this._mutationsObserver&&this._mutationsObserver.disconnect(),this._mutationsObserver=null,this._listenersEnabled=!1)},p(t,[{key:"continuousUpdates",get:function(){return this._isCycleContinuous},set:function(t){m&&(this._isCycleContinuous=t,this._listenersEnabled&&t&&this.refresh())}}]),t}(),O=i(0,0,0,0),A=function(){function t(e){l(this,t),this.target=e,this._contentRect=O,this.broadcastWidth=0,this.broadcastHeight=0}return t.prototype.broadcastRect=function(){var t=this._contentRect;return this.broadcastWidth=t.width,this.broadcastHeight=t.height,t},t.prototype.isActive=function(){var t=h(this.target);return this._contentRect=t,t.width!==this.broadcastWidth||t.height!==this.broadcastHeight},t}(),ResizeObserverEntry=function ResizeObserverEntry(t,e){l(this,ResizeObserverEntry);var n=window.ClientRect||Object,r=Object.create(n.prototype);f(r,e,{configurable:!0}),f(this,{target:t,contentRect:r},{configurable:!0})},k=function(){function ResizeObserver(t,e,n){if(l(this,ResizeObserver),"function"!=typeof t)throw new TypeError("The callback provided as parameter 1 is not a function.");this._callback=t,this._targets=new y,this._activeTargets=[],this._controller=e,this._publicObserver=n}return ResizeObserver.prototype.observe=function(t){if(!arguments.length)throw new TypeError("1 argument required, but only 0 present.");if(!(t instanceof Element))throw new TypeError('parameter 1 is not of type "Element".');var e=this._targets;e.has(t)||(e.set(t,new A(t)),this._controller.isConnected(this)||this._controller.connect(this),this._controller.refresh())},ResizeObserver.prototype.unobserve=function(t){if(!arguments.length)throw new TypeError("1 argument required, but only 0 present.");if(!(t instanceof Element))throw new TypeError('parameter 1 is not of type "Element".');var e=this._targets;e.has(t)&&(e.delete(t),e.size||this.disconnect())},ResizeObserver.prototype.disconnect=function(){this.clearActive(),this._targets.clear(),this._controller.disconnect(this)},ResizeObserver.prototype.gatherActive=function(){this.clearActive();var t=this._activeTargets;this._targets.forEach(function(e){e.isActive()&&t.push(e)})},ResizeObserver.prototype.broadcastActive=function(){if(this.hasActive()){var t=this._publicObserver,e=this._activeTargets.map(function(t){return new ResizeObserverEntry(t.target,t.broadcastRect())});this.clearActive(),this._callback.call(t,e,t)}},ResizeObserver.prototype.clearActive=function(){this._activeTargets.splice(0)},ResizeObserver.prototype.hasActive=function(){return!!this._activeTargets.length},ResizeObserver}(),T=new E,C=new v,ResizeObserver=function(){function ResizeObserver(t){if(l(this,ResizeObserver),!arguments.length)throw new TypeError("1 argument required, but only 0 present.");var e=new k(t,T,this);C.set(this,e)}return p(ResizeObserver,null,[{key:"continuousUpdates",get:function(){return T.continuousUpdates},set:function(t){if("boolean"!=typeof t)throw new TypeError('type of "continuousUpdates" value must be boolean.');T.continuousUpdates=t}}]),ResizeObserver}();["observe","unobserve","disconnect"].forEach(function(t){ResizeObserver.prototype[t]=function(){var e;return(e=C.get(this))[t].apply(e,arguments)}}),"function"!=typeof window.ResizeObserver&&Object.defineProperty(window,"ResizeObserver",{value:ResizeObserver,writable:!0,configurable:!0});var x=window.ResizeObserver;return x});

/*! iScroll v5.2.0-snapshot ~ (c) 2008-2018 Matteo Spinelli ~ http://cubiq.org/license */
!function(t,i,s){function e(s,e){this.wrapper="string"==typeof s?i.querySelector(s):s,this.scroller=this.wrapper.children[0],this.scrollerStyle=this.scroller.style,this.options={resizeScrollbars:!0,mouseWheelSpeed:20,snapThreshold:.334,disablePointer:!h.hasPointer,disableTouch:h.hasPointer||!h.hasTouch,disableMouse:h.hasPointer||h.hasTouch,startX:0,startY:0,scrollY:!0,directionLockThreshold:5,momentum:!0,onScrollHandler:Function.prototype,bounce:!0,bounceTime:600,bounceEasing:"",preventDefault:!0,preventDefaultException:{tagName:/^(A|INPUT|TEXTAREA|BUTTON|SELECT)$/},HWCompositing:!0,useTransition:!0,useTransform:!0,bindToWrapper:"undefined"==typeof t.onmousedown};for(var o in e)this.options[o]=e[o];this.translateZ=this.options.HWCompositing&&h.hasPerspective?" translateZ(0)":"",this.options.useTransition=h.hasTransition&&this.options.useTransition,this.options.useTransform=h.hasTransform&&this.options.useTransform,this.options.eventPassthrough=this.options.eventPassthrough===!0?"vertical":this.options.eventPassthrough,this.options.preventDefault=!this.options.eventPassthrough&&this.options.preventDefault,this.options.scrollY="vertical"!=this.options.eventPassthrough&&this.options.scrollY,this.options.scrollX="horizontal"!=this.options.eventPassthrough&&this.options.scrollX,this.options.freeScroll=this.options.freeScroll&&!this.options.eventPassthrough,this.options.directionLockThreshold=this.options.eventPassthrough?0:this.options.directionLockThreshold,this.options.bounceEasing="string"==typeof this.options.bounceEasing?h.ease[this.options.bounceEasing]||h.ease.circular:this.options.bounceEasing,this.options.resizePolling=void 0===this.options.resizePolling?60:this.options.resizePolling,this.options.tap===!0&&(this.options.tap="tap"),this.options.useTransition||this.options.useTransform||/relative|absolute/i.test(this.scrollerStyle.position)||(this.scrollerStyle.position="relative"),"scale"==this.options.shrinkScrollbars&&(this.options.useTransition=!1),this.options.invertWheelDirection=this.options.invertWheelDirection?-1:1,this.x=0,this.y=0,this.directionX=0,this.directionY=0,this._events={},this._init(),this.refresh(),this.scrollTo(this.options.startX,this.options.startY),this.enable()}function o(t,s,e){var o=i.createElement("div"),n=i.createElement("div");return e===!0&&(o.style.cssText="position:absolute;z-index:9999",n.style.cssText="-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;position:absolute;background:rgba(0,0,0,0.5);border:1px solid rgba(255,255,255,0.9);border-radius:3px"),n.className="iScrollIndicator","h"==t?(e===!0&&(o.style.cssText+=";height:7px;left:2px;right:2px;bottom:0",n.style.height="100%"),o.className="iScrollHorizontalScrollbar"):(e===!0&&(o.style.cssText+=";width:7px;bottom:2px;top:2px;right:1px",n.style.width="100%"),o.className="iScrollVerticalScrollbar"),o.style.cssText+=";overflow:hidden",s||(o.style.pointerEvents="none"),o.appendChild(n),o}function n(s,e){this.wrapper="string"==typeof e.el?i.querySelector(e.el):e.el,this.wrapperStyle=this.wrapper.style,this.indicator=this.wrapper.children[0],this.indicatorStyle=this.indicator.style,this.scroller=s,this.options={listenX:!0,listenY:!0,interactive:!1,resize:!0,defaultScrollbars:!1,shrink:!1,fade:!1,speedRatioX:0,speedRatioY:0};for(var o in e)this.options[o]=e[o];if(this.sizeRatioX=1,this.sizeRatioY=1,this.maxPosX=0,this.maxPosY=0,this.options.interactive&&(this.options.disableTouch||(h.addEvent(this.indicator,"touchstart",this),h.addEvent(t,"touchend",this)),this.options.disablePointer||(h.addEvent(this.indicator,h.prefixPointerEvent("pointerdown"),this),h.addEvent(t,h.prefixPointerEvent("pointerup"),this)),this.options.disableMouse||(h.addEvent(this.indicator,"mousedown",this),h.addEvent(t,"mouseup",this))),this.options.fade){this.wrapperStyle[h.style.transform]=this.scroller.translateZ;var n=h.style.transitionDuration;if(!n)return;this.wrapperStyle[n]=h.isBadAndroid?"0.0001ms":"0ms";var a=this;h.isBadAndroid&&r(function(){"0.0001ms"===a.wrapperStyle[n]&&(a.wrapperStyle[n]="0s")}),this.wrapperStyle.opacity="0"}}var r=t.requestAnimationFrame||t.webkitRequestAnimationFrame||t.mozRequestAnimationFrame||t.oRequestAnimationFrame||t.msRequestAnimationFrame||function(i){t.setTimeout(i,1e3/60)},h=function(){function e(t){return r!==!1&&(""===r?t:r+t.charAt(0).toUpperCase()+t.substr(1))}var o={},n=i.createElement("div").style,r=function(){for(var t,i=["t","webkitT","MozT","msT","OT"],s=0,e=i.length;s<e;s++)if(t=i[s]+"ransform",t in n)return i[s].substr(0,i[s].length-1);return!1}();o.getTime=Date.now||function(){return(new Date).getTime()},o.extend=function(t,i){for(var s in i)t[s]=i[s]},o.addEvent=function(t,i,s,e){t.addEventListener(i,s,!!e)},o.removeEvent=function(t,i,s,e){t.removeEventListener(i,s,!!e)},o.prefixPointerEvent=function(i){return t.MSPointerEvent?"MSPointer"+i.charAt(7).toUpperCase()+i.substr(8):i},o.momentum=function(t,i,e,o,n,r){var h,a,l=t-i,c=s.abs(l)/e;return r=void 0===r?6e-4:r,h=t+c*c/(2*r)*(l<0?-1:1),a=c/r,h<o?(h=n?o-n/2.5*(c/8):o,l=s.abs(h-t),a=l/c):h>0&&(h=n?n/2.5*(c/8):0,l=s.abs(t)+h,a=l/c),{destination:s.round(h),duration:a}};var h=e("transform");return o.extend(o,{hasTransform:h!==!1,hasPerspective:e("perspective")in n,hasTouch:"ontouchstart"in t,hasPointer:!(!t.PointerEvent&&!t.MSPointerEvent),hasTransition:e("transition")in n}),o.isBadAndroid=function(){var i=t.navigator.appVersion;if(/Android/.test(i)&&!/Chrome\/\d/.test(i)){var s=i.match(/Safari\/(\d+.\d)/);return!(s&&"object"==typeof s&&s.length>=2)||parseFloat(s[1])<535.19}return!1}(),o.extend(o.style={},{transform:h,transitionTimingFunction:e("transitionTimingFunction"),transitionDuration:e("transitionDuration"),transitionDelay:e("transitionDelay"),transformOrigin:e("transformOrigin"),touchAction:e("touchAction")}),o.hasClass=function(t,i){var s=new RegExp("(^|\\s)"+i+"(\\s|$)");return s.test(t.className)},o.addClass=function(t,i){if(!o.hasClass(t,i)){var s=t.className.split(" ");s.push(i),t.className=s.join(" ")}},o.removeClass=function(t,i){if(o.hasClass(t,i)){var s=new RegExp("(^|\\s)"+i+"(\\s|$)","g");t.className=t.className.replace(s," ")}},o.offset=function(t){for(var i=-t.offsetLeft,s=-t.offsetTop;t=t.offsetParent;)i-=t.offsetLeft,s-=t.offsetTop;return{left:i,top:s}},o.isHyperlink=function(t){if(!t)return!1;for(;t;){if("A"==t.nodeName.toLocaleUpperCase())return!0;t=t.parentNode}return!1},o.preventDefaultException=function(t,i){if(o.isHyperlink(t))return!0;for(var s in i)if(i[s].test(t[s]))return!0;return!1},o.extend(o.eventType={},{touchstart:1,touchmove:1,touchend:1,mousedown:2,mousemove:2,mouseup:2,pointerdown:3,pointermove:3,pointerup:3,MSPointerDown:3,MSPointerMove:3,MSPointerUp:3}),o.extend(o.ease={},{quadratic:{style:"cubic-bezier(0.25, 0.46, 0.45, 0.94)",fn:function(t){return t*(2-t)}},circular:{style:"cubic-bezier(0.1, 0.57, 0.1, 1)",fn:function(t){return s.sqrt(1- --t*t)}},back:{style:"cubic-bezier(0.175, 0.885, 0.32, 1.275)",fn:function(t){var i=4;return(t-=1)*t*((i+1)*t+i)+1}},bounce:{style:"",fn:function(t){return(t/=1)<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375}},elastic:{style:"",fn:function(t){var i=.22,e=.4;return 0===t?0:1==t?1:e*s.pow(2,-10*t)*s.sin((t-i/4)*(2*s.PI)/i)+1}}}),o.tap=function(t,s){var e=i.createEvent("Event");e.initEvent(s,!0,!0),e.pageX=t.pageX,e.pageY=t.pageY,t.target.dispatchEvent(e)},o.click=function(s){var e,o=s.target;/(SELECT|INPUT|TEXTAREA)/i.test(o.tagName)||(e=i.createEvent(t.MouseEvent?"MouseEvents":"Event"),e.initEvent("click",!0,!0),e.view=s.view||t,e.detail=1,e.screenX=o.screenX||0,e.screenY=o.screenY||0,e.clientX=o.clientX||0,e.clientY=o.clientY||0,e.ctrlKey=!!s.ctrlKey,e.altKey=!!s.altKey,e.shiftKey=!!s.shiftKey,e.metaKey=!!s.metaKey,e.button=0,e.relatedTarget=null,e._constructed=!0,o.dispatchEvent(e))},o.getTouchAction=function(t,i){var s="none";return"vertical"===t?s="pan-y":"horizontal"===t&&(s="pan-x"),i&&"none"!=s&&(s+=" pinch-zoom"),s},o.getRect=function(t){if(t instanceof SVGElement){var i=t.getBoundingClientRect();return{top:i.top,left:i.left,width:i.width,height:i.height}}return{top:t.offsetTop,left:t.offsetLeft,width:t.offsetWidth,height:t.offsetHeight}},o}();e.prototype={version:"5.2.0-snapshot",_init:function(){this._initEvents(),(this.options.scrollbars||this.options.indicators)&&this._initIndicators(),this.options.mouseWheel&&this._initWheel(),this.options.snap&&this._initSnap(),this.options.keyBindings&&this._initKeys()},destroy:function(){this._initEvents(!0),clearTimeout(this.resizeTimeout),this.resizeTimeout=null,this._execEvent("destroy")},setScrollHeight:function(t){this.scrollHeight=t,this.refresh()},_transitionEnd:function(t){t.target==this.scroller&&this.isInTransition&&(this._transitionTime(),this.resetPosition(this.options.bounceTime)||(this.isInTransition=!1,this._execEvent("scrollEnd")))},_start:function(t){if(1!=h.eventType[t.type]){var i;if(i=t.which?t.button:t.button<2?0:4==t.button?1:2,0!==i)return}if(this.enabled&&(!this.initiated||h.eventType[t.type]===this.initiated)){!this.options.preventDefault||h.isBadAndroid||h.preventDefaultException(t.target,this.options.preventDefaultException)||t.preventDefault();var e,o=t.touches?t.touches[0]:t;this.initiated=h.eventType[t.type],this.moved=!1,this.distX=0,this.distY=0,this.directionX=0,this.directionY=0,this.directionLocked=0,this.startTime=h.getTime(),this.options.useTransition&&this.isInTransition?(this._transitionTime(),this.isInTransition=!1,e=this.getComputedPosition(),this._translate(s.round(e.x),s.round(e.y)),this._execEvent("scrollEnd")):!this.options.useTransition&&this.isAnimating&&(this.isAnimating=!1,this._execEvent("scrollEnd")),this.startX=this.x,this.startY=this.y,this.absStartX=this.x,this.absStartY=this.y,this.pointX=o.pageX,this.pointY=o.pageY,this._execEvent("beforeScrollStart")}},_move:function(t){if(this.enabled&&h.eventType[t.type]===this.initiated){this.options.preventDefault&&!h.preventDefaultException(t.target,this.options.preventDefaultException)&&t.preventDefault();var i,e,o,n,r=t.touches?t.touches[0]:t,a=r.pageX-this.pointX,l=r.pageY-this.pointY,c=h.getTime();if(this.pointX=r.pageX,this.pointY=r.pageY,this.distX+=a,this.distY+=l,o=s.abs(this.distX),n=s.abs(this.distY),!(c-this.endTime>300&&o<10&&n<10)){if(this.directionLocked||this.options.freeScroll||(o>n+this.options.directionLockThreshold?this.directionLocked="h":n>=o+this.options.directionLockThreshold?this.directionLocked="v":this.directionLocked="n"),"h"==this.directionLocked){if("vertical"==this.options.eventPassthrough)t.preventDefault();else if("horizontal"==this.options.eventPassthrough)return void(this.initiated=!1);l=0}else if("v"==this.directionLocked){if("horizontal"==this.options.eventPassthrough)t.preventDefault();else if("vertical"==this.options.eventPassthrough)return void(this.initiated=!1);a=0}a=this.hasHorizontalScroll?a:0,l=this.hasVerticalScroll?l:0,i=this.x+a,e=this.y+l,(i>0||i<this.maxScrollX)&&(i=this.options.bounce?this.x+a/3:i>0?0:this.maxScrollX),(e>0||e<this.maxScrollY)&&(e=this.options.bounce?this.y+l/3:e>0?0:this.maxScrollY),this.directionX=a>0?-1:a<0?1:0,this.directionY=l>0?-1:l<0?1:0,this.moved||this._execEvent("scrollStart"),this.moved=!0,this._translate(i,e),c-this.startTime>300&&(this.startTime=c,this.startX=this.x,this.startY=this.y)}}},_end:function(t){if(this.enabled&&h.eventType[t.type]===this.initiated){this.options.preventDefault&&!h.preventDefaultException(t.target,this.options.preventDefaultException)&&t.preventDefault();var i,e,o=(t.changedTouches?t.changedTouches[0]:t,h.getTime()-this.startTime),n=s.round(this.x),r=s.round(this.y),a=s.abs(n-this.startX),l=s.abs(r-this.startY),c=0,p="";if(this.isInTransition=0,this.initiated=0,this.endTime=h.getTime(),!this.resetPosition(this.options.bounceTime)){if(this.scrollTo(n,r),!this.moved)return this.options.tap&&h.tap(t,this.options.tap),this.options.click&&h.click(t),void this._execEvent("scrollCancel");if(this._events.flick&&o<200&&a<100&&l<100)return void this._execEvent("flick");if(this.options.momentum&&o<300&&(i=this.hasHorizontalScroll?h.momentum(this.x,this.startX,o,this.maxScrollX,this.options.bounce?this.wrapperWidth:0,this.options.deceleration):{destination:n,duration:0},e=this.hasVerticalScroll?h.momentum(this.y,this.startY,o,this.maxScrollY,this.options.bounce?this.wrapperHeight:0,this.options.deceleration):{destination:r,duration:0},n=i.destination,r=e.destination,c=s.max(i.duration,e.duration),this.isInTransition=1),this.options.snap){var d=this._nearestSnap(n,r);this.currentPage=d,c=this.options.snapSpeed||s.max(s.max(s.min(s.abs(n-d.x),1e3),s.min(s.abs(r-d.y),1e3)),300),n=d.x,r=d.y,this.directionX=0,this.directionY=0,p=this.options.bounceEasing}return n!=this.x||r!=this.y?((n>0||n<this.maxScrollX||r>0||r<this.maxScrollY)&&(p=h.ease.quadratic),void this.scrollTo(n,r,c,p)):void this._execEvent("scrollEnd")}}},_resize:function(){var t=this;clearTimeout(this.resizeTimeout),this.resizeTimeout=setTimeout(function(){t.refresh()},this.options.resizePolling)},resetPosition:function(t){var i=this.x,s=this.y;return t=t||0,!this.hasHorizontalScroll||this.x>0?i=0:this.x<this.maxScrollX&&(i=this.maxScrollX),!this.hasVerticalScroll||this.y>0?s=0:this.y<this.maxScrollY&&(s=this.maxScrollY),(i!=this.x||s!=this.y)&&(this.scrollTo(i,s,t,this.options.bounceEasing),!0)},disable:function(){this.enabled=!1},enable:function(){this.enabled=!0},refresh:function(){h.getRect(this.wrapper),this.wrapperWidth=this.wrapper.clientWidth,this.wrapperHeight=this.wrapper.clientHeight;var t=h.getRect(this.scroller);this.scrollHeight&&(t.height=this.scrollHeight),this.scrollerWidth=t.width,this.scrollerHeight=t.height,this.maxScrollX=this.wrapperWidth-this.scrollerWidth,this.maxScrollY=this.wrapperHeight-this.scrollerHeight,this.hasHorizontalScroll=this.options.scrollX&&this.maxScrollX<0,this.hasVerticalScroll=this.options.scrollY&&this.maxScrollY<0,this.hasHorizontalScroll||(this.maxScrollX=0,this.scrollerWidth=this.wrapperWidth),this.hasVerticalScroll||(this.maxScrollY=0,this.scrollerHeight=this.wrapperHeight),this.endTime=0,this.directionX=0,this.directionY=0,h.hasPointer&&!this.options.disablePointer&&(this.wrapper.style[h.style.touchAction]=h.getTouchAction(this.options.eventPassthrough,!0),this.wrapper.style[h.style.touchAction]||(this.wrapper.style[h.style.touchAction]=h.getTouchAction(this.options.eventPassthrough,!1))),this.wrapperOffset=h.offset(this.wrapper),this._execEvent("refresh"),this.resetPosition()},on:function(t,i){this._events[t]||(this._events[t]=[]),this._events[t].push(i)},off:function(t,i){if(this._events[t]){var s=this._events[t].indexOf(i);s>-1&&this._events[t].splice(s,1)}},_execEvent:function(t){if(this._events[t]){var i=0,s=this._events[t].length;if(s)for(;i<s;i++)this._events[t][i].apply(this,[].slice.call(arguments,1))}},scrollBy:function(t,i,s,e){t=this.x+t,i=this.y+i,s=s||0,this.scrollTo(t,i,s,e)},scrollTo:function(t,i,s,e){e=e||h.ease.circular,this.isInTransition=this.options.useTransition&&s>0;var o=this.options.useTransition&&e.style;!s||o?(o&&(this._transitionTimingFunction(e.style),this._transitionTime(s)),this._translate(t,i)):this._animate(t,i,s,e.fn)},scrollToElement:function(t,i,e,o,n){if(t=t.nodeType?t:this.scroller.querySelector(t)){var r=h.offset(t);r.left-=this.wrapperOffset.left,r.top-=this.wrapperOffset.top;var a=h.getRect(t),l=h.getRect(this.wrapper);e===!0&&(e=s.round(a.width/2-l.width/2)),o===!0&&(o=s.round(a.height/2-l.height/2)),r.left-=e||0,r.top-=o||0,r.left=r.left>0?0:r.left<this.maxScrollX?this.maxScrollX:r.left,r.top=r.top>0?0:r.top<this.maxScrollY?this.maxScrollY:r.top,i=void 0===i||null===i||"auto"===i?s.max(s.abs(this.x-r.left),s.abs(this.y-r.top)):i,this.scrollTo(r.left,r.top,i,n)}},_transitionTime:function(t){if(this.options.useTransition){t=t||0;var i=h.style.transitionDuration;if(i){if(this.scrollerStyle[i]=t+"ms",!t&&h.isBadAndroid){this.scrollerStyle[i]="0.0001ms";var s=this;r(function(){"0.0001ms"===s.scrollerStyle[i]&&(s.scrollerStyle[i]="0s")})}if(this.indicators)for(var e=this.indicators.length;e--;)this.indicators[e].transitionTime(t)}}},_transitionTimingFunction:function(t){if(this.scrollerStyle[h.style.transitionTimingFunction]=t,this.indicators)for(var i=this.indicators.length;i--;)this.indicators[i].transitionTimingFunction(t)},_translate:function(t,i){if(this.options.useTransform?this.scrollerStyle[h.style.transform]="translate("+t+"px,"+i+"px)"+this.translateZ:(t=s.round(t),i=s.round(i),this.scrollerStyle.left=t+"px",this.scrollerStyle.top=i+"px"),this.x=t,this.y=i,this.indicators)for(var e=this.indicators.length;e--;)this.indicators[e].updatePosition();this.options.onScrollHandler()},_initEvents:function(i){var s=i?h.removeEvent:h.addEvent,e=this.options.bindToWrapper?this.wrapper:t;s(t,"orientationchange",this),s(t,"resize",this),this.options.click&&s(this.wrapper,"click",this,!0),this.options.disableMouse||(s(this.wrapper,"mousedown",this),s(e,"mousemove",this),s(e,"mousecancel",this),s(e,"mouseup",this)),h.hasPointer&&!this.options.disablePointer&&(s(this.wrapper,h.prefixPointerEvent("pointerdown"),this),s(e,h.prefixPointerEvent("pointermove"),this),s(e,h.prefixPointerEvent("pointercancel"),this),s(e,h.prefixPointerEvent("pointerup"),this)),h.hasTouch&&!this.options.disableTouch&&(s(this.wrapper,"touchstart",this),s(e,"touchmove",this),s(e,"touchcancel",this),s(e,"touchend",this)),s(this.scroller,"transitionend",this),s(this.scroller,"webkitTransitionEnd",this),s(this.scroller,"oTransitionEnd",this),s(this.scroller,"MSTransitionEnd",this)},getComputedPosition:function(){var i,s,e=t.getComputedStyle(this.scroller,null);return this.options.useTransform?(e=e[h.style.transform].split(")")[0].split(", "),i=+(e[12]||e[4]),s=+(e[13]||e[5])):(i=+e.left.replace(/[^-\d.]/g,""),s=+e.top.replace(/[^-\d.]/g,"")),{x:i,y:s}},_initIndicators:function(){function t(t){if(h.indicators)for(var i=h.indicators.length;i--;)t.call(h.indicators[i])}var i,s=this.options.interactiveScrollbars,e="string"!=typeof this.options.scrollbars,r=[],h=this;this.indicators=[],this.options.scrollbars&&(this.options.scrollY&&(i={el:o("v",s,this.options.scrollbars),interactive:s,defaultScrollbars:!0,customStyle:e,resize:this.options.resizeScrollbars,shrink:this.options.shrinkScrollbars,fade:this.options.fadeScrollbars,listenX:!1},this.wrapper.appendChild(i.el),r.push(i)),this.options.scrollX&&(i={el:o("h",s,this.options.scrollbars),interactive:s,defaultScrollbars:!0,customStyle:e,resize:this.options.resizeScrollbars,shrink:this.options.shrinkScrollbars,fade:this.options.fadeScrollbars,listenY:!1},this.wrapper.appendChild(i.el),r.push(i))),this.options.indicators&&(r=r.concat(this.options.indicators));for(var a=r.length;a--;)this.indicators.push(new n(this,r[a]));this.options.fadeScrollbars&&(this.on("scrollEnd",function(){t(function(){this.fade()})}),this.on("scrollCancel",function(){t(function(){this.fade()})}),this.on("scrollStart",function(){t(function(){this.fade(1)})}),this.on("beforeScrollStart",function(){t(function(){this.fade(1,!0)})})),this.on("refresh",function(){t(function(){this.refresh()})}),this.on("destroy",function(){t(function(){this.destroy()}),delete this.indicators})},_initWheel:function(){h.addEvent(this.wrapper,"wheel",this),h.addEvent(this.wrapper,"mousewheel",this),h.addEvent(this.wrapper,"DOMMouseScroll",this),this.on("destroy",function(){clearTimeout(this.wheelTimeout),this.wheelTimeout=null,h.removeEvent(this.wrapper,"wheel",this),h.removeEvent(this.wrapper,"mousewheel",this),h.removeEvent(this.wrapper,"DOMMouseScroll",this)})},_wheel:function(t){if(this.enabled){t.preventDefault();var i,e,o,n,r=this;if(void 0===this.wheelTimeout&&r._execEvent("scrollStart"),clearTimeout(this.wheelTimeout),this.wheelTimeout=setTimeout(function(){r.options.snap||r._execEvent("scrollEnd"),r.wheelTimeout=void 0},400),"deltaX"in t)1===t.deltaMode?(i=-t.deltaX*this.options.mouseWheelSpeed,e=-t.deltaY*this.options.mouseWheelSpeed):(i=-t.deltaX,e=-t.deltaY);else if("wheelDeltaX"in t)i=t.wheelDeltaX/120*this.options.mouseWheelSpeed,e=t.wheelDeltaY/120*this.options.mouseWheelSpeed;else if("wheelDelta"in t)i=e=t.wheelDelta/120*this.options.mouseWheelSpeed;else{if(!("detail"in t))return;i=e=-t.detail/3*this.options.mouseWheelSpeed}if(i*=this.options.invertWheelDirection,e*=this.options.invertWheelDirection,this.hasVerticalScroll||(i=e,e=0),this.options.snap)return o=this.currentPage.pageX,n=this.currentPage.pageY,i>0?o--:i<0&&o++,e>0?n--:e<0&&n++,void this.goToPage(o,n);o=this.x+s.round(this.hasHorizontalScroll?i:0),n=this.y+s.round(this.hasVerticalScroll?e:0),this.directionX=i>0?-1:i<0?1:0,this.directionY=e>0?-1:e<0?1:0,o>0?o=0:o<this.maxScrollX&&(o=this.maxScrollX),n>0?n=0:n<this.maxScrollY&&(n=this.maxScrollY),this.scrollTo(o,n,0)}},_initSnap:function(){this.currentPage={},"string"==typeof this.options.snap&&(this.options.snap=this.scroller.querySelectorAll(this.options.snap)),this.on("refresh",function(){var t,i,e,o,n,r,a,l=0,c=0,p=0,d=this.options.snapStepX||this.wrapperWidth,u=this.options.snapStepY||this.wrapperHeight;if(this.pages=[],this.wrapperWidth&&this.wrapperHeight&&this.scrollerWidth&&this.scrollerHeight){if(this.options.snap===!0)for(e=s.round(d/2),o=s.round(u/2);p>-this.scrollerWidth;){for(this.pages[l]=[],t=0,n=0;n>-this.scrollerHeight;)this.pages[l][t]={x:s.max(p,this.maxScrollX),y:s.max(n,this.maxScrollY),width:d,height:u,cx:p-e,cy:n-o},n-=u,t++;p-=d,l++}else for(r=this.options.snap,t=r.length,i=-1;l<t;l++)a=h.getRect(r[l]),(0===l||a.left<=h.getRect(r[l-1]).left)&&(c=0,i++),this.pages[c]||(this.pages[c]=[]),p=s.max(-a.left,this.maxScrollX),n=s.max(-a.top,this.maxScrollY),e=p-s.round(a.width/2),o=n-s.round(a.height/2),this.pages[c][i]={x:p,y:n,width:a.width,height:a.height,cx:e,cy:o},p>this.maxScrollX&&c++;this.goToPage(this.currentPage.pageX||0,this.currentPage.pageY||0,0),this.options.snapThreshold%1===0?(this.snapThresholdX=this.options.snapThreshold,this.snapThresholdY=this.options.snapThreshold):(this.snapThresholdX=s.round(this.pages[this.currentPage.pageX][this.currentPage.pageY].width*this.options.snapThreshold),this.snapThresholdY=s.round(this.pages[this.currentPage.pageX][this.currentPage.pageY].height*this.options.snapThreshold))}}),this.on("flick",function(){var t=this.options.snapSpeed||s.max(s.max(s.min(s.abs(this.x-this.startX),1e3),s.min(s.abs(this.y-this.startY),1e3)),300);this.goToPage(this.currentPage.pageX+this.directionX,this.currentPage.pageY+this.directionY,t)})},_nearestSnap:function(t,i){if(!this.pages.length)return{x:0,y:0,pageX:0,pageY:0};var e=0,o=this.pages.length,n=0;if(s.abs(t-this.absStartX)<this.snapThresholdX&&s.abs(i-this.absStartY)<this.snapThresholdY)return this.currentPage;for(t>0?t=0:t<this.maxScrollX&&(t=this.maxScrollX),i>0?i=0:i<this.maxScrollY&&(i=this.maxScrollY);e<o;e++)if(t>=this.pages[e][0].cx){t=this.pages[e][0].x;break}for(o=this.pages[e].length;n<o;n++)if(i>=this.pages[0][n].cy){i=this.pages[0][n].y;break}return e==this.currentPage.pageX&&(e+=this.directionX,e<0?e=0:e>=this.pages.length&&(e=this.pages.length-1),t=this.pages[e][0].x),n==this.currentPage.pageY&&(n+=this.directionY,n<0?n=0:n>=this.pages[0].length&&(n=this.pages[0].length-1),i=this.pages[0][n].y),{x:t,y:i,pageX:e,pageY:n}},goToPage:function(t,i,e,o){o=o||this.options.bounceEasing,t>=this.pages.length?t=this.pages.length-1:t<0&&(t=0),i>=this.pages[t].length?i=this.pages[t].length-1:i<0&&(i=0);var n=this.pages[t][i].x,r=this.pages[t][i].y;e=void 0===e?this.options.snapSpeed||s.max(s.max(s.min(s.abs(n-this.x),1e3),s.min(s.abs(r-this.y),1e3)),300):e,this.currentPage={x:n,y:r,pageX:t,pageY:i},this.scrollTo(n,r,e,o)},next:function(t,i){var s=this.currentPage.pageX,e=this.currentPage.pageY;s++,s>=this.pages.length&&this.hasVerticalScroll&&(s=0,e++),this.goToPage(s,e,t,i)},prev:function(t,i){var s=this.currentPage.pageX,e=this.currentPage.pageY;s--,s<0&&this.hasVerticalScroll&&(s=0,e--),this.goToPage(s,e,t,i)},_initKeys:function(i){var s,e={pageUp:33,pageDown:34,end:35,home:36,left:37,up:38,right:39,down:40};if("object"==typeof this.options.keyBindings)for(s in this.options.keyBindings)"string"==typeof this.options.keyBindings[s]&&(this.options.keyBindings[s]=this.options.keyBindings[s].toUpperCase().charCodeAt(0));else this.options.keyBindings={};for(s in e)this.options.keyBindings[s]=this.options.keyBindings[s]||e[s];h.addEvent(t,"keydown",this),this.on("destroy",function(){h.removeEvent(t,"keydown",this)})},_key:function(t){if(this.enabled){var i,e=this.options.snap,o=e?this.currentPage.pageX:this.x,n=e?this.currentPage.pageY:this.y,r=h.getTime(),a=this.keyTime||0,l=.25;switch(this.options.useTransition&&this.isInTransition&&(i=this.getComputedPosition(),this._translate(s.round(i.x),s.round(i.y)),this.isInTransition=!1),this.keyAcceleration=r-a<200?s.min(this.keyAcceleration+l,50):0,t.keyCode){case this.options.keyBindings.pageUp:this.hasHorizontalScroll&&!this.hasVerticalScroll?o+=e?1:this.wrapperWidth:n+=e?1:this.wrapperHeight;break;case this.options.keyBindings.pageDown:this.hasHorizontalScroll&&!this.hasVerticalScroll?o-=e?1:this.wrapperWidth:n-=e?1:this.wrapperHeight;break;case this.options.keyBindings.end:o=e?this.pages.length-1:this.maxScrollX,n=e?this.pages[0].length-1:this.maxScrollY;break;case this.options.keyBindings.home:o=0,n=0;break;case this.options.keyBindings.left:o+=e?-1:5+this.keyAcceleration>>0;break;case this.options.keyBindings.up:n+=e?1:5+this.keyAcceleration>>0;break;case this.options.keyBindings.right:o-=e?-1:5+this.keyAcceleration>>0;break;case this.options.keyBindings.down:n-=e?1:5+this.keyAcceleration>>0;break;default:return}if(e)return void this.goToPage(o,n);o>0?(o=0,this.keyAcceleration=0):o<this.maxScrollX&&(o=this.maxScrollX,this.keyAcceleration=0),n>0?(n=0,this.keyAcceleration=0):n<this.maxScrollY&&(n=this.maxScrollY,this.keyAcceleration=0),this.scrollTo(o,n,0),this.keyTime=r}},_animate:function(t,i,s,e){function o(){var d,u,m,f=h.getTime();return f>=p?(n.isAnimating=!1,n._translate(t,i),void(n.resetPosition(n.options.bounceTime)||n._execEvent("scrollEnd"))):(f=(f-c)/s,m=e(f),d=(t-a)*m+a,u=(i-l)*m+l,n._translate(d,u),void(n.isAnimating&&r(o)))}var n=this,a=this.x,l=this.y,c=h.getTime(),p=c+s;this.isAnimating=!0,o()},handleEvent:function(t){switch(t.type){case"touchstart":case"pointerdown":case"MSPointerDown":case"mousedown":t.defaultPrevented||this._start(t);break;case"touchmove":case"pointermove":case"MSPointerMove":case"mousemove":t.defaultPrevented||this._move(t);break;case"touchend":case"pointerup":case"MSPointerUp":case"mouseup":case"touchcancel":case"pointercancel":case"MSPointerCancel":case"mousecancel":this._end(t);break;case"orientationchange":case"resize":this._resize();break;case"transitionend":case"webkitTransitionEnd":case"oTransitionEnd":case"MSTransitionEnd":this._transitionEnd(t);break;case"wheel":case"DOMMouseScroll":case"mousewheel":this._wheel(t);break;case"keydown":this._key(t);break;case"click":this.enabled&&!t._constructed}}},n.prototype={handleEvent:function(t){switch(t.type){case"touchstart":case"pointerdown":case"MSPointerDown":case"mousedown":this._start(t);break;case"touchmove":case"pointermove":case"MSPointerMove":case"mousemove":this._move(t);break;case"touchend":case"pointerup":case"MSPointerUp":case"mouseup":case"touchcancel":case"pointercancel":case"MSPointerCancel":case"mousecancel":this._end(t)}},destroy:function(){this.options.fadeScrollbars&&(clearTimeout(this.fadeTimeout),this.fadeTimeout=null),this.options.interactive&&(h.removeEvent(this.indicator,"touchstart",this),h.removeEvent(this.indicator,h.prefixPointerEvent("pointerdown"),this),h.removeEvent(this.indicator,"mousedown",this),h.removeEvent(t,"touchmove",this),h.removeEvent(t,h.prefixPointerEvent("pointermove"),this),h.removeEvent(t,"mousemove",this),h.removeEvent(t,"touchend",this),h.removeEvent(t,h.prefixPointerEvent("pointerup"),this),h.removeEvent(t,"mouseup",this)),this.options.defaultScrollbars&&this.wrapper.parentNode&&this.wrapper.parentNode.removeChild(this.wrapper)},_start:function(i){var s=i.touches?i.touches[0]:i;i.preventDefault(),i.stopPropagation(),this.transitionTime(),this.initiated=!0,this.moved=!1,this.lastPointX=s.pageX,this.lastPointY=s.pageY,this.startTime=h.getTime(),this.options.disableTouch||h.addEvent(t,"touchmove",this),this.options.disablePointer||h.addEvent(t,h.prefixPointerEvent("pointermove"),this),this.options.disableMouse||h.addEvent(t,"mousemove",this),this.scroller._execEvent("beforeScrollStart")},_move:function(t){var i,s,e,o,n=t.touches?t.touches[0]:t;h.getTime();this.moved||this.scroller._execEvent("scrollStart"),this.moved=!0,i=n.pageX-this.lastPointX,this.lastPointX=n.pageX,s=n.pageY-this.lastPointY,this.lastPointY=n.pageY,e=this.x+i,o=this.y+s,this._pos(e,o),t.preventDefault(),t.stopPropagation()},_end:function(i){if(this.initiated){if(this.initiated=!1,i.preventDefault(),i.stopPropagation(),h.removeEvent(t,"touchmove",this),h.removeEvent(t,h.prefixPointerEvent("pointermove"),this),h.removeEvent(t,"mousemove",this),this.scroller.options.snap){var e=this.scroller._nearestSnap(this.scroller.x,this.scroller.y),o=this.options.snapSpeed||s.max(s.max(s.min(s.abs(this.scroller.x-e.x),1e3),s.min(s.abs(this.scroller.y-e.y),1e3)),300);this.scroller.x==e.x&&this.scroller.y==e.y||(this.scroller.directionX=0,this.scroller.directionY=0,this.scroller.currentPage=e,this.scroller.scrollTo(e.x,e.y,o,this.scroller.options.bounceEasing))}this.moved&&this.scroller._execEvent("scrollEnd")}},transitionTime:function(t){t=t||0;var i=h.style.transitionDuration;if(i&&(this.indicatorStyle[i]=t+"ms",!t&&h.isBadAndroid)){this.indicatorStyle[i]="0.0001ms";var s=this;r(function(){"0.0001ms"===s.indicatorStyle[i]&&(s.indicatorStyle[i]="0s")})}},transitionTimingFunction:function(t){this.indicatorStyle[h.style.transitionTimingFunction]=t},refresh:function(){this.transitionTime(),this.options.listenX&&!this.options.listenY?this.indicatorStyle.display=this.scroller.hasHorizontalScroll?"block":"none":this.options.listenY&&!this.options.listenX?this.indicatorStyle.display=this.scroller.hasVerticalScroll?"block":"none":this.indicatorStyle.display=this.scroller.hasHorizontalScroll||this.scroller.hasVerticalScroll?"block":"none",this.scroller.hasHorizontalScroll&&this.scroller.hasVerticalScroll?(h.addClass(this.wrapper,"iScrollBothScrollbars"),h.removeClass(this.wrapper,"iScrollLoneScrollbar"),this.options.defaultScrollbars&&this.options.customStyle&&(this.options.listenX?this.wrapper.style.right="8px":this.wrapper.style.bottom="8px")):(h.removeClass(this.wrapper,"iScrollBothScrollbars"),h.addClass(this.wrapper,"iScrollLoneScrollbar"),this.options.defaultScrollbars&&this.options.customStyle&&(this.options.listenX?this.wrapper.style.right="2px":this.wrapper.style.bottom="2px")),h.getRect(this.wrapper),this.options.listenX&&(this.wrapperWidth=this.wrapper.clientWidth,this.options.resize?(this.indicatorWidth=s.max(s.round(this.wrapperWidth*this.wrapperWidth/(this.scroller.scrollerWidth||this.wrapperWidth||1)),8),this.indicatorStyle.width=this.indicatorWidth+"px"):this.indicatorWidth=this.indicator.clientWidth,this.maxPosX=this.wrapperWidth-this.indicatorWidth,"clip"==this.options.shrink?(this.minBoundaryX=-this.indicatorWidth+8,this.maxBoundaryX=this.wrapperWidth-8):(this.minBoundaryX=0,this.maxBoundaryX=this.maxPosX),this.sizeRatioX=this.options.speedRatioX||this.scroller.maxScrollX&&this.maxPosX/this.scroller.maxScrollX),this.options.listenY&&(this.wrapperHeight=this.wrapper.clientHeight,this.options.resize?(this.indicatorHeight=s.max(s.round(this.wrapperHeight*this.wrapperHeight/(this.scroller.scrollerHeight||this.wrapperHeight||1)),8),this.indicatorStyle.height=this.indicatorHeight+"px"):this.indicatorHeight=this.indicator.clientHeight,this.maxPosY=this.wrapperHeight-this.indicatorHeight,"clip"==this.options.shrink?(this.minBoundaryY=-this.indicatorHeight+8,this.maxBoundaryY=this.wrapperHeight-8):(this.minBoundaryY=0,this.maxBoundaryY=this.maxPosY),
this.maxPosY=this.wrapperHeight-this.indicatorHeight,this.sizeRatioY=this.options.speedRatioY||this.scroller.maxScrollY&&this.maxPosY/this.scroller.maxScrollY),this.updatePosition()},updatePosition:function(){var t=this.options.listenX&&s.round(this.sizeRatioX*this.scroller.x)||0,i=this.options.listenY&&s.round(this.sizeRatioY*this.scroller.y)||0;this.options.ignoreBoundaries||(t<this.minBoundaryX?("scale"==this.options.shrink&&(this.width=s.max(this.indicatorWidth+t,8),this.indicatorStyle.width=this.width+"px"),t=this.minBoundaryX):t>this.maxBoundaryX?"scale"==this.options.shrink?(this.width=s.max(this.indicatorWidth-(t-this.maxPosX),8),this.indicatorStyle.width=this.width+"px",t=this.maxPosX+this.indicatorWidth-this.width):t=this.maxBoundaryX:"scale"==this.options.shrink&&this.width!=this.indicatorWidth&&(this.width=this.indicatorWidth,this.indicatorStyle.width=this.width+"px"),i<this.minBoundaryY?("scale"==this.options.shrink&&(this.height=s.max(this.indicatorHeight+3*i,8),this.indicatorStyle.height=this.height+"px"),i=this.minBoundaryY):i>this.maxBoundaryY?"scale"==this.options.shrink?(this.height=s.max(this.indicatorHeight-3*(i-this.maxPosY),8),this.indicatorStyle.height=this.height+"px",i=this.maxPosY+this.indicatorHeight-this.height):i=this.maxBoundaryY:"scale"==this.options.shrink&&this.height!=this.indicatorHeight&&(this.height=this.indicatorHeight,this.indicatorStyle.height=this.height+"px")),this.x=t,this.y=i,this.scroller.options.useTransform?this.indicatorStyle[h.style.transform]="translate("+t+"px,"+i+"px)"+this.scroller.translateZ:(this.indicatorStyle.left=t+"px",this.indicatorStyle.top=i+"px")},_pos:function(t,i){t<0?t=0:t>this.maxPosX&&(t=this.maxPosX),i<0?i=0:i>this.maxPosY&&(i=this.maxPosY),t=this.options.listenX?s.round(t/this.sizeRatioX):this.scroller.x,i=this.options.listenY?s.round(i/this.sizeRatioY):this.scroller.y,this.scroller.scrollTo(t,i)},fade:function(t,i){if(!i||this.visible){clearTimeout(this.fadeTimeout),this.fadeTimeout=null;var s=t?250:500,e=t?0:300;t=t?"1":"0",this.wrapperStyle[h.style.transitionDuration]=s+"ms",this.fadeTimeout=setTimeout(function(t){this.wrapperStyle.opacity=t,this.visible=+t}.bind(this,t),e)}}},e.utils=h,"undefined"!=typeof module&&module.exports?module.exports=e:"function"==typeof define&&define.amd?define(function(){return e}):t.IScroll=e}(window,document,Math);